/*
 * Decompiled with CFR 0.152.
 */
package com.tp.ads.adx.utils;

import android.content.Context;
import android.view.View;
import android.webkit.WebView;
import com.iab.omid.library.tradplus.Omid;
import com.iab.omid.library.tradplus.adsession.AdSession;
import com.iab.omid.library.tradplus.adsession.AdSessionConfiguration;
import com.iab.omid.library.tradplus.adsession.AdSessionContext;
import com.iab.omid.library.tradplus.adsession.CreativeType;
import com.iab.omid.library.tradplus.adsession.ImpressionType;
import com.iab.omid.library.tradplus.adsession.Owner;
import com.iab.omid.library.tradplus.adsession.Partner;
import com.iab.omid.library.tradplus.adsession.VerificationScriptResource;
import com.tp.ads.adx.utils.OmidJsLoader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;

public final class AdSessionUtil {
    public static AdSession getNativeAdSession(Context context, String customReferenceData, CreativeType creativeType, boolean isOpen) throws MalformedURLException {
        if (!isOpen) {
            return null;
        }
        AdSessionUtil.ensureOmidActivated(context);
        AdSessionConfiguration adSessionConfiguration = AdSessionConfiguration.createAdSessionConfiguration((CreativeType)creativeType, (ImpressionType)(creativeType == CreativeType.AUDIO ? ImpressionType.AUDIBLE : ImpressionType.VIEWABLE), (Owner)Owner.NATIVE, (Owner)(creativeType == CreativeType.HTML_DISPLAY || creativeType == CreativeType.NATIVE_DISPLAY ? Owner.NONE : Owner.NATIVE), (boolean)false);
        Partner partner = Partner.createPartner((String)"Tradplus", (String)"40.10.6.0.1");
        String omidJs = OmidJsLoader.getOmidJs(context);
        List<VerificationScriptResource> verificationScripts = AdSessionUtil.getVerificationScriptResources();
        AdSessionContext adSessionContext = AdSessionContext.createNativeAdSessionContext((Partner)partner, (String)omidJs, verificationScripts, null, (String)customReferenceData);
        return AdSession.createAdSession((AdSessionConfiguration)adSessionConfiguration, (AdSessionContext)adSessionContext);
    }

    public static AdSession getHtmlAdSession(Context context, WebView webView, String customReferenceData, CreativeType creativeType, boolean isOpen) {
        if (!isOpen) {
            return null;
        }
        AdSessionUtil.ensureOmidActivated(context);
        AdSessionConfiguration adSessionConfiguration = AdSessionConfiguration.createAdSessionConfiguration((CreativeType)creativeType, (ImpressionType)ImpressionType.BEGIN_TO_RENDER, (Owner)Owner.JAVASCRIPT, (Owner)(creativeType == CreativeType.HTML_DISPLAY || creativeType == CreativeType.DEFINED_BY_JAVASCRIPT ? Owner.NONE : Owner.NATIVE), (boolean)false);
        Partner partner = Partner.createPartner((String)"Tradplus", (String)"40.10.6.0.1");
        AdSessionContext adSessionContext = AdSessionContext.createHtmlAdSessionContext((Partner)partner, (WebView)webView, null, (String)customReferenceData);
        AdSession adSession = AdSession.createAdSession((AdSessionConfiguration)adSessionConfiguration, (AdSessionContext)adSessionContext);
        adSession.registerAdView((View)webView);
        return adSession;
    }

    public static AdSession getJsAdSession(Context context, WebView webView, String customReferenceData, CreativeType creativeType, boolean isOpen) {
        if (!isOpen) {
            return null;
        }
        AdSessionUtil.ensureOmidActivated(context);
        AdSessionConfiguration adSessionConfiguration = AdSessionConfiguration.createAdSessionConfiguration((CreativeType)creativeType, (ImpressionType)ImpressionType.VIEWABLE, (Owner)Owner.NATIVE, (Owner)(creativeType == CreativeType.NATIVE_DISPLAY ? Owner.NONE : Owner.NATIVE), (boolean)false);
        Partner partner = Partner.createPartner((String)"Tradplus", (String)"40.10.6.0.1");
        AdSessionContext adSessionContext = AdSessionContext.createJavascriptAdSessionContext((Partner)partner, (WebView)webView, null, (String)customReferenceData);
        AdSession adSession = AdSession.createAdSession((AdSessionConfiguration)adSessionConfiguration, (AdSessionContext)adSessionContext);
        return adSession;
    }

    private static List<VerificationScriptResource> getVerificationScriptResources() throws MalformedURLException {
        VerificationScriptResource verificationScriptResource = "iabtechlab-Tradplus" == null ? VerificationScriptResource.createVerificationScriptResourceWithoutParameters((URL)AdSessionUtil.getURL()) : VerificationScriptResource.createVerificationScriptResourceWithParameters((String)"iabtechlab.com-omid", (URL)AdSessionUtil.getURL(), (String)"iabtechlab-Tradplus");
        return Collections.singletonList(verificationScriptResource);
    }

    private static URL getURL() throws MalformedURLException {
        return new URL("https://www.baidu.com");
    }

    private static void ensureOmidActivated(Context context) {
        Omid.activate((Context)context.getApplicationContext());
    }
}

