/*
 * Decompiled with CFR 0.152.
 */
package com.tp.adx.sdk;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.text.TextUtils;
import android.widget.Toast;
import com.tp.adx.sdk.ui.InnerWebViewActivity;
import com.tp.adx.sdk.util.InnerLog;
import com.tradplus.ads.base.TradPlus;
import com.tradplus.ads.base.common.TPDataManager;
import com.tradplus.ads.base.common.TPTaskManager;

public class HandleClick {
    private static final String TAG = "ADX";
    public static final String HOST_GOOGLE_PLAY = "play.google.com";
    public static final String HOST_ANDROID_MARKET = "market.android.com";
    public static final String PATH_DETAILS = "details?";
    public static final String SCHEME_MARKET = "market";
    public static final String PROTOCOL_MARKET = "market://";
    private final int MAX_JUMP_COUNT = 10;
    private final int MARKET_TYPE = 1;
    private final int BROWSER_TYPE = 2;
    private final int APK_TYPE = 3;
    boolean mIsClicking;
    boolean mIsCancel;
    Context mContext;

    public HandleClick(Context context) {
        this.mContext = context.getApplicationContext();
    }

    public void onClick(final String url) {
        if (this.mIsClicking) {
            return;
        }
        this.mIsClicking = true;
        this.mIsCancel = false;
        TPTaskManager.getInstance().runNormalTask(new Runnable(){

            @Override
            public void run() {
                InnerLog.i(HandleClick.TAG, "run: deepLinkUrl \uff1a " + url);
                if (!TextUtils.isEmpty((CharSequence)url) && HandleClick.this.isApkInstalled(HandleClick.this.mContext, url)) {
                    InnerLog.i(HandleClick.TAG, "run: replace url \uff1a " + url);
                    if (HandleClick.this.openDeepLink(HandleClick.this.mContext, url)) {
                        InnerLog.i(HandleClick.TAG, "run: openDeepLink \uff1a");
                        HandleClick.this.mIsClicking = false;
                        return;
                    }
                    InnerLog.i(HandleClick.TAG, "run: openDeepLink else \uff1a");
                }
                HandleClick.this.openClickUrl(url);
            }
        });
    }

    private void openClickUrl(String url) {
        boolean isNeedJump = true;
        if (url.contains("mark")) {
            this.handleClickResult(1, url);
            return;
        }
        if (url.endsWith(".apk")) {
            this.handleClickResult(3, url);
            return;
        }
        if (!url.startsWith("http")) {
            this.handleClickResult(2, url);
            return;
        }
    }

    private boolean openDeepLink(Context context, String deepLinkUrl) {
        boolean openSuccessed = false;
        try {
            if (!TextUtils.isEmpty((CharSequence)deepLinkUrl)) {
                Uri uri = Uri.parse((String)deepLinkUrl);
                Intent intent = new Intent("android.intent.action.VIEW", uri);
                intent.setData(uri);
                intent.setFlags(0x10000000);
                context.startActivity(intent);
                openSuccessed = true;
            }
        }
        catch (Throwable t) {
            InnerLog.v(t.getMessage());
        }
        return openSuccessed;
    }

    private void handleClickResult(int type, String finalUrl) {
        if (this.mIsCancel) {
            return;
        }
        finalUrl = TextUtils.isEmpty((CharSequence)finalUrl) ? "" : finalUrl;
        switch (type) {
            case 1: {
                if (!finalUrl.startsWith("http")) {
                    if (this.openMarketApp(finalUrl)) break;
                    this.openBrowserUrl(finalUrl);
                    break;
                }
                String googleMarketUrl = this.convertToMarketUrl(finalUrl);
                if (!TextUtils.isEmpty((CharSequence)googleMarketUrl)) {
                    if (this.openMarketApp(googleMarketUrl)) break;
                    this.openBrowserUrl(finalUrl);
                    break;
                }
                this.openBrowserUrl(finalUrl);
                break;
            }
            case 2: {
                this.openBrowserUrl(finalUrl);
                break;
            }
            case 3: {
                this.downloadApkOrOpenBrowser(finalUrl);
                break;
            }
            default: {
                this.openBrowserUrl(finalUrl);
            }
        }
        this.mIsClicking = false;
    }

    private void downloadApkOrOpenBrowser(String finalUrl) {
        InnerLog.i(TAG, "downloadApkOrOpenBrowser: " + TradPlus.invoker().getChinaHandler());
        if (TradPlus.invoker().getChinaHandler() != null && !TextUtils.isEmpty((CharSequence)finalUrl) && finalUrl.endsWith(".apk")) {
            this.realStartDownloadApp(finalUrl);
            return;
        }
        this.openBrowserUrl(finalUrl);
    }

    public void realStartDownloadApp(String url) {
        InnerLog.i("servicedownload", "realStartDownloadApp: ");
    }

    private boolean openMarketApp(String googleMarketUrl) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)googleMarketUrl));
            intent.setData(Uri.parse((String)googleMarketUrl));
            intent.addFlags(0x10000000);
            this.mContext.startActivity(intent);
        }
        catch (Throwable e) {
            TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    Toast.makeText((Context)HandleClick.this.mContext, (CharSequence)"Detect that the App Market is not installed and cannot be opened through the App Market.", (int)1).show();
                }
            });
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openBrowserUrl(String finalUrl) {
        boolean isOpen = false;
        try {
            Intent intent = new Intent(this.mContext, InnerWebViewActivity.class);
            intent.putExtra("inner_adx_url", finalUrl);
            this.mContext.startActivity(intent);
            isOpen = true;
        }
        catch (Exception e2) {
            isOpen = false;
            e2.printStackTrace();
        }
        finally {
            if (isOpen) {
                // empty if block
            }
        }
    }

    private boolean isGooglePlayUrl(String url) {
        try {
            if (TextUtils.isEmpty((CharSequence)url)) {
                return false;
            }
            Uri uri = Uri.parse((String)url);
            if (uri == null || uri.getHost() == null) {
                return false;
            }
            return uri.getHost().equals(HOST_GOOGLE_PLAY) || uri.getHost().equals(HOST_ANDROID_MARKET);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private String convertToMarketUrl(String url) {
        block3: {
            try {
                if (this.isGooglePlayUrl(url)) {
                    String detailsUrl = url.substring(url.indexOf(PATH_DETAILS));
                    return PROTOCOL_MARKET + detailsUrl;
                }
            }
            catch (Throwable e) {
                if (!TPDataManager.getInstance().isDebugMode()) break block3;
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean isApkInstalled(Context context, String pkgName) {
        if (context == null || TextUtils.isEmpty((CharSequence)pkgName)) {
            return false;
        }
        try {
            ApplicationInfo info = context.getPackageManager().getApplicationInfo(pkgName, 8192);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }
}

