/*
 * Decompiled with CFR 0.152.
 */
package com.tp.adx.sdk;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import com.tp.adx.open.AdError;
import com.tp.adx.open.InnerSdk;
import com.tp.adx.open.TPAdOptions;
import com.tp.adx.open.TPInnerAdListener;
import com.tp.adx.sdk.InnerBaseMgr;
import com.tp.adx.sdk.bean.TPPayloadInfo;
import com.tp.adx.sdk.event.InnerSendEventMessage;
import com.tp.adx.sdk.tracking.InnerTrackNotification;
import com.tp.adx.sdk.tracking.InnerVastNotificationUtils;
import com.tp.adx.sdk.ui.InnerWebViewActivity;
import com.tp.adx.sdk.util.InnerLog;
import com.tp.adx.sdk.util.JumpUtils;
import com.tp.vast.VastManager;
import com.tp.vast.VastManagerFactory;
import com.tp.vast.VastTracker;
import com.tp.vast.VastVideoConfig;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.bean.TPAdMediaInfo;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.common.TPVideoAdPlayer;
import com.tradplus.ads.base.common.TPVideoProgressUpdate;
import com.tradplus.ads.common.UrlAction;
import com.tradplus.ads.common.UrlHandler;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.ResourceUtils;
import java.io.Serializable;
import java.util.EnumSet;

public class InnerMediaVideoMgr
extends InnerBaseMgr {
    private static final String TAG = "InnerSDK";
    private boolean isMute = true;
    private InnerSendEventMessage innerSendEventMessage;
    private boolean mIsShowing = false;
    private TPPayloadInfo.SeatBid.Bid bidInfo;
    private VastVideoConfig vastVideoConfig;
    private int rewarded;
    private boolean isReady;
    private TPPayloadInfo payloadInfo;
    private int skipTime;
    private TPVideoAdPlayer tpVideoAdPlayer;
    private int mVideoProgress25;
    private int mVideoProgress50;
    private int mVideoProgress75;
    private boolean mVideoPlay25;
    private boolean mVideoPlay50;
    private boolean mVideoPlay75;
    private ViewGroup detailView;
    private ViewGroup mAdContainerView;
    private Button tp_inner_detail;
    private Button tp_inner_time;
    private Button tp_inner_skip;
    private TPAdMediaInfo tpAdMediaInfo;
    private String detailLayoutId = "tp_inner_layout_mediavideo_detail";
    private ImageView tp_inner_privacy_tips;
    private TPVideoAdPlayer.TPVideoAdPlayerCallback tpVideoAdPlayerCallback = new TPVideoAdPlayer.TPVideoAdPlayerCallback(){

        public void onAdProgress(TPAdMediaInfo tpAdMediaInfo, TPVideoProgressUpdate tpVideoProgressUpdate) {
            final long currentTimeMs = tpVideoProgressUpdate.getCurrentTimeMs();
            long duration = tpVideoProgressUpdate.getDurationMs();
            if (InnerMediaVideoMgr.this.tpInnerAdListener != null) {
                Long cvalue = new Long(currentTimeMs);
                float currentvalue = cvalue.floatValue();
                Long dvalue = new Long(duration);
                double durationvalue = dvalue.doubleValue();
                InnerMediaVideoMgr.this.tpInnerAdListener.onAdProgress(currentvalue / 1000.0f, durationvalue / 1000.0);
            }
            if (!InnerMediaVideoMgr.this.mIsShowing) {
                InnerMediaVideoMgr.this.mVideoProgress25 = Math.round(0.25f * (float)duration);
                InnerMediaVideoMgr.this.mVideoProgress50 = Math.round(0.5f * (float)duration);
                InnerMediaVideoMgr.this.mVideoProgress75 = Math.round(0.75f * (float)duration);
                if (tpVideoProgressUpdate.getCurrentTimeMs() > 0L) {
                    InnerMediaVideoMgr.this.mIsShowing = true;
                    TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (InnerMediaVideoMgr.this.mAdContainerView != null && InnerMediaVideoMgr.this.detailView != null) {
                                InnerMediaVideoMgr.this.mAdContainerView.addView((View)InnerMediaVideoMgr.this.detailView);
                            }
                        }
                    });
                    if (InnerMediaVideoMgr.this.tpInnerAdListener != null) {
                        InnerMediaVideoMgr.this.sendVideoPlayProgressTrack(0);
                        InnerMediaVideoMgr.this.tpInnerAdListener.onVideoStart();
                        InnerMediaVideoMgr.this.tpInnerAdListener.onAdImpression();
                        InnerVastNotificationUtils.getInstance().sendCompanionImpNotification(InnerMediaVideoMgr.this.vastVideoConfig);
                        InnerTrackNotification.sendImpressionNotification(InnerMediaVideoMgr.this.bidInfo, InnerMediaVideoMgr.this.innerSendEventMessage, VastManager.getVastNetworkMediaUrl(InnerMediaVideoMgr.this.vastVideoConfig));
                    }
                }
            }
            final long time = (duration - currentTimeMs) / 1000L;
            TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    if (InnerMediaVideoMgr.this.tp_inner_time != null) {
                        InnerMediaVideoMgr.this.tp_inner_time.setText((CharSequence)(time + "s"));
                    }
                    if (InnerMediaVideoMgr.this.tp_inner_skip != null && InnerMediaVideoMgr.this.tp_inner_skip.getVisibility() == 8 && currentTimeMs > 5000L) {
                        InnerMediaVideoMgr.this.tp_inner_skip.setVisibility(0);
                    }
                }
            });
            if (!InnerMediaVideoMgr.this.mVideoPlay25 && currentTimeMs >= (long)InnerMediaVideoMgr.this.mVideoProgress25) {
                InnerMediaVideoMgr.this.mVideoPlay25 = true;
                InnerMediaVideoMgr.this.sendVideoPlayProgressTrack(25);
            } else if (!InnerMediaVideoMgr.this.mVideoPlay50 && currentTimeMs >= (long)InnerMediaVideoMgr.this.mVideoProgress50) {
                InnerMediaVideoMgr.this.mVideoPlay50 = true;
                InnerMediaVideoMgr.this.sendVideoPlayProgressTrack(50);
            } else if (!InnerMediaVideoMgr.this.mVideoPlay75 && currentTimeMs >= (long)InnerMediaVideoMgr.this.mVideoProgress75) {
                InnerMediaVideoMgr.this.mVideoPlay75 = true;
                InnerMediaVideoMgr.this.sendVideoPlayProgressTrack(75);
            }
        }

        public void onBuffering(TPAdMediaInfo var1) {
        }

        public void onContentComplete() {
        }

        public void onEnded(TPAdMediaInfo var1) {
            Log.i((String)InnerMediaVideoMgr.TAG, (String)"onEnded");
            if (InnerMediaVideoMgr.this.tpVideoAdPlayer != null) {
                InnerMediaVideoMgr.this.tpVideoAdPlayer.stopAd(var1);
                InnerMediaVideoMgr.this.tpVideoAdPlayer.release();
            }
            InnerMediaVideoMgr.this.sendVideoPlayProgressTrack(100);
            if (InnerMediaVideoMgr.this.tpInnerAdListener != null) {
                InnerMediaVideoMgr.this.tpInnerAdListener.onVideoEnd();
                InnerMediaVideoMgr.this.tpInnerAdListener.onAdClosed();
            }
        }

        public void onError(TPAdMediaInfo var1) {
            Log.i((String)InnerMediaVideoMgr.TAG, (String)"onError");
        }

        public void onLoaded(TPAdMediaInfo var1) {
            Log.i((String)InnerMediaVideoMgr.TAG, (String)"onLoaded");
        }

        public void onPause(TPAdMediaInfo var1) {
            Log.i((String)InnerMediaVideoMgr.TAG, (String)"onPause");
            InnerVastNotificationUtils.getInstance().sendPauseNotification(InnerMediaVideoMgr.this.vastVideoConfig);
            if (InnerMediaVideoMgr.this.tpInnerAdListener != null) {
                InnerMediaVideoMgr.this.tpInnerAdListener.onAdPause();
            }
        }

        public void onPlay(TPAdMediaInfo var1) {
            Log.i((String)InnerMediaVideoMgr.TAG, (String)"onPlay");
        }

        public void onResume(TPAdMediaInfo var1) {
            Log.i((String)InnerMediaVideoMgr.TAG, (String)"onResume");
            InnerVastNotificationUtils.getInstance().sendResumeNotification(InnerMediaVideoMgr.this.vastVideoConfig);
            if (InnerMediaVideoMgr.this.tpInnerAdListener != null) {
                InnerMediaVideoMgr.this.tpInnerAdListener.onAdResume();
            }
        }

        public void onVolumeChanged(TPAdMediaInfo var1, int var2) {
        }
    };

    private void createDetailView() {
        Context context = GlobalTradPlus.getInstance().getContext();
        this.detailView = (ViewGroup)LayoutInflater.from((Context)context).inflate(ResourceUtils.getLayoutIdByName((Context)context, (String)this.detailLayoutId), null);
        if (this.detailView != null) {
            this.tp_inner_detail = (Button)this.detailView.findViewById(ResourceUtils.getViewIdByName((Context)context, (String)"tp_inner_detail"));
            if (this.tp_inner_detail != null) {
                this.tp_inner_detail.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        InnerMediaVideoMgr.this.mediaViewClick();
                    }
                });
            }
            this.tp_inner_time = (Button)this.detailView.findViewById(ResourceUtils.getViewIdByName((Context)context, (String)"tp_inner_time"));
            this.tp_inner_privacy_tips = (ImageView)this.detailView.findViewById(ResourceUtils.getViewIdByName((Context)context, (String)"tp_inner_privacy_tips"));
            if (this.tp_inner_privacy_tips != null) {
                this.tp_inner_privacy_tips.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        InnerMediaVideoMgr.this.onJumpAction(v.getContext(), JumpUtils.getJumpPrivacyUrl(v.getContext()));
                    }
                });
            }
            this.tp_inner_skip = (Button)this.detailView.findViewById(ResourceUtils.getViewIdByName((Context)context, (String)"tp_inner_skip"));
            if (this.tp_inner_skip != null) {
                this.tp_inner_skip.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        InnerVastNotificationUtils.getInstance().sendSkipNotification(InnerMediaVideoMgr.this.vastVideoConfig);
                        if (InnerMediaVideoMgr.this.tpVideoAdPlayer != null) {
                            InnerMediaVideoMgr.this.tpVideoAdPlayer.stopAd(InnerMediaVideoMgr.this.tpAdMediaInfo);
                            InnerMediaVideoMgr.this.tpVideoAdPlayer.release();
                        }
                        if (InnerMediaVideoMgr.this.tpInnerAdListener != null) {
                            InnerMediaVideoMgr.this.tpInnerAdListener.onSkip();
                            InnerMediaVideoMgr.this.tpInnerAdListener.onVideoEnd();
                        }
                    }
                });
            }
        }
    }

    private boolean onJumpAction(Context context, String url) {
        boolean openSuccessed = false;
        try {
            this.startHtmlActivity(context, url);
            openSuccessed = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return openSuccessed;
    }

    private void startHtmlActivity(Context context, String url) {
        Intent intent;
        if (InnerSdk.isJumpWebViewOutSide()) {
            intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            intent.addCategory("android.intent.category.BROWSABLE");
        } else {
            intent = new Intent(context, InnerWebViewActivity.class);
            intent.putExtra("inner_adx_url", url);
        }
        intent.setFlags(0x10000000);
        context.startActivity(intent);
    }

    public InnerMediaVideoMgr(String adUnitId, String payload) {
        super(adUnitId, payload);
    }

    @Override
    public void setAdOption(TPAdOptions options) {
        super.setAdOption(options);
        this.isMute = options.isMute();
        this.rewarded = options.getRewarded();
        this.skipTime = options.getSkipTime();
    }

    @Override
    public void loadAd() {
        if (this.tpInnerAdListener == null) {
            this.tpInnerAdListener = new TPInnerAdListener();
        }
        if (this.adUnitId == null || this.adUnitId.length() <= 0) {
            this.tpInnerAdListener.onAdLoadFailed(new AdError(1000, "adUnitId is null"));
            return;
        }
        if (this.payload == null || this.payload.length() <= 0) {
            this.tpInnerAdListener.onAdLoadFailed(new AdError(1001, "payload is null"));
            return;
        }
        Log.v((String)TAG, (String)"mediaVideo loadStart");
        InnerLog.v(TAG, "payload:" + this.payload + " adUnitId:" + this.adUnitId);
        this.payloadInfo = (TPPayloadInfo)JSON.parseObject((String)this.payload, TPPayloadInfo.class);
        this.innerSendEventMessage = new InnerSendEventMessage(GlobalTradPlus.getInstance().getContext(), this.adUnitId, this.payloadInfo);
        this.innerSendEventMessage.sendLoadAdNetworkStart();
        if (this.payloadInfo == null || this.payloadInfo.getSeatBid() == null || this.payloadInfo.getSeatBid().size() <= 0 || this.payloadInfo.getSeatBid().get(0).getBid() == null || this.payloadInfo.getSeatBid().get(0).getBid().size() <= 0) {
            this.tpInnerAdListener.onAdLoadFailed(new AdError(1100, "no fill, payload is null"));
            this.innerSendEventMessage.sendLoadAdNetworkEnd(12);
            return;
        }
        this.mIsShowing = false;
        try {
            this.startLoad(this.payloadInfo);
        }
        catch (Exception e) {
            this.tpInnerAdListener.onAdLoadFailed(new AdError(1005, "payload parse error"));
            return;
        }
    }

    private void startLoad(TPPayloadInfo payloadInfo) {
        this.bidInfo = payloadInfo.getSeatBid().get(0).getBid().get(0);
        if (this.bidInfo.getAdm() == null) {
            this.tpInnerAdListener.onAdLoadFailed(new AdError(1100, "no fill\uff0cadm is null"));
            this.innerSendEventMessage.sendLoadAdNetworkEnd(12);
            return;
        }
        if (!DeviceUtils.isNetworkAvailable((Context)GlobalTradPlus.getInstance().getContext())) {
            this.tpInnerAdListener.onAdLoadFailed(new AdError(1002, "network is not connection"));
            this.innerSendEventMessage.sendLoadAdNetworkEnd(7);
            return;
        }
        if (this.checkAdIsTimeOut(this.bidInfo)) {
            this.tpInnerAdListener.onAdLoadFailed(new AdError(1004, "payload is timeout"));
            this.innerSendEventMessage.sendLoadAdNetworkEnd(16);
            return;
        }
        this.parseAdm(this.bidInfo);
    }

    private void parseAdm(final TPPayloadInfo.SeatBid.Bid bidInfo) {
        this.innerSendEventMessage.sendLoadAdNetworkEnd(1);
        this.startTimeOutDelay(this.innerSendEventMessage);
        Log.v((String)TAG, (String)"fullscreen download video start");
        final long startTime = System.currentTimeMillis();
        final VastManager vastManager = VastManagerFactory.create(GlobalTradPlus.getInstance().getContext(), true);
        vastManager.prepareVastVideoConfiguration(bidInfo.getAdm(), new VastManager.VastManagerListener(){

            @Override
            public void onVastVideoConfigurationPrepared(VastVideoConfig vastVideoConfig) {
                InnerLog.v(InnerMediaVideoMgr.TAG, "onVastVideoConfigurationPrepared " + (vastVideoConfig == null ? "null" : vastVideoConfig.toJsonString()));
                InnerMediaVideoMgr.this.endOverTimeRunnable(InnerMediaVideoMgr.this.innerSendEventMessage != null ? InnerMediaVideoMgr.this.innerSendEventMessage.getRequestId() : "");
                if (vastVideoConfig == null || vastVideoConfig.getDiskMediaFileUrl() == null) {
                    if (InnerMediaVideoMgr.this.innerSendEventMessage != null && vastManager.isStartDownload()) {
                        InnerMediaVideoMgr.this.innerSendEventMessage.sendDownloadAdEnd("5840", 18, startTime);
                    }
                    if (InnerMediaVideoMgr.this.tpInnerAdListener != null) {
                        InnerMediaVideoMgr.this.tpInnerAdListener.onAdLoadFailed(new AdError(1006, "ad media source download fail"));
                    }
                    return;
                }
                InnerMediaVideoMgr.this.vastVideoConfig = vastVideoConfig;
                InnerMediaVideoMgr.this.getTrackUrlToBidInfo(bidInfo, vastVideoConfig);
                if (InnerMediaVideoMgr.this.tpInnerAdListener != null) {
                    InnerMediaVideoMgr.this.isReady = true;
                    InnerTrackNotification.sendWinNotification(bidInfo, VastManager.getVastNetworkMediaUrl(vastVideoConfig));
                    InnerMediaVideoMgr.this.tpInnerAdListener.onAdLoaded();
                    if (InnerMediaVideoMgr.this.tpVideoAdPlayer != null) {
                        InnerMediaVideoMgr.this.tpVideoAdPlayer.addCallback(InnerMediaVideoMgr.this.tpVideoAdPlayerCallback);
                    }
                    InnerMediaVideoMgr.this.tpAdMediaInfo = new TPAdMediaInfo(vastVideoConfig.getDiskMediaFileUrl());
                    InnerMediaVideoMgr.this.createDetailView();
                }
            }

            @Override
            public void onVastVideoDownloadStart() {
                InnerMediaVideoMgr.this.innerSendEventMessage.sendDownloadAdStart("5830");
            }
        }, bidInfo.getCrid(), GlobalTradPlus.getInstance().getContext());
    }

    private void getTrackUrlToBidInfo(TPPayloadInfo.SeatBid.Bid bid, VastVideoConfig config) {
        if (bid == null || config == null) {
            return;
        }
        if (bid.getExt() == null) {
            bid.setExt(new TPPayloadInfo.SeatBid.Bid.Ext());
        }
        for (VastTracker vastTracker : config.getImpressionTrackers()) {
            if (TextUtils.isEmpty((CharSequence)vastTracker.getContent())) continue;
            bid.getExt().getImpurl().add(vastTracker.getContent());
        }
        for (VastTracker vastTracker : config.getClickTrackers()) {
            if (TextUtils.isEmpty((CharSequence)vastTracker.getContent())) continue;
            bid.getExt().getClkurl().add(vastTracker.getContent());
        }
    }

    private void mediaViewClick() {
        String url = this.vastVideoConfig.getClickThroughUrl();
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        if (this.tpInnerAdListener != null) {
            this.tpInnerAdListener.onAdClicked();
        }
        boolean result = this.onJumpAction(GlobalTradPlus.getInstance().getContext(), url, "", this.adUnitId);
        if (this.innerSendEventMessage != null) {
            this.innerSendEventMessage.sendClickAdEnd(result ? 1 : 32);
        }
        InnerVastNotificationUtils.getInstance().sendCompanionClickNotification(this.vastVideoConfig);
        InnerTrackNotification.sendClickNotification(this.bidInfo, this.innerSendEventMessage, VastManager.getVastNetworkMediaUrl(this.vastVideoConfig));
    }

    private boolean onJumpAction(Context context, String url, String requestId, String pid) {
        boolean openSuccessed = false;
        try {
            if (url.startsWith("market:")) {
                this.openMarket(context, url);
            } else if (url.startsWith("http")) {
                this.startHtmlActivity(context, url, requestId, pid);
            } else {
                this.openDeepLink(context, url);
            }
            openSuccessed = true;
        }
        catch (Throwable t) {
            InnerLog.v(TAG, "onJumpAction:" + t.getMessage());
        }
        return openSuccessed;
    }

    private void openMarket(Context context, String url) {
        Intent i = new Intent("android.intent.action.VIEW");
        i.setData(Uri.parse((String)url));
        i.setFlags(0x10000000);
        context.startActivity(i);
    }

    private void startHtmlActivity(Context context, String url, String requestId, String pid) {
        Intent intent;
        if (InnerSdk.isJumpWebViewOutSide()) {
            intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            intent.addCategory("android.intent.category.BROWSABLE");
        } else {
            intent = new Intent(context, InnerWebViewActivity.class);
            intent.putExtra("inner_adx_url", url);
            intent.putExtra("inner_adx_tp", (Serializable)this.innerSendEventMessage.getTpPayloadInfo());
            if (requestId != null && pid != null) {
                intent.putExtra("inner_adx_request_id", requestId);
                intent.putExtra("inner_adx_pid", pid);
            }
        }
        intent.setFlags(0x10000000);
        context.startActivity(intent);
    }

    private void openDeepLink(Context context, String deepLinkUrl) {
        UrlHandler.Builder builder = new UrlHandler.Builder();
        EnumSet<UrlAction[]> urlActions = EnumSet.of(UrlAction.IGNORE_ABOUT_SCHEME, new UrlAction[]{UrlAction.OPEN_NATIVE_BROWSER, UrlAction.OPEN_IN_APP_BROWSER, UrlAction.HANDLE_SHARE_TWEET, UrlAction.FOLLOW_DEEP_LINK_WITH_FALLBACK, UrlAction.FOLLOW_DEEP_LINK});
        builder.withSupportedUrlActions(urlActions).build().handleUrl(context, deepLinkUrl);
    }

    private void sendVideoPlayProgressTrack(int progress) {
        if (this.vastVideoConfig == null) {
            return;
        }
        InnerVastNotificationUtils.getInstance().sendProgressNotification(progress, this.vastVideoConfig);
    }

    public void setDetailLayoutId(String id2) {
        if (TextUtils.isEmpty((CharSequence)id2)) {
            return;
        }
        this.detailLayoutId = id2;
    }

    public boolean isReady() {
        this.innerSendEventMessage.sendAdNetworkIsReady(0, this.isReady);
        return this.isReady && !this.checkAdIsTimeOut(this.bidInfo);
    }

    public void load() {
        if (this.tpVideoAdPlayer != null) {
            this.tpVideoAdPlayer.loadAd(this.tpAdMediaInfo, null);
        }
    }

    public void start() {
        if (this.tpVideoAdPlayer != null) {
            this.tpVideoAdPlayer.playAd(this.tpAdMediaInfo);
        }
    }

    public void pause() {
        if (this.tpVideoAdPlayer != null) {
            this.tpVideoAdPlayer.pauseAd(this.tpAdMediaInfo);
        }
    }

    public void stop() {
        if (this.tpVideoAdPlayer != null) {
            this.tpVideoAdPlayer.stopAd(this.tpAdMediaInfo);
        }
    }

    public void setAdContainerView(ViewGroup mAdContainerView) {
        this.mAdContainerView = mAdContainerView;
    }

    public void setTpVideoAdPlayer(TPVideoAdPlayer tpVideoAdPlayer) {
        this.tpVideoAdPlayer = tpVideoAdPlayer;
    }
}

