/*
 * Decompiled with CFR 0.152.
 */
package com.tp.adx.sdk.ui.views;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.LinearInterpolator;
import com.tradplus.ads.common.util.PxUtils;

public class CountDownAnimiView
extends View {
    private float mRingWidth;
    private int mRingProgessTextSize;
    private int mWidth;
    private int mHeight;
    private Paint mPaint;
    private RectF mRectF;
    private int mCountdownTime;
    private int mCurrentProgress;
    private OnCountDownFinishListener mListener;
    private Context context;

    public CountDownAnimiView(Context context) {
        this(context, null);
        this.context = context;
    }

    public CountDownAnimiView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
        this.context = context;
    }

    public CountDownAnimiView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.mRingWidth = 4.0f;
        this.mRingProgessTextSize = PxUtils.dpToPx((Context)context, (int)13);
        this.mPaint = new Paint(1);
        this.mPaint.setAntiAlias(true);
        this.setWillNotDraw(false);
    }

    public void setCountdownTime(int mCountdownTime) {
        this.mCountdownTime = mCountdownTime;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mWidth = this.getMeasuredWidth();
        this.mHeight = this.getMeasuredHeight();
        this.mRectF = new RectF(0.0f + this.mRingWidth / 2.0f, 0.0f + this.mRingWidth / 2.0f, (float)this.mWidth - this.mRingWidth / 2.0f, (float)this.mHeight - this.mRingWidth / 2.0f);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mPaint.setColor(this.context.getResources().getColor(17170443));
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(this.mRingWidth);
        canvas.drawArc(this.mRectF, -90.0f, (float)(this.mCurrentProgress - 360), false, this.mPaint);
        Paint textPaint = new Paint();
        textPaint.setAntiAlias(true);
        textPaint.setTextAlign(Paint.Align.CENTER);
        String text = this.mCountdownTime - (int)((float)this.mCurrentProgress / 360.0f * (float)this.mCountdownTime) + "";
        textPaint.setTextSize((float)this.mRingProgessTextSize);
        textPaint.setColor(this.context.getResources().getColor(17170443));
        Paint.FontMetricsInt fontMetrics = textPaint.getFontMetricsInt();
        int baseline = (int)((this.mRectF.bottom + this.mRectF.top - (float)fontMetrics.bottom - (float)fontMetrics.top) / 2.0f);
        canvas.drawText(text, this.mRectF.centerX(), (float)baseline, textPaint);
    }

    private ValueAnimator getValA(long countdownTime) {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 100.0f});
        valueAnimator.setDuration(countdownTime);
        valueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        valueAnimator.setRepeatCount(0);
        return valueAnimator;
    }

    public void startCountDown() {
        this.setClickable(false);
        ValueAnimator valueAnimator = this.getValA(this.mCountdownTime * 1000);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float i = Float.valueOf(String.valueOf(animation.getAnimatedValue())).floatValue();
                CountDownAnimiView.this.mCurrentProgress = (int)(360.0f * (i / 100.0f));
                if (CountDownAnimiView.this.mListener != null) {
                    CountDownAnimiView.this.mListener.countDownProgress(CountDownAnimiView.this.mCountdownTime - (int)((float)CountDownAnimiView.this.mCurrentProgress / 360.0f * (float)CountDownAnimiView.this.mCountdownTime));
                }
                CountDownAnimiView.this.invalidate();
            }
        });
        valueAnimator.start();
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (CountDownAnimiView.this.mListener != null) {
                    CountDownAnimiView.this.mListener.countDownFinished();
                }
                CountDownAnimiView.this.setClickable(true);
            }
        });
    }

    public void setAddCountDownListener(OnCountDownFinishListener mListener) {
        this.mListener = mListener;
    }

    public static interface OnCountDownFinishListener {
        public void countDownFinished();

        public void countDownProgress(int var1);
    }
}

