/*
 * Decompiled with CFR 0.152.
 */
package com.tp.common;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.tp.adx.sdk.bean.TPPayloadInfo;
import com.tp.adx.sdk.util.ViewUtils;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.common.util.DeviceUtils;

public class InnerImpressionUtils {
    public static boolean isDefaultImpressionSetting(TPPayloadInfo payloadInfo) {
        if (payloadInfo == null) {
            return true;
        }
        TPPayloadInfo.Ext ext = payloadInfo.getExt();
        if (ext == null) {
            return true;
        }
        TPPayloadInfo.Ext.EffectiveDisplay effectiveDisplay = ext.getEffective_display();
        if (effectiveDisplay == null) {
            return true;
        }
        return !effectiveDisplay.isCheck_visible() && effectiveDisplay.getMin_area_ratio() == 0 && effectiveDisplay.getMin_duration() == 0;
    }

    public static int getValidCount(TPPayloadInfo payloadInfo) {
        TPPayloadInfo.Ext.EffectiveDisplay effectiveDisplay;
        TPPayloadInfo.Ext ext;
        if (payloadInfo != null && (ext = payloadInfo.getExt()) != null && (effectiveDisplay = ext.getEffective_display()) != null) {
            return effectiveDisplay.getMin_duration();
        }
        return 0;
    }

    public static boolean needViewVisible(TPPayloadInfo payloadInfo) {
        TPPayloadInfo.Ext.EffectiveDisplay effectiveDisplay;
        TPPayloadInfo.Ext ext;
        if (payloadInfo != null && (ext = payloadInfo.getExt()) != null && (effectiveDisplay = ext.getEffective_display()) != null) {
            return effectiveDisplay.isCheck_visible();
        }
        return true;
    }

    public static int getViewValidArea(TPPayloadInfo payloadInfo) {
        TPPayloadInfo.Ext.EffectiveDisplay effectiveDisplay;
        TPPayloadInfo.Ext ext;
        if (payloadInfo != null && (ext = payloadInfo.getExt()) != null && (effectiveDisplay = ext.getEffective_display()) != null) {
            return effectiveDisplay.getMin_area_ratio();
        }
        return 0;
    }

    public static boolean checkValidArea(View view, TPPayloadInfo payloadInfo, TPPayloadInfo.SeatBid.Bid bidInfo) {
        long height;
        if (view == null) {
            return false;
        }
        int area = InnerImpressionUtils.getViewValidArea(payloadInfo);
        if (area == 0) {
            return true;
        }
        long w = bidInfo.getW();
        long h = bidInfo.getH();
        long width = ViewUtils.dp2px(view.getContext(), view.getWidth());
        return width * (height = (long)ViewUtils.dp2px(view.getContext(), view.getHeight())) * 100L > w * h * (long)area;
    }

    public static boolean isCover(View view, TPPayloadInfo payloadInfo, int w, int h) {
        View currentView = view;
        Log.i((String)"InnerSDK", (String)("w = " + w + " h = " + h));
        int area = InnerImpressionUtils.getViewValidArea(payloadInfo);
        if (area != 0) {
            boolean totalViewVisible;
            Rect currentViewRect = new Rect();
            boolean partVisible = currentView.getGlobalVisibleRect(currentViewRect);
            boolean halfPercentVisible = (currentViewRect.bottom - currentViewRect.top) * (currentViewRect.right - currentViewRect.left) * 100 >= DeviceUtils.dip2px((Context)GlobalTradPlus.getInstance().getContext(), (float)w) * DeviceUtils.dip2px((Context)GlobalTradPlus.getInstance().getContext(), (float)h) * area;
            boolean bl = totalViewVisible = partVisible && halfPercentVisible;
            if (!totalViewVisible) {
                return true;
            }
            while (currentView.getParent() instanceof ViewGroup) {
                ViewGroup currentParent = (ViewGroup)currentView.getParent();
                if (currentParent.getVisibility() != 0) {
                    return true;
                }
                int start = InnerImpressionUtils.indexOfViewInParent(currentView, currentParent);
                for (int i = start + 1; i < currentParent.getChildCount(); ++i) {
                    int height;
                    int width;
                    ColorDrawable colorDrawable;
                    Drawable background;
                    Rect viewRect = new Rect();
                    view.getGlobalVisibleRect(viewRect);
                    View otherView = currentParent.getChildAt(i);
                    if (otherView == null || otherView.getVisibility() != 0 || (background = otherView.getBackground()) == null || background instanceof ColorDrawable && (colorDrawable = (ColorDrawable)background).getAlpha() == 0) continue;
                    Rect otherViewRect = new Rect();
                    otherView.getGlobalVisibleRect(otherViewRect);
                    if (!Rect.intersects((Rect)viewRect, (Rect)otherViewRect) || (width = Math.min(viewRect.right, otherViewRect.right) - Math.max(viewRect.left, otherViewRect.left)) * (height = Math.min(viewRect.bottom, otherViewRect.bottom) - Math.max(viewRect.top, otherViewRect.top)) * 100 < view.getMeasuredHeight() * view.getMeasuredWidth() * area) continue;
                    return true;
                }
                currentView = currentParent;
            }
        }
        return false;
    }

    private static int indexOfViewInParent(View view, ViewGroup parent) {
        int index;
        for (index = 0; index < parent.getChildCount() && parent.getChildAt(index) != view; ++index) {
        }
        return index;
    }
}

