/*
 * Decompiled with CFR 0.152.
 */
package com.tp.vast;

import android.text.TextUtils;
import com.tp.vast.VastCompanionAdXmlManager;
import com.tp.vast.VastExtensionParentXmlManager;
import com.tp.vast.VastLinearXmlManager;
import com.tp.vast.VastTracker;
import com.tradplus.ads.base.util.XmlUtils;
import com.tradplus.ads.common.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

abstract class VastBaseInLineWrapperXmlManager {
    private static final String IMPRESSION_TRACKER = "Impression";
    private static final String COMPANION = "Companion";
    private static final String LINEAR = "Linear";
    private static final String CREATIVES = "Creatives";
    private static final String CREATIVE = "Creative";
    private static final String COMPANION_ADS = "CompanionAds";
    private static final String ERROR = "Error";
    private static final String EXTENSIONS = "Extensions";
    protected final Node mNode;

    VastBaseInLineWrapperXmlManager(Node node) {
        Preconditions.checkNotNull((Object)node);
        this.mNode = node;
    }

    List<VastTracker> getImpressionTrackers() {
        List impressionNodes = XmlUtils.getMatchingChildNodes((Node)this.mNode, (String)IMPRESSION_TRACKER);
        ArrayList<VastTracker> impressionTrackers = new ArrayList<VastTracker>();
        for (Node impressionNode : impressionNodes) {
            String uri = XmlUtils.getNodeValue((Node)impressionNode);
            if (TextUtils.isEmpty((CharSequence)uri)) continue;
            impressionTrackers.add(new VastTracker.Builder(uri).build());
        }
        return impressionTrackers;
    }

    List<VastTracker> getErrorTrackers() {
        ArrayList<VastTracker> errorTrackers = new ArrayList<VastTracker>();
        List errorNodes = XmlUtils.getMatchingChildNodes((Node)this.mNode, (String)ERROR);
        if (errorNodes == null) {
            return errorTrackers;
        }
        for (Node error : errorNodes) {
            String tracker = XmlUtils.getNodeValue((Node)error);
            if (TextUtils.isEmpty((CharSequence)tracker)) continue;
            errorTrackers.add(new VastTracker.Builder(tracker).isRepeatable(true).build());
        }
        return errorTrackers;
    }

    List<VastLinearXmlManager> getLinearXmlManagers() {
        ArrayList<VastLinearXmlManager> linearXmlManagers = new ArrayList<VastLinearXmlManager>();
        Node creativesNode = XmlUtils.getFirstMatchingChildNode((Node)this.mNode, (String)CREATIVES);
        if (creativesNode == null) {
            return linearXmlManagers;
        }
        List creativeNodes = XmlUtils.getMatchingChildNodes((Node)creativesNode, (String)CREATIVE);
        if (creativeNodes == null) {
            return linearXmlManagers;
        }
        for (Node creativeNode : creativeNodes) {
            Node linearNode = XmlUtils.getFirstMatchingChildNode((Node)creativeNode, (String)LINEAR);
            if (linearNode == null) continue;
            linearXmlManagers.add(new VastLinearXmlManager(linearNode));
        }
        return linearXmlManagers;
    }

    List<VastCompanionAdXmlManager> getCompanionAdXmlManagers() {
        ArrayList<VastCompanionAdXmlManager> companionAdXmlManagers = new ArrayList<VastCompanionAdXmlManager>();
        Node creativesNode = XmlUtils.getFirstMatchingChildNode((Node)this.mNode, (String)CREATIVES);
        if (creativesNode == null) {
            return companionAdXmlManagers;
        }
        List creativeNodes = XmlUtils.getMatchingChildNodes((Node)creativesNode, (String)CREATIVE);
        if (creativeNodes == null) {
            return companionAdXmlManagers;
        }
        for (Node creativeNode : creativeNodes) {
            List companionAdsNodes;
            Node companionAds = XmlUtils.getFirstMatchingChildNode((Node)creativeNode, (String)COMPANION_ADS);
            if (companionAds == null || (companionAdsNodes = XmlUtils.getMatchingChildNodes((Node)companionAds, (String)COMPANION)) == null) continue;
            for (Node companionNode : companionAdsNodes) {
                companionAdXmlManagers.add(new VastCompanionAdXmlManager(companionNode));
            }
        }
        return companionAdXmlManagers;
    }

    VastExtensionParentXmlManager getVastExtensionParentXmlManager() {
        Node vastExtensionsNode = XmlUtils.getFirstMatchingChildNode((Node)this.mNode, (String)EXTENSIONS);
        if (vastExtensionsNode == null) {
            return null;
        }
        return new VastExtensionParentXmlManager(vastExtensionsNode);
    }
}

