/*
 * Decompiled with CFR 0.152.
 */
package com.tp.vast;

import android.text.TextUtils;
import com.tp.vast.VastResourceXmlManager;
import com.tp.vast.VastTracker;
import com.tradplus.ads.base.util.XmlUtils;
import com.tradplus.ads.common.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Node;

class VastCompanionAdXmlManager {
    private static final String VIDEO_TRACKER = "Tracking";
    private static final String TRACKING_EVENTS = "TrackingEvents";
    private static final String COMPANION_CLICK_THROUGH = "CompanionClickThrough";
    private static final String COMPANION_CLICK_TRACKING = "CompanionClickTracking";
    private static final String EVENT = "event";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String AD_SLOT_ID = "adSlotID";
    private static final String CREATIVE_VIEW = "creativeView";
    private final Node mCompanionNode;
    private final VastResourceXmlManager mResourceXmlManager;

    VastCompanionAdXmlManager(Node companionNode) {
        Preconditions.checkNotNull((Object)companionNode, (String)"companionNode cannot be null");
        this.mCompanionNode = companionNode;
        this.mResourceXmlManager = new VastResourceXmlManager(companionNode);
    }

    Integer getWidth() {
        return XmlUtils.getAttributeValueAsInt((Node)this.mCompanionNode, (String)WIDTH);
    }

    Integer getHeight() {
        return XmlUtils.getAttributeValueAsInt((Node)this.mCompanionNode, (String)HEIGHT);
    }

    String getAdSlotId() {
        return XmlUtils.getAttributeValue((Node)this.mCompanionNode, (String)AD_SLOT_ID);
    }

    VastResourceXmlManager getResourceXmlManager() {
        return this.mResourceXmlManager;
    }

    String getClickThroughUrl() {
        Node node = XmlUtils.getFirstMatchingChildNode((Node)this.mCompanionNode, (String)COMPANION_CLICK_THROUGH);
        return XmlUtils.getNodeValue((Node)node);
    }

    List<VastTracker> getClickTrackers() {
        ArrayList<VastTracker> companionAdClickTrackers = new ArrayList<VastTracker>();
        List trackerNodes = XmlUtils.getMatchingChildNodes((Node)this.mCompanionNode, (String)COMPANION_CLICK_TRACKING);
        if (trackerNodes == null) {
            return companionAdClickTrackers;
        }
        for (Node trackerNode : trackerNodes) {
            String uri = XmlUtils.getNodeValue((Node)trackerNode);
            if (TextUtils.isEmpty((CharSequence)uri)) continue;
            companionAdClickTrackers.add(new VastTracker.Builder(uri).build());
        }
        return companionAdClickTrackers;
    }

    List<VastTracker> getCompanionCreativeViewTrackers() {
        ArrayList<VastTracker> companionCreativeViewTrackers = new ArrayList<VastTracker>();
        Node node = XmlUtils.getFirstMatchingChildNode((Node)this.mCompanionNode, (String)TRACKING_EVENTS);
        if (node == null) {
            return companionCreativeViewTrackers;
        }
        List trackerNodes = XmlUtils.getMatchingChildNodes((Node)node, (String)VIDEO_TRACKER, (String)EVENT, Collections.singletonList(CREATIVE_VIEW));
        for (Node trackerNode : trackerNodes) {
            String trackerUrl = XmlUtils.getNodeValue((Node)trackerNode);
            if (trackerUrl == null) continue;
            companionCreativeViewTrackers.add(new VastTracker.Builder(trackerUrl).build());
        }
        return companionCreativeViewTrackers;
    }

    boolean hasResources() {
        return !TextUtils.isEmpty((CharSequence)this.mResourceXmlManager.getStaticResource()) || !TextUtils.isEmpty((CharSequence)this.mResourceXmlManager.getHTMLResource()) || !TextUtils.isEmpty((CharSequence)this.mResourceXmlManager.getIFrameResource());
    }
}

