/*
 * Decompiled with CFR 0.152.
 */
package com.tp.vast;

import android.text.TextUtils;
import com.tp.vast.VideoViewabilityTracker;
import com.tp.vast.VideoViewabilityTrackerXmlManager;
import com.tradplus.ads.base.util.XmlUtils;
import com.tradplus.ads.common.Preconditions;
import org.w3c.dom.Node;

public class VastExtensionXmlManager {
    public static final String VIDEO_VIEWABILITY_TRACKER = "MoPubViewabilityTracker";
    public static final String TYPE = "type";
    public static final String ID = "id";
    final Node mExtensionNode;

    public VastExtensionXmlManager(Node extensionNode) {
        Preconditions.checkNotNull((Object)extensionNode);
        this.mExtensionNode = extensionNode;
    }

    VideoViewabilityTracker getVideoViewabilityTracker() {
        Node videoViewabilityTrackerNode = XmlUtils.getFirstMatchingChildNode((Node)this.mExtensionNode, (String)VIDEO_VIEWABILITY_TRACKER);
        if (videoViewabilityTrackerNode == null) {
            return null;
        }
        VideoViewabilityTrackerXmlManager videoViewabilityTrackerXmlManager = new VideoViewabilityTrackerXmlManager(videoViewabilityTrackerNode);
        Integer viewablePlaytime = videoViewabilityTrackerXmlManager.getViewablePlaytimeMS();
        Integer percentViewable = videoViewabilityTrackerXmlManager.getPercentViewable();
        String videoViewabilityTrackerUrl = videoViewabilityTrackerXmlManager.getVideoViewabilityTrackerUrl();
        if (viewablePlaytime == null || percentViewable == null || TextUtils.isEmpty((CharSequence)videoViewabilityTrackerUrl)) {
            return null;
        }
        return new VideoViewabilityTracker.Builder(videoViewabilityTrackerUrl, viewablePlaytime, percentViewable).build();
    }

    String getType() {
        return XmlUtils.getAttributeValue((Node)this.mExtensionNode, (String)TYPE);
    }
}

