/*
 * Decompiled with CFR 0.152.
 */
package com.tp.vast;

import com.tp.adx.sdk.util.InnerLog;
import com.tp.vast.VastAbsoluteProgressTracker;
import com.tp.vast.VastResourceXmlManager;
import com.tp.vast.VastTracker;
import com.tradplus.ads.base.util.XmlUtils;
import com.tradplus.ads.common.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

public class VastIconXmlManager {
    public static final String ICON_CLICKS = "IconClicks";
    public static final String ICON_CLICK_TRACKING = "IconClickTracking";
    public static final String ICON_CLICK_THROUGH = "IconClickThrough";
    public static final String ICON_VIEW_TRACKING = "IconViewTracking";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String OFFSET = "offset";
    public static final String DURATION = "duration";
    private final Node mIconNode;
    private final VastResourceXmlManager mResourceXmlManager;

    VastIconXmlManager(Node iconNode) {
        Preconditions.checkNotNull((Object)iconNode);
        this.mIconNode = iconNode;
        this.mResourceXmlManager = new VastResourceXmlManager(iconNode);
    }

    Integer getWidth() {
        return XmlUtils.getAttributeValueAsInt((Node)this.mIconNode, (String)WIDTH);
    }

    Integer getHeight() {
        return XmlUtils.getAttributeValueAsInt((Node)this.mIconNode, (String)HEIGHT);
    }

    Integer getOffsetMS() {
        String iconOffsetStr = XmlUtils.getAttributeValue((Node)this.mIconNode, (String)OFFSET);
        Integer iconOffset = null;
        try {
            iconOffset = VastAbsoluteProgressTracker.Companion.parseAbsoluteOffset(iconOffsetStr);
        }
        catch (NumberFormatException e) {
            InnerLog.v(String.format("Invalid VAST icon offset format: %s:" + iconOffsetStr, new Object[0]));
        }
        return iconOffset;
    }

    Integer getDurationMS() {
        String iconDurationStr = XmlUtils.getAttributeValue((Node)this.mIconNode, (String)DURATION);
        Integer iconDuration = null;
        try {
            iconDuration = VastAbsoluteProgressTracker.Companion.parseAbsoluteOffset(iconDurationStr);
        }
        catch (NumberFormatException e) {
            InnerLog.v(String.format("Invalid VAST icon duration format: %s:" + iconDurationStr, new Object[0]));
        }
        return iconDuration;
    }

    VastResourceXmlManager getResourceXmlManager() {
        return this.mResourceXmlManager;
    }

    List<VastTracker> getClickTrackingUris() {
        Node iconClicksNode = XmlUtils.getFirstMatchingChildNode((Node)this.mIconNode, (String)ICON_CLICKS);
        ArrayList<VastTracker> iconClickTrackingUris = new ArrayList<VastTracker>();
        if (iconClicksNode == null) {
            return iconClickTrackingUris;
        }
        List iconClickTrackingNodes = XmlUtils.getMatchingChildNodes((Node)iconClicksNode, (String)ICON_CLICK_TRACKING);
        for (Node iconClickTrackingNode : iconClickTrackingNodes) {
            String uri = XmlUtils.getNodeValue((Node)iconClickTrackingNode);
            if (uri == null) continue;
            iconClickTrackingUris.add(new VastTracker.Builder(uri).build());
        }
        return iconClickTrackingUris;
    }

    String getClickThroughUri() {
        Node iconClicksNode = XmlUtils.getFirstMatchingChildNode((Node)this.mIconNode, (String)ICON_CLICKS);
        if (iconClicksNode == null) {
            return null;
        }
        Node iconClickThroughNode = XmlUtils.getFirstMatchingChildNode((Node)iconClicksNode, (String)ICON_CLICK_THROUGH);
        return XmlUtils.getNodeValue((Node)iconClickThroughNode);
    }

    List<VastTracker> getViewTrackingUris() {
        List iconViewTrackingNodes = XmlUtils.getMatchingChildNodes((Node)this.mIconNode, (String)ICON_VIEW_TRACKING);
        ArrayList<VastTracker> iconViewTrackingUris = new ArrayList<VastTracker>();
        for (Node iconViewTrackingNode : iconViewTrackingNodes) {
            String uri = XmlUtils.getNodeValue((Node)iconViewTrackingNode);
            if (uri == null) continue;
            iconViewTrackingUris.add(new VastTracker.Builder(uri).build());
        }
        return iconViewTrackingUris;
    }
}

