/*
 * Decompiled with CFR 0.152.
 */
package com.tp.vast;

import com.tp.adx.sdk.util.InnerLog;
import com.tp.vast.VastAbsoluteProgressTracker;
import com.tradplus.ads.base.util.XmlUtils;
import com.tradplus.ads.common.Preconditions;
import org.w3c.dom.Node;

public class VideoViewabilityTrackerXmlManager {
    public static final String VIEWABLE_PLAYTIME = "viewablePlaytime";
    public static final String PERCENT_VIEWABLE = "percentViewable";
    private final Node mVideoViewabilityNode;

    VideoViewabilityTrackerXmlManager(Node videoViewabilityNode) {
        Preconditions.checkNotNull((Object)videoViewabilityNode);
        this.mVideoViewabilityNode = videoViewabilityNode;
    }

    Integer getViewablePlaytimeMS() {
        String viewablePlaytimeStr = XmlUtils.getAttributeValue((Node)this.mVideoViewabilityNode, (String)VIEWABLE_PLAYTIME);
        if (viewablePlaytimeStr == null) {
            return null;
        }
        Integer viewablePlaytimeMS = null;
        if (VastAbsoluteProgressTracker.Companion.isAbsoluteTracker(viewablePlaytimeStr)) {
            try {
                viewablePlaytimeMS = VastAbsoluteProgressTracker.Companion.parseAbsoluteOffset(viewablePlaytimeStr);
            }
            catch (NumberFormatException e) {
                InnerLog.v(String.format("Invalid VAST viewablePlaytime format for \"HH:MM:SS[.mmm]\": %s:", viewablePlaytimeStr));
            }
        } else {
            try {
                viewablePlaytimeMS = (int)(Float.parseFloat(viewablePlaytimeStr) * 1000.0f);
            }
            catch (NumberFormatException e) {
                InnerLog.v(String.format("Invalid VAST viewablePlaytime format for \"SS[.mmm]\": %s:", viewablePlaytimeStr));
            }
        }
        if (viewablePlaytimeMS == null || viewablePlaytimeMS < 0) {
            return null;
        }
        return viewablePlaytimeMS;
    }

    Integer getPercentViewable() {
        String percentViewableStr = XmlUtils.getAttributeValue((Node)this.mVideoViewabilityNode, (String)PERCENT_VIEWABLE);
        if (percentViewableStr == null) {
            return null;
        }
        Integer percentViewable = null;
        try {
            percentViewable = (int)Float.parseFloat(percentViewableStr.replace("%", ""));
        }
        catch (NumberFormatException e) {
            InnerLog.v(String.format("Invalid VAST percentViewable format for \"d{1,3}%%\": %s:", percentViewableStr));
        }
        if (percentViewable == null || percentViewable < 0 || percentViewable > 100) {
            return null;
        }
        return percentViewable;
    }

    String getVideoViewabilityTrackerUrl() {
        return XmlUtils.getNodeValue((Node)this.mVideoViewabilityNode);
    }
}

