/*
 * Decompiled with CFR 0.152.
 */
package com.tp.adx.open;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.iab.omid.library.tradplus.adsession.AdSession;
import com.iab.omid.library.tradplus.adsession.media.InteractionType;
import com.iab.omid.library.tradplus.adsession.media.MediaEvents;
import com.tp.adx.R;
import com.tp.adx.open.TPInnerNativeAd;
import com.tp.adx.sdk.bean.TPPayloadInfo;
import com.tp.adx.sdk.common.InnerImageLoader;
import com.tp.adx.sdk.common.InnerTaskManager;
import com.tp.adx.sdk.util.InnerLog;
import com.tp.adx.sdk.util.ViewUtils;
import com.tp.vast.VastVideoConfig;

public class TPInnerMediaView
extends RelativeLayout
implements TextureView.SurfaceTextureListener {
    public static final String TAG = "InnerSDK";
    private static final int MEDIA_MUTE_WIDTH = 30;
    private MediaPlayer mMediaPlayer;
    private SurfaceTexture mSurfaceTexture;
    private TextureView mTextureView;
    private Surface mSurface;
    private String diskFileUrl;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mCurrentPosition;
    private int mDuration;
    private int mVideoProgress25;
    private int mVideoProgress50;
    private int mVideoProgress75;
    private boolean mVideoPlay25;
    private boolean mVideoPlay50;
    private boolean mVideoPlay75;
    private boolean mFlag;
    private boolean mIsVideoStart;
    private boolean mIsVideoPlayCompletion;
    private boolean mIsMediaPlayerPrepared;
    private OnPlayerListener mListener;
    private Handler mMainHandler;
    private Button mMuteBtn;
    private boolean mIsMute;
    private Thread mProgressThread;
    private MediaEvents mediaEvents;
    private AdSession adSession;
    private boolean isVideoVast;
    private boolean isSkipped;
    private boolean isStartCheckHardwareAccelerated;

    public TPInnerMediaView(Context context) {
        TPInnerMediaView tPInnerMediaView = this;
        super(context);
        tPInnerMediaView.mCurrentPosition = -1;
        tPInnerMediaView.mFlag = false;
        tPInnerMediaView.mIsVideoStart = false;
        tPInnerMediaView.mIsVideoPlayCompletion = false;
        tPInnerMediaView.mIsMediaPlayerPrepared = false;
        tPInnerMediaView.init();
    }

    public TPInnerMediaView(Context context, AttributeSet attributeSet) {
        TPInnerMediaView tPInnerMediaView = this;
        super(context, attributeSet);
        tPInnerMediaView.mCurrentPosition = -1;
        tPInnerMediaView.mFlag = false;
        tPInnerMediaView.mIsVideoStart = false;
        tPInnerMediaView.mIsVideoPlayCompletion = false;
        tPInnerMediaView.mIsMediaPlayerPrepared = false;
        tPInnerMediaView.init();
    }

    private void init() {
        Handler handler;
        TPInnerMediaView tPInnerMediaView = this;
        tPInnerMediaView.setSaveEnabled(true);
        Handler handler2 = handler;
        handler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message message) {
                1 v02 = this;
                TPInnerMediaView.access$002(v02.TPInnerMediaView.this, message.what);
                if (v02.TPInnerMediaView.this.mCurrentPosition <= 0) {
                    return;
                }
                if (!TPInnerMediaView.this.mIsVideoStart && !TPInnerMediaView.this.mIsVideoPlayCompletion) {
                    1 v1 = this;
                    TPInnerMediaView.access$102(v1.TPInnerMediaView.this, true);
                    if (v1.TPInnerMediaView.this.mediaEvents != null && TPInnerMediaView.this.adSession != null) {
                        1 v2 = this;
                        message = v2.TPInnerMediaView.this.mediaEvents;
                        float f2 = v2.TPInnerMediaView.this.mMediaPlayer.getDuration();
                        float f3 = v2.TPInnerMediaView.this.mIsMute ? 0.0f : 1.0f;
                        message.start(f2, f3);
                    }
                    if (TPInnerMediaView.this.mListener != null) {
                        TPInnerMediaView.this.mListener.onVideoPlayStart();
                    }
                }
                if (TPInnerMediaView.this.mListener != null) {
                    TPInnerMediaView.this.mListener.onVideoUpdateProgress(TPInnerMediaView.this.mCurrentPosition, TPInnerMediaView.this.mDuration);
                }
                if (!TPInnerMediaView.this.mVideoPlay25 && TPInnerMediaView.this.mCurrentPosition >= TPInnerMediaView.this.mVideoProgress25) {
                    1 v3 = this;
                    TPInnerMediaView.access$902(v3.TPInnerMediaView.this, true);
                    if (v3.TPInnerMediaView.this.mediaEvents != null && TPInnerMediaView.this.adSession != null) {
                        TPInnerMediaView.this.mediaEvents.firstQuartile();
                    }
                    if (TPInnerMediaView.this.mListener != null) {
                        TPInnerMediaView.this.mListener.onVideoPlayProgress(25);
                    }
                } else if (!TPInnerMediaView.this.mVideoPlay50 && TPInnerMediaView.this.mCurrentPosition >= TPInnerMediaView.this.mVideoProgress50) {
                    1 v4 = this;
                    TPInnerMediaView.access$1102(v4.TPInnerMediaView.this, true);
                    if (v4.TPInnerMediaView.this.mediaEvents != null && TPInnerMediaView.this.adSession != null) {
                        TPInnerMediaView.this.mediaEvents.midpoint();
                    }
                    if (TPInnerMediaView.this.mListener != null) {
                        TPInnerMediaView.this.mListener.onVideoPlayProgress(50);
                    }
                } else if (!TPInnerMediaView.this.mVideoPlay75 && TPInnerMediaView.this.mCurrentPosition >= TPInnerMediaView.this.mVideoProgress75) {
                    1 v5 = this;
                    TPInnerMediaView.access$1302(v5.TPInnerMediaView.this, true);
                    if (v5.TPInnerMediaView.this.mediaEvents != null && TPInnerMediaView.this.adSession != null) {
                        TPInnerMediaView.this.mediaEvents.thirdQuartile();
                    }
                    if (TPInnerMediaView.this.mListener != null) {
                        TPInnerMediaView.this.mListener.onVideoPlayProgress(75);
                    }
                }
            }
        };
        tPInnerMediaView.mMainHandler = handler2;
        tPInnerMediaView.initView();
    }

    private void initView() {
        TPInnerMediaView tPInnerMediaView = this;
        InnerLog.v((String)TAG, (String)"TPInnerMediaView MediaView initView");
        tPInnerMediaView.initTextureView();
        tPInnerMediaView.initMediaPlayer();
    }

    private void startProgressThread() {
        Runnable runnable;
        Thread thread;
        if (this.mProgressThread != null) {
            return;
        }
        this.mFlag = true;
        Thread thread2 = thread;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                while (TPInnerMediaView.this.mFlag) {
                    if (TPInnerMediaView.this.mIsVideoPlayCompletion || TPInnerMediaView.this.mMediaPlayer == null || !TPInnerMediaView.this.mMediaPlayer.isPlaying() || TPInnerMediaView.this.mMainHandler == null) continue;
                    TPInnerMediaView.this.mMainHandler.sendEmptyMessage(TPInnerMediaView.this.mMediaPlayer.getCurrentPosition());
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        };
        thread2(runnable2);
        this.mProgressThread = thread2;
        thread.start();
    }

    private void stopProgressThread() {
        TPInnerMediaView tPInnerMediaView = this;
        tPInnerMediaView.mFlag = false;
        tPInnerMediaView.mProgressThread = null;
    }

    private void initMediaPlayer() {
        if (this.mMediaPlayer == null) {
            MediaPlayer mediaPlayer;
            MediaPlayer mediaPlayer2 = mediaPlayer;
            mediaPlayer = new MediaPlayer();
            this.mMediaPlayer = mediaPlayer2;
            boolean bl = this.mIsMute;
            float f2 = bl ? 0.0f : 1.0f;
            float f3 = bl ? 0.0f : 1.0f;
            TPInnerMediaView tPInnerMediaView = this;
            mediaPlayer2.setVolume(f2, f3);
            tPInnerMediaView.mMediaPlayer.setAudioStreamType(3);
            tPInnerMediaView.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mediaPlayer) {
                    4 v02 = this;
                    InnerLog.v((String)TPInnerMediaView.TAG, (String)"TPInnerMediaView MediaPlayer onPrepared()...");
                    TPInnerMediaView.access$1802(v02.TPInnerMediaView.this, true);
                    TPInnerMediaView tPInnerMediaView = v02.TPInnerMediaView.this;
                    TPInnerMediaView.access$802(tPInnerMediaView, tPInnerMediaView.mMediaPlayer.getDuration());
                    TPInnerMediaView tPInnerMediaView2 = v02.TPInnerMediaView.this;
                    TPInnerMediaView.access$1002(tPInnerMediaView2, Math.round((float)tPInnerMediaView2.mDuration * 0.25f));
                    TPInnerMediaView tPInnerMediaView3 = v02.TPInnerMediaView.this;
                    TPInnerMediaView.access$1202(tPInnerMediaView3, Math.round((float)tPInnerMediaView3.mDuration * 0.5f));
                    TPInnerMediaView tPInnerMediaView4 = v02.TPInnerMediaView.this;
                    TPInnerMediaView.access$1402(tPInnerMediaView4, Math.round((float)tPInnerMediaView4.mDuration * 0.75f));
                    if (v02.TPInnerMediaView.this.mCurrentPosition > 0) {
                        TPInnerMediaView.this.mMediaPlayer.seekTo(TPInnerMediaView.this.mCurrentPosition);
                    } else {
                        TPInnerMediaView.this.start();
                    }
                }
            });
            tPInnerMediaView.mMediaPlayer.setOnSeekCompleteListener(new MediaPlayer.OnSeekCompleteListener(){

                public void onSeekComplete(MediaPlayer mediaPlayer) {
                    if (TPInnerMediaView.this.mIsVideoPlayCompletion && TPInnerMediaView.this.mCurrentPosition == TPInnerMediaView.this.mDuration) {
                        return;
                    }
                    TPInnerMediaView.this.start();
                }
            });
            if (!tPInnerMediaView.mIsVideoPlayCompletion) {
                this.mMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                    public void onCompletion(MediaPlayer mediaPlayer) {
                        if (!TPInnerMediaView.this.mIsVideoPlayCompletion) {
                            6 v02 = this;
                            TPInnerMediaView.access$202(v02.TPInnerMediaView.this, true);
                            v02.TPInnerMediaView.this.stopProgressThread();
                            if (v02.TPInnerMediaView.this.mListener != null) {
                                TPInnerMediaView.this.mListener.onVideoPlayCompletion();
                            }
                            6 v1 = this;
                            TPInnerMediaView tPInnerMediaView = v1.TPInnerMediaView.this;
                            TPInnerMediaView.access$002(tPInnerMediaView, tPInnerMediaView.mDuration);
                            if (v1.TPInnerMediaView.this.mMediaPlayer != null) {
                                TPInnerMediaView.this.mMediaPlayer.seekTo(TPInnerMediaView.this.mCurrentPosition);
                            }
                            InnerLog.v((String)TPInnerMediaView.TAG, (String)"TPInnerMediaView onVideoPlayCompletion");
                            if (TPInnerMediaView.this.mediaEvents != null && TPInnerMediaView.this.adSession != null && !TPInnerMediaView.this.isSkipped) {
                                TPInnerMediaView.this.mediaEvents.complete();
                            }
                            if (TPInnerMediaView.this.mMuteBtn != null) {
                                TPInnerMediaView.this.mMuteBtn.setVisibility(8);
                            }
                        }
                    }
                });
            }
            this.mMediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                public boolean onError(MediaPlayer mediaPlayer, int n2, int n3) {
                    if (TPInnerMediaView.this.mListener != null) {
                        TPInnerMediaView.this.mListener.onVideoShowFailed();
                    }
                    return true;
                }
            });
        }
    }

    private void initTextureView() {
        if (tPInnerMediaView2.mTextureView == null) {
            RelativeLayout.LayoutParams layoutParams;
            TextureView textureView;
            TextureView textureView2;
            TPInnerMediaView tPInnerMediaView = tPInnerMediaView2;
            TextureView textureView3 = textureView2 = textureView;
            textureView3(tPInnerMediaView2.getContext());
            tPInnerMediaView2.mTextureView = textureView3;
            textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)tPInnerMediaView2);
            tPInnerMediaView.mTextureView.setKeepScreenOn(true);
            TPInnerMediaView tPInnerMediaView2 = layoutParams;
            new RelativeLayout.LayoutParams(-1, -1).addRule(13);
            tPInnerMediaView.removeAllViews();
            tPInnerMediaView.addView((View)tPInnerMediaView.mTextureView, (ViewGroup.LayoutParams)tPInnerMediaView2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openPlayer() {
        if (TextUtils.isEmpty((CharSequence)((TPInnerMediaView)((Object)onPlayerListener)).diskFileUrl)) {
            return;
        }
        try {
            if (((TPInnerMediaView)((Object)onPlayerListener)).mMediaPlayer == null) {
                ((TPInnerMediaView)((Object)onPlayerListener)).initMediaPlayer();
            }
            TPInnerMediaView tPInnerMediaView = onPlayerListener;
            tPInnerMediaView.mMediaPlayer.reset();
            tPInnerMediaView.mMediaPlayer.setDataSource(onPlayerListener.getContext(), Uri.parse((String)((TPInnerMediaView)((Object)onPlayerListener)).diskFileUrl));
            if (tPInnerMediaView.mSurface == null) {
                ((TPInnerMediaView)((Object)onPlayerListener)).mSurface = new Surface(((TPInnerMediaView)((Object)onPlayerListener)).mSurfaceTexture);
            }
            OnPlayerListener onPlayerListener = onPlayerListener;
            ((TPInnerMediaView)((Object)onPlayerListener)).mMediaPlayer.setSurface(((TPInnerMediaView)((Object)onPlayerListener)).mSurface);
            ((TPInnerMediaView)((Object)onPlayerListener)).mMediaPlayer.prepareAsync();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            OnPlayerListener onPlayerListener = ((TPInnerMediaView)((Object)onPlayerListener)).mListener;
            if (onPlayerListener == null) return;
            onPlayerListener.onVideoShowFailed();
        }
    }

    private void checkHardwareAccelerated() {
        if (!this.isStartCheckHardwareAccelerated) {
            this.isStartCheckHardwareAccelerated = true;
            InnerTaskManager.getInstance().runOnMainThreadDelayed(new Runnable(){

                @Override
                public void run() {
                    if (!TPInnerMediaView.this.mTextureView.isHardwareAccelerated() && TPInnerMediaView.this.mListener != null) {
                        TPInnerMediaView.this.mListener.onVideoShowFailed();
                    }
                }
            }, 500L);
        }
    }

    public static /* synthetic */ int access$002(TPInnerMediaView tPInnerMediaView, int n2) {
        tPInnerMediaView.mCurrentPosition = n2;
        return n2;
    }

    public static /* synthetic */ boolean access$102(TPInnerMediaView tPInnerMediaView, boolean bl) {
        tPInnerMediaView.mIsVideoStart = bl;
        return bl;
    }

    public static /* synthetic */ boolean access$902(TPInnerMediaView tPInnerMediaView, boolean bl) {
        tPInnerMediaView.mVideoPlay25 = bl;
        return bl;
    }

    public static /* synthetic */ boolean access$1102(TPInnerMediaView tPInnerMediaView, boolean bl) {
        tPInnerMediaView.mVideoPlay50 = bl;
        return bl;
    }

    public static /* synthetic */ boolean access$1302(TPInnerMediaView tPInnerMediaView, boolean bl) {
        tPInnerMediaView.mVideoPlay75 = bl;
        return bl;
    }

    public static /* synthetic */ boolean access$602(TPInnerMediaView tPInnerMediaView, boolean bl) {
        tPInnerMediaView.mIsMute = bl;
        return bl;
    }

    public static /* synthetic */ boolean access$1802(TPInnerMediaView tPInnerMediaView, boolean bl) {
        tPInnerMediaView.mIsMediaPlayerPrepared = bl;
        return bl;
    }

    public static /* synthetic */ int access$802(TPInnerMediaView tPInnerMediaView, int n2) {
        tPInnerMediaView.mDuration = n2;
        return n2;
    }

    public static /* synthetic */ int access$1002(TPInnerMediaView tPInnerMediaView, int n2) {
        tPInnerMediaView.mVideoProgress25 = n2;
        return n2;
    }

    public static /* synthetic */ int access$1202(TPInnerMediaView tPInnerMediaView, int n2) {
        tPInnerMediaView.mVideoProgress50 = n2;
        return n2;
    }

    public static /* synthetic */ int access$1402(TPInnerMediaView tPInnerMediaView, int n2) {
        tPInnerMediaView.mVideoProgress75 = n2;
        return n2;
    }

    public static /* synthetic */ boolean access$202(TPInnerMediaView tPInnerMediaView, boolean bl) {
        tPInnerMediaView.mIsVideoPlayCompletion = bl;
        return bl;
    }

    public void setOnPlayerListener(OnPlayerListener onPlayerListener) {
        this.mListener = onPlayerListener;
    }

    public void setIsMute(boolean bl) {
        InnerLog.v((String)TAG, (String)("TPInnerMediaView isMute - " + bl));
        this.mIsMute = bl;
    }

    public void setMute(boolean bl) {
        if (bl) {
            MediaPlayer mediaPlayer = ((TPInnerMediaView)((Object)this)).mMediaPlayer;
            if (mediaPlayer != null) {
                mediaPlayer.setVolume(0.0f, 0.0f);
                mediaPlayer = ((TPInnerMediaView)((Object)this)).mediaEvents;
                if (mediaPlayer != null && ((TPInnerMediaView)((Object)this)).adSession != null) {
                    mediaPlayer.volumeChange(0.0f);
                }
                if ((this = ((TPInnerMediaView)((Object)this)).mListener) != null) {
                    this.onVideoMute();
                }
            }
        } else {
            MediaPlayer mediaPlayer = ((TPInnerMediaView)((Object)this)).mMediaPlayer;
            if (mediaPlayer != null) {
                mediaPlayer.setVolume(1.0f, 1.0f);
                mediaPlayer = ((TPInnerMediaView)((Object)this)).mediaEvents;
                if (mediaPlayer != null && ((TPInnerMediaView)((Object)this)).adSession != null) {
                    mediaPlayer.volumeChange(1.0f);
                }
                if ((this = ((TPInnerMediaView)((Object)this)).mListener) != null) {
                    this.onVideoNoMute();
                }
            }
        }
    }

    public void setMediaEvent(AdSession adSession, MediaEvents mediaEvents) {
        if (this.adSession == null) {
            this.adSession = adSession;
        }
        if (this.mediaEvents == null) {
            this.mediaEvents = mediaEvents;
        }
    }

    public void setDestoryMediaEvent() {
        TPInnerMediaView tPInnerMediaView = this;
        tPInnerMediaView.adSession = null;
        tPInnerMediaView.mediaEvents = null;
    }

    public void setVastVideoConfig(TPInnerNativeAd tPInnerNativeAd) {
        if (tPInnerNativeAd == null) {
            InnerLog.v((String)TAG, (String)"TPInnerMediaView setVastVideoConfig config is null");
            return;
        }
        if (tPInnerNativeAd.getVastVideoConfig() != null) {
            TPInnerMediaView tPInnerMediaView = this;
            this.diskFileUrl = tPInnerNativeAd.getVastVideoConfig().getDiskMediaFileUrl();
            this.mVideoHeight = tPInnerNativeAd.getVastVideoConfig().getVideoHeight();
            tPInnerMediaView.mVideoWidth = tPInnerNativeAd.getVastVideoConfig().getVideoWidth();
            InnerLog.v((String)TAG, (String)("TPInnerMediaView setVastVideoConfig config DiskMediaFileUrl:" + tPInnerNativeAd.getVastVideoConfig().getDiskMediaFileUrl()));
            InnerLog.v((String)TAG, (String)("TPInnerMediaView setVastVideoConfig config width:" + this.mVideoWidth + " height:" + this.mVideoHeight));
            tPInnerMediaView.isVideoVast = true;
            return;
        }
        if (tPInnerNativeAd.getImageUrl() != null) {
            ImageView imageView;
            ImageView imageView2 = imageView;
            imageView = new ImageView(this.getContext());
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
            layoutParams.addRule(13);
            this.addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
            InnerImageLoader.getInstance().loadImage(imageView2, tPInnerNativeAd.getImageUrl());
        }
    }

    public void setVastVideoConfig(TPPayloadInfo.SeatBid.Bid bid, VastVideoConfig vastVideoConfig) {
        if (bid != null && vastVideoConfig != null) {
            TPInnerMediaView tPInnerMediaView = this;
            this.diskFileUrl = vastVideoConfig.getDiskMediaFileUrl();
            this.mVideoHeight = vastVideoConfig.getVideoHeight();
            tPInnerMediaView.mVideoWidth = vastVideoConfig.getVideoWidth();
            InnerLog.v((String)TAG, (String)("TPInnerMediaView setVastVideoConfig config DiskMediaFileUrl:" + vastVideoConfig.getDiskMediaFileUrl()));
            InnerLog.v((String)TAG, (String)("TPInnerMediaView setVastVideoConfig config width:" + this.mVideoWidth + " height:" + this.mVideoHeight));
            tPInnerMediaView.isVideoVast = true;
            return;
        }
        InnerLog.v((String)TAG, (String)"TPInnerMediaView setVastVideoConfig config is null");
    }

    public boolean isVideoVast() {
        return this.isVideoVast;
    }

    public void initMuteButton() {
        RelativeLayout.LayoutParams layoutParams;
        TPInnerMediaView tPInnerMediaView = this;
        tPInnerMediaView.mMuteBtn = new Button(this.getContext());
        RelativeLayout.LayoutParams layoutParams2 = layoutParams;
        layoutParams = new RelativeLayout.LayoutParams(ViewUtils.dp2px((Context)this.getContext(), (int)30), ViewUtils.dp2px((Context)this.getContext(), (int)30));
        tPInnerMediaView.mMuteBtn.setVisibility(0);
        tPInnerMediaView.addView((View)tPInnerMediaView.mMuteBtn, (ViewGroup.LayoutParams)layoutParams2);
        if (tPInnerMediaView.mIsMute) {
            this.mMuteBtn.setBackgroundResource(R.drawable.tp_inner_video_mute);
        } else {
            this.mMuteBtn.setBackgroundResource(R.drawable.tp_inner_video_no_mute);
        }
        this.mMuteBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (TPInnerMediaView.this.mIsVideoPlayCompletion) {
                    return;
                }
                2 v02 = this;
                TPInnerMediaView tPInnerMediaView = v02.TPInnerMediaView.this;
                TPInnerMediaView.access$602(tPInnerMediaView, tPInnerMediaView.mIsMute ^ true);
                if (v02.TPInnerMediaView.this.mIsMute) {
                    2 v2 = this;
                    v2.TPInnerMediaView.this.mMuteBtn.setBackgroundResource(R.drawable.tp_inner_video_mute);
                    if (v2.TPInnerMediaView.this.mMediaPlayer != null) {
                        2 v3 = this;
                        v3.TPInnerMediaView.this.mMediaPlayer.setVolume(0.0f, 0.0f);
                        if (v3.TPInnerMediaView.this.mediaEvents != null && TPInnerMediaView.this.adSession != null) {
                            TPInnerMediaView.this.mediaEvents.volumeChange(0.0f);
                        }
                        if (TPInnerMediaView.this.mListener != null) {
                            TPInnerMediaView.this.mListener.onVideoMute();
                        }
                    }
                } else {
                    2 v4 = this;
                    v4.TPInnerMediaView.this.mMuteBtn.setBackgroundResource(R.drawable.tp_inner_video_no_mute);
                    if (v4.TPInnerMediaView.this.mMediaPlayer != null) {
                        2 v5 = this;
                        v5.TPInnerMediaView.this.mMediaPlayer.setVolume(1.0f, 1.0f);
                        if (v5.TPInnerMediaView.this.mediaEvents != null && TPInnerMediaView.this.adSession != null) {
                            TPInnerMediaView.this.mediaEvents.volumeChange(1.0f);
                        }
                        if (TPInnerMediaView.this.mListener != null) {
                            TPInnerMediaView.this.mListener.onVideoNoMute();
                        }
                    }
                }
            }
        });
    }

    public int getDuration() {
        return this.mDuration;
    }

    public void start() {
        if (this.mIsVideoPlayCompletion) {
            return;
        }
        InnerLog.v((String)TAG, (String)"TPInnerMediaView start");
        MediaPlayer mediaPlayer = this.mMediaPlayer;
        if (mediaPlayer != null && this.mIsMediaPlayerPrepared) {
            mediaPlayer.start();
        }
        if ((mediaPlayer = this.mediaEvents) != null && this.adSession != null) {
            mediaPlayer.resume();
        }
        TPInnerMediaView tPInnerMediaView = this;
        tPInnerMediaView.checkHardwareAccelerated();
        tPInnerMediaView.startProgressThread();
    }

    public void release() {
        if (!this.mIsMediaPlayerPrepared) {
            return;
        }
        TPInnerMediaView tPInnerMediaView = this;
        InnerLog.v((String)TAG, (String)"TPInnerMediaView release");
        tPInnerMediaView.stopProgressThread();
        tPInnerMediaView.mSurfaceTexture = null;
        tPInnerMediaView.mSurface = null;
        MediaPlayer mediaPlayer = tPInnerMediaView.mMediaPlayer;
        if (mediaPlayer != null) {
            if (mediaPlayer.isPlaying()) {
                this.mMediaPlayer.stop();
            }
            TPInnerMediaView tPInnerMediaView2 = this;
            tPInnerMediaView2.mMediaPlayer.reset();
            tPInnerMediaView2.mMediaPlayer.release();
            tPInnerMediaView2.mMediaPlayer = null;
        }
        if ((mediaPlayer = this.mMainHandler) != null) {
            mediaPlayer.removeCallbacksAndMessages(null);
        }
        this.mIsMediaPlayerPrepared = false;
    }

    public boolean isPlaying() {
        MediaPlayer mediaPlayer = this.mMediaPlayer;
        if (mediaPlayer != null && this.mIsMediaPlayerPrepared) {
            return mediaPlayer.isPlaying();
        }
        return false;
    }

    public void seekToEnd() {
        TPInnerMediaView tPInnerMediaView = tPInnerMediaView.mMediaPlayer;
        if (tPInnerMediaView != null) {
            TPInnerMediaView tPInnerMediaView2 = tPInnerMediaView;
            tPInnerMediaView2.seekTo(tPInnerMediaView2.getDuration());
        }
    }

    public void pause() {
        TPInnerMediaView tPInnerMediaView = this;
        tPInnerMediaView.stopProgressThread();
        if (tPInnerMediaView.isPlaying()) {
            TPInnerMediaView tPInnerMediaView2 = this;
            tPInnerMediaView2.mMediaPlayer.pause();
            MediaEvents mediaEvents = tPInnerMediaView2.mediaEvents;
            if (mediaEvents != null && this.adSession != null) {
                mediaEvents.pause();
            }
        }
    }

    public int getCurrentPosition() {
        int n2 = this.mCurrentPosition;
        if (n2 < 0) {
            n2 = 0;
        }
        return n2;
    }

    public int getVideoLength() {
        return this.mDuration;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n2, int n3) {
        InnerLog.v((String)TAG, (String)"TPInnerMediaView onSurfaceTextureAvailable()...");
        this.mSurfaceTexture = surfaceTexture;
        if (this.mVideoWidth > 0 && this.mVideoHeight > 0) {
            RelativeLayout.LayoutParams layoutParams;
            TPInnerMediaView tPInnerMediaView = this;
            int n4 = tPInnerMediaView.getWidth();
            float f2 = Math.min((float)n4 / (float)this.mVideoWidth, (float)tPInnerMediaView.getHeight() / (float)this.mVideoHeight);
            RelativeLayout.LayoutParams layoutParams2 = layoutParams;
            new RelativeLayout.LayoutParams((int)((float)this.mVideoWidth * f2), (int)((float)this.mVideoHeight * f2)).addRule(13);
            InnerLog.v((String)TAG, (String)("TPInnerMediaView setVastVideoConfig reset width:" + layoutParams2.width + " height:" + layoutParams2.height));
            tPInnerMediaView.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        }
        this.openPlayer();
    }

    public void setClickEvent() {
        MediaEvents mediaEvents = this.mediaEvents;
        if (mediaEvents != null && this.adSession != null) {
            mediaEvents.adUserInteraction(InteractionType.CLICK);
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n2, int n3) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        InnerLog.v((String)TAG, (String)"TPInnerMediaView onSurfaceTextureDestroyed()...");
        this.release();
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }

    public void onDetachedFromWindow() {
        TPInnerMediaView tPInnerMediaView = this;
        super.onDetachedFromWindow();
        InnerLog.v((String)TAG, (String)"TPInnerMediaView onDetachedFromWindow()");
        tPInnerMediaView.release();
    }

    public boolean isSkipped() {
        return this.isSkipped;
    }

    public void setSkipped(boolean bl) {
        this.isSkipped = bl;
    }

    public static interface OnPlayerListener {
        public void onVideoPlayStart();

        public void onVideoUpdateProgress(int var1, int var2);

        public void onVideoPlayCompletion();

        public void onVideoShowFailed();

        public void onVideoPlayProgress(int var1);

        public void onVideoMute();

        public void onVideoNoMute();
    }
}

