/*
 * Decompiled with CFR 0.152.
 */
package com.tp.adx.open;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.iab.omid.library.tradplus.adsession.AdSession;
import com.iab.omid.library.tradplus.adsession.media.InteractionType;
import com.iab.omid.library.tradplus.adsession.media.MediaEvents;
import com.tp.adx.R;
import com.tp.adx.open.TPInnerNativeAd;
import com.tp.adx.sdk.bean.TPPayloadInfo;
import com.tp.adx.sdk.common.InnerImageLoader;
import com.tp.adx.sdk.common.InnerTaskManager;
import com.tp.adx.sdk.util.InnerLog;
import com.tp.adx.sdk.util.ViewUtils;
import com.tp.vast.VastVideoConfig;

public class TPInnerMediaView
extends RelativeLayout
implements TextureView.SurfaceTextureListener {
    public static final String TAG = "InnerSDK";
    private static final int MEDIA_MUTE_WIDTH = 30;
    private MediaPlayer mMediaPlayer;
    private SurfaceTexture mSurfaceTexture;
    private TextureView mTextureView;
    private Surface mSurface;
    private String diskFileUrl;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mCurrentPosition = -1;
    private int mDuration;
    private int mVideoProgress25;
    private int mVideoProgress50;
    private int mVideoProgress75;
    private boolean mVideoPlay25;
    private boolean mVideoPlay50;
    private boolean mVideoPlay75;
    private boolean mFlag = false;
    private boolean mIsVideoStart = false;
    private boolean mIsVideoPlayCompletion = false;
    private boolean mIsMediaPlayerPrepared = false;
    private OnPlayerListener mListener;
    private Handler mMainHandler;
    private Button mMuteBtn;
    private boolean mIsMute;
    private Thread mProgressThread;
    private MediaEvents mediaEvents;
    private AdSession adSession;
    private boolean isVideoVast;
    private boolean isSkipped;
    private boolean isStartCheckHardwareAccelerated;

    public void setOnPlayerListener(OnPlayerListener onPlayerListener) {
        this.mListener = onPlayerListener;
    }

    public TPInnerMediaView(Context context) {
        super(context);
        this.init();
    }

    public TPInnerMediaView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    private void init() {
        this.setSaveEnabled(true);
        this.mMainHandler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message message) {
                TPInnerMediaView.this.mCurrentPosition = message.what;
                if (TPInnerMediaView.this.mCurrentPosition <= 0) {
                    return;
                }
                if (!TPInnerMediaView.this.mIsVideoStart && !TPInnerMediaView.this.mIsVideoPlayCompletion) {
                    TPInnerMediaView.this.mIsVideoStart = true;
                    if (TPInnerMediaView.this.mediaEvents != null && TPInnerMediaView.this.adSession != null) {
                        TPInnerMediaView.this.mediaEvents.start((float)TPInnerMediaView.this.mMediaPlayer.getDuration(), TPInnerMediaView.this.mIsMute ? 0.0f : 1.0f);
                    }
                    if (TPInnerMediaView.this.mListener != null) {
                        TPInnerMediaView.this.mListener.onVideoPlayStart();
                    }
                }
                if (TPInnerMediaView.this.mListener != null) {
                    TPInnerMediaView.this.mListener.onVideoUpdateProgress(TPInnerMediaView.this.mCurrentPosition, TPInnerMediaView.this.mDuration);
                }
                if (!TPInnerMediaView.this.mVideoPlay25 && TPInnerMediaView.this.mCurrentPosition >= TPInnerMediaView.this.mVideoProgress25) {
                    TPInnerMediaView.this.mVideoPlay25 = true;
                    if (TPInnerMediaView.this.mediaEvents != null && TPInnerMediaView.this.adSession != null) {
                        TPInnerMediaView.this.mediaEvents.firstQuartile();
                    }
                    if (TPInnerMediaView.this.mListener != null) {
                        TPInnerMediaView.this.mListener.onVideoPlayProgress(25);
                        return;
                    }
                } else if (!TPInnerMediaView.this.mVideoPlay50 && TPInnerMediaView.this.mCurrentPosition >= TPInnerMediaView.this.mVideoProgress50) {
                    TPInnerMediaView.this.mVideoPlay50 = true;
                    if (TPInnerMediaView.this.mediaEvents != null && TPInnerMediaView.this.adSession != null) {
                        TPInnerMediaView.this.mediaEvents.midpoint();
                    }
                    if (TPInnerMediaView.this.mListener != null) {
                        TPInnerMediaView.this.mListener.onVideoPlayProgress(50);
                        return;
                    }
                } else if (!TPInnerMediaView.this.mVideoPlay75 && TPInnerMediaView.this.mCurrentPosition >= TPInnerMediaView.this.mVideoProgress75) {
                    TPInnerMediaView.this.mVideoPlay75 = true;
                    if (TPInnerMediaView.this.mediaEvents != null && TPInnerMediaView.this.adSession != null) {
                        TPInnerMediaView.this.mediaEvents.thirdQuartile();
                    }
                    if (TPInnerMediaView.this.mListener != null) {
                        TPInnerMediaView.this.mListener.onVideoPlayProgress(75);
                    }
                }
            }
        };
        this.initView();
    }

    public void setIsMute(boolean bl) {
        InnerLog.v((String)TAG, (String)"TPInnerMediaView isMute - ".concat(String.valueOf(bl)));
        this.mIsMute = bl;
    }

    public void setMute(boolean bl) {
        if (bl) {
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.setVolume(0.0f, 0.0f);
                if (this.mediaEvents != null && this.adSession != null) {
                    this.mediaEvents.volumeChange(0.0f);
                }
                if (this.mListener != null) {
                    this.mListener.onVideoMute();
                    return;
                }
            }
        } else if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setVolume(1.0f, 1.0f);
            if (this.mediaEvents != null && this.adSession != null) {
                this.mediaEvents.volumeChange(1.0f);
            }
            if (this.mListener != null) {
                this.mListener.onVideoNoMute();
            }
        }
    }

    public void setMediaEvent(AdSession adSession, MediaEvents mediaEvents) {
        if (this.adSession == null) {
            this.adSession = adSession;
        }
        if (this.mediaEvents == null) {
            this.mediaEvents = mediaEvents;
        }
    }

    public void setDestoryMediaEvent() {
        this.adSession = null;
        this.mediaEvents = null;
    }

    public void setVastVideoConfig(TPInnerNativeAd tPInnerNativeAd) {
        if (tPInnerNativeAd == null) {
            InnerLog.v((String)TAG, (String)"TPInnerMediaView setVastVideoConfig config is null");
            return;
        }
        if (tPInnerNativeAd.getVastVideoConfig() != null) {
            this.diskFileUrl = tPInnerNativeAd.getVastVideoConfig().getDiskMediaFileUrl();
            this.mVideoHeight = tPInnerNativeAd.getVastVideoConfig().getVideoHeight();
            this.mVideoWidth = tPInnerNativeAd.getVastVideoConfig().getVideoWidth();
            InnerLog.v((String)TAG, (String)("TPInnerMediaView setVastVideoConfig config DiskMediaFileUrl:" + tPInnerNativeAd.getVastVideoConfig().getDiskMediaFileUrl()));
            InnerLog.v((String)TAG, (String)("TPInnerMediaView setVastVideoConfig config width:" + this.mVideoWidth + " height:" + this.mVideoHeight));
            this.isVideoVast = true;
            return;
        }
        if (tPInnerNativeAd.getImageUrl() != null) {
            ImageView imageView = new ImageView(this.getContext());
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
            layoutParams.addRule(13);
            this.addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
            InnerImageLoader.getInstance().loadImage(imageView, tPInnerNativeAd.getImageUrl());
        }
    }

    public void setVastVideoConfig(TPPayloadInfo.SeatBid.Bid bid, VastVideoConfig vastVideoConfig) {
        if (bid == null || vastVideoConfig == null) {
            InnerLog.v((String)TAG, (String)"TPInnerMediaView setVastVideoConfig config is null");
            return;
        }
        if (vastVideoConfig != null) {
            this.diskFileUrl = vastVideoConfig.getDiskMediaFileUrl();
            this.mVideoHeight = vastVideoConfig.getVideoHeight();
            this.mVideoWidth = vastVideoConfig.getVideoWidth();
            InnerLog.v((String)TAG, (String)("TPInnerMediaView setVastVideoConfig config DiskMediaFileUrl:" + vastVideoConfig.getDiskMediaFileUrl()));
            InnerLog.v((String)TAG, (String)("TPInnerMediaView setVastVideoConfig config width:" + this.mVideoWidth + " height:" + this.mVideoHeight));
            this.isVideoVast = true;
            return;
        }
    }

    public boolean isVideoVast() {
        return this.isVideoVast;
    }

    private void initView() {
        InnerLog.v((String)TAG, (String)"TPInnerMediaView MediaView initView");
        this.initTextureView();
        this.initMediaPlayer();
    }

    public void initMuteButton() {
        this.mMuteBtn = new Button(this.getContext());
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(ViewUtils.dp2px((Context)this.getContext(), (int)30), ViewUtils.dp2px((Context)this.getContext(), (int)30));
        this.mMuteBtn.setVisibility(0);
        TPInnerMediaView tPInnerMediaView = this;
        tPInnerMediaView.addView((View)tPInnerMediaView.mMuteBtn, (ViewGroup.LayoutParams)layoutParams);
        if (this.mIsMute) {
            this.mMuteBtn.setBackgroundResource(R.drawable.tp_inner_video_mute);
        } else {
            this.mMuteBtn.setBackgroundResource(R.drawable.tp_inner_video_no_mute);
        }
        this.mMuteBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (TPInnerMediaView.this.mIsVideoPlayCompletion) {
                    return;
                }
                TPInnerMediaView.this.mIsMute = !TPInnerMediaView.this.mIsMute;
                if (TPInnerMediaView.this.mIsMute) {
                    TPInnerMediaView.this.mMuteBtn.setBackgroundResource(R.drawable.tp_inner_video_mute);
                    if (TPInnerMediaView.this.mMediaPlayer != null) {
                        TPInnerMediaView.this.mMediaPlayer.setVolume(0.0f, 0.0f);
                        if (TPInnerMediaView.this.mediaEvents != null && TPInnerMediaView.this.adSession != null) {
                            TPInnerMediaView.this.mediaEvents.volumeChange(0.0f);
                        }
                        if (TPInnerMediaView.this.mListener != null) {
                            TPInnerMediaView.this.mListener.onVideoMute();
                            return;
                        }
                    }
                } else {
                    TPInnerMediaView.this.mMuteBtn.setBackgroundResource(R.drawable.tp_inner_video_no_mute);
                    if (TPInnerMediaView.this.mMediaPlayer != null) {
                        TPInnerMediaView.this.mMediaPlayer.setVolume(1.0f, 1.0f);
                        if (TPInnerMediaView.this.mediaEvents != null && TPInnerMediaView.this.adSession != null) {
                            TPInnerMediaView.this.mediaEvents.volumeChange(1.0f);
                        }
                        if (TPInnerMediaView.this.mListener != null) {
                            TPInnerMediaView.this.mListener.onVideoNoMute();
                        }
                    }
                }
            }
        });
    }

    private void startProgressThread() {
        if (this.mProgressThread != null) {
            return;
        }
        this.mFlag = true;
        this.mProgressThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (TPInnerMediaView.this.mFlag) {
                    if (TPInnerMediaView.this.mIsVideoPlayCompletion || TPInnerMediaView.this.mMediaPlayer == null || !TPInnerMediaView.this.mMediaPlayer.isPlaying() || TPInnerMediaView.this.mMainHandler == null) continue;
                    TPInnerMediaView.this.mMainHandler.sendEmptyMessage(TPInnerMediaView.this.mMediaPlayer.getCurrentPosition());
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        });
        this.mProgressThread.start();
    }

    private void stopProgressThread() {
        this.mFlag = false;
        this.mProgressThread = null;
    }

    private void initMediaPlayer() {
        if (this.mMediaPlayer == null) {
            this.mMediaPlayer = new MediaPlayer();
            this.mMediaPlayer.setVolume(this.mIsMute ? 0.0f : 1.0f, this.mIsMute ? 0.0f : 1.0f);
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mediaPlayer) {
                    InnerLog.v((String)TPInnerMediaView.TAG, (String)"TPInnerMediaView MediaPlayer onPrepared()...");
                    TPInnerMediaView.this.mIsMediaPlayerPrepared = true;
                    TPInnerMediaView.this.mDuration = TPInnerMediaView.this.mMediaPlayer.getDuration();
                    TPInnerMediaView.this.mVideoProgress25 = Math.round(0.25f * (float)TPInnerMediaView.this.mDuration);
                    TPInnerMediaView.this.mVideoProgress50 = Math.round(0.5f * (float)TPInnerMediaView.this.mDuration);
                    TPInnerMediaView.this.mVideoProgress75 = Math.round(0.75f * (float)TPInnerMediaView.this.mDuration);
                    if (TPInnerMediaView.this.mCurrentPosition > 0) {
                        TPInnerMediaView.this.mMediaPlayer.seekTo(TPInnerMediaView.this.mCurrentPosition);
                        return;
                    }
                    TPInnerMediaView.this.start();
                }
            });
            this.mMediaPlayer.setOnSeekCompleteListener(new MediaPlayer.OnSeekCompleteListener(){

                public void onSeekComplete(MediaPlayer mediaPlayer) {
                    if (TPInnerMediaView.this.mIsVideoPlayCompletion && TPInnerMediaView.this.mCurrentPosition == TPInnerMediaView.this.mDuration) {
                        return;
                    }
                    TPInnerMediaView.this.start();
                }
            });
            if (!this.mIsVideoPlayCompletion) {
                this.mMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                    public void onCompletion(MediaPlayer mediaPlayer) {
                        if (!TPInnerMediaView.this.mIsVideoPlayCompletion) {
                            TPInnerMediaView.this.mIsVideoPlayCompletion = true;
                            TPInnerMediaView.this.stopProgressThread();
                            if (TPInnerMediaView.this.mListener != null) {
                                TPInnerMediaView.this.mListener.onVideoPlayCompletion();
                            }
                            TPInnerMediaView.this.mCurrentPosition = TPInnerMediaView.this.mDuration;
                            if (TPInnerMediaView.this.mMediaPlayer != null) {
                                TPInnerMediaView.this.mMediaPlayer.seekTo(TPInnerMediaView.this.mCurrentPosition);
                            }
                            InnerLog.v((String)TPInnerMediaView.TAG, (String)"TPInnerMediaView onVideoPlayCompletion");
                            if (TPInnerMediaView.this.mediaEvents != null && TPInnerMediaView.this.adSession != null && !TPInnerMediaView.this.isSkipped) {
                                TPInnerMediaView.this.mediaEvents.complete();
                            }
                            if (TPInnerMediaView.this.mMuteBtn != null) {
                                TPInnerMediaView.this.mMuteBtn.setVisibility(8);
                            }
                        }
                    }
                });
            }
            this.mMediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                public boolean onError(MediaPlayer mediaPlayer, int n2, int n3) {
                    if (TPInnerMediaView.this.mListener != null) {
                        TPInnerMediaView.this.mListener.onVideoShowFailed();
                    }
                    return true;
                }
            });
        }
    }

    public int getDuration() {
        return this.mDuration;
    }

    private void initTextureView() {
        if (this.mTextureView == null) {
            this.mTextureView = new TextureView(this.getContext());
            this.mTextureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
            this.mTextureView.setKeepScreenOn(true);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
            layoutParams.addRule(13);
            this.removeAllViews();
            TPInnerMediaView tPInnerMediaView = this;
            tPInnerMediaView.addView((View)tPInnerMediaView.mTextureView, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    private void openPlayer() {
        if (TextUtils.isEmpty((CharSequence)this.diskFileUrl)) {
            return;
        }
        try {
            if (this.mMediaPlayer == null) {
                this.initMediaPlayer();
            }
            this.mMediaPlayer.reset();
            this.mMediaPlayer.setDataSource(this.getContext(), Uri.parse((String)this.diskFileUrl));
            if (this.mSurface == null) {
                this.mSurface = new Surface(this.mSurfaceTexture);
            }
            this.mMediaPlayer.setSurface(this.mSurface);
            this.mMediaPlayer.prepareAsync();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (this.mListener != null) {
                this.mListener.onVideoShowFailed();
            }
            return;
        }
    }

    public void start() {
        if (this.mIsVideoPlayCompletion) {
            return;
        }
        InnerLog.v((String)TAG, (String)"TPInnerMediaView start");
        if (this.mMediaPlayer != null && this.mIsMediaPlayerPrepared) {
            this.mMediaPlayer.start();
        }
        if (this.mediaEvents != null && this.adSession != null) {
            this.mediaEvents.resume();
        }
        this.checkHardwareAccelerated();
        this.startProgressThread();
    }

    public void release() {
        if (!this.mIsMediaPlayerPrepared) {
            return;
        }
        InnerLog.v((String)TAG, (String)"TPInnerMediaView release");
        this.stopProgressThread();
        this.mSurfaceTexture = null;
        this.mSurface = null;
        if (this.mMediaPlayer != null) {
            if (this.mMediaPlayer.isPlaying()) {
                this.mMediaPlayer.stop();
            }
            this.mMediaPlayer.reset();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
        if (this.mMainHandler != null) {
            this.mMainHandler.removeCallbacksAndMessages(null);
        }
        this.mIsMediaPlayerPrepared = false;
    }

    public boolean isPlaying() {
        if (this.mMediaPlayer != null && this.mIsMediaPlayerPrepared) {
            return this.mMediaPlayer.isPlaying();
        }
        return false;
    }

    public void seekToEnd() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.seekTo(this.mMediaPlayer.getDuration());
        }
    }

    public void pause() {
        this.stopProgressThread();
        if (this.isPlaying()) {
            this.mMediaPlayer.pause();
            if (this.mediaEvents != null && this.adSession != null) {
                this.mediaEvents.pause();
            }
        }
    }

    private void checkHardwareAccelerated() {
        if (!this.isStartCheckHardwareAccelerated) {
            this.isStartCheckHardwareAccelerated = true;
            InnerTaskManager.getInstance().runOnMainThreadDelayed(new Runnable(){

                @Override
                public void run() {
                    if (!TPInnerMediaView.this.mTextureView.isHardwareAccelerated() && TPInnerMediaView.this.mListener != null) {
                        TPInnerMediaView.this.mListener.onVideoShowFailed();
                    }
                }
            }, 500L);
        }
    }

    public int getCurrentPosition() {
        if (this.mCurrentPosition < 0) {
            return 0;
        }
        return this.mCurrentPosition;
    }

    public int getVideoLength() {
        return this.mDuration;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n2, int n3) {
        InnerLog.v((String)TAG, (String)"TPInnerMediaView onSurfaceTextureAvailable()...");
        this.mSurfaceTexture = surfaceTexture;
        if (this.mVideoWidth > 0 && this.mVideoHeight > 0) {
            int n4 = this.getWidth();
            n2 = this.getHeight();
            float f2 = Math.min((float)n4 / (float)this.mVideoWidth, (float)n2 / (float)this.mVideoHeight);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams((int)((float)this.mVideoWidth * f2), (int)((float)this.mVideoHeight * f2));
            layoutParams.addRule(13);
            InnerLog.v((String)TAG, (String)("TPInnerMediaView setVastVideoConfig reset width:" + layoutParams.width + " height:" + layoutParams.height));
            this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        this.openPlayer();
    }

    public void setClickEvent() {
        if (this.mediaEvents != null && this.adSession != null) {
            this.mediaEvents.adUserInteraction(InteractionType.CLICK);
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n2, int n3) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        InnerLog.v((String)TAG, (String)"TPInnerMediaView onSurfaceTextureDestroyed()...");
        this.release();
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        InnerLog.v((String)TAG, (String)"TPInnerMediaView onDetachedFromWindow()");
        this.release();
    }

    public boolean isSkipped() {
        return this.isSkipped;
    }

    public void setSkipped(boolean bl) {
        this.isSkipped = bl;
    }

    public static interface OnPlayerListener {
        public void onVideoPlayStart();

        public void onVideoUpdateProgress(int var1, int var2);

        public void onVideoPlayCompletion();

        public void onVideoShowFailed();

        public void onVideoPlayProgress(int var1);

        public void onVideoMute();

        public void onVideoNoMute();
    }
}

