/*
 * Decompiled with CFR 0.152.
 */
package com.tp.vast;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.tp.adx.sdk.util.InnerBrowser;
import com.tp.adx.sdk.util.InnerLog;
import com.tp.adx.sdk.util.Intents;
import com.tp.adx.sdk.util.UrlAction;
import com.tp.adx.sdk.util.UrlHandler;
import com.tp.vast.VastResource;
import com.tp.vast.VastTracker;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VastCompanionAdConfig
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Expose
    @SerializedName(value="width")
    private final int a;
    @Expose
    @SerializedName(value="height")
    private final int b;
    @Expose
    @SerializedName(value="resource")
    @NotNull
    private final VastResource c;
    @Expose
    @SerializedName(value="clickthrough_url")
    @Nullable
    private final String d;
    @Expose
    @SerializedName(value="click_trackers")
    @NotNull
    private final List<VastTracker> e;
    @Expose
    @SerializedName(value="impression_trackers")
    @NotNull
    private final List<VastTracker> f;
    @Expose
    @SerializedName(value="custom_cta_text")
    @Nullable
    private final String g;
    private static final long h = 3L;

    public VastCompanionAdConfig(int n2, int n3, @NotNull VastResource vastResource, @Nullable String string, @NotNull List<VastTracker> list, @NotNull List<VastTracker> list2, @Nullable String string2) {
        Intrinsics.checkNotNullParameter((Object)vastResource, (String)"vastResource");
        Intrinsics.checkNotNullParameter(list, (String)"clickTrackers");
        Intrinsics.checkNotNullParameter(list2, (String)"creativeViewTrackers");
        this.a = n2;
        this.b = n3;
        this.c = vastResource;
        this.d = string;
        this.e = list;
        this.f = list2;
        this.g = string2;
    }

    public final int getWidth() {
        return this.a;
    }

    public final int getHeight() {
        return this.b;
    }

    @NotNull
    public final VastResource getVastResource() {
        return this.c;
    }

    @Nullable
    public final String getClickThroughUrl() {
        return this.d;
    }

    @NotNull
    public final List<VastTracker> getClickTrackers() {
        return this.e;
    }

    @NotNull
    public final List<VastTracker> getCreativeViewTrackers() {
        return this.f;
    }

    @Nullable
    public final String getCustomCtaText() {
        return this.g;
    }

    public final void addClickTrackers(@NotNull Collection<? extends VastTracker> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"clickTrackers");
        this.e.addAll(collection);
    }

    public final void addCreativeViewTrackers(@NotNull Collection<? extends VastTracker> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"creativeViewTrackers");
        this.f.addAll(collection);
    }

    public final void handleImpression(@NotNull Context context, int n2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    public final double formatScore() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.c.getType().ordinal()]) {
            case 1: {
                if (VastResource.CreativeType.JAVASCRIPT.equals((Object)this.c.getCreativeType())) {
                    return 1.0;
                }
                if (VastResource.CreativeType.IMAGE.equals((Object)this.c.getCreativeType())) {
                    return 0.8;
                }
                return 0.0;
            }
            case 2: {
                return 1.2;
            }
            case 3: {
                return 1.0;
            }
            case 4: {
                return 0.0;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public double calculateScore(int n2, int n3) {
        if (n3 == 0 || this.b == 0) {
            return 0.0;
        }
        double d2 = Math.abs((double)n2 / (double)n3 - (double)this.a / (double)this.b);
        double d3 = Math.abs(((double)n2 - (double)this.a) / (double)n2);
        double d4 = d2 + d3;
        return this.formatScore() / (1.0 + d4);
    }

    public void handleClick(@NotNull Context context, int n2, @Nullable String urlActionArray, @Nullable String string) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(context instanceof Activity)) {
            urlActionArray = "context must be an activity";
            throw new IllegalArgumentException(urlActionArray.toString());
        }
        if ((urlActionArray = this.c.getCorrectClickThroughUrl(this.d, (String)urlActionArray)) != null && (urlActionArray = ((CharSequence)urlActionArray).length() > 0 ? urlActionArray : null) != null) {
            UrlAction[] urlActionArray2 = urlActionArray;
            UrlAction[] urlActionArray3 = new UrlAction[6];
            urlActionArray = urlActionArray3;
            urlActionArray3[0] = UrlAction.OPEN_APP_MARKET;
            urlActionArray[1] = UrlAction.OPEN_NATIVE_BROWSER;
            urlActionArray[2] = UrlAction.OPEN_IN_APP_BROWSER;
            urlActionArray[3] = UrlAction.HANDLE_SHARE_TWEET;
            urlActionArray[4] = UrlAction.FOLLOW_DEEP_LINK_WITH_FALLBACK;
            urlActionArray[5] = UrlAction.FOLLOW_DEEP_LINK;
            new UrlHandler.Builder().withSupportedUrlActions(UrlAction.IGNORE_ABOUT_SCHEME, urlActionArray).withResultActions(new UrlHandler.ResultActions(context, n2, string){
                final /* synthetic */ Context a;
                final /* synthetic */ int b;
                final /* synthetic */ String c;
                {
                    this.a = context;
                    this.b = n2;
                    this.c = string;
                }

                public final void urlHandlingSucceeded(@NotNull String charSequence, @NotNull UrlAction urlAction) {
                    Intrinsics.checkNotNullParameter((Object)charSequence, (String)"url");
                    Intrinsics.checkNotNullParameter((Object)urlAction, (String)"urlAction");
                    if (urlAction == UrlAction.OPEN_IN_APP_BROWSER) {
                        urlAction = new Bundle();
                        Object object = urlAction;
                        String string = this.c;
                        object.putString("URL", (String)charSequence);
                        charSequence = string;
                        if (!(charSequence == null || charSequence.length() == 0)) {
                            object.putString("tp-dsp-creative-id", string);
                        }
                        object = InnerBrowser.class;
                        string = Intents.getStartActivityIntent((Context)this.a, (Class)object, (Bundle)urlAction);
                        try {
                            ((Activity)this.a).startActivityForResult((Intent)string, this.b);
                            return;
                        }
                        catch (ActivityNotFoundException activityNotFoundException) {
                            InnerLog.v((String)("Activity " + ((Class)object).getName() + " not found. Did you declare it in your AndroidManifest.xml?"));
                        }
                    }
                }

                public final void urlHandlingFailed(@NotNull String string, @NotNull UrlAction urlAction) {
                    Intrinsics.checkNotNullParameter((Object)string, (String)"url");
                    Intrinsics.checkNotNullParameter((Object)urlAction, (String)"lastFailedUrlAction");
                }
            }).withDspCreativeId(string).withoutInnerBrowser().build().handleUrl(context, (String)urlActionArray2);
        }
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof VastCompanionAdConfig)) {
            return false;
        }
        if (this.a != ((VastCompanionAdConfig)object).a) {
            return false;
        }
        if (this.b != ((VastCompanionAdConfig)object).b) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.c, (Object)((VastCompanionAdConfig)object).c)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.d, (Object)((VastCompanionAdConfig)object).d)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.e, ((VastCompanionAdConfig)object).e)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.f, ((VastCompanionAdConfig)object).f)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.g, (Object)((VastCompanionAdConfig)object).g);
    }

    public int hashCode() {
        int n2 = this.a;
        n2 = 31 * n2 + this.b;
        n2 = 31 * n2 + this.c.hashCode();
        String string = this.d;
        n2 = 31 * n2 + (string != null ? string.hashCode() : 0);
        n2 = 31 * n2 + ((Object)this.e).hashCode();
        n2 = 31 * n2 + ((Object)this.f).hashCode();
        String string2 = this.g;
        return 31 * n2 + (string2 != null ? string2.hashCode() : 0);
    }

    @NotNull
    public String toString() {
        return "VastCompanionAdConfig(width=" + this.a + ", height=" + this.b + ", vastResource=" + this.c + ", clickThroughUrl=" + this.d + ", clickTrackers=" + this.e + ", creativeViewTrackers=" + this.f + ", customCtaText=" + this.g + ')';
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VastResource.Type.values().length];
            try {
                nArray[VastResource.Type.STATIC_RESOURCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[VastResource.Type.HTML_RESOURCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[VastResource.Type.IFRAME_RESOURCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[VastResource.Type.BLURRED_LAST_FRAME.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

