/*
 * Decompiled with CFR 0.152.
 */
package com.tp.vast;

import com.tp.adx.sdk.util.InnerLog;
import com.tp.adx.sdk.util.Preconditions;
import com.tp.adx.sdk.util.XmlUtils;
import com.tp.vast.VastAbsoluteProgressTracker;
import com.tp.vast.VastResourceXmlManager;
import com.tp.vast.VastTracker;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

public class VastIconXmlManager {
    public static final String ICON_CLICKS = "IconClicks";
    public static final String ICON_CLICK_TRACKING = "IconClickTracking";
    public static final String ICON_CLICK_THROUGH = "IconClickThrough";
    public static final String ICON_VIEW_TRACKING = "IconViewTracking";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String OFFSET = "offset";
    public static final String DURATION = "duration";
    private final Node b;
    final VastResourceXmlManager a;

    public VastIconXmlManager(Node node) {
        Preconditions.checkNotNull((Object)node);
        this.b = node;
        this.a = new VastResourceXmlManager(node);
    }

    final Integer a() {
        return XmlUtils.getAttributeValueAsInt((Node)this.b, (String)WIDTH);
    }

    final Integer b() {
        return XmlUtils.getAttributeValueAsInt((Node)this.b, (String)HEIGHT);
    }

    final Integer c() {
        String string = XmlUtils.getAttributeValue((Node)this.b, (String)OFFSET);
        Integer n2 = null;
        try {
            n2 = VastAbsoluteProgressTracker.Companion.parseAbsoluteOffset(string);
        }
        catch (NumberFormatException numberFormatException) {
            InnerLog.v((String)String.format("Invalid VAST icon offset format: %s:".concat(String.valueOf(string)), new Object[0]));
        }
        return n2;
    }

    final Integer d() {
        String string = XmlUtils.getAttributeValue((Node)this.b, (String)DURATION);
        Integer n2 = null;
        try {
            n2 = VastAbsoluteProgressTracker.Companion.parseAbsoluteOffset(string);
        }
        catch (NumberFormatException numberFormatException) {
            InnerLog.v((String)String.format("Invalid VAST icon duration format: %s:".concat(String.valueOf(string)), new Object[0]));
        }
        return n2;
    }

    final List<VastTracker> e() {
        Object object = XmlUtils.getFirstMatchingChildNode((Node)this.b, (String)ICON_CLICKS);
        ArrayList<VastTracker> arrayList = new ArrayList<VastTracker>();
        if (object == null) {
            return arrayList;
        }
        object = XmlUtils.getMatchingChildNodes((Node)object, (String)ICON_CLICK_TRACKING).iterator();
        while (object.hasNext()) {
            String string = XmlUtils.getNodeValue((Node)((Node)object.next()));
            if (string == null) continue;
            arrayList.add(new VastTracker.Builder(string).build());
        }
        return arrayList;
    }

    final String f() {
        Node node = XmlUtils.getFirstMatchingChildNode((Node)this.b, (String)ICON_CLICKS);
        if (node == null) {
            return null;
        }
        return XmlUtils.getNodeValue((Node)XmlUtils.getFirstMatchingChildNode((Node)node, (String)ICON_CLICK_THROUGH));
    }

    final List<VastTracker> g() {
        Object object = XmlUtils.getMatchingChildNodes((Node)this.b, (String)ICON_VIEW_TRACKING);
        ArrayList<VastTracker> arrayList = new ArrayList<VastTracker>();
        object = object.iterator();
        while (object.hasNext()) {
            String string = XmlUtils.getNodeValue((Node)((Node)object.next()));
            if (string == null) continue;
            arrayList.add(new VastTracker.Builder(string).build());
        }
        return arrayList;
    }
}

