/*
 * Decompiled with CFR 0.152.
 */
package com.tp.vast;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.view.Display;
import android.view.WindowManager;
import com.tp.adx.sdk.util.InnerLog;
import com.tp.adx.sdk.util.Preconditions;
import com.tp.common.CacheService;
import com.tp.common.util.AsyncTasks;
import com.tp.vast.VastVideoConfig;
import com.tp.vast.VastXmlManagerAggregator;
import com.tp.vast.VideoDownloader;

public class VastManager
implements VastXmlManagerAggregator.a {
    private boolean a;
    private VastManagerListener b;
    private VastXmlManagerAggregator c;
    private String d;
    private double e;
    private int f;
    private final boolean g;

    public boolean isStartDownload() {
        return this.a;
    }

    public VastManager(Context context, boolean bl) {
        float f2;
        Context context2 = context;
        VastManager vastManager = this;
        Preconditions.checkNotNull((Object)context2, (String)"context cannot be null");
        Display display = ((WindowManager)context2.getSystemService("window")).getDefaultDisplay();
        int n2 = display.getWidth();
        int n3 = display.getHeight();
        float f3 = context2.getResources().getDisplayMetrics().density;
        if (f2 <= 0.0f) {
            f3 = 1.0f;
        }
        vastManager.e = (double)n2 / (double)n3;
        vastManager.f = (int)((float)n2 / f3);
        this.g = bl;
        if (bl) {
            CacheService.initializeDiskCache((Context)context);
        }
    }

    public void prepareVastVideoConfiguration(String string, VastManagerListener vastManagerListener, String string2, Context context) {
        Preconditions.checkNotNull((Object)vastManagerListener, (String)"vastManagerListener cannot be null");
        Preconditions.checkNotNull((Object)context, (String)"context cannot be null");
        if (this.c == null) {
            this.b = vastManagerListener;
            VastManager vastManager = this;
            this.c = new VastXmlManagerAggregator(vastManager, vastManager.e, this.f, context.getApplicationContext());
            this.d = string2;
            try {
                AsyncTasks.safeExecuteOnExecutor((AsyncTask)this.c, (Object[])new String[]{string});
                return;
            }
            catch (Exception exception) {
                InnerLog.v((String)"Failed to aggregate vast xml".concat(String.valueOf(exception)));
                this.b.onVastVideoConfigurationPrepared(null);
            }
        }
    }

    public void cancel() {
        if (this.c != null) {
            this.c.cancel(true);
            this.c = null;
        }
    }

    @Override
    public void onAggregationComplete(VastVideoConfig object) {
        if (this.b == null) {
            throw new IllegalStateException("mVastManagerListener cannot be null here. Did you call prepareVastVideoConfiguration()?");
        }
        if (object == null) {
            this.b.onVastVideoConfigurationPrepared(null);
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.d)) {
            ((VastVideoConfig)object).setDspCreativeId(this.d);
        }
        if (!this.g || VastManager.b((VastVideoConfig)object)) {
            this.a = true;
            this.b.onVastVideoDownloadStart();
            this.b.onVastVideoConfigurationPrepared((VastVideoConfig)object);
            return;
        }
        VideoDownloader.a a2 = new VideoDownloader.a((VastVideoConfig)object){
            final /* synthetic */ VastVideoConfig a;
            {
                this.a = vastVideoConfig;
            }

            @Override
            public final void a(boolean bl) {
                if (bl && VastManager.b(this.a)) {
                    VastManager.this.b.onVastVideoConfigurationPrepared(this.a);
                    return;
                }
                InnerLog.v((String)"Failed to download VAST video.");
                VastManager.this.b.onVastVideoConfigurationPrepared(null);
            }

            @Override
            public final void a() {
                VastManager.b(VastManager.this);
                VastManager.this.b.onVastVideoDownloadStart();
            }
        };
        if ((object = ((VastVideoConfig)object).getNetworkMediaFileUrl()) != null) {
            object = ((String)object).endsWith(".mp") ? (String)object + "4" : object;
        }
        VideoDownloader.cache((String)object, a2);
    }

    public static String getVastNetworkMediaUrl(VastVideoConfig vastVideoConfig) {
        if (vastVideoConfig == null) {
            return "";
        }
        return vastVideoConfig.getNetworkMediaFileUrl();
    }

    private static boolean b(VastVideoConfig vastVideoConfig) {
        Preconditions.checkNotNull((Object)vastVideoConfig, (String)"vastVideoConfig cannot be null");
        String string = vastVideoConfig.getNetworkMediaFileUrl();
        if (string != null) {
            String string2 = string = string.endsWith("mp") ? string + "4" : string;
        }
        if (CacheService.containsKeyDiskCache((String)string)) {
            string = CacheService.getFilePathDiskCache((String)string);
            vastVideoConfig.setDiskMediaFileUrl(string);
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean b(VastManager vastManager) {
        vastManager.a = true;
        return true;
    }

    public static interface VastManagerListener {
        public void onVastVideoConfigurationPrepared(VastVideoConfig var1);

        public void onVastVideoDownloadStart();
    }
}

