/*
 * Decompiled with CFR 0.152.
 */
package com.tp.vast;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.tp.adx.sdk.util.InnerLog;
import com.tp.adx.sdk.util.XmlUtils;
import com.tp.vast.VastResourceXmlManager;
import com.tp.vast.VastWebView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Node;

public final class VastResource
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Expose
    @SerializedName(value="resource")
    @NotNull
    private final String a;
    @Expose
    @SerializedName(value="type")
    @NotNull
    private final Type b;
    @Expose
    @SerializedName(value="creative_type")
    @NotNull
    private final CreativeType c;
    @Expose
    @SerializedName(value="width")
    private final int d;
    @Expose
    @SerializedName(value="height")
    private final int e;
    private static final long f = 1L;
    @NotNull
    private static final List<String> g;
    @NotNull
    private static final List<String> h;

    public VastResource(@NotNull String string, @NotNull Type type, @NotNull CreativeType creativeType, int n2, int n3) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)creativeType), (String)"creativeType");
        this.a = string;
        this.b = type;
        this.c = creativeType;
        this.d = n2;
        this.e = n3;
    }

    @NotNull
    public final String getResource() {
        return this.a;
    }

    @NotNull
    public final Type getType() {
        return this.b;
    }

    @NotNull
    public final CreativeType getCreativeType() {
        return this.c;
    }

    public final int getWidth() {
        return this.d;
    }

    public final int getHeight() {
        return this.e;
    }

    public final void initializeWebView(@NotNull VastWebView vastWebView) {
        Intrinsics.checkNotNullParameter((Object)((Object)vastWebView), (String)"webView");
        this.getHtmlResourceValue();
    }

    @Nullable
    public final String getHtmlResourceValue() {
        if (this.b == Type.HTML_RESOURCE) {
            return this.a;
        }
        if (this.b == Type.IFRAME_RESOURCE) {
            return "<iframe frameborder=\"0\" scrolling=\"no\" marginheight=\"0\" marginwidth=\"0\" style=\"border: 0px; margin: 0px;\" width=\"" + this.d + "\" height=\"" + this.e + "\" src=\"" + this.a + "\"></iframe>";
        }
        if (this.b == Type.STATIC_RESOURCE && this.c == CreativeType.IMAGE) {
            return "<html><head></head><body style=\"margin:0;padding:0\"><img src=\"" + this.a + "\" width=\"100%\" style=\"max-width:100%;max-height:100%;\" /></body></html>";
        }
        if (this.b == Type.STATIC_RESOURCE && this.c == CreativeType.JAVASCRIPT) {
            return "<script src=\"" + this.a + "\"></script>";
        }
        if (this.b == Type.BLURRED_LAST_FRAME) {
            return this.a;
        }
        return null;
    }

    @Nullable
    public final String getCorrectClickThroughUrl(@Nullable String string, @Nullable String string2) {
        if (this.b == Type.HTML_RESOURCE || this.b == Type.IFRAME_RESOURCE) {
            return string2;
        }
        if (this.b == Type.STATIC_RESOURCE && this.c == CreativeType.IMAGE) {
            return string;
        }
        if (this.b == Type.STATIC_RESOURCE && this.c == CreativeType.JAVASCRIPT) {
            return string2;
        }
        if (this.b == Type.BLURRED_LAST_FRAME) {
            return string;
        }
        return null;
    }

    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof VastResource)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.a, (Object)((VastResource)object).a)) {
            return false;
        }
        if (this.b != ((VastResource)object).b) {
            return false;
        }
        if (this.c != ((VastResource)object).c) {
            return false;
        }
        if (this.d != ((VastResource)object).d) {
            return false;
        }
        return this.e == ((VastResource)object).e;
    }

    public final int hashCode() {
        int n2 = this.a.hashCode();
        n2 = 31 * n2 + this.b.hashCode();
        n2 = 31 * n2 + this.c.hashCode();
        n2 = 31 * n2 + this.d;
        return 31 * n2 + this.e;
    }

    @NotNull
    public final String toString() {
        return "VastResource(resource='" + this.a + "', type=" + (Object)((Object)this.b) + ", creativeType=" + (Object)((Object)this.c) + ", width=" + this.d + ", height=" + this.e + ')';
    }

    @JvmStatic
    @Nullable
    public static final VastResource fromVastResourceXmlManager(@NotNull VastResourceXmlManager vastResourceXmlManager, int n2, int n3) {
        return Companion.fromVastResourceXmlManager(vastResourceXmlManager, n2, n3);
    }

    @JvmStatic
    @Nullable
    public static final VastResource fromVastResourceXmlManager(@NotNull VastResourceXmlManager vastResourceXmlManager, @NotNull Type type, int n2, int n3) {
        return Companion.fromVastResourceXmlManager(vastResourceXmlManager, type, n2, n3);
    }

    static {
        Object[] objectArray = new String[5];
        Object[] objectArray2 = objectArray;
        objectArray[0] = "image/jpeg";
        objectArray2[1] = "image/png";
        objectArray2[2] = "image/bmp";
        objectArray2[3] = "image/gif";
        objectArray2[4] = "image/jpg";
        g = CollectionsKt.listOf((Object[])objectArray2);
        h = CollectionsKt.listOf((Object)"application/x-javascript");
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type HTML_RESOURCE = new Type();
        public static final /* enum */ Type STATIC_RESOURCE = new Type();
        public static final /* enum */ Type IFRAME_RESOURCE = new Type();
        public static final /* enum */ Type BLURRED_LAST_FRAME = new Type();
        private static final /* synthetic */ Type[] a;

        public static Type[] values() {
            return (Type[])a.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }

        static {
            Type[] typeArray = new Type[4];
            Type[] typeArray2 = typeArray;
            typeArray[0] = HTML_RESOURCE;
            typeArray2[1] = STATIC_RESOURCE;
            typeArray2[2] = IFRAME_RESOURCE;
            typeArray2[3] = BLURRED_LAST_FRAME;
            a = typeArray2;
        }
    }

    public static final class CreativeType
    extends Enum<CreativeType> {
        public static final /* enum */ CreativeType NONE = new CreativeType();
        public static final /* enum */ CreativeType IMAGE = new CreativeType();
        public static final /* enum */ CreativeType JAVASCRIPT = new CreativeType();
        private static final /* synthetic */ CreativeType[] a;

        public static CreativeType[] values() {
            return (CreativeType[])a.clone();
        }

        public static CreativeType valueOf(String string) {
            return Enum.valueOf(CreativeType.class, string);
        }

        static {
            CreativeType[] creativeTypeArray = new CreativeType[3];
            CreativeType[] creativeTypeArray2 = creativeTypeArray;
            creativeTypeArray[0] = NONE;
            creativeTypeArray2[1] = IMAGE;
            creativeTypeArray2[2] = JAVASCRIPT;
            a = creativeTypeArray2;
        }
    }

    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final VastResource fromVastResourceXmlManager(@NotNull VastResourceXmlManager vastResourceXmlManager, int n2, int n3) {
            Intrinsics.checkNotNullParameter((Object)vastResourceXmlManager, (String)"resourceXmlManager");
            Type[] typeArray = Type.values();
            Collection collection = new ArrayList();
            for (Object object : typeArray) {
                VastResource vastResource = Companion.fromVastResourceXmlManager(vastResourceXmlManager, (Type)((Object)object), n2, n3);
                if (vastResource == null) continue;
                object = vastResource;
                collection.add(object);
            }
            return (VastResource)CollectionsKt.firstOrNull((List)((List)collection));
        }

        @JvmStatic
        @Nullable
        public final VastResource fromVastResourceXmlManager(@NotNull VastResourceXmlManager object, @NotNull Type type, int n2, int n3) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"resourceXmlManager");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            String string = XmlUtils.getAttributeValue((Node)XmlUtils.getFirstMatchingChildNode((Node)((VastResourceXmlManager)object).a, (String)"StaticResource"), (String)"creativeType");
            string = string != null ? string.toLowerCase() : null;
            Object object2 = null;
            Object object3 = CreativeType.NONE;
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    object = ((VastResourceXmlManager)object).a();
                    object2 = g.contains(string) || h.contains(string) ? object : null;
                    object = CreativeType.IMAGE;
                    Object object4 = g.contains(string) ? object : null;
                    if (object4 == null) {
                        object4 = CreativeType.JAVASCRIPT;
                    }
                    object3 = object4;
                    break;
                }
                case 2: {
                    object2 = ((VastResourceXmlManager)object).c();
                    break;
                }
                case 3: {
                    object2 = ((VastResourceXmlManager)object).b();
                    break;
                }
                default: {
                    InnerLog.d((String)"fromVastResourceXmlManager error");
                }
            }
            String string2 = object2;
            if (string2 != null) {
                object = string2;
                return new VastResource((String)object, type, (CreativeType)((Object)object3), n2, n3);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Type.values().length];
                try {
                    nArray[Type.STATIC_RESOURCE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[Type.HTML_RESOURCE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[Type.IFRAME_RESOURCE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

