/*
 * Decompiled with CFR 0.152.
 */
package com.tp.vast;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.tp.adx.sdk.exceptions.IntentNotResolvableException;
import com.tp.adx.sdk.util.InnerBrowser;
import com.tp.adx.sdk.util.InnerLog;
import com.tp.adx.sdk.util.Intents;
import com.tp.adx.sdk.util.UrlAction;
import com.tp.adx.sdk.util.UrlHandler;
import com.tp.vast.VastAbsoluteProgressTracker;
import com.tp.vast.VastCompanionAdConfig;
import com.tp.vast.VastErrorCode;
import com.tp.vast.VastFractionalProgressTracker;
import com.tp.vast.VastIconConfig;
import com.tp.vast.VastTracker;
import com.tp.vast.VideoTrackingEvent;
import com.tp.vast.VideoViewabilityTracker;
import com.tp.vast.ViewabilityVendor;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

public final class VastVideoConfig
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Expose
    @SerializedName(value="impression_trackers")
    @NotNull
    private final List<VastTracker> a = new ArrayList();
    @Expose
    @SerializedName(value="pause_trackers")
    @NotNull
    private final List<VastTracker> b = new ArrayList();
    @Expose
    @SerializedName(value="resume_trackers")
    @NotNull
    private final List<VastTracker> c = new ArrayList();
    @Expose
    @SerializedName(value="complete_trackers")
    @NotNull
    private final List<VastTracker> d = new ArrayList();
    @Expose
    @SerializedName(value="close_trackers")
    @NotNull
    private final List<VastTracker> e = new ArrayList();
    @Expose
    @SerializedName(value="skip_trackers")
    @NotNull
    private final List<VastTracker> f = new ArrayList();
    @Expose
    @SerializedName(value="click_trackers")
    @NotNull
    private final List<VastTracker> g = new ArrayList();
    @Expose
    @SerializedName(value="error_trackers")
    @NotNull
    private final List<VastTracker> h = new ArrayList();
    @Expose
    @SerializedName(value="fractional_trackers")
    @NotNull
    private final List<VastFractionalProgressTracker> i = new ArrayList();
    @Expose
    @SerializedName(value="absolute_trackers")
    @NotNull
    private final List<VastAbsoluteProgressTracker> j = new ArrayList();
    @Expose
    @SerializedName(value="viewability-verification-resources")
    @NotNull
    private final Set<ViewabilityVendor> k = new LinkedHashSet();
    @SerializedName(value="clickthrough_url")
    @Nullable
    private String l;
    @Expose
    @SerializedName(value="network_media_file_url")
    @Nullable
    private String m;
    @Expose
    @SerializedName(value="disk_media_file_url")
    @Nullable
    private String n;
    @Expose
    @SerializedName(value="skip_offset")
    @Nullable
    private String o;
    @Expose
    @SerializedName(value="companion_ads")
    @NotNull
    private final Set<VastCompanionAdConfig> p = new HashSet();
    @Expose
    @SerializedName(value="icon_config")
    @Nullable
    private VastIconConfig q;
    @Expose
    @SerializedName(value="is_rewarded")
    private boolean r;
    @Expose
    @SerializedName(value="countdown_timer_duration")
    private int s;
    @Expose
    @SerializedName(value="width")
    private int t;
    @Expose
    @SerializedName(value="height")
    private int u;
    @Expose
    @SerializedName(value="enable_click_exp")
    private boolean v;
    @Expose
    @SerializedName(value="custom_cta_text")
    @Nullable
    private String w;
    @Expose
    @SerializedName(value="custom_skip_text")
    @Nullable
    private String x;
    @Expose
    @SerializedName(value="custom_close_icon_url")
    @Nullable
    private String y;
    @Expose
    @SerializedName(value="video_viewability_tracker")
    @Nullable
    private VideoViewabilityTracker z;
    @Expose
    @SerializedName(value="dsp_creative_id")
    @Nullable
    private String A;
    @Expose
    @SerializedName(value="privacy_icon_image_url")
    @Nullable
    private String B;
    @Expose
    @SerializedName(value="privacy_icon_click_url")
    @Nullable
    private String C;
    private static final long D = 3L;

    @NotNull
    public final ArrayList<VastTracker> getImpressionTrackers() {
        return new ArrayList<VastTracker>((Collection)this.a);
    }

    @NotNull
    public final ArrayList<VastTracker> getPauseTrackers() {
        return new ArrayList<VastTracker>((Collection)this.b);
    }

    @NotNull
    public final ArrayList<VastTracker> getResumeTrackers() {
        return new ArrayList<VastTracker>((Collection)this.c);
    }

    @NotNull
    public final ArrayList<VastTracker> getCompleteTrackers() {
        return new ArrayList<VastTracker>((Collection)this.d);
    }

    @NotNull
    public final ArrayList<VastTracker> getCloseTrackers() {
        return new ArrayList<VastTracker>((Collection)this.e);
    }

    @NotNull
    public final ArrayList<VastTracker> getSkipTrackers() {
        return new ArrayList<VastTracker>((Collection)this.f);
    }

    @NotNull
    public final ArrayList<VastTracker> getClickTrackers() {
        return new ArrayList<VastTracker>((Collection)this.g);
    }

    @NotNull
    public final ArrayList<VastTracker> getErrorTrackers() {
        return new ArrayList<VastTracker>((Collection)this.h);
    }

    @NotNull
    public final ArrayList<VastFractionalProgressTracker> getFractionalTrackers() {
        return new ArrayList<VastFractionalProgressTracker>((Collection)this.i);
    }

    @NotNull
    public final ArrayList<VastAbsoluteProgressTracker> getAbsoluteTrackers() {
        return new ArrayList<VastAbsoluteProgressTracker>((Collection)this.j);
    }

    @NotNull
    public final Set<ViewabilityVendor> getViewabilityVendors() {
        return new HashSet(this.k);
    }

    @Nullable
    public final String getClickThroughUrl() {
        return this.l;
    }

    public final void setClickThroughUrl(@Nullable String string) {
        this.l = string;
    }

    @Nullable
    public final String getNetworkMediaFileUrl() {
        return this.m;
    }

    public final void setNetworkMediaFileUrl(@Nullable String string) {
        this.m = string;
    }

    @Nullable
    public final String getDiskMediaFileUrl() {
        return this.n;
    }

    public final void setDiskMediaFileUrl(@Nullable String string) {
        this.n = string;
    }

    @Nullable
    public final String getSkipOffset() {
        return this.o;
    }

    public final void setSkipOffset(@Nullable String string) {
        this.o = string;
    }

    @NotNull
    public final Set<VastCompanionAdConfig> getVastCompanionAdConfigs() {
        return this.p;
    }

    @Nullable
    public final VastIconConfig getVastIconConfig() {
        return this.q;
    }

    public final void setVastIconConfig(@Nullable VastIconConfig vastIconConfig) {
        this.q = vastIconConfig;
    }

    public final boolean isRewarded() {
        return this.r;
    }

    public final void setRewarded(boolean bl) {
        this.r = bl;
    }

    public final int getCountdownTimerDuration() {
        return this.s;
    }

    public final void setCountdownTimerDuration(int n2) {
        this.s = n2;
    }

    public final int getVideoWidth() {
        return this.t;
    }

    public final void setVideoWidth(int n2) {
        this.t = n2;
    }

    public final int getVideoHeight() {
        return this.u;
    }

    public final void setVideoHeight(int n2) {
        this.u = n2;
    }

    public final boolean getEnableClickExperiment() {
        return this.v;
    }

    public final void setEnableClickExperiment(boolean bl) {
        this.v = bl;
    }

    @Nullable
    public final String getCustomCtaText() {
        return this.w;
    }

    public final void setCustomCtaText(@Nullable String string) {
        String string2 = string;
        if (string2 == null) {
            string2 = this.w;
        }
        this.w = string2;
    }

    @Nullable
    public final String getCustomSkipText() {
        return this.x;
    }

    public final void setCustomSkipText(@Nullable String string) {
        String string2 = string;
        if (string2 == null) {
            string2 = this.x;
        }
        this.x = string2;
    }

    @Nullable
    public final String getCustomCloseIconUrl() {
        return this.y;
    }

    public final void setCustomCloseIconUrl(@Nullable String string) {
        String string2 = string;
        if (string2 == null) {
            string2 = this.y;
        }
        this.y = string2;
    }

    @Nullable
    public final VideoViewabilityTracker getVideoViewabilityTracker() {
        return this.z;
    }

    public final void setVideoViewabilityTracker(@Nullable VideoViewabilityTracker videoViewabilityTracker) {
        VideoViewabilityTracker videoViewabilityTracker2 = videoViewabilityTracker;
        if (videoViewabilityTracker2 == null) {
            videoViewabilityTracker2 = this.z;
        }
        this.z = videoViewabilityTracker2;
    }

    @Nullable
    public final String getDspCreativeId() {
        return this.A;
    }

    public final void setDspCreativeId(@Nullable String string) {
        String string2 = string;
        if (string2 == null) {
            string2 = this.A;
        }
        this.A = string2;
    }

    @Nullable
    public final String getPrivacyInformationIconImageUrl() {
        return this.B;
    }

    public final void setPrivacyInformationIconImageUrl(@Nullable String string) {
        String string2 = string;
        if (string2 == null) {
            string2 = this.B;
        }
        this.B = string2;
    }

    @Nullable
    public final String getPrivacyInformationIconClickthroughUrl() {
        return this.C;
    }

    public final void setPrivacyInformationIconClickthroughUrl(@Nullable String string) {
        this.C = string;
    }

    public final void addImpressionTrackers(@NotNull List<? extends VastTracker> list) {
        Intrinsics.checkNotNullParameter(list, (String)"impressionTrackers");
        this.a.addAll((Collection<VastTracker>)list);
    }

    public final void addResumeTrackers(@NotNull List<? extends VastTracker> list) {
        Intrinsics.checkNotNullParameter(list, (String)"resumeTrackers");
        this.c.addAll((Collection<VastTracker>)list);
    }

    public final void addFractionalTrackers(@NotNull List<VastFractionalProgressTracker> list) {
        Intrinsics.checkNotNullParameter(list, (String)"fractionalTrackers");
        this.i.addAll((Collection<VastFractionalProgressTracker>)list);
        CollectionsKt.sort(this.i);
    }

    public final void addAbsoluteTrackers(@NotNull List<? extends VastAbsoluteProgressTracker> list) {
        Intrinsics.checkNotNullParameter(list, (String)"absoluteTrackers");
        this.j.addAll((Collection<VastAbsoluteProgressTracker>)list);
        CollectionsKt.sort(this.j);
    }

    public final void addCompleteTrackers(@NotNull List<? extends VastTracker> list) {
        Intrinsics.checkNotNullParameter(list, (String)"completeTrackers");
        this.d.addAll((Collection<VastTracker>)list);
    }

    public final void addPauseTrackers(@NotNull List<? extends VastTracker> list) {
        Intrinsics.checkNotNullParameter(list, (String)"pauseTrackers");
        this.b.addAll((Collection<VastTracker>)list);
    }

    public final void addCloseTrackers(@NotNull List<? extends VastTracker> list) {
        Intrinsics.checkNotNullParameter(list, (String)"closeTrackers");
        this.e.addAll((Collection<VastTracker>)list);
    }

    public final void addSkipTrackers(@NotNull List<? extends VastTracker> list) {
        Intrinsics.checkNotNullParameter(list, (String)"skipTrackers");
        this.f.addAll((Collection<VastTracker>)list);
    }

    public final void addClickTrackers(@NotNull List<? extends VastTracker> list) {
        Intrinsics.checkNotNullParameter(list, (String)"clickTrackers");
        this.g.addAll((Collection<VastTracker>)list);
    }

    public final void addErrorTrackers(@NotNull List<? extends VastTracker> list) {
        Intrinsics.checkNotNullParameter(list, (String)"errorTrackers");
        this.h.addAll((Collection<VastTracker>)list);
    }

    public final void addViewabilityVendors(@Nullable Set<? extends ViewabilityVendor> set) {
        Set<? extends ViewabilityVendor> set2 = set;
        if (set2 != null) {
            set = set2;
            this.k.addAll((Collection<ViewabilityVendor>)set);
            return;
        }
    }

    public final void addVideoTrackers(@Nullable JSONObject jSONObject) {
        if (jSONObject == null) {
            return;
        }
        JSONArray jSONArray = jSONObject.optJSONArray("urls");
        jSONObject = jSONObject.optJSONArray("events");
        if (jSONArray == null || jSONObject == null) {
            return;
        }
        int n2 = jSONObject.length();
        block7: for (int i2 = 0; i2 < n2; ++i2) {
            List list;
            String string = jSONObject.optString(i2);
            Object object = jSONArray;
            String string2 = string;
            if (string == null) {
                list = null;
            } else {
                List list2 = new ArrayList();
                int n3 = object.length();
                for (int i3 = 0; i3 < n3; ++i3) {
                    String string3;
                    if (object.optString(i3) == null) continue;
                    list2.add(StringsKt.replace$default((String)string3, (String)"%%VIDEO_EVENT%%", (String)string2, (boolean)false, (int)4, null));
                }
                list = list2;
            }
            string2 = list;
            object = VideoTrackingEvent.Companion.fromString(string);
            if (string == null || string2 == null) continue;
            switch (WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()]) {
                case 1: {
                    this.b((List<String>)((Object)string2));
                    continue block7;
                }
                case 2: 
                case 3: 
                case 4: {
                    this.a((List<String>)((Object)string2), ((VideoTrackingEvent)((Object)object)).toFloat());
                    continue block7;
                }
                case 5: {
                    this.addCompleteTrackers(VastVideoConfig.a((List<String>)((Object)string2)));
                    continue block7;
                }
                case 6: {
                    this.c((List<String>)((Object)string2));
                    continue block7;
                }
                case 7: {
                    this.d((List<String>)((Object)string2));
                    continue block7;
                }
                default: {
                    InnerLog.v((String)"Encountered unknown video tracking event: ".concat(String.valueOf(string)));
                }
            }
        }
    }

    public final boolean hasCompanionAd() {
        return !((Collection)this.p).isEmpty();
    }

    public final void handleImpression(@NotNull Context context, int n2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    public final void handleClickForResult(@NotNull Activity activity, int n2, int n3) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.a((Context)activity, (Integer)n3);
    }

    public final void handleClickWithoutResult(@NotNull Context context, int n2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        this.a(context2, null);
    }

    private final void a(Context context, Integer object) {
        UrlHandler urlHandler2 = (UrlHandler)this.l;
        if (urlHandler2 == null || urlHandler2.length() == 0) {
            return;
        }
        UrlHandler urlHandler3 = new UrlAction[6];
        urlHandler2 = urlHandler3;
        urlHandler3[0] = UrlAction.OPEN_APP_MARKET;
        urlHandler2[1] = UrlAction.OPEN_NATIVE_BROWSER;
        urlHandler2[2] = UrlAction.OPEN_IN_APP_BROWSER;
        urlHandler2[3] = UrlAction.HANDLE_SHARE_TWEET;
        urlHandler2[4] = UrlAction.FOLLOW_DEEP_LINK_WITH_FALLBACK;
        urlHandler2[5] = UrlAction.FOLLOW_DEEP_LINK;
        urlHandler2 = new UrlHandler.Builder().withDspCreativeId(this.A).withoutInnerBrowser().withSupportedUrlActions(UrlAction.IGNORE_ABOUT_SCHEME, (UrlAction[])urlHandler2).withResultActions(new UrlHandler.ResultActions(context, (Integer)object, this){
            final /* synthetic */ Context a;
            final /* synthetic */ Integer b;
            final /* synthetic */ VastVideoConfig c;
            {
                this.a = context;
                this.b = n2;
                this.c = vastVideoConfig;
            }

            public final void urlHandlingSucceeded(@NotNull String string, @NotNull UrlAction urlAction) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"url");
                Intrinsics.checkNotNullParameter((Object)urlAction, (String)"urlAction");
                if (urlAction == UrlAction.OPEN_IN_APP_BROWSER) {
                    urlAction = new Bundle();
                    Object object = urlAction;
                    VastVideoConfig vastVideoConfig = this.c;
                    object.putString("URL", string);
                    object.putString("tp-dsp-creative-id", vastVideoConfig.getDspCreativeId());
                    object = InnerBrowser.class;
                    vastVideoConfig = Intents.getStartActivityIntent((Context)this.a, (Class)object, (Bundle)urlAction);
                    try {
                        if (this.a instanceof Activity) {
                            if (this.b == null) {
                                string = "Activity context requires a requestCode";
                                throw new IllegalArgumentException(string.toString());
                            }
                            ((Activity)this.a).startActivityForResult((Intent)vastVideoConfig, this.b.intValue());
                            return;
                        }
                        Intents.startActivity((Context)this.a, (Intent)vastVideoConfig);
                        return;
                    }
                    catch (ActivityNotFoundException activityNotFoundException) {
                        InnerLog.v((String)("Activity " + ((Class)object).getName() + " not found. Did you declare it in your AndroidManifest.xml?"));
                        return;
                    }
                    catch (IntentNotResolvableException intentNotResolvableException) {
                        InnerLog.v((String)("Activity " + ((Class)object).getName() + " not found. Did you declare it in your AndroidManifest.xml?"));
                    }
                }
            }

            public final void urlHandlingFailed(@NotNull String string, @NotNull UrlAction urlAction) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"url");
                Intrinsics.checkNotNullParameter((Object)urlAction, (String)"lastFailedUrlAction");
            }
        }).build();
        String string = this.l;
        if (string != null) {
            object = string;
            urlHandler2.handleUrl(context, (String)object);
            return;
        }
    }

    public final void handleResume(@NotNull Context context, int n2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    public final void handlePause(@NotNull Context context, int n2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    public final void handleClose(@NotNull Context context, int n2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    public final void handleSkip(@NotNull Context context, int n2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    public final void handleComplete(@NotNull Context context, int n2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    public final void handleError(@NotNull Context context, @Nullable VastErrorCode vastErrorCode, int n2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    @NotNull
    public final List<VastTracker> getUntriggeredTrackersBefore(int n2, int n3) {
        ArrayList<VastTracker> arrayList;
        if (n3 <= 0 || n2 < 0) {
            return CollectionsKt.emptyList();
        }
        ArrayList<VastTracker> arrayList2 = arrayList = new ArrayList<VastTracker>();
        VastAbsoluteProgressTracker vastAbsoluteProgressTracker = new VastAbsoluteProgressTracker.Builder("", n2).build();
        for (VastAbsoluteProgressTracker vastAbsoluteProgressTracker2 : (Iterable)this.j) {
            if (vastAbsoluteProgressTracker2.compareTo(vastAbsoluteProgressTracker) > 0 || vastAbsoluteProgressTracker2.isTracked()) continue;
            arrayList2.add(vastAbsoluteProgressTracker2);
        }
        VastFractionalProgressTracker vastFractionalProgressTracker = new VastFractionalProgressTracker.Builder("", (float)n2 / (float)n3).build();
        for (VastFractionalProgressTracker vastFractionalProgressTracker2 : (Iterable)this.i) {
            if (vastFractionalProgressTracker2.compareTo(vastFractionalProgressTracker) > 0 || vastFractionalProgressTracker2.isTracked()) continue;
            arrayList2.add(vastFractionalProgressTracker2);
        }
        return arrayList;
    }

    public final int getRemainingProgressTrackerCount() {
        return this.getUntriggeredTrackersBefore(Integer.MAX_VALUE, Integer.MAX_VALUE).size();
    }

    @Nullable
    public final Integer getSkipOffsetMillis(int n2) {
        String string = this.o;
        if (string != null) {
            Object object;
            Object object2 = string;
            if (VastAbsoluteProgressTracker.Companion.isAbsoluteTracker((String)object2)) {
                object = VastAbsoluteProgressTracker.Companion.parseAbsoluteOffset((String)object2);
            } else if (VastFractionalProgressTracker.Companion.isPercentageTracker((String)object2)) {
                object = VastFractionalProgressTracker.Companion.parsePercentageOffset((String)object2, n2);
            } else {
                InnerLog.v((String)"Invalid VAST skipoffset format: ".concat(String.valueOf(object2)));
                object = object2 = (Integer)null;
            }
            if (object != null) {
                return Math.min(((Number)object2).intValue(), n2);
            }
            return null;
        }
        return null;
    }

    @NotNull
    public final String toJsonString() {
        String string = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new a()).create().toJson((Object)this);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(this@VastVideoConfig)");
        return string;
    }

    private static List<VastTracker> a(List<String> iterable) {
        iterable = iterable;
        Object object = iterable;
        iterable = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (String)object2;
            Iterable<String> iterable2 = iterable;
            iterable2.add((String)((Object)new VastTracker.Builder((String)object2).build()));
        }
        return iterable;
    }

    private final void b(List<String> iterable) {
        iterable = iterable;
        VastVideoConfig vastVideoConfig = this;
        Object object = iterable;
        iterable = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (String)object2;
            Iterable<String> iterable2 = iterable;
            iterable2.add((String)((Object)new VastAbsoluteProgressTracker.Builder((String)object2, 0).build()));
        }
        vastVideoConfig.addAbsoluteTrackers((List<? extends VastAbsoluteProgressTracker>)iterable);
    }

    private final void a(List<String> iterable, float f2) {
        iterable = iterable;
        VastVideoConfig vastVideoConfig = this;
        Object object = iterable;
        iterable = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (String)object2;
            Iterable<String> iterable2 = iterable;
            iterable2.add((String)((Object)new VastFractionalProgressTracker.Builder((String)object2, f2).build()));
        }
        vastVideoConfig.addFractionalTrackers((List<VastFractionalProgressTracker>)iterable);
    }

    private final void c(List<String> list) {
        list = VastVideoConfig.a(list);
        Iterator iterator = ((Iterable)this.p).iterator();
        while (iterator.hasNext()) {
            ((VastCompanionAdConfig)iterator.next()).addCreativeViewTrackers((Collection<? extends VastTracker>)list);
        }
    }

    private final void d(List<String> list) {
        list = VastVideoConfig.a(list);
        Iterator iterator = ((Iterable)this.p).iterator();
        while (iterator.hasNext()) {
            ((VastCompanionAdConfig)iterator.next()).addClickTrackers((Collection<? extends VastTracker>)list);
        }
    }

    public final void addVastCompanionAdConfig(@NotNull VastCompanionAdConfig vastCompanionAdConfig) {
        Intrinsics.checkNotNullParameter((Object)vastCompanionAdConfig, (String)"vastCompanionAdConfig");
        this.p.add(vastCompanionAdConfig);
    }

    public final void addVastCompanionAdConfigs(@NotNull Iterable<? extends VastCompanionAdConfig> object) {
        Intrinsics.checkNotNullParameter(object, (String)"vastCompanionAdConfigs");
        object = object.iterator();
        while (object.hasNext()) {
            VastCompanionAdConfig vastCompanionAdConfig = (VastCompanionAdConfig)object.next();
            this.addVastCompanionAdConfig(vastCompanionAdConfig);
        }
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VastVideoConfig fromVastVideoConfigString(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"input");
            Object object = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new a()).create().fromJson(string, VastVideoConfig.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.fromJson(input, VastVideoConfig::class.java)");
            return (VastVideoConfig)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    static final class a
    implements TypeAdapterFactory {
        @Nullable
        public final <T> TypeAdapter<T> create(@Nullable Gson gson, @Nullable TypeToken<T> typeToken) {
            if (typeToken == null || !Class.class.isAssignableFrom(typeToken.getRawType())) {
                return null;
            }
            return new VastVideoConfigTypeAdapter();
        }
    }

    public static final class VastVideoConfigTypeAdapter
    extends TypeAdapter<Class<?>> {
        public final void write(@Nullable JsonWriter jsonWriter, @Nullable Class<?> clazz) {
            if (jsonWriter == null) {
                return;
            }
            if (clazz == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.value(clazz.getName());
        }

        @Nullable
        public final Class<?> read(@Nullable JsonReader object) {
            if (object == null) {
                return null;
            }
            if (object.peek() == JsonToken.NULL) {
                object.nextNull();
                return null;
            }
            try {
                object = Class.forName(object.nextString());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException);
            }
            return object;
        }
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VideoTrackingEvent.values().length];
            try {
                nArray[VideoTrackingEvent.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[VideoTrackingEvent.FIRST_QUARTILE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[VideoTrackingEvent.MIDPOINT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[VideoTrackingEvent.THIRD_QUARTILE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[VideoTrackingEvent.COMPLETE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[VideoTrackingEvent.COMPANION_AD_VIEW.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[VideoTrackingEvent.COMPANION_AD_CLICK.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

