/*
 * Decompiled with CFR 0.152.
 */
package com.tp.vast;

import com.tp.adx.sdk.util.InnerLog;
import com.tp.adx.sdk.util.Preconditions;
import com.tp.adx.sdk.util.XmlUtils;
import com.tp.vast.VastAbsoluteProgressTracker;
import org.w3c.dom.Node;

public class VideoViewabilityTrackerXmlManager {
    public static final String VIEWABLE_PLAYTIME = "viewablePlaytime";
    public static final String PERCENT_VIEWABLE = "percentViewable";
    final Node a;

    VideoViewabilityTrackerXmlManager(Node node) {
        Preconditions.checkNotNull((Object)node);
        this.a = node;
    }

    final Integer a() {
        String string = XmlUtils.getAttributeValue((Node)this.a, (String)VIEWABLE_PLAYTIME);
        if (string == null) {
            return null;
        }
        Integer n2 = null;
        if (VastAbsoluteProgressTracker.Companion.isAbsoluteTracker(string)) {
            try {
                n2 = VastAbsoluteProgressTracker.Companion.parseAbsoluteOffset(string);
            }
            catch (NumberFormatException numberFormatException) {
                InnerLog.v((String)String.format("Invalid VAST viewablePlaytime format for \"HH:MM:SS[.mmm]\": %s:", string));
            }
        } else {
            try {
                n2 = (int)(Float.parseFloat(string) * 1000.0f);
            }
            catch (NumberFormatException numberFormatException) {
                InnerLog.v((String)String.format("Invalid VAST viewablePlaytime format for \"SS[.mmm]\": %s:", string));
            }
        }
        if (n2 == null || n2 < 0) {
            return null;
        }
        return n2;
    }

    final Integer b() {
        String string = XmlUtils.getAttributeValue((Node)this.a, (String)PERCENT_VIEWABLE);
        if (string == null) {
            return null;
        }
        Integer n2 = null;
        try {
            n2 = (int)Float.parseFloat(string.replace("%", ""));
        }
        catch (NumberFormatException numberFormatException) {
            InnerLog.v((String)String.format("Invalid VAST percentViewable format for \"d{1,3}%%\": %s:", string));
        }
        if (n2 == null || n2 < 0 || n2 > 100) {
            return null;
        }
        return n2;
    }
}

