/*
 * Decompiled with CFR 0.152.
 */
package com.tp.ads.adx;

import android.content.Context;
import android.util.Log;
import android.view.View;
import com.tp.ads.adx.AdxErrorUtil;
import com.tp.adx.open.AdError;
import com.tp.adx.open.TPAdOptions;
import com.tp.adx.open.TPInnerAdListener;
import com.tp.adx.open.TPInnerSplash;
import com.tradplus.ads.base.adapter.splash.TPSplashAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class AdxSplashAdapter
extends TPSplashAdapter {
    private static final String TAG = "AdxSplash";
    private boolean isLandscape;
    private TPInnerSplash tpInnerSplash;

    public void clean() {
        if (this.tpInnerSplash != null) {
            this.tpInnerSplash.onDestroy();
        }
    }

    public boolean isReady() {
        return this.tpInnerSplash.isReady();
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("40");
    }

    public String getNetworkVersion() {
        return "1.0";
    }

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        String orientation;
        String placementId = tpParams.get("placementId");
        String payload = tpParams.get("ADX-Payload");
        String startTimeStr = tpParams.get("ADX-Payload_Start_time");
        Log.v((String)TAG, (String)("loadCustomAd placementId:" + placementId));
        if (placementId == null || placementId.length() <= 0 || payload == null || payload.length() <= 0) {
            TPError tpError = new TPError();
            tpError.setTpErrorCode("Native Network or Custom Event adapter was configured incorrectly.");
            this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
            return;
        }
        if (userParams.get("ADX-Splash-Orientation") != null && (orientation = (String)userParams.get("ADX-Splash-Orientation")).equals("1")) {
            this.isLandscape = true;
        }
        long startTime = 0L;
        try {
            startTime = startTimeStr == null ? 0L : Long.parseLong(startTimeStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tpInnerSplash = new TPInnerSplash(placementId, payload);
        this.tpInnerSplash.setAdOptions(new TPAdOptions.Builder().setPayloadStartTime(startTime).setMute(false).setLandscape(this.isLandscape).build());
        this.tpInnerSplash.setAdListener(new TPInnerAdListener(){

            @Override
            public void onAdLoaded() {
                Log.v((String)AdxSplashAdapter.TAG, (String)"onAdLoaded");
                AdxSplashAdapter.this.setNetworkObjectAd(AdxSplashAdapter.this.tpInnerSplash);
                if (AdxSplashAdapter.this.mLoadAdapterListener != null) {
                    AdxSplashAdapter.this.mLoadAdapterListener.loadAdapterLoaded(null);
                }
            }

            @Override
            public void onAdImpression() {
                Log.v((String)AdxSplashAdapter.TAG, (String)"onAdImpression");
                if (AdxSplashAdapter.this.mShowListener != null) {
                    AdxSplashAdapter.this.mShowListener.onAdShown();
                }
            }

            @Override
            public void onAdLoadFailed(AdError error) {
                Log.v((String)AdxSplashAdapter.TAG, (String)("onAdLoadFailed error:" + error.getErrorCode() + " msg:" + error.getErrorMsg()));
                if (AdxSplashAdapter.this.mLoadAdapterListener != null) {
                    AdxSplashAdapter.this.mLoadAdapterListener.loadAdapterLoadFailed(AdxErrorUtil.getTradPlusErrorCode(error));
                }
            }

            @Override
            public void onAdClicked() {
                Log.i((String)AdxSplashAdapter.TAG, (String)"onAdClicked: ");
                if (AdxSplashAdapter.this.mShowListener != null) {
                    AdxSplashAdapter.this.mShowListener.onAdClicked();
                }
            }

            @Override
            public void onVideoStart() {
                Log.i((String)AdxSplashAdapter.TAG, (String)"onVideoStart: ");
                if (AdxSplashAdapter.this.mShowListener != null) {
                    AdxSplashAdapter.this.mShowListener.onAdVideoStart();
                }
            }

            @Override
            public void onVideoEnd() {
                Log.i((String)AdxSplashAdapter.TAG, (String)"onVideoEnd: ");
                if (AdxSplashAdapter.this.mShowListener != null) {
                    AdxSplashAdapter.this.mShowListener.onAdVideoEnd();
                }
            }

            @Override
            public void onAdClosed() {
                Log.i((String)AdxSplashAdapter.TAG, (String)"onAdClosed: ");
                if (AdxSplashAdapter.this.mShowListener != null) {
                    AdxSplashAdapter.this.mShowListener.onAdClosed();
                }
            }

            @Override
            public void onCountDown(int progress) {
            }
        });
        this.tpInnerSplash.loadAd();
    }

    public void showAd() {
        View viewGroup = this.tpInnerSplash.getSplashView();
        if (this.mAdContainerView != null && viewGroup != null) {
            this.mAdContainerView.removeAllViews();
            this.mAdContainerView.addView(viewGroup);
        } else {
            this.mShowListener.onAdVideoError(new TPError("Didn't find valid adv.Show Failed"));
        }
    }
}

