/*
 * Decompiled with CFR 0.152.
 */
package com.tp.adx.open;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.iab.omid.library.tradplus.adsession.AdEvents;
import com.iab.omid.library.tradplus.adsession.AdSession;
import com.iab.omid.library.tradplus.adsession.CreativeType;
import com.iab.omid.library.tradplus.adsession.FriendlyObstructionPurpose;
import com.iab.omid.library.tradplus.adsession.media.MediaEvents;
import com.iab.omid.library.tradplus.adsession.media.Position;
import com.iab.omid.library.tradplus.adsession.media.VastProperties;
import com.tp.ads.adx.utils.AdSessionUtil;
import com.tp.adx.R;
import com.tp.adx.open.TPInnerNativeAd;
import com.tp.adx.sdk.bean.TPPayloadInfo;
import com.tp.adx.sdk.util.InnerLog;
import com.tp.adx.sdk.util.ViewUtils;
import com.tp.vast.VastVideoConfig;
import com.tradplus.ads.base.common.TPImageLoader;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.common.util.LogUtil;
import java.util.ArrayList;

public class TPInnerMediaView
extends RelativeLayout
implements TextureView.SurfaceTextureListener {
    public static final String TAG = "InnerSDK";
    private static final int MEDIA_MUTE_WIDTH = 10;
    private MediaPlayer mMediaPlayer;
    private SurfaceTexture mSurfaceTexture;
    private TextureView mTextureView;
    private Surface mSurface;
    private String diskFileUrl;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mCurrentPosition = -1;
    private int mDuration;
    private int mVideoProgress25;
    private int mVideoProgress50;
    private int mVideoProgress75;
    private boolean mVideoPlay25;
    private boolean mVideoPlay50;
    private boolean mVideoPlay75;
    private boolean mFlag = false;
    private boolean mIsVideoStart = false;
    private boolean mIsVideoPlayCompletion = false;
    private boolean mIsMediaPlayerPrepared = false;
    private OnPlayerListener mListener;
    private Handler mMainHandler;
    private ImageView mMuteBtn;
    private boolean mIsMute;
    private Thread mProgressThread;
    private AdSession adSession;
    private AdEvents adEvents;
    private MediaEvents mediaEvents;
    private boolean isStartCheckHardwareAccelerated;

    public void setOnPlayerListener(OnPlayerListener listener) {
        this.mListener = listener;
    }

    public TPInnerMediaView(Context context) {
        super(context);
        this.init();
    }

    public TPInnerMediaView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.setSaveEnabled(true);
        this.mMainHandler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                TPInnerMediaView.this.mCurrentPosition = msg.what;
                if (TPInnerMediaView.this.mCurrentPosition <= 0) {
                    return;
                }
                if (!TPInnerMediaView.this.mIsVideoStart && !TPInnerMediaView.this.mIsVideoPlayCompletion) {
                    TPInnerMediaView.this.mIsVideoStart = true;
                    if (TPInnerMediaView.this.mediaEvents != null) {
                        TPInnerMediaView.this.mediaEvents.start((float)TPInnerMediaView.this.mMediaPlayer.getDuration(), TPInnerMediaView.this.mIsMute ? 0.0f : 1.0f);
                    }
                    if (TPInnerMediaView.this.adEvents != null) {
                        TPInnerMediaView.this.adEvents.impressionOccurred();
                    }
                    if (TPInnerMediaView.this.mListener != null) {
                        TPInnerMediaView.this.mListener.onVideoPlayStart();
                    }
                }
                if (TPInnerMediaView.this.mListener != null) {
                    TPInnerMediaView.this.mListener.onVideoUpdateProgress(TPInnerMediaView.this.mCurrentPosition, TPInnerMediaView.this.mDuration);
                }
                if (!TPInnerMediaView.this.mVideoPlay25 && TPInnerMediaView.this.mCurrentPosition >= TPInnerMediaView.this.mVideoProgress25) {
                    TPInnerMediaView.this.mVideoPlay25 = true;
                    if (TPInnerMediaView.this.mediaEvents != null) {
                        TPInnerMediaView.this.mediaEvents.firstQuartile();
                    }
                    if (TPInnerMediaView.this.mListener != null) {
                        TPInnerMediaView.this.mListener.onVideoPlayProgress(25);
                    }
                } else if (!TPInnerMediaView.this.mVideoPlay50 && TPInnerMediaView.this.mCurrentPosition >= TPInnerMediaView.this.mVideoProgress50) {
                    TPInnerMediaView.this.mVideoPlay50 = true;
                    if (TPInnerMediaView.this.mediaEvents != null) {
                        TPInnerMediaView.this.mediaEvents.midpoint();
                    }
                    if (TPInnerMediaView.this.mListener != null) {
                        TPInnerMediaView.this.mListener.onVideoPlayProgress(50);
                    }
                } else if (!TPInnerMediaView.this.mVideoPlay75 && TPInnerMediaView.this.mCurrentPosition >= TPInnerMediaView.this.mVideoProgress75) {
                    TPInnerMediaView.this.mVideoPlay75 = true;
                    if (TPInnerMediaView.this.mediaEvents != null) {
                        TPInnerMediaView.this.mediaEvents.thirdQuartile();
                    }
                    if (TPInnerMediaView.this.mListener != null) {
                        TPInnerMediaView.this.mListener.onVideoPlayProgress(75);
                    }
                }
            }
        };
        this.initView();
    }

    public void setFriendlyObstruction(ArrayList<View> views) {
        if (this.adSession != null && views != null) {
            for (View view : views) {
                if (view == null) continue;
                this.adSession.addFriendlyObstruction(view, FriendlyObstructionPurpose.OTHER, null);
            }
        }
    }

    public void setIsMute(boolean isMute) {
        InnerLog.v(TAG, "TPInnerMediaView isMute - " + isMute);
        this.mIsMute = isMute;
    }

    public void setMute(boolean isMute) {
        if (isMute) {
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.setVolume(0.0f, 0.0f);
                if (this.mediaEvents != null) {
                    this.mediaEvents.volumeChange(0.0f);
                }
                if (this.mListener != null) {
                    this.mListener.onVideoMute();
                }
            }
        } else if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setVolume(1.0f, 1.0f);
            if (this.mediaEvents != null) {
                this.mediaEvents.volumeChange(1.0f);
            }
            if (this.mListener != null) {
                this.mListener.onVideoNoMute();
            }
        }
    }

    public void setAdSession(boolean isOpenOmsdk) {
        try {
            this.adSession = AdSessionUtil.getNativeAdSession(this.getContext(), "", CreativeType.VIDEO, isOpenOmsdk);
        }
        catch (Throwable e) {
            Log.d((String)TAG, (String)"setupAdSession failed", (Throwable)e);
        }
        if (this.adSession != null) {
            this.mediaEvents = MediaEvents.createMediaEvents((AdSession)this.adSession);
            this.adEvents = AdEvents.createAdEvents((AdSession)this.adSession);
            this.adSession.registerAdView((View)this);
            this.adSession.start();
        }
    }

    public void setVastVideoConfig(TPInnerNativeAd config, boolean isOpenOmsdk) {
        if (config == null) {
            InnerLog.v(TAG, "TPInnerMediaView setVastVideoConfig config is null");
            return;
        }
        this.setAdSession(isOpenOmsdk);
        if (config.getVastVideoConfig() != null) {
            this.diskFileUrl = config.getVastVideoConfig().getDiskMediaFileUrl();
            this.mVideoHeight = config.getVastVideoConfig().getVideoHeight();
            this.mVideoWidth = config.getVastVideoConfig().getVideoWidth();
            InnerLog.v(TAG, "TPInnerMediaView setVastVideoConfig config DiskMediaFileUrl:" + config.getVastVideoConfig().getDiskMediaFileUrl());
            InnerLog.v(TAG, "TPInnerMediaView setVastVideoConfig config width:" + this.mVideoWidth + " height:" + this.mVideoHeight);
            return;
        }
        if (config.getImageUrl() != null) {
            ImageView imageView = new ImageView(this.getContext());
            RelativeLayout.LayoutParams rl = new RelativeLayout.LayoutParams(-1, -1);
            rl.addRule(13);
            this.addView((View)imageView, (ViewGroup.LayoutParams)rl);
            TPImageLoader.getInstance().loadImage(imageView, config.getImageUrl());
        }
    }

    public void setVastVideoConfig(TPPayloadInfo.SeatBid.Bid bidInfo, VastVideoConfig vastVideoConfig) {
        if (bidInfo == null || vastVideoConfig == null) {
            InnerLog.v(TAG, "TPInnerMediaView setVastVideoConfig config is null");
            return;
        }
        this.setAdSession(bidInfo.isOpenOMSdk());
        if (vastVideoConfig != null) {
            this.diskFileUrl = vastVideoConfig.getDiskMediaFileUrl();
            this.mVideoHeight = vastVideoConfig.getVideoHeight();
            this.mVideoWidth = vastVideoConfig.getVideoWidth();
            InnerLog.v(TAG, "TPInnerMediaView setVastVideoConfig config DiskMediaFileUrl:" + vastVideoConfig.getDiskMediaFileUrl());
            InnerLog.v(TAG, "TPInnerMediaView setVastVideoConfig config width:" + this.mVideoWidth + " height:" + this.mVideoHeight);
            return;
        }
    }

    private void initView() {
        InnerLog.v(TAG, "TPInnerMediaView MediaView initView");
        this.initTextureView();
        this.initMediaPlayer();
        this.initMuteButton();
    }

    private void initMuteButton() {
        this.mMuteBtn = new ImageView(this.getContext());
        RelativeLayout.LayoutParams rl = new RelativeLayout.LayoutParams(ViewUtils.dp2px(this.getContext(), 10), ViewUtils.dp2px(this.getContext(), 10));
        rl.addRule(10);
        rl.addRule(11);
        this.mMuteBtn.setVisibility(4);
        this.addView((View)this.mMuteBtn, (ViewGroup.LayoutParams)rl);
        if (this.mIsMute) {
            this.mMuteBtn.setBackgroundResource(R.drawable.tp_inner_video_mute);
        } else {
            this.mMuteBtn.setBackgroundResource(R.drawable.tp_inner_video_no_mute);
        }
        this.mMuteBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (TPInnerMediaView.this.mIsVideoPlayCompletion) {
                    return;
                }
                TPInnerMediaView.this.mIsMute = !TPInnerMediaView.this.mIsMute;
                if (TPInnerMediaView.this.mIsMute) {
                    TPInnerMediaView.this.mMuteBtn.setBackgroundResource(R.drawable.tp_inner_video_mute);
                    if (TPInnerMediaView.this.mMediaPlayer != null) {
                        TPInnerMediaView.this.mMediaPlayer.setVolume(0.0f, 0.0f);
                        if (TPInnerMediaView.this.mediaEvents != null) {
                            TPInnerMediaView.this.mediaEvents.volumeChange(0.0f);
                        }
                        if (TPInnerMediaView.this.mListener != null) {
                            TPInnerMediaView.this.mListener.onVideoMute();
                        }
                    }
                } else {
                    TPInnerMediaView.this.mMuteBtn.setBackgroundResource(R.drawable.tp_inner_video_no_mute);
                    if (TPInnerMediaView.this.mMediaPlayer != null) {
                        TPInnerMediaView.this.mMediaPlayer.setVolume(1.0f, 1.0f);
                        if (TPInnerMediaView.this.mediaEvents != null) {
                            TPInnerMediaView.this.mediaEvents.volumeChange(1.0f);
                        }
                        if (TPInnerMediaView.this.mListener != null) {
                            TPInnerMediaView.this.mListener.onVideoNoMute();
                        }
                    }
                }
            }
        });
    }

    private void startProgressThread() {
        if (this.mProgressThread != null) {
            return;
        }
        this.mFlag = true;
        this.mProgressThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (TPInnerMediaView.this.mFlag) {
                    if (TPInnerMediaView.this.mIsVideoPlayCompletion || TPInnerMediaView.this.mMediaPlayer == null || !TPInnerMediaView.this.mMediaPlayer.isPlaying() || TPInnerMediaView.this.mMainHandler == null) continue;
                    TPInnerMediaView.this.mMainHandler.sendEmptyMessage(TPInnerMediaView.this.mMediaPlayer.getCurrentPosition());
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.mProgressThread.start();
    }

    private void stopProgressThread() {
        this.mFlag = false;
        this.mProgressThread = null;
    }

    private void initMediaPlayer() {
        if (this.mMediaPlayer == null) {
            this.mMediaPlayer = new MediaPlayer();
            this.mMediaPlayer.setVolume(this.mIsMute ? 0.0f : 1.0f, this.mIsMute ? 0.0f : 1.0f);
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mp) {
                    InnerLog.v(TPInnerMediaView.TAG, "TPInnerMediaView MediaPlayer onPrepared()...");
                    TPInnerMediaView.this.mIsMediaPlayerPrepared = true;
                    TPInnerMediaView.this.mDuration = TPInnerMediaView.this.mMediaPlayer.getDuration();
                    TPInnerMediaView.this.mVideoProgress25 = Math.round(0.25f * (float)TPInnerMediaView.this.mDuration);
                    TPInnerMediaView.this.mVideoProgress50 = Math.round(0.5f * (float)TPInnerMediaView.this.mDuration);
                    TPInnerMediaView.this.mVideoProgress75 = Math.round(0.75f * (float)TPInnerMediaView.this.mDuration);
                    if (TPInnerMediaView.this.mCurrentPosition > 0) {
                        TPInnerMediaView.this.mMediaPlayer.seekTo(TPInnerMediaView.this.mCurrentPosition);
                    } else {
                        TPInnerMediaView.this.start();
                    }
                }
            });
            this.mMediaPlayer.setOnSeekCompleteListener(new MediaPlayer.OnSeekCompleteListener(){

                public void onSeekComplete(MediaPlayer mp) {
                    if (TPInnerMediaView.this.mIsVideoPlayCompletion && TPInnerMediaView.this.mCurrentPosition == TPInnerMediaView.this.mDuration) {
                        return;
                    }
                    TPInnerMediaView.this.start();
                }
            });
            if (!this.mIsVideoPlayCompletion) {
                this.mMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                    public void onCompletion(MediaPlayer mp) {
                        TPInnerMediaView.this.stopProgressThread();
                        TPInnerMediaView.this.mIsVideoPlayCompletion = true;
                        TPInnerMediaView.this.mCurrentPosition = TPInnerMediaView.this.mDuration;
                        TPInnerMediaView.this.mMediaPlayer.seekTo(TPInnerMediaView.this.mCurrentPosition);
                        InnerLog.v(TPInnerMediaView.TAG, "TPInnerMediaView onVideoPlayCompletion");
                        if (TPInnerMediaView.this.mediaEvents != null) {
                            TPInnerMediaView.this.mediaEvents.complete();
                        }
                        if (TPInnerMediaView.this.mListener != null) {
                            TPInnerMediaView.this.mListener.onVideoPlayCompletion();
                        }
                    }
                });
            }
            this.mMediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                public boolean onError(MediaPlayer mp, int what, int extra) {
                    if (TPInnerMediaView.this.mListener != null) {
                        TPInnerMediaView.this.mListener.onVideoShowFailed();
                    }
                    return true;
                }
            });
        }
    }

    public int getDuration() {
        return this.mDuration;
    }

    private void initTextureView() {
        if (this.mTextureView == null) {
            this.mTextureView = new TextureView(this.getContext());
            this.mTextureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
            this.mTextureView.setKeepScreenOn(true);
            RelativeLayout.LayoutParams rl = new RelativeLayout.LayoutParams(-1, -1);
            rl.addRule(13);
            this.removeAllViews();
            this.addView((View)this.mTextureView, (ViewGroup.LayoutParams)rl);
        }
    }

    private void openPlayer() {
        block6: {
            if (TextUtils.isEmpty((CharSequence)this.diskFileUrl)) {
                return;
            }
            try {
                if (this.mMediaPlayer == null) {
                    this.initMediaPlayer();
                }
                this.mMediaPlayer.reset();
                this.mMediaPlayer.setDataSource(this.getContext(), Uri.parse((String)this.diskFileUrl));
                if (this.mSurface == null) {
                    this.mSurface = new Surface(this.mSurfaceTexture);
                }
                this.mMediaPlayer.setSurface(this.mSurface);
                this.mMediaPlayer.prepareAsync();
                VastProperties vastProperties = VastProperties.createVastPropertiesForNonSkippableMedia((boolean)false, (Position)Position.STANDALONE);
                Log.d((String)TAG, (String)("mediaEvents.loaded() VastProperties = [" + vastProperties + "]"));
                if (this.adEvents != null) {
                    this.adEvents.loaded(vastProperties);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (this.mListener == null) break block6;
                this.mListener.onVideoShowFailed();
            }
        }
    }

    public void start() {
        InnerLog.v(TAG, "TPInnerMediaView start");
        if (this.mMediaPlayer != null && this.mIsMediaPlayerPrepared) {
            this.mMediaPlayer.start();
        }
        if (this.mediaEvents != null) {
            this.mediaEvents.resume();
        }
        this.checkHardwareAccelerated();
        this.startProgressThread();
    }

    public void release() {
        if (!this.mIsMediaPlayerPrepared) {
            return;
        }
        InnerLog.v(TAG, "TPInnerMediaView release");
        this.stopProgressThread();
        this.mSurfaceTexture = null;
        this.mSurface = null;
        if (this.mMediaPlayer != null) {
            if (this.mMediaPlayer.isPlaying()) {
                this.mMediaPlayer.stop();
            }
            this.mMediaPlayer.reset();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
        if (this.mMainHandler != null) {
            this.mMainHandler.removeCallbacksAndMessages(null);
        }
        this.mIsMediaPlayerPrepared = false;
    }

    public boolean isPlaying() {
        if (this.mMediaPlayer != null && this.mIsMediaPlayerPrepared) {
            return this.mMediaPlayer.isPlaying();
        }
        return false;
    }

    public void pause() {
        LogUtil.ownShow((String)"pause()");
        this.stopProgressThread();
        if (this.mediaEvents != null) {
            this.mediaEvents.pause();
        }
        if (this.isPlaying()) {
            this.mMediaPlayer.pause();
        }
    }

    private void checkHardwareAccelerated() {
        if (!this.isStartCheckHardwareAccelerated) {
            this.isStartCheckHardwareAccelerated = true;
            TPTaskManager.getInstance().runOnMainThreadDelayed(new Runnable(){

                @Override
                public void run() {
                    if (!TPInnerMediaView.this.mTextureView.isHardwareAccelerated() && TPInnerMediaView.this.mListener != null) {
                        TPInnerMediaView.this.mListener.onVideoShowFailed();
                    }
                }
            }, 500L);
        }
    }

    public int getCurrentPosition() {
        return this.mCurrentPosition < 0 ? 0 : this.mCurrentPosition;
    }

    public int getVideoLength() {
        return this.mDuration;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        InnerLog.v(TAG, "TPInnerMediaView onSurfaceTextureAvailable()...");
        this.mSurfaceTexture = surface;
        if (this.mVideoWidth > 0 && this.mVideoHeight > 0) {
            int viewWidth = this.getWidth();
            int viewHeight = this.getHeight();
            float a = Math.min((float)viewWidth / (float)this.mVideoWidth, (float)viewHeight / (float)this.mVideoHeight);
            RelativeLayout.LayoutParams rl = new RelativeLayout.LayoutParams((int)((float)this.mVideoWidth * a), (int)((float)this.mVideoHeight * a));
            rl.addRule(13);
            InnerLog.v(TAG, "TPInnerMediaView setVastVideoConfig reset width:" + rl.width + " height:" + rl.height);
            this.mTextureView.setLayoutParams((ViewGroup.LayoutParams)rl);
        }
        this.openPlayer();
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        InnerLog.v(TAG, "TPInnerMediaView onSurfaceTextureDestroyed()...");
        this.release();
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        InnerLog.v(TAG, "TPInnerMediaView onDetachedFromWindow()");
        this.release();
    }

    public static interface OnPlayerListener {
        public void onVideoPlayStart();

        public void onVideoUpdateProgress(int var1, int var2);

        public void onVideoPlayCompletion();

        public void onVideoShowFailed();

        public void onVideoPlayProgress(int var1);

        public void onVideoMute();

        public void onVideoNoMute();
    }
}

