/*
 * Decompiled with CFR 0.152.
 */
package com.tp.adx.sdk;

import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import com.tp.adx.open.AdError;
import com.tp.adx.open.TPAdOptions;
import com.tp.adx.open.TPInnerAdListener;
import com.tp.adx.open.TPInnerNativeAd;
import com.tp.adx.sdk.bean.TPPayloadInfo;
import com.tp.adx.sdk.event.InnerSendEventMessage;
import com.tradplus.ads.base.common.TPTaskManager;
import java.util.HashMap;
import java.util.List;

public abstract class InnerBaseMgr {
    protected static final String TAG = "InnerSDK";
    private static final long AD_EXPIRED_THRESHOLD = 30000L;
    private static final long LOAD_TIMEOUT_DELAY = 30000L;
    public static final int NATIVEALIDTIME = 2;
    public static final int BANNERALIDTIME = 1;
    public static final int FULLSCREENALIDTIME = 2;
    protected Object bidCn;
    String adUnitId;
    String payload;
    long payloadStartTime;
    TPInnerAdListener tpInnerAdListener;
    HashMap<String, Runnable> mOverTimeMap;
    Handler mThreadHandler;

    public Object getBidCn() {
        return this.bidCn;
    }

    InnerBaseMgr(String adUnitId, String payload) {
        this.payload = payload;
        this.adUnitId = adUnitId;
        this.mThreadHandler = TPTaskManager.getInstance().getThresholdThreadHandler();
        this.mOverTimeMap = new HashMap();
    }

    public abstract void loadAd();

    public void setAdListener(TPInnerAdListener listener) {
        this.tpInnerAdListener = listener;
    }

    public TPInnerNativeAd getNativeAd() {
        return null;
    }

    public void setAdOption(TPAdOptions options) {
        this.payloadStartTime = options.getPayloadStartTime();
    }

    public void registerView(ViewGroup viewGroup, List<View> clickableViews, TPInnerNativeAd nativeAd, boolean provicyIcon) {
    }

    boolean checkAdIsTimeOut(TPPayloadInfo.SeatBid.Bid bidInfo) {
        if (bidInfo.getExp() <= 0) {
            return false;
        }
        bidInfo.setEndTime(this.payloadStartTime + (long)(bidInfo.getExp() * 1000));
        if (bidInfo.getEndTime() == 0L) {
            return false;
        }
        return bidInfo.getEndTime() < System.currentTimeMillis() + 30000L;
    }

    void startTimeOutDelay(final InnerSendEventMessage innerSendEventMessage) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (innerSendEventMessage != null) {
                    InnerBaseMgr.this.endOverTimeRunnable(innerSendEventMessage.getRequestId());
                    innerSendEventMessage.sendLoadAdNetworkEnd(3);
                }
                TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (InnerBaseMgr.this.tpInnerAdListener != null) {
                            InnerBaseMgr.this.tpInnerAdListener.onAdLoadFailed(new AdError(1003, "load failed"));
                        }
                    }
                });
            }
        };
        this.mThreadHandler.postDelayed(runnable, 30000L);
        this.mOverTimeMap.put(innerSendEventMessage.getRequestId(), runnable);
    }

    synchronized void endOverTimeRunnable(String requestId) {
        Runnable runnable = this.mOverTimeMap.get(requestId);
        if (runnable != null) {
            this.mThreadHandler.removeCallbacks(runnable);
        }
        this.mOverTimeMap.remove(requestId);
    }
}

