/*
 * Decompiled with CFR 0.152.
 */
package com.tp.adx.sdk.tracking;

import android.text.TextUtils;
import com.tp.adx.sdk.bean.TPPayloadInfo;
import com.tp.adx.sdk.event.InnerSendEventMessage;
import com.tp.adx.sdk.tracking.InnerTrackingManager;
import com.tp.adx.sdk.util.InnerLog;
import com.tp.adx.sdk.util.Utils;
import com.tradplus.ads.base.common.TPTaskManager;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;

public class InnerTrackNotification {
    private static final String TAG = "InnerTrackNotification";
    public static final String MACRO_ERRORCODE = "[ERRORCODE]";
    public static final String MACRO_CONTENTPLAYHEAD = "[CONTENTPLAYHEAD]";
    public static final String MACRO_CACHEBUSTING = "[CACHEBUSTING]";
    public static final String MACRO_ASSETURI = "[ASSETURI]";

    public static void sendWinNotification(TPPayloadInfo.SeatBid.Bid tempBid, final String uri) {
        if (tempBid == null) {
            return;
        }
        ArrayList<String> winUrlList = new ArrayList<String>();
        if (!TextUtils.isEmpty((CharSequence)tempBid.getNurl())) {
            winUrlList.add(tempBid.getNurl());
        }
        if (tempBid.getExt() != null && tempBid.getExt().getNurl() != null) {
            winUrlList.addAll(tempBid.getExt().getNurl());
        }
        InnerLog.v(TAG, "win list:" + winUrlList.toString());
        for (final String tempUrl : winUrlList) {
            if (TextUtils.isEmpty((CharSequence)tempUrl)) {
                return;
            }
            TPTaskManager.getInstance().runNormalTask(new Runnable(){

                @Override
                public void run() {
                    InnerTrackingManager.getInstance().innerTracking(InnerTrackNotification.replaceVastMacro(tempUrl, "", uri), new InnerTrackingManager.InnerTrackingListener(){

                        @Override
                        public void onSuccess(String response) {
                        }

                        @Override
                        public void onFailed(int code, String msg) {
                        }
                    });
                }
            });
        }
    }

    public static void sendLossNotification(TPPayloadInfo.SeatBid.Bid tempBid) {
        if (tempBid == null) {
            return;
        }
        ArrayList<String> losUrlList = new ArrayList<String>();
        if (!TextUtils.isEmpty((CharSequence)tempBid.getLurl())) {
            losUrlList.add(tempBid.getLurl());
        }
        if (tempBid.getExt() != null && tempBid.getExt().getLurl() != null) {
            losUrlList.addAll(tempBid.getExt().getLurl());
        }
        InnerLog.v(TAG, "los list:" + losUrlList.toString());
        for (final String tempUrl : losUrlList) {
            if (TextUtils.isEmpty((CharSequence)tempUrl)) {
                return;
            }
            TPTaskManager.getInstance().runNormalTask(new Runnable(){

                @Override
                public void run() {
                    InnerTrackingManager.getInstance().innerTracking(tempUrl, new InnerTrackingManager.InnerTrackingListener(){

                        @Override
                        public void onSuccess(String response) {
                        }

                        @Override
                        public void onFailed(int code, String msg) {
                        }
                    });
                }
            });
        }
    }

    public static void sendImpressionNotification(TPPayloadInfo.SeatBid.Bid tempBid, InnerSendEventMessage innerSendEventMessage, final String uri) {
        if (tempBid == null) {
            return;
        }
        ArrayList<String> impUrlList = new ArrayList<String>();
        if (!TextUtils.isEmpty((CharSequence)tempBid.getBurl())) {
            impUrlList.add(tempBid.getBurl());
        }
        if (tempBid.getExt() != null && tempBid.getExt().getBurl() != null) {
            impUrlList.addAll(tempBid.getExt().getBurl());
        }
        if (tempBid.getExt() != null && tempBid.getExt().getImpurl() != null) {
            impUrlList.addAll(tempBid.getExt().getImpurl());
        }
        if (impUrlList.size() == 0) {
            return;
        }
        InnerLog.v(TAG, "imp list:" + impUrlList.toString());
        innerSendEventMessage.sendThirdShowStart("6145", -1);
        final WinTrackResult resultCount = new WinTrackResult(impUrlList.size(), innerSendEventMessage, new WinTrackResult.ResultListener(){

            @Override
            public void onResult(boolean success, InnerSendEventMessage innerSendEventMessage) {
                innerSendEventMessage.sendThirdShowStart("6150", success ? 1 : 2);
            }
        });
        for (final String tempUrl : impUrlList) {
            if (TextUtils.isEmpty((CharSequence)tempUrl)) {
                return;
            }
            TPTaskManager.getInstance().runNormalTask(new Runnable(){

                @Override
                public void run() {
                    InnerTrackingManager.getInstance().innerTracking(InnerTrackNotification.replaceVastMacro(tempUrl, "", uri), new InnerTrackingManager.InnerTrackingListener(){

                        @Override
                        public void onSuccess(String response) {
                            resultCount.onSuccess();
                        }

                        @Override
                        public void onFailed(int code, String msg) {
                            resultCount.onFailed();
                        }
                    });
                }
            });
        }
    }

    public static void sendClickNotification(TPPayloadInfo.SeatBid.Bid tempBid, InnerSendEventMessage innerSendEventMessage, String uri) {
        if (tempBid == null) {
            return;
        }
        ArrayList<String> clickUrlList = new ArrayList<String>();
        if (tempBid.getExt() != null && tempBid.getExt().getClkurl() != null) {
            for (String url : tempBid.getExt().getClkurl()) {
                clickUrlList.add(InnerTrackNotification.replaceVastMacro(url, "", uri));
            }
        }
        InnerLog.v(TAG, "click list:" + clickUrlList.toString());
        innerSendEventMessage.sendThirdClickStart("6245", -1);
        final WinTrackResult resultCount = new WinTrackResult(clickUrlList.size(), innerSendEventMessage, new WinTrackResult.ResultListener(){

            @Override
            public void onResult(boolean success, InnerSendEventMessage innerSendEventMessage) {
                innerSendEventMessage.sendThirdClickStart("6250", success ? 1 : 2);
            }
        });
        for (final String tempUrl : clickUrlList) {
            if (TextUtils.isEmpty((CharSequence)tempUrl)) {
                return;
            }
            TPTaskManager.getInstance().runNormalTask(new Runnable(){

                @Override
                public void run() {
                    InnerTrackingManager.getInstance().innerTracking(tempUrl, new InnerTrackingManager.InnerTrackingListener(){

                        @Override
                        public void onSuccess(String response) {
                            resultCount.onSuccess();
                        }

                        @Override
                        public void onFailed(int code, String msg) {
                            resultCount.onFailed();
                        }
                    });
                }
            });
        }
    }

    public static void sendErrorNotification(ArrayList<String> errorUrlList, final String errorcode, final String uri) {
        if (errorUrlList == null || errorUrlList.size() <= 0) {
            return;
        }
        InnerLog.v(TAG, "error list:" + errorUrlList.toString());
        for (final String tempUrl : errorUrlList) {
            TPTaskManager.getInstance().runNormalTask(new Runnable(){

                @Override
                public void run() {
                    InnerTrackingManager.getInstance().innerTracking(InnerTrackNotification.replaceVastMacro(tempUrl, errorcode, uri), new InnerTrackingManager.InnerTrackingListener(){

                        @Override
                        public void onSuccess(String response) {
                        }

                        @Override
                        public void onFailed(int code, String msg) {
                        }
                    });
                }
            });
        }
    }

    public static void sendVideoProgressNotification(final String progressTrackUrl, final String uri) {
        if (TextUtils.isEmpty((CharSequence)progressTrackUrl)) {
            return;
        }
        InnerLog.v(TAG, "progress list:" + progressTrackUrl);
        TPTaskManager.getInstance().runNormalTask(new Runnable(){

            @Override
            public void run() {
                InnerTrackingManager.getInstance().innerTracking(InnerTrackNotification.replaceVastMacro(progressTrackUrl, "", uri), new InnerTrackingManager.InnerTrackingListener(){

                    @Override
                    public void onSuccess(String response) {
                    }

                    @Override
                    public void onFailed(int code, String msg) {
                    }
                });
            }
        });
    }

    private static String replaceVastMacro(String url, String error, String asset) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return "";
        }
        url = url.replace(MACRO_ERRORCODE, TextUtils.isEmpty((CharSequence)error) ? "0" : error);
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:MM:SS.mmm");
        Calendar cal = Calendar.getInstance();
        String contentPlayHead = dateFormat.format(cal.getTime());
        url = url.replace(MACRO_CONTENTPLAYHEAD, contentPlayHead);
        url = url.replace(MACRO_CACHEBUSTING, Utils.getRandomPwd(8));
        url = url.replace(MACRO_ASSETURI, asset);
        return url;
    }

    public static class WinTrackResult {
        private int successCount;
        private int loadAllCount;
        private int needLoadCount;
        private WeakReference<InnerSendEventMessage> weakReference;
        private ResultListener resultListener;

        public WinTrackResult(int count, InnerSendEventMessage innerSendEventMessage, ResultListener listener) {
            this.needLoadCount = count;
            this.weakReference = new WeakReference<InnerSendEventMessage>(innerSendEventMessage);
            this.resultListener = listener;
        }

        public synchronized void onSuccess() {
            ++this.successCount;
            ++this.loadAllCount;
            this.checkAndSendMessage();
        }

        public synchronized void onFailed() {
            ++this.loadAllCount;
            this.checkAndSendMessage();
        }

        public synchronized void checkAndSendMessage() {
            if (this.needLoadCount == this.loadAllCount && this.weakReference != null && this.weakReference.get() != null) {
                this.resultListener.onResult(this.successCount == this.loadAllCount, (InnerSendEventMessage)this.weakReference.get());
            }
        }

        static interface ResultListener {
            public void onResult(boolean var1, InnerSendEventMessage var2);
        }
    }
}

