/*
 * Decompiled with CFR 0.152.
 */
package com.tp.adx.sdk.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.view.Window;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.tp.adx.sdk.bean.TPPayloadInfo;
import com.tp.adx.sdk.event.InnerSendEventMessage;
import com.tp.adx.sdk.util.InnerLog;
import com.tradplus.ads.common.util.ResourceUtils;
import java.lang.reflect.Method;

public class InnerWebViewActivity
extends Activity {
    public static final String TAG = "InnerSDK";
    public static final String INNER_ACTIVITY_URL_KEY = "inner_adx_url";
    public static final String INNER_ACTIVITY_REQUEST_ID_KEY = "inner_adx_request_id";
    public static final String INNER_ACTIVITY_PID_KEY = "inner_adx_pid";
    public static final String INNER_ACTIVITY_TP_KEY = "inner_adx_tp";
    private boolean mIsLoaded = false;
    private TPPayloadInfo payloadInfo;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window window = this.getWindow();
        this.requestWindowFeature(1);
        int flag = 1024;
        window.setFlags(flag, flag);
        this.setContentView(ResourceUtils.getLayoutIdByName((Context)this, (String)"tp_activity_inner_web_view"));
        String url = null;
        String requestId = null;
        String pid = null;
        Intent intent = this.getIntent();
        try {
            if (intent != null) {
                url = intent.getStringExtra(INNER_ACTIVITY_URL_KEY);
                requestId = intent.getStringExtra(INNER_ACTIVITY_REQUEST_ID_KEY);
                pid = intent.getStringExtra(INNER_ACTIVITY_PID_KEY);
                this.payloadInfo = (TPPayloadInfo)intent.getSerializableExtra(INNER_ACTIVITY_TP_KEY);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        InnerLog.v("onCreate url:" + url + " requestId:" + requestId + " pid:" + pid);
        if (url == null) {
            this.finish();
        }
        WebView webView = (WebView)this.findViewById(ResourceUtils.getViewIdByName((Context)this, (String)"tp_inner_activity_webview"));
        this.disableScrollingAndZoom(webView);
        this.initializeWebView(webView);
        webView.loadUrl(url);
        final String finalRequestId = requestId;
        final String finalPid = pid;
        webView.setWebViewClient(new WebViewClient(){
            private int running = 0;

            public boolean shouldOverrideUrlLoading(WebView view, String urlNewString) {
                ++this.running;
                return super.shouldOverrideUrlLoading(view, urlNewString);
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                this.running = Math.max(this.running, 1);
            }

            public void onPageFinished(WebView view, String url) {
                if (--this.running == 0) {
                    if (InnerWebViewActivity.this.mIsLoaded) {
                        return;
                    }
                    InnerWebViewActivity.this.mIsLoaded = true;
                    if (finalRequestId != null && finalPid != null) {
                        InnerSendEventMessage.sendOpenAd(InnerWebViewActivity.this.getApplicationContext(), finalRequestId, finalPid, 1, InnerWebViewActivity.this.payloadInfo);
                    }
                }
            }
        });
    }

    private void disableScrollingAndZoom(WebView webView) {
        webView.setHorizontalScrollBarEnabled(false);
        webView.setHorizontalScrollbarOverlay(false);
        webView.setVerticalScrollBarEnabled(false);
        webView.setVerticalScrollbarOverlay(false);
        webView.requestFocus();
    }

    private void initializeWebView(WebView webView) {
        WebSettings webSettings = webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setAppCacheEnabled(true);
        webSettings.setAppCacheMaxSize(0x500000L);
        webSettings.setAllowFileAccess(true);
        webSettings.setBuiltInZoomControls(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        webSettings.setDomStorageEnabled(true);
        webSettings.setSupportZoom(false);
        webSettings.setSavePassword(false);
        webSettings.setDatabaseEnabled(true);
        webSettings.setUseWideViewPort(true);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setRenderPriority(WebSettings.RenderPriority.HIGH);
        webSettings.setAppCachePath(this.getCacheDir().getAbsolutePath());
        webView.removeJavascriptInterface("searchBoxJavaBridge_");
        webView.removeJavascriptInterface("accessibility");
        webView.removeJavascriptInterface("accessibilityTraversal");
        if (Build.VERSION.SDK_INT >= 17) {
            webSettings.setMediaPlaybackRequiresUserGesture(false);
        }
        try {
            webSettings.setAllowUniversalAccessFromFileURLs(false);
            webSettings.setAllowFileAccessFromFileURLs(false);
        }
        catch (Throwable var6) {
            var6.printStackTrace();
        }
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                webSettings.setMixedContentMode(0);
            }
        }
        catch (Exception var5) {
            var5.printStackTrace();
        }
        if (Build.VERSION.SDK_INT >= 11) {
            try {
                Method var7 = WebSettings.class.getDeclaredMethod("setDisplayZoomControls", Boolean.TYPE);
                var7.setAccessible(true);
                var7.invoke((Object)webSettings, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void onBackPressed() {
        InnerLog.v("onBackPressed");
        WebView webView = (WebView)this.findViewById(ResourceUtils.getViewIdByName((Context)this, (String)"tp_inner_activity_webview"));
        if (webView.canGoBack()) {
            webView.goBack();
        } else {
            this.finish();
        }
    }
}

