/*
 * Decompiled with CFR 0.152.
 */
package com.tp.vast;

import com.tradplus.ads.base.util.XmlUtils;
import com.tradplus.ads.common.Preconditions;
import org.w3c.dom.Node;

public class VastResourceXmlManager {
    public static final String STATIC_RESOURCE = "StaticResource";
    public static final String IFRAME_RESOURCE = "IFrameResource";
    public static final String HTML_RESOURCE = "HTMLResource";
    public static final String CREATIVE_TYPE = "creativeType";
    private final Node mResourceNode;

    VastResourceXmlManager(Node resourceNode) {
        Preconditions.checkNotNull((Object)resourceNode);
        this.mResourceNode = resourceNode;
    }

    String getStaticResource() {
        return XmlUtils.getNodeValue((Node)XmlUtils.getFirstMatchingChildNode((Node)this.mResourceNode, (String)STATIC_RESOURCE));
    }

    String getStaticResourceType() {
        Node staticResource = XmlUtils.getFirstMatchingChildNode((Node)this.mResourceNode, (String)STATIC_RESOURCE);
        String attribute = XmlUtils.getAttributeValue((Node)staticResource, (String)CREATIVE_TYPE);
        if (attribute != null) {
            return attribute.toLowerCase();
        }
        return null;
    }

    String getIFrameResource() {
        return XmlUtils.getNodeValue((Node)XmlUtils.getFirstMatchingChildNode((Node)this.mResourceNode, (String)IFRAME_RESOURCE));
    }

    String getHTMLResource() {
        return XmlUtils.getNodeValue((Node)XmlUtils.getFirstMatchingChildNode((Node)this.mResourceNode, (String)HTML_RESOURCE));
    }
}

