/*
 * Decompiled with CFR 0.152.
 */
package com.tp.vast;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import com.tp.adx.sdk.ui.BaseWebView;
import com.tp.vast.VastResource;
import com.tradplus.ads.common.Preconditions;

public class VastWebView
extends BaseWebView {
    VastWebViewClickListener mVastWebViewClickListener;

    VastWebView(Context context) {
        super(context);
        this.disableScrollingAndZoom();
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setSavePassword(false);
        this.setBackgroundColor(0);
        this.setOnTouchListener(new VastWebViewOnTouchListener());
        this.setId(View.generateViewId());
    }

    void loadData(String data) {
    }

    void setVastWebViewClickListener(VastWebViewClickListener vastWebViewClickListener) {
        this.mVastWebViewClickListener = vastWebViewClickListener;
    }

    private void disableScrollingAndZoom() {
        this.setHorizontalScrollBarEnabled(false);
        this.setHorizontalScrollbarOverlay(false);
        this.setVerticalScrollBarEnabled(false);
        this.setVerticalScrollbarOverlay(false);
        this.getSettings().setSupportZoom(false);
        this.setScrollBarStyle(0);
    }

    static VastWebView createView(Context context, VastResource vastResource) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)vastResource);
        VastWebView webView = new VastWebView(context);
        vastResource.initializeWebView(webView);
        return webView;
    }

    @Deprecated
    VastWebViewClickListener getVastWebViewClickListener() {
        return this.mVastWebViewClickListener;
    }

    class VastWebViewOnTouchListener
    implements View.OnTouchListener {
        private boolean mClickStarted;

        VastWebViewOnTouchListener() {
        }

        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getAction()) {
                case 0: {
                    this.mClickStarted = true;
                    break;
                }
                case 1: {
                    if (!this.mClickStarted) {
                        return false;
                    }
                    this.mClickStarted = false;
                    if (VastWebView.this.mVastWebViewClickListener == null) break;
                    VastWebView.this.mVastWebViewClickListener.onVastWebViewClick();
                }
            }
            return false;
        }
    }

    static interface VastWebViewClickListener {
        public void onVastWebViewClick();
    }
}

