/*
 * Decompiled with CFR 0.152.
 */
package com.tp.vast;

import android.text.TextUtils;
import com.tp.vast.VastAdXmlManager;
import com.tp.vast.VastTracker;
import com.tradplus.ads.base.util.XmlUtils;
import com.tradplus.ads.common.Preconditions;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class VastXmlManager {
    private static final String ROOT_TAG = "MPMoVideoXMLDocRoot";
    private static final String ROOT_TAG_OPEN = "<MPMoVideoXMLDocRoot>";
    private static final String ROOT_TAG_CLOSE = "</MPMoVideoXMLDocRoot>";
    private static final String AD = "Ad";
    private static final String ERROR = "Error";
    private static final String MP_IMPRESSION_TRACKER = "MP_TRACKING_URL";
    private static final String CUSTOM_CTA_TEXT = "MoPubCtaText";
    private static final String CUSTOM_SKIP_TEXT = "MoPubSkipText";
    private static final String CUSTOM_CLOSE_ICON = "MoPubCloseIcon";
    private static final String CUSTOM_FORCE_ORIENTATION = "MoPubForceOrientation";
    private static final int MAX_CTA_TEXT_LENGTH = 15;
    private static final int MAX_SKIP_TEXT_LENGTH = 8;
    private Document mVastDoc;

    VastXmlManager() {
    }

    void parseVastXml(String xmlString) throws ParserConfigurationException, IOException, SAXException {
        Preconditions.checkNotNull((Object)xmlString, (String)"xmlString cannot be null");
        xmlString = xmlString.replaceFirst("<\\?.*\\?>", "");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setCoalescing(true);
        documentBuilderFactory.setExpandEntityReferences(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.mVastDoc = documentBuilder.parse(new InputSource(new StringReader(xmlString)));
    }

    List<VastAdXmlManager> getAdXmlManagers() {
        ArrayList<VastAdXmlManager> vastAdXmlManagers = new ArrayList<VastAdXmlManager>();
        if (this.mVastDoc == null) {
            return vastAdXmlManagers;
        }
        NodeList nodes = this.mVastDoc.getElementsByTagName(AD);
        for (int i = 0; i < nodes.getLength(); ++i) {
            vastAdXmlManagers.add(new VastAdXmlManager(nodes.item(i)));
        }
        return vastAdXmlManagers;
    }

    VastTracker getErrorTracker() {
        if (this.mVastDoc == null) {
            return null;
        }
        String errorTracker = XmlUtils.getFirstMatchingStringData((Document)this.mVastDoc, (String)ERROR);
        if (TextUtils.isEmpty((CharSequence)errorTracker)) {
            return null;
        }
        return new VastTracker.Builder(errorTracker).build();
    }

    List<VastTracker> getMoPubImpressionTrackers() {
        List trackers = XmlUtils.getStringDataAsList((Document)this.mVastDoc, (String)MP_IMPRESSION_TRACKER);
        ArrayList<VastTracker> vastTrackers = new ArrayList<VastTracker>(trackers.size());
        for (String tracker : trackers) {
            vastTrackers.add(new VastTracker.Builder(tracker).build());
        }
        return vastTrackers;
    }

    String getCustomCtaText() {
        String customCtaText = XmlUtils.getFirstMatchingStringData((Document)this.mVastDoc, (String)CUSTOM_CTA_TEXT);
        if (customCtaText != null && customCtaText.length() <= 15) {
            return customCtaText;
        }
        return null;
    }

    String getCustomSkipText() {
        String customSkipText = XmlUtils.getFirstMatchingStringData((Document)this.mVastDoc, (String)CUSTOM_SKIP_TEXT);
        if (customSkipText != null && customSkipText.length() <= 8) {
            return customSkipText;
        }
        return null;
    }

    String getCustomCloseIconUrl() {
        return XmlUtils.getFirstMatchingStringData((Document)this.mVastDoc, (String)CUSTOM_CLOSE_ICON);
    }
}

