/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.core;

import android.content.Context;
import android.os.Handler;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.adapter.TPLoadAdapterListener;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.LoadMode;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.filter.NetWorkFrequencyUtils;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.core.AdCacheManager;
import com.tradplus.ads.core.AdIntervalManager;
import com.tradplus.ads.core.cache.AdCache;
import com.tradplus.ads.core.factory.CustomEventFactory;
import com.tradplus.ads.core.track.LoadLifecycleCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public class BottomAdLoadManager {
    private static final int LOAD_STATUS_SUCCESS = 1;
    private static final int LOAD_STATUS_HAS_CACHE = 2;
    private static final int LOAD_STATUS_FAILED = 0;
    private static final int DEFAULT_INTERSTITIAL_TIMEOUT_DELAY = 60000;
    private ArrayList<ConfigResponse.WaterfallBean> mWaterfallBeans;
    private String mAdUnitId;
    private volatile int currentIndex;
    private ConcurrentHashMap<String, Runnable> mOverTimeMap;
    private Handler mThreadHandler;
    private int op;
    private LoadMode loadMode;
    private float bottomLoadedCallbackTime;
    private long startLoadAdTime;
    private HashMap<ConfigResponse.WaterfallBean, Integer> mLoadFinishLayers;

    public BottomAdLoadManager(String string, ArrayList<ConfigResponse.WaterfallBean> arrayList, int n, LoadMode loadMode, float f) {
        float f2;
        BottomAdLoadManager bottomAdLoadManager = this;
        this.mWaterfallBeans = arrayList;
        bottomAdLoadManager.mAdUnitId = string;
        bottomAdLoadManager.mThreadHandler = TPTaskManager.getInstance().getThresholdThreadHandler();
        bottomAdLoadManager.mOverTimeMap = new ConcurrentHashMap();
        this.op = n;
        this.loadMode = loadMode;
        float f3 = f - 0.1f;
        if (!(f2 > 0.0f)) {
            f3 = f;
        }
        BottomAdLoadManager bottomAdLoadManager2 = this;
        bottomAdLoadManager2.bottomLoadedCallbackTime = f3 * 1000.0f;
        bottomAdLoadManager2.startLoadAdTime = System.currentTimeMillis();
        bottomAdLoadManager2.mLoadFinishLayers = new HashMap();
    }

    private void loadLayerAd(int n, LoadLifecycleCallback loadLifecycleCallback) {
        d d2;
        if (n >= this.mWaterfallBeans.size()) {
            return;
        }
        ConfigResponse.WaterfallBean waterfallBean = this.mWaterfallBeans.get(n);
        if (waterfallBean == null) {
            this.loadAdLoadFailed(null, null, loadLifecycleCallback, "9", null, 0L);
            return;
        }
        if (!NetWorkFrequencyUtils.getInstance().checkNetworkFrequency(waterfallBean)) {
            this.loadAdLoadFailed(waterfallBean, null, loadLifecycleCallback, "4", null, 0L);
            return;
        }
        if (!NetWorkFrequencyUtils.getInstance().checkAdSourceFilter(waterfallBean)) {
            this.loadAdLoadFailed(waterfallBean, null, loadLifecycleCallback, "4", null, 0L);
            return;
        }
        AdCache adCache = AdCacheManager.getInstance().isExistCache(this.mAdUnitId, waterfallBean);
        if (adCache != null) {
            this.currentLayerHasCache(adCache, waterfallBean, loadLifecycleCallback);
            return;
        }
        adCache = CustomEventFactory.create(waterfallBean.getCustomClassName());
        if (adCache == null) {
            this.loadAdLoadFailed(waterfallBean, null, loadLifecycleCallback, "13", null, 0L);
            return;
        }
        Object object = AdIntervalManager.getInstance(waterfallBean);
        if (object != null && !((AdIntervalManager)object).canLoadToWaterfall()) {
            this.loadAdLoadFailed(waterfallBean, null, loadLifecycleCallback, "1107", null, 0L);
            return;
        }
        ConfigResponse.WaterfallBean waterfallBean2 = waterfallBean;
        object = d2;
        d2 = new d((TPBaseAdapter)adCache, loadLifecycleCallback);
        int n2 = this.mWaterfallBeans.indexOf(waterfallBean);
        adCache.setRequestId(loadLifecycleCallback.getRequestId());
        adCache.initAdapter(this.mAdUnitId, waterfallBean, n2, (TPLoadAdapterListener)object);
        waterfallBean2.setBottomWaterfall(true);
        if (waterfallBean2.getIs_main_thread() == 0) {
            this.loadAdapterOnThread((TPBaseAdapter)adCache, loadLifecycleCallback, waterfallBean);
        } else {
            this.loadAdapterOnMainThread((TPBaseAdapter)adCache, loadLifecycleCallback, waterfallBean);
        }
    }

    private void loadAdapterOnMainThread(final TPBaseAdapter tPBaseAdapter, final LoadLifecycleCallback loadLifecycleCallback, final ConfigResponse.WaterfallBean waterfallBean) {
        TPTaskManager.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                a a2 = a3;
                a a3 = a2.tPBaseAdapter;
                LoadLifecycleCallback loadLifecycleCallback2 = a2.loadLifecycleCallback;
                ConfigResponse.WaterfallBean waterfallBean2 = a2.waterfallBean;
                a3.BottomAdLoadManager.this.loadAd((TPBaseAdapter)a3, loadLifecycleCallback2, waterfallBean2);
            }
        });
    }

    private void loadAdapterOnThread(final TPBaseAdapter tPBaseAdapter, final LoadLifecycleCallback loadLifecycleCallback, final ConfigResponse.WaterfallBean waterfallBean) {
        TPTaskManager.getInstance().runDyCorePool(new Runnable(){

            @Override
            public void run() {
                b b2 = b3;
                b b3 = b2.tPBaseAdapter;
                LoadLifecycleCallback loadLifecycleCallback2 = b2.loadLifecycleCallback;
                ConfigResponse.WaterfallBean waterfallBean2 = b2.waterfallBean;
                b3.BottomAdLoadManager.this.loadAd((TPBaseAdapter)b3, loadLifecycleCallback2, waterfallBean2);
            }
        });
    }

    private void loadAd(TPBaseAdapter tPBaseAdapter, LoadLifecycleCallback loadLifecycleCallback, ConfigResponse.WaterfallBean waterfallBean) {
        try {
            this.startOverTimeRunnable(tPBaseAdapter, loadLifecycleCallback, waterfallBean);
            loadLifecycleCallback.loadNetWorkStart(tPBaseAdapter);
            tPBaseAdapter.loadAd();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.loadAdLoadFailed(waterfallBean, tPBaseAdapter, loadLifecycleCallback, "18", null, 0L);
        }
    }

    private void startOverTimeRunnable(final TPBaseAdapter tPBaseAdapter, final LoadLifecycleCallback loadLifecycleCallback, final ConfigResponse.WaterfallBean waterfallBean) {
        Runnable runnable;
        long l = 60000L;
        if (waterfallBean.getLoadTimeout() > 0L && waterfallBean.getLoadTimeout() <= 300L) {
            l = waterfallBean.getLoadTimeout() * 1000L;
        }
        BottomAdLoadManager bottomAdLoadManager = this;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                AdIntervalManager adIntervalManager;
                c c2 = c4;
                c2.BottomAdLoadManager.this.endOverTimeRunnable(c4.waterfallBean.getAdsource_placement_id());
                if (!c2.BottomAdLoadManager.this.mLoadFinishLayers.containsKey(c4.tPBaseAdapter.getWaterfallBean()) && (adIntervalManager = AdIntervalManager.getInstance(c4.tPBaseAdapter.getWaterfallBean())) != null) {
                    adIntervalManager.loadWaterfallFailed();
                }
                BottomAdLoadManager bottomAdLoadManager = c4.BottomAdLoadManager.this;
                c c3 = c4;
                c c4 = c3.waterfallBean;
                adIntervalManager = c3.tPBaseAdapter;
                LoadLifecycleCallback loadLifecycleCallback2 = c3.loadLifecycleCallback;
                String string = bottomAdLoadManager.getErrorMessage();
                bottomAdLoadManager.loadAdLoadFailed((ConfigResponse.WaterfallBean)c4, (TPBaseAdapter)adIntervalManager, loadLifecycleCallback2, "3", string, 0L);
            }
        };
        LogUtil.ownShow((String)("AdLoadManager startOverTimeRunnable timeout:" + l));
        bottomAdLoadManager.mThreadHandler.postDelayed(runnable2, l);
        bottomAdLoadManager.mOverTimeMap.put(waterfallBean.getAdsource_placement_id(), runnable2);
    }

    private String getErrorMessage() {
        if (!DeviceUtils.isNetworkAvailable((Context)GlobalTradPlus.getInstance().getContext())) {
            TPError tPError = new TPError();
            tPError.setErrorMessage("Network is unavailable.");
            tPError.setErrorCode("7");
            return tPError.getEmsg();
        }
        return null;
    }

    private void endOverTimeRunnable(String string) {
        Runnable runnable = this.mOverTimeMap.get(string);
        if (runnable != null) {
            this.mThreadHandler.removeCallbacks(runnable);
        }
        this.mOverTimeMap.remove(string);
    }

    private synchronized void loadAdLoaded(TPBaseAd tPBaseAd, TPBaseAdapter tPBaseAdapter, LoadLifecycleCallback loadLifecycleCallback, AdCache adCache, long l) {
        tPBaseAd = tPBaseAdapter.getWaterfallBean();
        if (this.mLoadFinishLayers.containsKey(tPBaseAd)) {
            return;
        }
        this.mLoadFinishLayers.put((ConfigResponse.WaterfallBean)tPBaseAd, 1);
        this.endOverTimeRunnable(tPBaseAdapter.getAdSourcePid());
        loadLifecycleCallback.loadBottomNetWorkEnd(adCache, tPBaseAdapter.getWaterfallBean(), tPBaseAdapter, "1", null, l);
    }

    private AdCache saveBottomCache(TPBaseAd tPBaseAd, TPBaseAdapter tPBaseAdapter, LoadLifecycleCallback loadLifecycleCallback) {
        AdCache adCache;
        AdCache adCache2;
        ConfigResponse.WaterfallBean waterfallBean = tPBaseAdapter.getWaterfallBean();
        AdCache adCache3 = adCache2 = adCache;
        adCache2();
        adCache2.setAdapter(tPBaseAdapter);
        adCache2.setAdObj(tPBaseAd);
        adCache2.setCallback(loadLifecycleCallback);
        adCache3.setConfigBean(waterfallBean);
        adCache3.setStatus(0);
        adCache3.setBottomWaterfall(true);
        adCache.setLoadMode(this.loadMode);
        adCache.setEffectTime(System.currentTimeMillis() + this.getCallbackTime());
        if (loadLifecycleCallback.isLoadAllNetwork()) {
            adCache2.setEffectTime(0L);
        }
        AdCacheManager.getInstance().saveBottomCache(this.mAdUnitId, adCache2);
        return adCache2;
    }

    private synchronized void loadAdLoadFailed(ConfigResponse.WaterfallBean waterfallBean, TPBaseAdapter tPBaseAdapter, LoadLifecycleCallback loadLifecycleCallback, String string, String string2, long l) {
        if (waterfallBean == null) {
            this.mLoadFinishLayers.put(new ConfigResponse.WaterfallBean(), 0);
        } else {
            if (this.mLoadFinishLayers.containsKey(waterfallBean)) {
                return;
            }
            this.mLoadFinishLayers.put(waterfallBean, 0);
            this.endOverTimeRunnable(waterfallBean.getAdsource_placement_id());
        }
        BottomAdLoadManager bottomAdLoadManager = this;
        loadLifecycleCallback.loadBottomNetWorkEnd(null, waterfallBean, tPBaseAdapter, string, string2, l);
        int n = bottomAdLoadManager.currentIndex;
        bottomAdLoadManager.currentIndex = n + 1;
        bottomAdLoadManager.loadLayerAd(n, loadLifecycleCallback);
    }

    private void currentLayerHasCache(AdCache adCache, ConfigResponse.WaterfallBean waterfallBean, LoadLifecycleCallback loadLifecycleCallback) {
        loadLifecycleCallback.currentBottomLayerHasCache(adCache);
        this.mLoadFinishLayers.put(waterfallBean, 2);
    }

    private long getCallbackTime() {
        float f;
        BottomAdLoadManager bottomAdLoadManager = this;
        long l = bottomAdLoadManager.startLoadAdTime;
        long l2 = 0L;
        float f2 = bottomAdLoadManager.bottomLoadedCallbackTime;
        if (f > 0.0f) {
            l2 = Float.valueOf(f2).longValue() - (System.currentTimeMillis() - l);
            LogUtil.ownShow((String)("tradpluslog endTimeCount = " + l2 + " loadTime = " + l));
            if (l2 <= 0L) {
                l2 = 0L;
            }
        }
        LogUtil.ownShow((String)("tradpluslog callbackTime = " + l2));
        return l2;
    }

    public void loadWaterfall(LoadLifecycleCallback loadLifecycleCallback) {
        BottomAdLoadManager bottomAdLoadManager = this;
        bottomAdLoadManager.currentIndex = 0;
        bottomAdLoadManager.mLoadFinishLayers.clear();
        int n = bottomAdLoadManager.currentIndex;
        bottomAdLoadManager.currentIndex = n + 1;
        bottomAdLoadManager.loadLayerAd(n, loadLifecycleCallback);
    }

    public class d
    implements TPLoadAdapterListener {
        public TPBaseAdapter a;
        public LoadLifecycleCallback b;

        public d(TPBaseAdapter tPBaseAdapter, LoadLifecycleCallback loadLifecycleCallback) {
            this.a = tPBaseAdapter;
            this.b = loadLifecycleCallback;
        }

        public void loadAdapterLoaded(final TPBaseAd tPBaseAd) {
            Runnable runnable;
            d d2 = this;
            d d3 = this;
            Object object = d3.a;
            object = d2.BottomAdLoadManager.this.saveBottomCache(tPBaseAd, object, d3.b);
            long l = System.currentTimeMillis() - BottomAdLoadManager.this.startLoadAdTime;
            Handler handler = TPTaskManager.getInstance().getLoadThreadHandler();
            Runnable runnable2 = runnable;
            runnable = new Runnable((AdCache)object, l){
                public final /* synthetic */ AdCache b;
                public final /* synthetic */ long c;
                {
                    this.b = adCache;
                    this.c = l;
                }

                @Override
                public void run() {
                    d d2 = a3.d.this;
                    d d3 = d2;
                    a a2 = a3;
                    d d4 = d3;
                    a a3 = a3.tPBaseAd;
                    d3 = d4.a;
                    LoadLifecycleCallback loadLifecycleCallback = d4.b;
                    AdCache adCache = a2.b;
                    long l = a2.c;
                    d2.BottomAdLoadManager.this.loadAdLoaded((TPBaseAd)a3, (TPBaseAdapter)d3, loadLifecycleCallback, adCache, l);
                }
            };
            long l2 = d2.b.isLoadAllNetwork() ? 0L : BottomAdLoadManager.this.getCallbackTime();
            handler.postDelayed(runnable2, l2);
        }

        public void loadAdapterLoadFailed(final TPError tPError) {
            final long l = System.currentTimeMillis() - BottomAdLoadManager.this.startLoadAdTime;
            TPTaskManager.getInstance().getLoadThreadHandler().post(new Runnable(){

                @Override
                public void run() {
                    Object object;
                    if (!b3.BottomAdLoadManager.this.mLoadFinishLayers.containsKey(b3.d.this.a.getWaterfallBean()) && (object = AdIntervalManager.getInstance(b3.d.this.a.getWaterfallBean())) != null) {
                        ((AdIntervalManager)object).loadWaterfallFailed();
                    }
                    d d2 = b3.d.this;
                    object = d2;
                    b b2 = b3;
                    b b3 = ((d)object).a.getWaterfallBean();
                    d d3 = b2.d.this;
                    object = d3.a;
                    LoadLifecycleCallback loadLifecycleCallback = d3.b;
                    String string = b2.tPError.getTpErrorCode();
                    String string2 = b2.tPError.getEmsg();
                    long l2 = b2.l;
                    d2.BottomAdLoadManager.this.loadAdLoadFailed((ConfigResponse.WaterfallBean)b3, (TPBaseAdapter)object, loadLifecycleCallback, string, string2, l2);
                }
            });
        }
    }
}

