/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.core;

import android.util.SparseArray;
import com.tradplus.ads.base.adapter.banner.TPBannerAdapter;
import com.tradplus.ads.base.adapter.interactive.TPInterActiveAdapter;
import com.tradplus.ads.base.adapter.interstitial.TPInterstitialAdapter;
import com.tradplus.ads.base.adapter.mediavideo.TPMediaVideoAdapter;
import com.tradplus.ads.base.adapter.nativead.TPNativeAdapter;
import com.tradplus.ads.base.adapter.offerwall.TPOfferWallAdapter;
import com.tradplus.ads.base.adapter.reward.TPRewardAdapter;
import com.tradplus.ads.base.adapter.splash.TPSplashAdapter;
import com.tradplus.ads.base.config.response.BiddingResponse;
import com.tradplus.ads.base.filter.NetWorkFrequencyUtils;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.common.util.CustomLogUtils;
import com.tradplus.ads.core.HbTokenManager;
import com.tradplus.ads.core.cache.AdCache;
import com.tradplus.ads.core.track.LoadLifecycleCallback;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;

public class AdCacheManager {
    private static AdCacheManager mInstance;
    private ConcurrentHashMap<String, a> allAdCaches;

    private AdCacheManager() {
        ConcurrentHashMap concurrentHashMap;
        ConcurrentHashMap concurrentHashMap2 = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap();
        v1.allAdCaches = concurrentHashMap2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized AdCacheManager getInstance() {
        if (mInstance == null) {
            Class<AdCacheManager> clazz = AdCacheManager.class;
            synchronized (AdCacheManager.class) {
                mInstance = new AdCacheManager();
            }
        }
        return mInstance;
    }

    private boolean checkAdCacheValid(AdCache adCache) {
        if (adCache == null) {
            return false;
        }
        if (adCache.getCallback() == null) {
            return false;
        }
        if (adCache.getConfigBean() == null) {
            return false;
        }
        if (adCache.isBottomWaterfall() && !adCache.isEffect()) {
            return false;
        }
        AdCacheManager adCacheManager = adCache.getAdapter();
        if (adCacheManager == null) {
            return false;
        }
        if (adCacheManager instanceof TPInterstitialAdapter) {
            return adCacheManager.isReady() && !((TPInterstitialAdapter)adCacheManager).isAdsTimeOut();
        }
        if (adCacheManager instanceof TPRewardAdapter) {
            return adCacheManager.isReady() && !((TPRewardAdapter)adCacheManager).isAdsTimeOut();
        }
        if (adCacheManager instanceof TPInterActiveAdapter) {
            return adCacheManager.isReady() && !((TPInterActiveAdapter)adCacheManager).isAdsTimeOut();
        }
        if (adCacheManager instanceof TPOfferWallAdapter) {
            return adCacheManager.isReady() && !((TPOfferWallAdapter)adCacheManager).isAdsTimeOut();
        }
        if (adCacheManager instanceof TPSplashAdapter) {
            return adCacheManager.isReady() && !((TPSplashAdapter)adCacheManager).isAdsTimeOut();
        }
        if (adCacheManager instanceof TPMediaVideoAdapter) {
            return adCacheManager.isReady() && !((TPMediaVideoAdapter)adCacheManager).isAdsTimeOut();
        }
        if (adCacheManager instanceof TPNativeAdapter) {
            return adCache.getAdObj() != null && !adCache.getAdObj().hasShown() && !((TPNativeAdapter)adCacheManager).isAdsTimeOut();
        }
        if (adCacheManager instanceof TPBannerAdapter) {
            return adCache.getAdObj() != null && !adCache.getAdObj().hasShown() && !((TPBannerAdapter)adCacheManager).isAdsTimeOut();
        }
        return false;
    }

    private void saveFirstLoadTime(AdCache adCache) {
        if (adCache == null) {
            return;
        }
        AdCacheManager adCacheManager = adCache.getAdapter();
        if (adCacheManager == null) {
            return;
        }
        if (adCacheManager instanceof TPInterstitialAdapter) {
            ((TPInterstitialAdapter)adCacheManager).setFirstLoadedTime();
        }
        if (adCacheManager instanceof TPInterActiveAdapter) {
            ((TPInterActiveAdapter)adCacheManager).setFirstLoadedTime();
        }
        if (adCacheManager instanceof TPRewardAdapter) {
            ((TPRewardAdapter)adCacheManager).setFirstLoadedTime();
        }
        if (adCacheManager instanceof TPBannerAdapter) {
            ((TPBannerAdapter)adCacheManager).setFirstLoadedTime();
        }
        if (adCacheManager instanceof TPSplashAdapter) {
            ((TPSplashAdapter)adCacheManager).setFirstLoadedTime();
        }
        if (adCacheManager instanceof TPMediaVideoAdapter) {
            ((TPMediaVideoAdapter)adCacheManager).setFirstLoadedTime();
        }
        if (adCacheManager instanceof TPNativeAdapter) {
            ((TPNativeAdapter)adCacheManager).setFirstLoadedTime();
        }
        if (adCacheManager instanceof TPOfferWallAdapter) {
            ((TPOfferWallAdapter)adCacheManager).setFirstLoadedTime();
        }
    }

    private void checkAndPushLossNotification(String object, AdCache adCache) {
        if (adCache == null) {
            return;
        }
        if (adCache.getConfigBean() != null && adCache.getConfigBean().getPayLoadInfo() != null) {
            AdCache adCache2 = adCache;
            AdCacheManager adCacheManager = adCache2.getConfigBean();
            object = adCache2.getCallback();
            HbTokenManager.sendLosNotification("4902", (ConfigResponse.WaterfallBean)adCacheManager, (LoadLifecycleCallback)object);
            adCache2.getConfigBean().setPayLoadInfo(null);
        }
    }

    private AdCache getShowCache(String string, a a2, boolean bl) {
        AdCache adCache;
        int n;
        block10: {
            AdCache adCache2;
            n = 0;
            while (true) {
                adCache2 = null;
                if (n >= a2.a.size()) break;
                a a3 = a2;
                int n2 = a3.a.keyAt(n);
                adCache = null;
                try {
                    adCache = (AdCache)a3.a.get(n2);
                }
                catch (Exception exception) {}
                if (this.checkAdCacheValid(adCache)) {
                    if (!NetWorkFrequencyUtils.getInstance().checkNetworkFrequency(adCache.getConfigBean()) || !NetWorkFrequencyUtils.getInstance().checkAdSourceFilter(adCache.getConfigBean())) {
                        ++n;
                        continue;
                    }
                    break block10;
                }
                this.checkAndPushLossNotification(string, adCache);
                a2.a(n);
            }
            adCache = adCache2;
        }
        if (adCache == null && !this.checkAdCacheValid(adCache = a2.c)) {
            return null;
        }
        if (bl) {
            NetWorkFrequencyUtils.getInstance().saveNetworkFrequency(adCache.getConfigBean());
            NetWorkFrequencyUtils.getInstance().addAdSourceIdShowCount(adCache.getConfigBean());
            if (adCache.isBottomWaterfall()) {
                a2.c = null;
            } else {
                a2.a(n);
            }
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.GET_NETWORK_SUCCESS, adCache.getConfigBean().getName() + " " + adCache.getAdapter().getAdUnitId() + " isShow :" + bl);
        } else {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.CHECK_FROM_CACHE, adCache.getConfigBean().getName() + " " + adCache.getAdapter().getAdUnitId() + " isShow :" + bl);
        }
        return adCache;
    }

    public synchronized void saveBottomCache(String string, AdCache adCache) {
        if (string == null) {
            return;
        }
        if (adCache == null) {
            return;
        }
        AdCacheManager adCacheManager = this;
        adCacheManager.saveFirstLoadTime(adCache);
        a a2 = adCacheManager.allAdCaches.get(string);
        if (a2 == null) {
            a a3;
            a2 = a3;
            a3 = new a(this);
            this.allAdCaches.put(string, a2);
        }
        a2.c = adCache;
        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.SAVE_NETWORK_SUCCESS, adCache.getConfigBean().getName() + " " + string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void saveWaterfallCache(String string, AdCache adCache, int n) {
        if (string == null) {
            return;
        }
        this.saveFirstLoadTime(adCache);
        if (!this.checkAdCacheValid(adCache)) {
            return;
        }
        if (n < 0) {
            return;
        }
        a a2 = this.allAdCaches.get(string);
        if (a2 == null) {
            a a3;
            a2 = a3;
            a3 = new a(this);
            this.allAdCaches.put(string, a2);
        }
        a a4 = a2;
        synchronized (a4) {
            a4.a.put(n, (Object)adCache);
        }
        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.SAVE_NETWORK_SUCCESS, adCache.getConfigBean().getName() + " " + string);
    }

    public synchronized void sortWaterfallCacheByResult(String object, ArrayList<ConfigResponse.WaterfallBean> arrayList) {
        ArrayList arrayList2;
        if (object == null) {
            return;
        }
        a a2 = this.allAdCaches.get(object);
        if (a2 == null) {
            a a3;
            a2 = a3;
            a3 = new a(this);
            this.allAdCaches.put((String)object, a2);
        }
        object = arrayList2;
        arrayList2 = new ArrayList();
        for (int i = 0; i < a2.a.size(); ++i) {
            AdCache adCache = a2.b(i);
            if (!this.checkAdCacheValid(adCache)) continue;
            ((ArrayList)object).add(adCache);
        }
        a2.a.clear();
        block4: for (int i = 0; i < arrayList.size(); ++i) {
            ConfigResponse.WaterfallBean waterfallBean = arrayList.get(i);
            if (waterfallBean == null) continue;
            for (int j = 0; j < ((ArrayList)object).size(); ++j) {
                ConfigResponse.WaterfallBean waterfallBean2;
                AdCache adCache = (AdCache)((ArrayList)object).get(j);
                if (adCache == null || (waterfallBean2 = adCache.getConfigBean()) == null || !waterfallBean2.getAdsource_placement_id().equals(waterfallBean.getAdsource_placement_id())) continue;
                a a4 = a2;
                synchronized (a4) {
                    a4.a.put(i, (Object)adCache);
                    continue block4;
                }
            }
        }
    }

    @Deprecated
    public synchronized void saveHbCache(String string, AdCache adCache) {
        int n;
        a a2;
        block9: {
            if (string == null) {
                return;
            }
            if (!this.checkAdCacheValid(adCache)) {
                return;
            }
            if (adCache.getConfigBean().getPayLoadInfo() == null) {
                return;
            }
            a2 = this.allAdCaches.get(string);
            if (a2 == null) {
                a a3;
                a2 = a3;
                a3 = new a(this);
                this.allAdCaches.put(string, a2);
            }
            int n2 = 0;
            for (n = 0; n < a2.b.size(); ++n) {
                BiddingResponse.PayLoadInfo payLoadInfo = adCache.getConfigBean().getPayLoadInfo();
                if (!(a2.b.get(n).getConfigBean().getPayLoadInfo().getPrice() <= payLoadInfo.getPrice())) {
                    continue;
                }
                break block9;
            }
            n = n2;
        }
        a a4 = a2;
        synchronized (a4) {
            a4.b.add(n, adCache);
            return;
        }
    }

    public synchronized boolean removeHbCache(String string, BiddingResponse.PayLoadInfo payLoadInfo) {
        if (string != null && payLoadInfo != null) {
            return this.removeCache(string, String.valueOf(payLoadInfo.getId()));
        }
        return false;
    }

    public synchronized boolean removeCache(String string, String string2) {
        if (string != null && string2 != null) {
            a a2 = ((AdCacheManager)((Object)a2)).allAdCaches.get(string);
            if (a2 == null) {
                return false;
            }
            for (int i = 0; i < a2.a.size(); ++i) {
                AdCache adCache = a2.b(i);
                if (adCache == null || !adCache.getConfigBean().getAdsource_placement_id().equals(string2)) continue;
                a2.a(i);
                return true;
            }
            return false;
        }
        return false;
    }

    public synchronized void removeEndCache(String string, int n) {
        if (string == null && n <= 0) {
            return;
        }
        a a2 = ((AdCacheManager)((Object)a2)).allAdCaches.get(string);
        if (a2 == null) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            a a3 = a2;
            a3.a(a3.a.size() - 1);
        }
        a2.c = null;
    }

    public AdCache getReadyAd(String string) {
        if (string == null) {
            return null;
        }
        a a2 = this.allAdCaches.get(string);
        if (a2 == null) {
            return null;
        }
        return this.getShowCache(string, a2, false);
    }

    public boolean hasExclusiveAds(String string) {
        if (string == null) {
            return false;
        }
        a a2 = ((AdCacheManager)((Object)a2)).allAdCaches.get(string);
        if (a2 == null) {
            return false;
        }
        for (int i = 0; i < a2.a.size(); ++i) {
            AdCache adCache = (AdCache)a2.a.get(i);
            if (adCache == null || adCache.isExclusive() != 1) continue;
            return true;
        }
        return false;
    }

    public AdCache getBottomCacheAd(String string) {
        if (string == null) {
            return null;
        }
        a a2 = ((AdCacheManager)((Object)a2)).allAdCaches.get(string);
        if (a2 == null) {
            return null;
        }
        return a2.c;
    }

    public int getIncludeBottomReadyNum(String object) {
        AdCacheManager adCacheManager = this;
        int n = adCacheManager.getReadyAdNum((String)object);
        if ((object = adCacheManager.allAdCaches.get(object)) != null && this.checkAdCacheValid(((a)object).c)) {
            ++n;
        }
        return n;
    }

    public int getReadyAdNum(String string) {
        if (string == null) {
            return 0;
        }
        a a2 = this.allAdCaches.get(string);
        if (a2 == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n < a2.a.size()) {
            AdCache adCache = a2.b(n);
            if (this.checkAdCacheValid(adCache)) {
                if (NetWorkFrequencyUtils.getInstance().checkNetworkFrequency(adCache.getConfigBean()) && NetWorkFrequencyUtils.getInstance().checkAdSourceFilter(adCache.getConfigBean())) {
                    ++n2;
                }
                ++n;
                continue;
            }
            this.checkAndPushLossNotification(string, adCache);
            a2.a(n);
        }
        return n2;
    }

    public ArrayList<AdCache> hasBiddingAdByCachesList(String object) {
        ArrayList<AdCache> arrayList;
        if (object == null) {
            return null;
        }
        if ((object = this.allAdCaches.get(object)) == null) {
            return null;
        }
        ArrayList<AdCache> arrayList2 = arrayList;
        arrayList = new ArrayList<AdCache>();
        for (int i = 0; i < ((a)object).a.size(); ++i) {
            AdCache adCache = ((a)object).b(i);
            if (!this.checkAdCacheValid(adCache) || adCache.getConfigBean().getNew_sort_type() != 9) continue;
            arrayList2.add(adCache);
        }
        return arrayList2;
    }

    public boolean hasBiddingAdByCaches(String object) {
        if (object == null) {
            return false;
        }
        if ((object = this.allAdCaches.get(object)) == null) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < ((a)object).a.size(); ++i) {
            AdCache adCache = ((a)object).b(i);
            if (!this.checkAdCacheValid(adCache) || adCache.getConfigBean().getNew_sort_type() != 9) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public AdCache isExistCache(String string, ConfigResponse.WaterfallBean waterfallBean) {
        if (string == null) {
            return null;
        }
        if (waterfallBean == null) {
            return null;
        }
        a a2 = this.allAdCaches.get(string);
        if (a2 == null) {
            return null;
        }
        int n = 0;
        while (n < a2.a.size()) {
            AdCache adCache = a2.b(n);
            if (adCache != null && adCache.getConfigBean().getAdsource_placement_id().equals(waterfallBean.getAdsource_placement_id())) {
                if (this.checkAdCacheValid(adCache)) {
                    return adCache;
                }
                this.checkAndPushLossNotification(string, adCache);
                a2.a(n);
                continue;
            }
            ++n;
        }
        return null;
    }

    @Deprecated
    public AdCache isExistHbCache(String iterator, ConfigResponse.WaterfallBean waterfallBean) {
        if (iterator == null) {
            return null;
        }
        if (waterfallBean == null) {
            return null;
        }
        if ((iterator = this.allAdCaches.get(iterator)) == null) {
            return null;
        }
        iterator = ((a)((Object)iterator)).b.iterator();
        while (iterator.hasNext()) {
            AdCache adCache = iterator.next();
            if (!adCache.getConfigBean().getAdsource_placement_id().equals(waterfallBean.getAdsource_placement_id())) continue;
            if (this.checkAdCacheValid(adCache)) {
                return adCache;
            }
            iterator.remove();
        }
        return null;
    }

    public AdCache isExistHbCache(String string, BiddingResponse.PayLoadInfo payLoadInfo) {
        if (string == null) {
            return null;
        }
        if (payLoadInfo == null) {
            return null;
        }
        a a2 = this.allAdCaches.get(string);
        if (a2 == null) {
            return null;
        }
        for (int i = 0; i < a2.a.size(); ++i) {
            AdCache adCache = a2.b(i);
            if (adCache == null || !adCache.getConfigBean().getAdsource_placement_id().equals(String.valueOf(payLoadInfo.getId()))) continue;
            if (this.checkAdCacheValid(adCache)) {
                return adCache;
            }
            this.checkAndPushLossNotification(string, adCache);
            a2.a(i);
            return null;
        }
        return null;
    }

    public boolean checkAdCacheTimeout(String object) {
        if (object == null) {
            return false;
        }
        a a2 = this.allAdCaches.get(object);
        if (a2 == null) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < a2.a.size()) {
            AdCache adCache = a2.b(n2);
            if (!this.checkAdCacheValid(adCache)) {
                ++n;
                this.checkAndPushLossNotification((String)object, adCache);
                a2.a(n2);
                continue;
            }
            ++n2;
        }
        object = a2.c;
        if (object != null && !this.checkAdCacheValid((AdCache)object)) {
            ++n;
            a2.c = null;
        }
        return n > 0;
    }

    public AdCache getAdCacheToShow(String string) {
        if (string == null) {
            return null;
        }
        a a2 = this.allAdCaches.get(string);
        if (a2 == null) {
            return null;
        }
        return this.getShowCache(string, a2, true);
    }

    public SparseArray<AdCache> getWaterFallCaches(String string) {
        if (string == null) {
            return null;
        }
        a a2 = ((AdCacheManager)((Object)a2)).allAdCaches.get(string);
        if (a2 == null) {
            return null;
        }
        return a2.a;
    }

    public class a {
        public volatile SparseArray<AdCache> a;
        public volatile ArrayList<AdCache> b;
        public volatile AdCache c;

        public a(AdCacheManager adCacheManager) {
            ArrayList arrayList;
            SparseArray sparseArray;
            Object object = sparseArray;
            sparseArray = new SparseArray();
            v1.a = object;
            object = arrayList;
            arrayList = new ArrayList();
            v1.b = object;
        }

        public AdCache b(int n) {
            a a2 = object;
            Object object = null;
            try {
                object = (AdCache)a2.a.valueAt(n);
            }
            catch (Exception exception) {}
            return object;
        }

        public synchronized void a(int n) {
            if (n >= this.a.size()) {
                return;
            }
            this.a.removeAt(n);
        }
    }
}

