/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.core;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.widget.Toast;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.TradPlus;
import com.tradplus.ads.base.common.IntervalLock;
import com.tradplus.ads.base.common.LoadMode;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.common.ValidBoolean;
import com.tradplus.ads.base.config.ConfigLoadManager;
import com.tradplus.ads.base.filter.FrequencyUtils;
import com.tradplus.ads.base.filter.NetWorkFrequencyUtils;
import com.tradplus.ads.base.network.TPSettingManager;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.base.util.TradPlusDataConstants;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.CustomLogUtils;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.core.AdCacheManager;
import com.tradplus.ads.core.AdLoadManager;
import com.tradplus.ads.core.BottomAdLoadManager;
import com.tradplus.ads.core.HbTokenManager;
import com.tradplus.ads.core.cache.AdCache;
import com.tradplus.ads.core.track.LoadLifecycleCallback;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AdMediationManager {
    private final long LOAD_FAIL_TIME_INTERVAL = 10000L;
    private final long LOAD_SUCCESS_BUT_NOT_SHOW_VALID = 240000L;
    private static ConcurrentHashMap<String, AdMediationManager> adMediationManagerMap = new ConcurrentHashMap();
    public static final int LOAD_TRIGGER_INITUNIT = 1;
    public static final int LOAD_TRIGGER_ISREADY_FALSE = 2;
    public static final int LOAD_TRIGGER_SHOW_ISREADY_FALSE = 3;
    public static final int LOAD_TRIGGER_DISMISS = 4;
    public static final int LOAD_TRIGGER_LOAD_FAILED = 500;
    public static final int LOAD_TRIGGER_MANUAL_LOAD = 6;
    public static final int LOAD_TRIGGER_RELOAD_MANUAL = 7;
    public static final int LOAD_TRIGGER_RELOAD_AUTO = 8;
    public static final int LOAD_TRIGGER_RELOAD_SCENARIO = 9;
    public static final int LOAD_TRIGGER_UNKNOWN = 10;
    public static final int LOAD_TRIGGER_AUTO_REFRESH = 11;
    public static final int LOAD_TRIGGER_ADEXPIRED = 12;
    public static final int LOAD_TRIGGER_NETWORKCONNECT_RELOAD = 13;
    private static final String BID_PRICE_CURRENCY = "customBidPriceCurrency";
    private static final String BID_PRICE = "customBidPrice";
    private static final String CURRENCY_USD = "USD";
    private String mAdUnitId;
    private boolean isLoading = false;
    private ValidBoolean loadSuccess;
    private IntervalLock intervalLock;
    private int cacheNumber;
    private double bidFloorPrice;
    private String bidFloorCurrency;

    public static boolean isReload(int n) {
        return n == 9 || n == 7 || n == 8;
    }

    private AdMediationManager(String string) {
        this.mAdUnitId = string;
        this.intervalLock = new IntervalLock(10000L);
        this.loadSuccess = new ValidBoolean(240000L);
    }

    public static synchronized AdMediationManager getInstance(String string) {
        AdMediationManager adMediationManager = adMediationManagerMap.get(string);
        if (adMediationManager == null) {
            adMediationManager = new AdMediationManager(string);
            adMediationManagerMap.put(string, adMediationManager);
        }
        return adMediationManager;
    }

    private void load(final LoadLifecycleCallback loadLifecycleCallback, final int n) {
        TradPlus.invoker().checkSDKInit();
        ConfigLoadManager.getInstance().loadConfig(this.mAdUnitId, new ConfigLoadManager.ConfigLoadListener(){

            public final void onSuccess(ConfigResponse configResponse) {
                if (configResponse == null) {
                    loadLifecycleCallback.loadEndNoConfig();
                    return;
                }
                AdMediationManager.this.changeThreadAndLoadAd(configResponse, loadLifecycleCallback, n);
            }

            public final void onFailed(int n2, String string) {
                loadLifecycleCallback.loadEndNoConfig();
            }
        });
    }

    public void loadAd(LoadLifecycleCallback loadLifecycleCallback, int n) {
        this.load(loadLifecycleCallback, n);
    }

    private void putBidFloorByAdExpired(int n) {
        if (12 == n) {
            Map map = GlobalTradPlus.getInstance().getUserLoadParam(this.mAdUnitId);
            map.put(BID_PRICE, "" + this.bidFloorPrice);
            map.put(BID_PRICE_CURRENCY, this.bidFloorCurrency);
            GlobalTradPlus.getInstance().setUserLoadParam(this.mAdUnitId, map);
        }
    }

    private void changeThreadAndLoadAd(final ConfigResponse configResponse, final LoadLifecycleCallback loadLifecycleCallback, final int n) {
        TPTaskManager.getInstance().getLoadThreadHandler().post(new Runnable(){

            @Override
            public final void run() {
                AdMediationManager adMediationManager = AdMediationManager.this;
                synchronized (adMediationManager) {
                    loadLifecycleCallback.loadStart(n);
                    AdMediationManager.this.putBidFloorByAdExpired(n);
                    ConfigResponse configResponse2 = AdMediationManager.this.checkBidPrice(configResponse);
                    AdMediationManager.this.checkAndLoadAd(configResponse2, loadLifecycleCallback, n);
                    return;
                }
            }
        });
    }

    private ConfigResponse checkBidPrice(ConfigResponse configResponse) {
        Object object;
        Map map = GlobalTradPlus.getInstance().getUserLoadParam(this.mAdUnitId);
        try {
            object = map.get(BID_PRICE);
            double d = object != null ? Double.parseDouble((String)object) : 0.0;
            object = map.get(BID_PRICE_CURRENCY);
            object = (object != null ? (String)object : "").toUpperCase(Locale.ENGLISH);
            if (TPSettingManager.getInstance().isOpenAutoLoad(this.mAdUnitId) && d > 0.0) {
                CustomLogUtils.getInstance().logWarn(CustomLogUtils.TradPlusLog.NOT_BIDDING_BY_AUTOLOAD_OPEN, this.mAdUnitId);
                d = 0.0;
                object = "";
            }
            this.bidFloorPrice = d;
            this.bidFloorCurrency = object;
            object = this.checkBidPriceWaterfall(configResponse, d, (String)object);
            map.put(BID_PRICE, "0");
            map.put(BID_PRICE_CURRENCY, "");
            GlobalTradPlus.getInstance().setUserLoadParam(this.mAdUnitId, map);
        }
        catch (Throwable throwable) {
            this.bidFloorPrice = 0.0;
            this.bidFloorCurrency = "";
            map.put(BID_PRICE, "" + this.bidFloorPrice);
            map.put(BID_PRICE_CURRENCY, this.bidFloorCurrency);
            GlobalTradPlus.getInstance().setUserLoadParam(this.mAdUnitId, map);
            return this.checkBidPriceWaterfall(configResponse, this.bidFloorPrice, this.bidFloorCurrency);
        }
        return object;
    }

    private ConfigResponse checkBidPriceWaterfall(ConfigResponse configResponse, double d, String string) {
        ConfigResponse configResponse2;
        if (configResponse == null) {
            return null;
        }
        try {
            configResponse2 = (ConfigResponse)JSON.parseObject((String)JSON.toJSONString((Object)configResponse), ConfigResponse.class);
            if (d <= 0.0) {
                return configResponse2;
            }
            if (TextUtils.isEmpty((CharSequence)string)) {
                string = CURRENCY_USD;
            }
            int n = 0;
            ArrayList arrayList = configResponse2.getWaterfall();
            while (n < arrayList.size()) {
                ConfigResponse.WaterfallBean waterfallBean = (ConfigResponse.WaterfallBean)arrayList.get(n);
                double d2 = CURRENCY_USD.equals(string) ? waterfallBean.getEcpm() : waterfallBean.getEcpm_cny();
                if (d2 >= d) {
                    ++n;
                    continue;
                }
                AdCacheManager.getInstance().removeCache(this.mAdUnitId, waterfallBean.getAdsource_placement_id());
                configResponse2.getWaterfall().remove(waterfallBean);
            }
            if (configResponse2.getWaterfall().size() == 0) {
                CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOAD_NORMAL_WATERFALL_HAS_NO_SIZE, this.mAdUnitId);
            }
        }
        catch (Throwable throwable) {
            return configResponse;
        }
        return configResponse2;
    }

    private boolean hasBottomWaterfall(ConfigResponse configResponse) {
        return configResponse.getBottomwaterfall() != null && configResponse.getBottomwaterfall().size() > 0;
    }

    private void isTestMode(String string, ConfigResponse.WaterfallBean object) {
        String string2 = "";
        if (object.getConfigBean() != null) {
            string2 = object.getConfigBean().getPlacementId();
        }
        object = object.getName();
        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.TPTESTMODE_ON, "");
        if (!TextUtils.isEmpty((CharSequence)string)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.TPTESTMODE_TPYE, string + " ----- ");
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.TPTESTMODE_ADSOURCE_PID, string2 + " ----- ");
        }
        if (!TextUtils.isEmpty((CharSequence)object)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.TPTESTMODE_ADSOURCE_NAME, (String)object + " ----- ");
        }
        TPTaskManager.getInstance().runOnMainThread(new Runnable(){

            @Override
            public final void run() {
                Activity activity = GlobalTradPlus.getInstance().getActivity();
                if (activity != null) {
                    Toast.makeText((Context)activity, (CharSequence)"TradPlus TestMode Is On", (int)1).show();
                }
            }
        });
    }

    private void checkAndLoadBottomWaterfall(ConfigResponse configResponse, LoadLifecycleCallback loadLifecycleCallback, int n) {
        LogUtil.ownShow((String)("TradPlusLog----- LoadMode -----" + this.getLoadedType(configResponse.getAd_fill_callback())));
        if (!this.hasBottomWaterfall(configResponse)) {
            return;
        }
        if (AdCacheManager.getInstance().getIncludeBottomReadyNum(this.mAdUnitId) > 0) {
            return;
        }
        new BottomAdLoadManager(this.mAdUnitId, configResponse.getBottomwaterfall(), n, this.getLoadedType(configResponse.getAd_fill_callback()), configResponse.getBottomWaitTime()).loadWaterfall(loadLifecycleCallback);
    }

    private void checkAndLoadAd(final ConfigResponse configResponse, final LoadLifecycleCallback loadLifecycleCallback, final int n) {
        ArrayList arrayList;
        ArrayList arrayList2;
        final int n2 = this.cacheNumber != 0 ? this.cacheNumber : configResponse.getCacheNum();
        LogUtil.ownShow((String)"AdMediationManager \u5e76\u884c\u6570ParallelNum:".concat(String.valueOf(n2)));
        int n3 = this.cacheNumber != 0 ? this.cacheNumber : configResponse.getMinCache();
        LogUtil.ownShow((String)"AdMediationManager \u6700\u5c0f\u7f13\u5b58\u6570minCache:".concat(String.valueOf(n3)));
        int n4 = 0;
        final int n5 = 0;
        int n6 = 0;
        ArrayList arrayList3 = configResponse.getWaterfall();
        if (arrayList3 != null) {
            n4 = arrayList3.size();
        }
        if ((arrayList2 = configResponse.getBiddingwaterfall()) != null) {
            n5 = arrayList2.size();
        }
        if ((arrayList = configResponse.getC2sbiddingwaterfall()) != null) {
            n6 = arrayList.size();
        }
        int n7 = configResponse.getIs_test_mode();
        String string = configResponse.getAdType();
        if (n7 == 1) {
            if (n5 > 0) {
                this.isTestMode(string, (ConfigResponse.WaterfallBean)arrayList2.get(0));
            } else if (n6 > 0) {
                this.isTestMode(string, (ConfigResponse.WaterfallBean)arrayList.get(0));
            } else if (n4 > 0) {
                this.isTestMode(string, (ConfigResponse.WaterfallBean)arrayList3.get(0));
            }
        }
        if (n2 <= 0 || n3 <= 0 || n4 <= 0 && n5 <= 0 && n6 <= 0) {
            if (!this.hasBottomWaterfall(configResponse)) {
                loadLifecycleCallback.loadEnd("9", n);
                return;
            }
            loadLifecycleCallback.loadEnd("1", n);
            return;
        }
        if (this.checkFilter()) {
            loadLifecycleCallback.loadEnd("4", n);
            return;
        }
        if (!NetWorkFrequencyUtils.getInstance().checkGroupFrequency(this.mAdUnitId)) {
            loadLifecycleCallback.loadEnd("4", n);
            return;
        }
        n2 = Math.min(n2, n4 + n5 + n6);
        n4 = AdCacheManager.getInstance().getReadyAdNum(this.mAdUnitId);
        LogUtil.ownShow((String)("AdMediationManager checkCacheFill hasCache(\u5df2\u6709\u7f13\u5b58\u6570):" + n4 + " needParallelNum(\u5b9e\u9645\u5e76\u884c\u6570):" + n2 + " minCache(\u6700\u5c0f\u7f13\u5b58\u6570):" + n3));
        n5 = n3;
        final LoadMode loadMode = this.getLoadedType(configResponse.getAd_fill_callback());
        if (this.bidFloorPrice <= 0.0 || !AdCacheManager.getInstance().hasBiddingAdByCaches(this.mAdUnitId)) {
            if (n4 >= n3 && !AdMediationManager.isReload(n)) {
                loadLifecycleCallback.loadEnd("8", n);
                return;
            }
            if (this.checkHadCache() && LoadMode.ECPM != loadMode) {
                loadLifecycleCallback.loadEnd("19", n);
                return;
            }
        }
        if (this.checkHasExclusiveCache()) {
            loadLifecycleCallback.loadEnd("20", n);
            return;
        }
        if (this.checkNetwork()) {
            loadLifecycleCallback.loadEnd("7", n);
            return;
        }
        this.intervalLock.setExpireSecond(configResponse.getLoadFailedInterval());
        if (this.intervalLock.isLocked() && !TPSettingManager.getInstance().isGlobalCloseLimitReload()) {
            loadLifecycleCallback.loadEnd("15", n);
            return;
        }
        loadLifecycleCallback.loadEnd("1", n);
        this.checkAndLoadBottomWaterfall(configResponse, loadLifecycleCallback, n);
        GlobalTradPlus.getInstance().setConfigParam(this.mAdUnitId, configResponse);
        if (LoadMode.ECPM != loadMode && configResponse.getNobid() != 0) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.NOBIDMODE_OPEN, " " + this.mAdUnitId);
            AdCache adCache = AdCacheManager.getInstance().getReadyAd(this.mAdUnitId);
            if (adCache != null && adCache.getConfigBean() != null) {
                loadLifecycleCallback.currentLayerHasCache(adCache);
            }
        }
        new HbTokenManager(this.mAdUnitId).startBidding(configResponse, this.bidFloorPrice, this.bidFloorCurrency, loadLifecycleCallback, loadMode, new HbTokenManager.a(){

            @Override
            public final void a(ArrayList<ConfigResponse.WaterfallBean> arrayList, String string) {
                if (arrayList == null || arrayList.size() <= 0) {
                    loadLifecycleCallback.loadAllNetwork(AdMediationManager.this.getBiddingNoResultStatus(loadLifecycleCallback, string), AdMediationManager.isReload(n), n, 0);
                    return;
                }
                if ((arrayList = AdMediationManager.this.getLoadWaterfalls(configResponse, arrayList, AdMediationManager.isReload(n))).size() == 0) {
                    loadLifecycleCallback.loadAllNetwork(AdMediationManager.this.getBiddingNoResultStatus(loadLifecycleCallback, string), AdMediationManager.isReload(n), n, 0);
                    return;
                }
                int n3 = n2;
                if (arrayList.size() > 0 && AdMediationManager.isReload(n)) {
                    n3 = 1;
                }
                LogUtil.ownShow((String)"AdMediationManager needParallelNum(\u5e76\u884c\u6570):".concat(String.valueOf(n3)));
                LogUtil.ownShow((String)("mediation reload = " + n));
                new AdLoadManager(AdMediationManager.this.mAdUnitId, arrayList, n3, n5, n, loadMode, configResponse.getNobid() != 0).loadWaterfall(loadLifecycleCallback);
            }
        });
    }

    private String getBiddingNoResultStatus(LoadLifecycleCallback loadLifecycleCallback, String string) {
        String string2 = "103";
        AdCache adCache = AdCacheManager.getInstance().getBottomCacheAd(this.mAdUnitId);
        if (adCache != null && adCache.isBottomWaterfall()) {
            adCache.setEffectTime(0L);
            loadLifecycleCallback.loadAdLoaded(adCache);
            string2 = "1";
        }
        if (TextUtils.equals((CharSequence)"105", (CharSequence)string)) {
            string2 = "105";
        }
        return string2;
    }

    private ArrayList<ConfigResponse.WaterfallBean> getLoadWaterfalls(ConfigResponse configResponse, ArrayList<ConfigResponse.WaterfallBean> arrayList, boolean n) {
        ArrayList<ConfigResponse.WaterfallBean> arrayList2 = new ArrayList<ConfigResponse.WaterfallBean>();
        configResponse = configResponse.getReload_config();
        if (n != 0 && configResponse != null) {
            int n2 = configResponse.getRequest_layer();
            if (n2 <= 0) {
                return arrayList2;
            }
            n2 = n2 > arrayList.size() ? arrayList.size() : n2;
            for (n = 0; n < n2; ++n) {
                arrayList2.add(arrayList.get(n));
            }
        } else {
            arrayList2.addAll(arrayList);
        }
        return arrayList2;
    }

    private boolean checkHasExclusiveCache() {
        return AdCacheManager.getInstance().hasExclusiveAds(this.mAdUnitId);
    }

    private boolean checkFilter() {
        Context context = GlobalTradPlus.getInstance().getContext();
        return !FrequencyUtils.getInstance().needFrequencyShow(context, this.mAdUnitId, TradPlusDataConstants.CACHETRADPLUSTYPE);
    }

    private boolean checkNetwork() {
        return !DeviceUtils.isNetworkAvailable((Context)GlobalTradPlus.getInstance().getContext());
    }

    private boolean checkHadCache() {
        int n = AdCacheManager.getInstance().getReadyAdNum(this.mAdUnitId);
        LogUtil.ownShow((String)("AdMediationManager checkHadCache hasCache:" + n + " loadSuccessButNotShow:" + this.checkHasLoadSuccess()));
        return n > 0 && this.checkHasLoadSuccess();
    }

    public boolean checkIsLoading() {
        return this.isLoading;
    }

    public synchronized void setLoading(boolean bl) {
        this.isLoading = bl;
    }

    public boolean checkHasLoadSuccess() {
        return this.loadSuccess.checkResult();
    }

    public synchronized void setLoadSuccess(boolean bl) {
        this.loadSuccess.setResult(bl);
    }

    public synchronized void setAllLoadFail() {
        this.intervalLock.tryLock();
    }

    public int getCacheNumber() {
        return this.cacheNumber;
    }

    public void setCacheNumber(int n) {
        this.cacheNumber = n;
    }

    public LoadMode getLoadedType(int n) {
        if (n == 1) {
            return LoadMode.ECPM;
        }
        return LoadMode.SPEED;
    }
}

