/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.core.track;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.bean.TPAdError;
import com.tradplus.ads.base.common.LoadMode;
import com.tradplus.ads.base.common.NetworkSourceManager;
import com.tradplus.ads.base.common.Util;
import com.tradplus.ads.base.config.response.BiddingResponse;
import com.tradplus.ads.base.event.TPPushCenter;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.CustomLogUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.core.AdCacheManager;
import com.tradplus.ads.core.AdMediationManager;
import com.tradplus.ads.core.HBManager;
import com.tradplus.ads.core.HbTokenManager;
import com.tradplus.ads.core.cache.AdCache;
import com.tradplus.ads.core.track.LoadAdListener;
import com.tradplus.ads.pushcenter.event.request.EventBiddingNotification;
import com.tradplus.ads.pushcenter.event.request.SimplifyEvent;
import com.tradplus.ads.pushcenter.reqeust.AdconfRequest;
import com.tradplus.ads.pushcenter.reqeust.BaseRequest;
import com.tradplus.ads.pushcenter.reqeust.BiddingEndRequest;
import com.tradplus.ads.pushcenter.reqeust.BiddingStartRequest;
import com.tradplus.ads.pushcenter.reqeust.ClickRequest;
import com.tradplus.ads.pushcenter.reqeust.LoadFirstNetworkAd;
import com.tradplus.ads.pushcenter.reqeust.LoadNetworkRequest;
import com.tradplus.ads.pushcenter.reqeust.LoadRequest;
import com.tradplus.ads.pushcenter.reqeust.ReadyRequest;
import com.tradplus.ads.pushcenter.reqeust.RewardRequest;
import com.tradplus.ads.pushcenter.reqeust.ShowRequest;
import com.tradplus.ads.pushcenter.reqeust.ShowStartRequest;
import com.tradplus.ads.pushcenter.reqeust.VideoCloseRequest;
import com.tradplus.ads.pushcenter.reqeust.VideoRequest;
import com.tradplus.ads.pushcenter.utils.PushMessageUtils;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import com.tradplus.ads.pushcenter.utils.SendMessageUtil;
import java.util.Map;
import java.util.UUID;

public class LoadLifecycleCallback {
    private final String ENTRYSCENARIO = "entryScenario";
    private String requestId = UUID.randomUUID().toString();
    private String mAdUnitId;
    private LoadAdListener mLoadListener;
    private boolean isSaveAgainClickEvent;
    private boolean isSaveClickEvent;
    private long startLoadAdTime = 0L;
    private String allLoadUUID = null;
    private boolean isLoadAllNetwork;

    public LoadLifecycleCallback(String string, LoadAdListener loadAdListener) {
        this.mLoadListener = loadAdListener;
        this.mAdUnitId = string;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void refreshListener(LoadAdListener loadAdListener) {
        this.mLoadListener = loadAdListener;
    }

    public void loadStart(int n) {
        SendMessageUtil.getInstance().sendLoadAdStart(GlobalTradPlus.getInstance().getContext(), this.mAdUnitId, this.requestId, n);
        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOAD_START, this.mAdUnitId);
        this.startLoadAdTime = System.currentTimeMillis();
        if (this.mLoadListener != null) {
            this.mLoadListener.onAdStartLoad();
        }
    }

    public void loadEndNoConfig() {
        if (this.mLoadListener != null) {
            this.mLoadListener.onAdLoadFailed("12");
        }
        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOAD_FAILED_CONFIG, this.mAdUnitId);
    }

    public void loadEnd(String string, int n) {
        Object object;
        if (this.mLoadListener != null) {
            if ("19".equals(string) || "8".equals(string) || "20".equals(string)) {
                object = AdCacheManager.getInstance().getReadyAd(this.mAdUnitId);
                this.mLoadListener.onAdLoaded((AdCache)object);
                this.mLoadListener.onAdAllLoaded(true, AdMediationManager.isReload(n));
            } else if ("103".equals(string)) {
                this.mLoadListener.onAdAllLoaded(false, AdMediationManager.isReload(n));
                this.mLoadListener.onAdLoadFailed(string);
            } else if (!"1".equals(string)) {
                this.mLoadListener.onAdLoadFailed(string);
            }
        }
        object = GlobalTradPlus.getInstance().getContext();
        object = new LoadRequest(object, PushMessageUtils.PushStatus.EV_LOAD_AD.getValue());
        object.setLuid(this.mAdUnitId);
        object.setRequestId(this.requestId);
        object.setEc(string);
        object.setOp(String.valueOf(n));
        TPPushCenter.getInstance().saveEvent((BaseRequest)object);
        if (TextUtils.equals((CharSequence)"7", (CharSequence)string)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOADADFAILEDNOCONNECTION, "AdUnitID \uff1a" + this.mAdUnitId);
            return;
        }
        if (TextUtils.equals((CharSequence)"19", (CharSequence)string)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOAD_FAILED_HASCACHE, this.mAdUnitId);
            return;
        }
        if (TextUtils.equals((CharSequence)"13", (CharSequence)string)) {
            Log.w((String)"TradPlusLog", (String)"****************");
            CustomLogUtils.getInstance().logWarn(CustomLogUtils.TradPlusLog.NOTFOUNT_ADAPTER, this.mAdUnitId);
            Log.w((String)"TradPlusLog", (String)"****************");
            return;
        }
        if (TextUtils.equals((CharSequence)"4", (CharSequence)string)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOAD_FAILED_FREQUENCYLIMIT, this.mAdUnitId);
            return;
        }
        if (TextUtils.equals((CharSequence)"9", (CharSequence)string)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOAD_FAILED_NOTHING, this.mAdUnitId);
            return;
        }
        if (TextUtils.equals((CharSequence)"103", (CharSequence)string)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.BIDDING_WATERFALL_NOTHING, this.mAdUnitId);
            return;
        }
        if (TextUtils.equals((CharSequence)"15", (CharSequence)string)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOADADFAILEDINTERVAL, this.mAdUnitId);
            return;
        }
        if (TextUtils.equals((CharSequence)"12", (CharSequence)string)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOAD_FAILED_CONFIG, this.mAdUnitId);
        }
    }

    public void startBiddingEvent(ConfigResponse.WaterfallBean waterfallBean) {
        Context context = GlobalTradPlus.getInstance().getContext();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (waterfallBean != null) {
            string3 = waterfallBean.getId();
            string4 = waterfallBean.getName();
            string2 = waterfallBean.getAdsource_placement_id();
            if (waterfallBean.getConfigBean() != null) {
                string = NetworkSourceManager.getNetworkPlacementId((ConfigResponse.WaterfallBean)waterfallBean);
            }
        }
        context = new BiddingStartRequest(context, PushMessageUtils.PushStatus.BIDDING_LOAD_START_AD.getValue());
        context.setAsu(string);
        context.setLuid(this.mAdUnitId);
        context.setBi(string2);
        context.setApid(Util.parseToInteger((String)string2));
        context.setAdsource(string2);
        context.setPID(string);
        context.setRequestId(this.requestId);
        context.setAs(string3);
        TPPushCenter.getInstance().saveEvent((BaseRequest)context);
        context = new SimplifyEvent(PushMessageUtils.PushStatus.BIDDING_LOAD_START_AD.getValue());
        context.setAsu(string);
        context.setLuid(this.mAdUnitId);
        context.setApid(string2);
        context.setAs(string3);
        context.setRequestId(this.requestId);
        TPPushCenter.getInstance().saveEvent((SimplifyEvent)context);
        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.BIDDING_START_ACTION, string4);
        if (this.mLoadListener != null) {
            this.mLoadListener.onBiddingStart(waterfallBean, this.requestId);
        }
    }

    public void endBiddingEvent(ConfigResponse.WaterfallBean waterfallBean, BiddingResponse.PayLoadInfo payLoadInfo, HBManager.TrackInfo trackInfo, String string) {
        StringBuilder stringBuilder;
        boolean bl;
        boolean bl2 = false;
        Context context = GlobalTradPlus.getInstance().getContext();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (waterfallBean != null) {
            string4 = waterfallBean.getId();
            string5 = waterfallBean.getName();
            string3 = waterfallBean.getAdsource_placement_id();
            if (waterfallBean.getConfigBean() != null) {
                string2 = NetworkSourceManager.getNetworkPlacementId((ConfigResponse.WaterfallBean)waterfallBean);
            }
        }
        int n = 0;
        try {
            if (!TextUtils.isEmpty((CharSequence)string)) {
                n = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {}
        if (!(TextUtils.equals((CharSequence)"3", (CharSequence)string) || TextUtils.equals((CharSequence)"2", (CharSequence)string) || TextUtils.equals((CharSequence)"7", (CharSequence)string) || TextUtils.equals((CharSequence)"1", (CharSequence)string) || TextUtils.isEmpty((CharSequence)string))) {
            bl2 = true;
        }
        n = payLoadInfo != null ? payLoadInfo.getNbr() : n;
        int bl22 = payLoadInfo != null ? payLoadInfo.getIsbid() : 0;
        boolean bl3 = bl = n == 0 && bl22 == 1;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (!TextUtils.isEmpty((CharSequence)trackInfo.getStatus()) && !TextUtils.equals((CharSequence)trackInfo.getStatus(), (CharSequence)"1")) {
                string = trackInfo.getStatus();
            } else if (bl2) {
                string = "21";
            }
        } else if (payLoadInfo != null && payLoadInfo.getIsbid() == 1) {
            string = "1";
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.BIDDING_END_ACTION, string5 + "\u3000isBid success");
        } else {
            string = payLoadInfo == null ? "21" : (payLoadInfo.getIsbid() != 0 && !TextUtils.isEmpty((CharSequence)trackInfo.getStatus()) ? trackInfo.getStatus() : "2");
        }
        String string6 = "" + (payLoadInfo == null ? 0.0 : payLoadInfo.getPrice());
        context = new BiddingEndRequest(context, PushMessageUtils.PushStatus.BIDDING_LOAD_AD.getValue());
        context.setBt("" + trackInfo.getEndTime());
        context.setRt("" + trackInfo.getEndTime());
        Object object = GlobalTradPlus.getInstance().getUserLoadParam(this.mAdUnitId).get("key_hp");
        if (object != null && waterfallBean.getBidding_mode() == 1) {
            double string7 = Double.parseDouble((String)object);
            context.setBidfloor(String.valueOf(string7));
        }
        context.setLuid(this.mAdUnitId);
        context.setBi(string3);
        context.setApid(Util.parseToInteger((String)string3));
        context.setAsu(string2);
        context.setAdsource(string3);
        context.setPID(string2);
        context.setRequestId(this.requestId);
        context.setNbr(String.valueOf(n));
        context.setEcpm(string6);
        String string7 = String.valueOf(n);
        if (!"1".equals(string)) {
            stringBuilder = new StringBuilder();
            String string8 = "";
            object = "";
            if ("21".equals(string)) {
                object = "network request error.";
                stringBuilder.append("errCode:");
                stringBuilder.append(string8);
                stringBuilder.append(",errMsg:");
                stringBuilder.append((String)object);
            } else if (payLoadInfo != null && payLoadInfo.getExt() != null) {
                string8 = TextUtils.isEmpty((CharSequence)payLoadInfo.getExt().getError_code()) ? "" : payLoadInfo.getExt().getError_code();
                object = TextUtils.isEmpty((CharSequence)payLoadInfo.getExt().getError_msg()) ? "unknown error" : payLoadInfo.getExt().getError_msg();
                stringBuilder.append("errCode:");
                stringBuilder.append(string8);
                stringBuilder.append(",errMsg:");
                stringBuilder.append((String)object);
            } else if (!TextUtils.isEmpty((CharSequence)trackInfo.getMsg())) {
                object = trackInfo.getMsg();
                stringBuilder.append("errCode:");
                stringBuilder.append(string8);
                stringBuilder.append(",errMsg:");
                stringBuilder.append((String)object);
            } else if (TextUtils.isEmpty((CharSequence)trackInfo.getStatus())) {
                object = trackInfo.getMsg();
                stringBuilder.append("errCode:");
                stringBuilder.append(string8);
                stringBuilder.append(",errMsg:");
                stringBuilder.append("track info status is empty");
            }
            context.setEmsg(stringBuilder.toString());
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.BIDDING_END_ACTION, string5 + " failed, errCode:" + string8 + ",errMsg:" + object);
        }
        context.setAs(string4);
        context.setEc(string);
        TPPushCenter.getInstance().saveEvent((BaseRequest)context);
        stringBuilder = new SimplifyEvent(PushMessageUtils.PushStatus.BIDDING_LOAD_AD.getValue());
        stringBuilder.setLt("" + trackInfo.getEndTime());
        stringBuilder.setLuid(this.mAdUnitId);
        stringBuilder.setApid(string3);
        stringBuilder.setAsu(string2);
        stringBuilder.setAs(string4);
        stringBuilder.setEc(string);
        stringBuilder.setEcpm(string6);
        stringBuilder.setRequestId(this.requestId);
        TPPushCenter.getInstance().saveEvent((SimplifyEvent)stringBuilder);
        if (this.mLoadListener != null) {
            this.mLoadListener.onBiddingEnd(waterfallBean, trackInfo.getEndTime(), bl, string7, this.requestId);
        }
    }

    public void endBiddingServiceEvent(long l, boolean bl) {
        Context context = GlobalTradPlus.getInstance().getContext();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = bl ? "1" : "3";
        context = new BiddingEndRequest(context, PushMessageUtils.PushStatus.BIDDING_LOAD_TPSERVICE_AD.getValue());
        context.setRt("" + RequestUtils.getInstance().countRuntime(l));
        context.setLuid(this.mAdUnitId);
        context.setBi(string2);
        context.setApid(Util.parseToInteger((String)string2));
        context.setAsu(string);
        context.setAdsource(string2);
        context.setPID(string);
        context.setRequestId(this.requestId);
        context.setAs(string3);
        context.setEc(string4);
        TPPushCenter.getInstance().saveEvent((BaseRequest)context);
    }

    public void sendLossNotification(ConfigResponse.WaterfallBean waterfallBean, String string, String string2) {
        Context context = GlobalTradPlus.getInstance().getContext();
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (waterfallBean != null) {
            string5 = waterfallBean.getId();
            string4 = waterfallBean.getAdsource_placement_id();
            if (waterfallBean.getConfigBean() != null) {
                string3 = NetworkSourceManager.getNetworkPlacementId((ConfigResponse.WaterfallBean)waterfallBean);
            }
        }
        waterfallBean = new EventBiddingNotification(context, PushMessageUtils.PushStatus.BIDDING_LOSS_AD.getValue());
        waterfallBean.setLuid(this.mAdUnitId);
        waterfallBean.setLc(string2);
        waterfallBean.setAdsource(string4);
        waterfallBean.setApid(Util.parseToInteger((String)string4));
        waterfallBean.setPID(string3);
        waterfallBean.setEc(string);
        waterfallBean.setAs(string5);
        waterfallBean.setRequestid(this.requestId);
        waterfallBean.setAsu(string3);
        waterfallBean.setEc(string);
        TPPushCenter.getInstance().saveEvent((BaseRequest)waterfallBean);
    }

    public void loadNetWorkStart(TPBaseAdapter tPBaseAdapter) {
        if (this.mLoadListener != null) {
            this.mLoadListener.onLoadBefor(this, tPBaseAdapter);
        }
        Context context = GlobalTradPlus.getInstance().getContext();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        ConfigResponse.WaterfallBean waterfallBean = null;
        if (tPBaseAdapter != null) {
            waterfallBean = tPBaseAdapter.getWaterfallBean();
        }
        if (waterfallBean != null) {
            string = waterfallBean.getId();
            string2 = waterfallBean.getName();
            string4 = waterfallBean.getAdsource_placement_id();
            if (waterfallBean.getConfigBean() != null) {
                string3 = NetworkSourceManager.getNetworkPlacementId((ConfigResponse.WaterfallBean)waterfallBean);
            }
        }
        context = new VideoRequest(context, PushMessageUtils.PushStatus.EV_LOAD_NETWORK_AD_START.getValue());
        context.setLuid(this.mAdUnitId);
        context.setAs(string);
        context.setPID(string3);
        context.setAdsource(string4);
        context.setRequestId(this.requestId);
        context.setAsu(string3);
        context.setApid(Util.parseToInteger((String)string4));
        TPPushCenter.getInstance().saveEvent((BaseRequest)context);
        context = new SimplifyEvent(PushMessageUtils.PushStatus.EV_LOAD_NETWORK_AD_START.getValue());
        context.setLuid(this.mAdUnitId);
        context.setAs(string);
        context.setAsu(string3);
        context.setApid(string4);
        context.setRequestId(this.requestId);
        TPPushCenter.getInstance().saveEvent((SimplifyEvent)context);
        CustomLogUtils.getInstance().log(string2 + " ", CustomLogUtils.TradPlusLog.LOAD_LOADING_ADS);
        if (tPBaseAdapter != null) {
            tPBaseAdapter.setLoadStartTime();
        }
        if (this.mLoadListener != null) {
            this.mLoadListener.oneLayerLoadStart(tPBaseAdapter);
        }
    }

    public void loadBottomNetWorkEnd(AdCache adCache, ConfigResponse.WaterfallBean waterfallBean, TPBaseAdapter tPBaseAdapter, String string, String string2, long l) {
        String string3 = "";
        String string4 = "";
        if (waterfallBean != null) {
            string4 = waterfallBean.getName();
            string3 = waterfallBean.getCustomClassName();
            LogUtil.ownShow((String)("tradpluslog isBottomWaterfall " + waterfallBean.isBottomWaterfall()));
        }
        this.setLoadEndRequest(adCache, waterfallBean, tPBaseAdapter, string, string2, l);
        if ("1".equals(string) && this.mLoadListener != null && adCache != null) {
            if (adCache.getLoadMode() == LoadMode.SPEED) {
                this.mLoadListener.onAdLoaded(adCache);
            }
            if (this.mLoadListener != null) {
                this.mLoadListener.oneLayerLoaded(adCache);
            }
        }
        if (!"1".equals(string) && this.mLoadListener != null) {
            this.mLoadListener.oneLayerLoadFailed(string, tPBaseAdapter, string2);
        }
        this.printEc(string, string4, string3, string2);
    }

    public void loadNetWorkEnd(AdCache adCache, ConfigResponse.WaterfallBean waterfallBean, TPBaseAdapter tPBaseAdapter, String string, String string2) {
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        if (waterfallBean != null) {
            string3 = waterfallBean.getId();
            string5 = waterfallBean.getName();
            string4 = waterfallBean.getCustomClassName();
            string7 = waterfallBean.getAdsource_placement_id();
            if (waterfallBean.getConfigBean() != null) {
                string6 = NetworkSourceManager.getNetworkPlacementId((ConfigResponse.WaterfallBean)waterfallBean);
            }
            LogUtil.ownShow((String)("tradpluslog isBottomWaterfall " + waterfallBean.isBottomWaterfall()));
        }
        this.setLoadEndRequest(adCache, waterfallBean, tPBaseAdapter, string, string2, tPBaseAdapter == null ? 0L : RequestUtils.getInstance().countRuntime(tPBaseAdapter.getLoadStartTime()));
        if ("1".equals(string) && this.mLoadListener != null && adCache != null) {
            this.mLoadListener.onAdLoaded(adCache);
            if (this.mLoadListener != null) {
                this.mLoadListener.oneLayerLoaded(adCache);
            }
            this.loadFirstAdLoaded(string6, string3, string7);
            this.loadOnceAdLoaded(string6, string3, string7);
        }
        if (!"1".equals(string) && this.mLoadListener != null) {
            this.mLoadListener.oneLayerLoadFailed(string, tPBaseAdapter, string2);
        }
        this.printEc(string, string5, string4, string2);
    }

    public void loadNetWorkTimeoutSuccess(ConfigResponse.WaterfallBean waterfallBean, TPBaseAdapter tPBaseAdapter) {
        String string = "";
        String string2 = "";
        String string3 = "";
        if (waterfallBean != null) {
            string = waterfallBean.getAdsource_placement_id();
            string2 = waterfallBean.getId();
            if (waterfallBean.getConfigBean() != null) {
                string3 = NetworkSourceManager.getNetworkPlacementId((ConfigResponse.WaterfallBean)waterfallBean);
            }
        }
        Object object = GlobalTradPlus.getInstance().getContext();
        waterfallBean = new LoadNetworkRequest(object, PushMessageUtils.PushStatus.EV_LOAD_NETWORK_AD_TIMEOUT_SUCCESS.getValue());
        object = "";
        try {
            object = tPBaseAdapter.getNetworkVersion();
        }
        catch (Throwable throwable) {}
        long l = RequestUtils.getInstance().countRuntime(tPBaseAdapter.getLoadStartTime());
        waterfallBean.setAdsource(string);
        waterfallBean.setAs(string2);
        waterfallBean.setAsu(string3);
        waterfallBean.setApid(Util.parseToInteger((String)string));
        waterfallBean.setLt(String.valueOf(l));
        waterfallBean.setAs_ver(tPBaseAdapter == null ? "" : object);
        waterfallBean.setLuid(this.mAdUnitId);
        waterfallBean.setPID(string3);
        waterfallBean.setEc("1");
        waterfallBean.setRequestId(this.requestId);
        waterfallBean.setFill("2");
        TPPushCenter.getInstance().saveEvent((BaseRequest)waterfallBean);
        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOAD_NETWORK_TIME_OUT_SUCCESS, string + " " + this.mAdUnitId);
    }

    private void setLoadEndRequest(AdCache adCache, ConfigResponse.WaterfallBean object, TPBaseAdapter tPBaseAdapter, String string, String string2, long l) {
        VideoRequest videoRequest;
        Context context = GlobalTradPlus.getInstance().getContext();
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (object != null) {
            string3 = object.getId();
            string5 = object.getAdsource_placement_id();
            if (object.getConfigBean() != null) {
                string4 = NetworkSourceManager.getNetworkPlacementId((ConfigResponse.WaterfallBean)object);
            }
            LogUtil.ownShow((String)("tradpluslog isBottomWaterfall " + object.isBottomWaterfall()));
        }
        if (tPBaseAdapter != null) {
            tPBaseAdapter.setLoadEndTime();
        }
        if (tPBaseAdapter == null || tPBaseAdapter.getLoadStartTime() <= 0L) {
            videoRequest = new VideoRequest(context, PushMessageUtils.PushStatus.EV_LOAD_NETWORK_AD_START.getValue());
            videoRequest.setLuid(this.mAdUnitId);
            videoRequest.setAs(string3);
            videoRequest.setPID(string4);
            videoRequest.setAdsource(string5);
            videoRequest.setAsu(string4);
            videoRequest.setApid(Util.parseToInteger((String)string5));
            videoRequest.setRequestId(this.requestId);
            TPPushCenter.getInstance().saveEvent((BaseRequest)videoRequest);
            object = new SimplifyEvent(PushMessageUtils.PushStatus.EV_LOAD_NETWORK_AD_START.getValue());
            object.setLuid(this.mAdUnitId);
            object.setAs(string3);
            object.setAsu(string4);
            object.setApid(string5);
            object.setRequestId(this.requestId);
            TPPushCenter.getInstance().saveEvent((SimplifyEvent)object);
        }
        videoRequest = new LoadNetworkRequest(context, PushMessageUtils.PushStatus.EV_LOAD_NETWORK_AD.getValue());
        if (tPBaseAdapter != null) {
            videoRequest.setCreateTime(tPBaseAdapter.getLoadStartTime());
        }
        videoRequest.setLuid(this.mAdUnitId);
        videoRequest.setAdsource(string5);
        videoRequest.setAs(string3);
        videoRequest.setPID(string4);
        object = "";
        try {
            object = tPBaseAdapter.getNetworkVersion();
        }
        catch (Throwable throwable) {}
        videoRequest.setAs_ver(tPBaseAdapter == null ? "" : object);
        videoRequest.setLt(String.valueOf(l));
        videoRequest.setRequestId(this.requestId);
        videoRequest.setEc(string);
        videoRequest.setFill(adCache != null ? "2" : "1");
        videoRequest.setEmsg(string2);
        videoRequest.setAsu(string4);
        videoRequest.setApid(Util.parseToInteger((String)string5));
        TPPushCenter.getInstance().saveEvent((BaseRequest)videoRequest);
        adCache = new SimplifyEvent(PushMessageUtils.PushStatus.EV_LOAD_NETWORK_AD.getValue());
        adCache.setLuid(this.mAdUnitId);
        adCache.setAs(string3);
        adCache.setLt(videoRequest.getLt());
        adCache.setEc(string);
        adCache.setAsu(string4);
        adCache.setApid(string5);
        adCache.setRequestId(this.requestId);
        TPPushCenter.getInstance().saveEvent((SimplifyEvent)adCache);
    }

    private void printEc(String string, String string2, String string3, String string4) {
        if ("1".equals(string)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOAD_NETWORK_SUCCESS, string2 + " " + this.mAdUnitId);
            return;
        }
        if ("9".equals(string)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOAD_FAILED_NOTHING, this.mAdUnitId);
            return;
        }
        if ("13".equals(string)) {
            Log.w((String)"TradPlusLog", (String)"****************");
            CustomLogUtils.getInstance().logWarn(CustomLogUtils.TradPlusLog.NOTFOUNT_ADAPTER, string3);
            Log.w((String)"TradPlusLog", (String)"****************");
            return;
        }
        if ("18".equals(string)) {
            CustomLogUtils.getInstance().logWarn(CustomLogUtils.TradPlusLog.LOAD_ADAPTER_EXCEPTION, "exception ".concat(String.valueOf(string2)));
            return;
        }
        if ("3".equals(string)) {
            CustomLogUtils.getInstance().log(string3, CustomLogUtils.TradPlusLog.LOAD_TIMEOUT);
            return;
        }
        if ("2".equals(string)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.ADAPTER_INTERNAL_ERROR, string2 + " " + string4);
            return;
        }
        if ("12".equals(string)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOAD_FAILED_CONFIG, this.mAdUnitId);
            return;
        }
        if ("17".equals(string)) {
            CustomLogUtils.getInstance().logWarn(CustomLogUtils.TradPlusLog.ADAPTER_CONFIG_ERROR, string3);
            return;
        }
        LogUtil.ownShow((String)string);
    }

    public void currentLayerHasCache(AdCache adCache) {
        if (this.mLoadListener != null) {
            ConfigResponse.WaterfallBean waterfallBean;
            if (adCache != null && (waterfallBean = adCache.getConfigBean()) != null) {
                String string = waterfallBean.getId();
                String string2 = waterfallBean.getAdsource_placement_id();
                ConfigResponse.WaterfallBean.ConfigBean configBean = waterfallBean.getConfigBean();
                String string3 = "";
                if (configBean != null) {
                    string3 = NetworkSourceManager.getNetworkPlacementId((ConfigResponse.WaterfallBean)waterfallBean);
                }
                this.loadOnceAdLoaded(string3, string, string2);
            }
            this.mLoadListener.onAdLoaded(adCache);
            if (this.mLoadListener != null) {
                this.mLoadListener.oneLayerLoaded(adCache);
            }
        }
    }

    public void currentBottomLayerHasCache(AdCache adCache) {
        if (this.mLoadListener != null && adCache != null) {
            LoadMode loadMode = adCache.getLoadMode();
            if (loadMode != null && loadMode == LoadMode.SPEED) {
                this.mLoadListener.onAdLoaded(adCache);
            }
            if (this.mLoadListener != null) {
                this.mLoadListener.oneLayerLoaded(adCache);
            }
        }
    }

    public void loadFirstAdLoaded(String string, String string2, String string3) {
        if (GlobalTradPlus.getInstance().getAdUnitFirstLoadTrace(this.mAdUnitId)) {
            return;
        }
        Context context = GlobalTradPlus.getInstance().getContext();
        context = new LoadFirstNetworkAd(context, PushMessageUtils.PushStatus.EV_LOAD_FIRST_NETWORK_AD.getValue());
        context.setCreateTime(this.startLoadAdTime);
        long l = RequestUtils.getInstance().countRuntime(context.getCreateTime());
        long l2 = RequestUtils.getInstance().countRuntime(GlobalTradPlus.getInstance().getInitSdkTime());
        context.setLuid(this.mAdUnitId);
        context.setAsu(string);
        context.setLt(String.valueOf(l));
        context.setRt(String.valueOf(l2));
        context.setRequestId(this.requestId);
        context.setApid(Util.parseToInteger((String)string3));
        context.setAs(string2);
        context.setPID(string);
        context.setAdsource(string3);
        TPPushCenter.getInstance().saveEvent((BaseRequest)context);
        context = new SimplifyEvent(PushMessageUtils.PushStatus.EV_LOAD_FIRST_NETWORK_AD.getValue());
        context.setLuid(this.mAdUnitId);
        context.setAsu(string);
        context.setLt(String.valueOf(l));
        context.setRt(String.valueOf(l2));
        context.setApid(string3);
        context.setAs(string2);
        context.setRequestId(this.requestId);
        TPPushCenter.getInstance().saveEvent((SimplifyEvent)context);
        GlobalTradPlus.getInstance().setAdUnitFirstLoadTrace(this.mAdUnitId);
    }

    public void loadOnceAdLoaded(String string, String string2, String string3) {
        if (GlobalTradPlus.getInstance().getAdUnitFirstLoadTrace(this.requestId)) {
            return;
        }
        Context context = GlobalTradPlus.getInstance().getContext();
        context = new LoadFirstNetworkAd(context, PushMessageUtils.PushStatus.EV_ONCE_LOAD_NETWORK_AD.getValue());
        context.setCreateTime(this.startLoadAdTime);
        long l = RequestUtils.getInstance().countRuntime(context.getCreateTime());
        context.setLuid(this.mAdUnitId);
        context.setAsu(string);
        context.setLt(String.valueOf(l));
        context.setRequestId(this.requestId);
        context.setApid(Util.parseToInteger((String)string3));
        context.setAs(string2);
        context.setPID(string);
        context.setAdsource(string3);
        TPPushCenter.getInstance().saveEvent((BaseRequest)context);
        context = new SimplifyEvent(PushMessageUtils.PushStatus.EV_ONCE_LOAD_NETWORK_AD.getValue());
        context.setLuid(this.mAdUnitId);
        context.setAsu(string);
        context.setLt(String.valueOf(l));
        context.setApid(string3);
        context.setAs(string2);
        context.setRequestId(this.requestId);
        TPPushCenter.getInstance().saveEvent((SimplifyEvent)context);
        GlobalTradPlus.getInstance().setAdUnitFirstLoadTrace(this.requestId);
    }

    public void loadAdLoaded(AdCache adCache) {
        if (this.mLoadListener != null) {
            this.mLoadListener.onAdLoaded(adCache);
        }
    }

    public void loadAllNetwork(String string, boolean bl, int n, int n2) {
        Context context = GlobalTradPlus.getInstance().getContext();
        this.isLoadAllNetwork = true;
        context = new AdconfRequest(context, PushMessageUtils.PushStatus.EV_ALLLOAD_NETWORK_AD_END.getValue());
        context.setLuid(this.mAdUnitId);
        context.setEc(string);
        context.setOp(String.valueOf(n));
        context.setRequestId(this.requestId);
        context.setCf(bl ? "1" : "0");
        context.setLoaded_count(String.valueOf(n2));
        if (this.allLoadUUID != null) {
            context.setSuuid(this.allLoadUUID);
        } else {
            this.allLoadUUID = context.getSuuid();
        }
        TPPushCenter.getInstance().saveEvent((BaseRequest)context);
        SimplifyEvent simplifyEvent = new SimplifyEvent(PushMessageUtils.PushStatus.EV_ALLLOAD_NETWORK_AD_END.getValue());
        simplifyEvent.setLuid(this.mAdUnitId);
        simplifyEvent.setEc(string);
        TPPushCenter.getInstance().saveEvent(simplifyEvent);
        GlobalTradPlus.getInstance().removeAdUnitFirstLoadTrace(this.requestId);
        if (this.mLoadListener != null && ("11".equals(string) || "103".equals(string) || "105".equals(string))) {
            this.mLoadListener.onAdLoadFailed(string);
        }
        if (this.mLoadListener != null) {
            this.mLoadListener.onAdAllLoaded("1".equals(string), bl);
        }
    }

    public void reloadEvent(String string) {
        Context context = GlobalTradPlus.getInstance().getContext();
        context = new AdconfRequest(context, PushMessageUtils.PushStatus.EV_RELOAD.getValue());
        context.setLuid(this.mAdUnitId);
        context.setEc(string);
        context.setCf("1");
        if (this.allLoadUUID != null) {
            context.setSuuid(this.allLoadUUID);
        } else {
            this.allLoadUUID = context.getSuuid();
        }
        TPPushCenter.getInstance().saveEvent((BaseRequest)context);
    }

    public void sendWinNotification(ConfigResponse.WaterfallBean waterfallBean, String string) {
        Context context = GlobalTradPlus.getInstance().getContext();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (waterfallBean != null) {
            string4 = waterfallBean.getId();
            string3 = waterfallBean.getAdsource_placement_id();
            if (waterfallBean.getConfigBean() != null) {
                string2 = NetworkSourceManager.getNetworkPlacementId((ConfigResponse.WaterfallBean)waterfallBean);
            }
        }
        waterfallBean = new EventBiddingNotification(context, PushMessageUtils.PushStatus.BIDDING_WIN_AD.getValue());
        waterfallBean.setLuid(this.mAdUnitId);
        waterfallBean.setAdsource(string3);
        waterfallBean.setApid(Integer.parseInt(string3));
        waterfallBean.setPID(string2);
        waterfallBean.setRequestid(this.requestId);
        waterfallBean.setEc(string);
        waterfallBean.setLc("0");
        waterfallBean.setAs(string4);
        waterfallBean.setAsu(string2);
        waterfallBean.setEc(string);
        TPPushCenter.getInstance().saveEvent((BaseRequest)waterfallBean);
    }

    public void entryScenario(String string, AdCache adCache, long l) {
        Context context = GlobalTradPlus.getInstance().getContext();
        TPBaseAdapter tPBaseAdapter = adCache == null ? null : adCache.getAdapter();
        tPBaseAdapter = tPBaseAdapter == null ? null : tPBaseAdapter.getWaterfallBean();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (tPBaseAdapter != null) {
            string2 = tPBaseAdapter.getId();
            string4 = tPBaseAdapter.getAdsource_placement_id();
            if (tPBaseAdapter.getConfigBean() != null) {
                string3 = NetworkSourceManager.getNetworkPlacementId((ConfigResponse.WaterfallBean)tPBaseAdapter);
            }
        }
        context = new ReadyRequest(context, PushMessageUtils.PushStatus.EV_CONFIRM_USER_IS_VIEW_AD.getValue());
        context.setLuid(this.mAdUnitId);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            context.setScid(string);
        }
        if (!TextUtils.isEmpty((CharSequence)string) && !GlobalTradPlus.getInstance().getAdUnitFirstLoadTrace(string + "entryScenario")) {
            GlobalTradPlus.getInstance().setAdUnitFirstLoadTrace(string + "entryScenario");
            context.setLt("" + (System.currentTimeMillis() - GlobalTradPlus.getInstance().getInitSdkTime()));
        }
        context.setIar(adCache == null ? "1" : "2");
        context.setAdsource(string4);
        context.setAs(string2);
        context.setPID(string3);
        context.setAsu(string3);
        context.setApid(Util.parseToInteger((String)string4));
        TPPushCenter.getInstance().saveEvent((BaseRequest)context);
        context = new SimplifyEvent(PushMessageUtils.PushStatus.EV_CONFIRM_USER_IS_VIEW_AD.getValue());
        context.setLuid(this.mAdUnitId);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            context.setScid(string);
        }
        if (!TextUtils.isEmpty((CharSequence)string) && !GlobalTradPlus.getInstance().getAdUnitFirstLoadTrace(string + "entryScenario")) {
            GlobalTradPlus.getInstance().setAdUnitFirstLoadTrace(string + "entryScenario");
            context.setLt("" + (System.currentTimeMillis() - l));
        }
        context.setIar(adCache == null ? "1" : "2");
        context.setAs(string2);
        context.setAsu(string3);
        context.setApid(string4);
        TPPushCenter.getInstance().saveEvent((SimplifyEvent)context);
        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.CONFIRM_UH_VIEW_AD, this.mAdUnitId + " " + string + " " + (adCache != null));
    }

    public void isReady(AdCache adCache) {
        Context context = GlobalTradPlus.getInstance().getContext();
        TPBaseAdapter tPBaseAdapter = adCache == null ? null : adCache.getAdapter();
        tPBaseAdapter = tPBaseAdapter == null ? null : tPBaseAdapter.getWaterfallBean();
        String string = "";
        String string2 = "";
        String string3 = "";
        if (tPBaseAdapter != null) {
            string = tPBaseAdapter.getId();
            string3 = tPBaseAdapter.getAdsource_placement_id();
            if (tPBaseAdapter.getConfigBean() != null) {
                string2 = NetworkSourceManager.getNetworkPlacementId((ConfigResponse.WaterfallBean)tPBaseAdapter);
            }
        }
        context = new ReadyRequest(context, PushMessageUtils.PushStatus.EV_IS_READY.getValue());
        context.setLuid(this.mAdUnitId);
        context.setIar(adCache == null ? "1" : "2");
        context.setAs(string);
        context.setPID(string2);
        context.setAdsource(string3);
        context.setRequestId(this.requestId);
        context.setAsu(string2);
        context.setApid(Util.parseToInteger((String)string3));
        TPPushCenter.getInstance().saveEvent((BaseRequest)context);
        context = new SimplifyEvent(PushMessageUtils.PushStatus.EV_IS_READY.getValue());
        context.setLuid(this.mAdUnitId);
        context.setIar(adCache == null ? "1" : "2");
        context.setAs(string);
        context.setAsu(string2);
        context.setApid(string3);
        context.setRequestId(this.requestId);
        TPPushCenter.getInstance().saveEvent((SimplifyEvent)context);
    }

    public void showAdStart(AdCache adCache, String string) {
        Context context = GlobalTradPlus.getInstance().getContext();
        adCache = adCache == null ? null : adCache.getAdapter();
        adCache = adCache == null ? null : adCache.getWaterfallBean();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (adCache != null) {
            string2 = adCache.getId();
            string4 = adCache.getAdsource_placement_id();
            if (adCache.getConfigBean() != null) {
                string3 = NetworkSourceManager.getNetworkPlacementId((ConfigResponse.WaterfallBean)adCache);
            }
        }
        adCache = new ShowStartRequest(context, PushMessageUtils.PushStatus.EV_SHOW_AD_START.getValue());
        adCache.setAs(string2);
        adCache.setLuid(this.mAdUnitId);
        adCache.setAdsource(string4);
        adCache.setPID(string3);
        adCache.setAsu(string3);
        adCache.setApid(Util.parseToInteger((String)string4));
        adCache.setRequestId(this.requestId);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            adCache.setScid(string);
        }
        TPPushCenter.getInstance().saveEvent((BaseRequest)adCache);
        adCache = new SimplifyEvent(PushMessageUtils.PushStatus.EV_SHOW_AD_START.getValue());
        adCache.setAs(string2);
        adCache.setLuid(this.mAdUnitId);
        adCache.setAsu(string3);
        adCache.setApid(string4);
        adCache.setRequestId(this.requestId);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            adCache.setScid(string);
        }
        TPPushCenter.getInstance().saveEvent((SimplifyEvent)adCache);
    }

    public void showAdEnd(AdCache adCache, String string, String string2) {
        this.showAdEnd(adCache, string, string2, "");
    }

    public void showAdEnd(AdCache adCache, String string, String string2, String string3) {
        Context context = GlobalTradPlus.getInstance().getContext();
        adCache = adCache == null ? null : adCache.getAdapter();
        ConfigResponse.WaterfallBean waterfallBean = adCache == null ? null : adCache.getWaterfallBean();
        String string4 = "";
        String string5 = "";
        String string6 = "";
        if (waterfallBean != null) {
            string4 = waterfallBean.getId();
            string6 = waterfallBean.getAdsource_placement_id();
            if (waterfallBean.getConfigBean() != null) {
                string5 = NetworkSourceManager.getNetworkPlacementId((ConfigResponse.WaterfallBean)waterfallBean);
            }
        }
        double d = this.getEcpmByTPBaseAdapter((TPBaseAdapter)adCache);
        double d2 = this.getEcpmCnyByTPBaseAdapter((TPBaseAdapter)adCache);
        context = new ShowRequest(context, PushMessageUtils.PushStatus.EV_SHOW_AD.getValue());
        context.setAs(string4);
        context.setPID(string5);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            context.setScid(string);
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            context.setEmsg(string3);
        }
        context.setEc(string2);
        context.setLuid(this.mAdUnitId);
        context.setAdsource(string6);
        context.setRequestId(this.requestId);
        context.setAsu(string5);
        context.setEcpm(String.valueOf(d));
        context.setEcpmCny(String.valueOf(d2));
        context.setApid(Util.parseToInteger((String)string6));
        TPPushCenter.getInstance().saveEvent((BaseRequest)context);
        context = new SimplifyEvent(PushMessageUtils.PushStatus.EV_SHOW_AD.getValue());
        context.setAs(string4);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            context.setScid(string);
        }
        context.setEc(string2);
        context.setLuid(this.mAdUnitId);
        context.setAsu(string5);
        context.setEcpm(String.valueOf(d));
        context.setEcpm_cny(String.valueOf(d2));
        context.setApid(string6);
        context.setRequestId(this.requestId);
        TPPushCenter.getInstance().saveEvent((SimplifyEvent)context);
        this.isSaveClickEvent = false;
        this.isSaveAgainClickEvent = false;
        if ("1".equals(string2)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            if (this.mLoadListener != null) {
                this.mLoadListener.onAdVideoError(string2, (TPBaseAdapter)adCache, new TPAdError(string2).getErrorMsg());
            }
            return;
        }
        if (this.mLoadListener != null) {
            this.mLoadListener.onAdVideoError(string2, (TPBaseAdapter)adCache, string3);
        }
    }

    public void adShown(TPBaseAdapter tPBaseAdapter, String string) {
        if (this.mLoadListener != null) {
            this.mLoadListener.onAdShow(tPBaseAdapter);
        }
        Context context = GlobalTradPlus.getInstance().getContext();
        tPBaseAdapter = tPBaseAdapter == null ? null : tPBaseAdapter.getWaterfallBean();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (tPBaseAdapter != null) {
            string2 = tPBaseAdapter.getId();
            string4 = tPBaseAdapter.getAdsource_placement_id();
            if (tPBaseAdapter.getConfigBean() != null) {
                string3 = NetworkSourceManager.getNetworkPlacementId((ConfigResponse.WaterfallBean)tPBaseAdapter);
            }
        }
        tPBaseAdapter = new ShowStartRequest(context, PushMessageUtils.PushStatus.EV_SHOW_AD_START.getValue());
        tPBaseAdapter.setAs(string2);
        tPBaseAdapter.setLuid(this.mAdUnitId);
        tPBaseAdapter.setAdsource(string4);
        tPBaseAdapter.setPID(string3);
        tPBaseAdapter.setRequestId(this.requestId);
        tPBaseAdapter.setAsu(string3);
        tPBaseAdapter.setApid(Util.parseToInteger((String)string4));
        if (!TextUtils.isEmpty((CharSequence)string)) {
            tPBaseAdapter.setScid(string);
        }
        TPPushCenter.getInstance().saveEvent((BaseRequest)tPBaseAdapter);
        tPBaseAdapter = new ShowRequest(context, PushMessageUtils.PushStatus.EV_SHOW_AD.getValue());
        tPBaseAdapter.setAs(string2);
        tPBaseAdapter.setPID(string3);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            tPBaseAdapter.setScid(string);
        }
        tPBaseAdapter.setEc("1");
        tPBaseAdapter.setLuid(this.mAdUnitId);
        tPBaseAdapter.setAdsource(string4);
        tPBaseAdapter.setRequestId(this.requestId);
        tPBaseAdapter.setAsu(string3);
        tPBaseAdapter.setApid(Util.parseToInteger((String)string4));
        TPPushCenter.getInstance().saveEvent((BaseRequest)tPBaseAdapter);
    }

    void adClicked(TPBaseAdapter tPBaseAdapter, String string, boolean bl) {
        if (this.mLoadListener != null) {
            if (tPBaseAdapter != null) {
                tPBaseAdapter.setShowSceneId(string);
            }
            if (bl) {
                this.mLoadListener.onAdAgainVideoClicked(tPBaseAdapter);
            } else {
                this.mLoadListener.onAdClicked(tPBaseAdapter);
            }
        }
        if (bl ? this.isSaveAgainClickEvent : this.isSaveClickEvent) {
            return;
        }
        tPBaseAdapter = tPBaseAdapter == null ? null : tPBaseAdapter.getWaterfallBean();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (tPBaseAdapter != null) {
            string2 = tPBaseAdapter.getId();
            string3 = tPBaseAdapter.getName();
            string5 = tPBaseAdapter.getAdsource_placement_id();
            if (tPBaseAdapter.getConfigBean() != null) {
                string4 = NetworkSourceManager.getNetworkPlacementId((ConfigResponse.WaterfallBean)tPBaseAdapter);
            }
        }
        tPBaseAdapter = GlobalTradPlus.getInstance().getContext();
        tPBaseAdapter = new ClickRequest((Context)tPBaseAdapter, PushMessageUtils.PushStatus.EV_CLICK_AD.getValue());
        tPBaseAdapter.setAs(string2);
        tPBaseAdapter.setPID(string4);
        tPBaseAdapter.setLuid(this.mAdUnitId);
        tPBaseAdapter.setAdsource(string5);
        tPBaseAdapter.setRequestId(this.requestId);
        tPBaseAdapter.setAsu(string4);
        tPBaseAdapter.setApid(Util.parseToInteger((String)string5));
        if (!TextUtils.isEmpty((CharSequence)string)) {
            tPBaseAdapter.setScid(string);
        }
        TPPushCenter.getInstance().saveEvent((BaseRequest)tPBaseAdapter);
        tPBaseAdapter = new SimplifyEvent(PushMessageUtils.PushStatus.EV_CLICK_AD.getValue());
        tPBaseAdapter.setAs(string2);
        tPBaseAdapter.setLuid(this.mAdUnitId);
        tPBaseAdapter.setAsu(string4);
        tPBaseAdapter.setApid(string5);
        tPBaseAdapter.setRequestId(this.requestId);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            tPBaseAdapter.setScid(string);
        }
        TPPushCenter.getInstance().saveEvent((SimplifyEvent)tPBaseAdapter);
        if (bl) {
            this.isSaveAgainClickEvent = true;
        } else {
            this.isSaveClickEvent = true;
        }
        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.CLICK_NETWORK, string3 + "  " + this.mAdUnitId);
    }

    void adImpression(TPBaseAdapter tPBaseAdapter, String string, boolean bl) {
        ConfigResponse.WaterfallBean waterfallBean = tPBaseAdapter == null ? null : tPBaseAdapter.getWaterfallBean();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (waterfallBean != null) {
            string2 = waterfallBean.getId();
            string4 = waterfallBean.getAdsource_placement_id();
            if (waterfallBean.getConfigBean() != null) {
                string3 = NetworkSourceManager.getNetworkPlacementId((ConfigResponse.WaterfallBean)waterfallBean);
            }
        }
        double d = this.getEcpmByTPBaseAdapter(tPBaseAdapter);
        double d2 = this.getEcpmCnyByTPBaseAdapter(tPBaseAdapter);
        Context context = GlobalTradPlus.getInstance().getContext();
        context = new VideoRequest(context, PushMessageUtils.PushStatus.EV_AD_VIDEO_START.getValue());
        context.setLuid(this.mAdUnitId);
        context.setAs(string2);
        context.setEc("1");
        context.setEcpm(String.valueOf(d));
        context.setEcpm_cny(String.valueOf(d2));
        context.setPID(string3);
        context.setEcpm_precision(waterfallBean.getEcpmPrecision());
        context.setAdsource(string4);
        context.setRequestId(this.requestId);
        context.setAsu(string3);
        context.setApid(Util.parseToInteger((String)string4));
        Map map = tPBaseAdapter.getNetworkhashMap();
        if (map != null && map.containsKey("network_requestId") && (map = map.get("network_requestId")) instanceof String) {
            context.setAdRequestId((String)((Object)map));
        }
        map = tPBaseAdapter.getCustomShowData();
        String string5 = "";
        if (map != null) {
            string5 = JSON.toJSONString((Object)map);
            context.setCustom_show_data(string5);
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            context.setScid(string);
        }
        TPPushCenter.getInstance().saveEvent((BaseRequest)context);
        context = new SimplifyEvent(PushMessageUtils.PushStatus.EV_AD_VIDEO_START.getValue());
        context.setLuid(this.mAdUnitId);
        context.setAs(string2);
        context.setEcpm_precision(waterfallBean.getEcpmPrecision());
        context.setEc("1");
        context.setEcpm(String.valueOf(d));
        context.setEcpm_cny(String.valueOf(d2));
        context.setAsu(string3);
        context.setApid(string4);
        context.setRequestId(this.requestId);
        if (!TextUtils.isEmpty((CharSequence)string5)) {
            context.setCustom_show_data(string5);
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            context.setScid(string);
        }
        TPPushCenter.getInstance().saveEvent((SimplifyEvent)context);
        if (tPBaseAdapter != null) {
            tPBaseAdapter.setShowStartTime();
            tPBaseAdapter.setShowSceneId(string);
            if (!TextUtils.isEmpty((CharSequence)tPBaseAdapter.getPayLoadStr()) || waterfallBean.getC2sAdapter() != null) {
                HbTokenManager.sendWinOrDisplayNotification(false, tPBaseAdapter, this);
            }
        }
        if (this.mLoadListener != null) {
            if (bl) {
                this.mLoadListener.onAdAgainShow(tPBaseAdapter);
                return;
            }
            this.mLoadListener.onAdShow(tPBaseAdapter);
        }
    }

    void adImpressionEcpm(TPBaseAdapter tPBaseAdapter, String string, boolean bl, Map<String, Object> map) {
        tPBaseAdapter = tPBaseAdapter == null ? null : tPBaseAdapter.getWaterfallBean();
        Object object = "";
        String string2 = "";
        String string3 = "";
        if (tPBaseAdapter != null) {
            object = tPBaseAdapter.getId();
            string3 = tPBaseAdapter.getAdsource_placement_id();
            if (tPBaseAdapter.getConfigBean() != null) {
                string2 = NetworkSourceManager.getNetworkPlacementId((ConfigResponse.WaterfallBean)tPBaseAdapter);
            }
        }
        tPBaseAdapter = GlobalTradPlus.getInstance().getContext();
        tPBaseAdapter = new VideoRequest((Context)tPBaseAdapter, PushMessageUtils.PushStatus.EV_AD_IMP_ECPM.getValue());
        tPBaseAdapter.setLuid(this.mAdUnitId);
        tPBaseAdapter.setAs((String)object);
        tPBaseAdapter.setEc("1");
        tPBaseAdapter.setPID(string2);
        tPBaseAdapter.setAdsource(string3);
        tPBaseAdapter.setRequestId(this.requestId);
        tPBaseAdapter.setAsu(string2);
        tPBaseAdapter.setApid(Util.parseToInteger((String)string3));
        try {
            if (map != null) {
                object = map.get("paid_valueMicros");
                if (object != null) {
                    object = new Double((Double)object);
                    tPBaseAdapter.setImp_ecpm(String.valueOf(object));
                }
                if ((object = map.get("paid_currencycode")) != null) {
                    tPBaseAdapter.setImp_currency(String.valueOf(object));
                }
                if ((object = map.get("paid_precision")) != null) {
                    tPBaseAdapter.setImp_precision(String.valueOf(object));
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            tPBaseAdapter.setScid(string);
        }
        TPPushCenter.getInstance().saveEvent((BaseRequest)tPBaseAdapter);
    }

    private double getEcpmByTPBaseAdapter(TPBaseAdapter tPBaseAdapter) {
        if (tPBaseAdapter == null) {
            return 0.0;
        }
        Object object = tPBaseAdapter.getWaterfallBean();
        if (object == null) {
            return 0.0;
        }
        double d = object.getEcpm();
        if (!TextUtils.isEmpty((CharSequence)(object = object.getEcpmPrecision())) && ((String)object).equals("exact") && !TextUtils.isEmpty((CharSequence)tPBaseAdapter.getPayLoadStr())) {
            try {
                d = Double.valueOf(String.valueOf(((BiddingResponse.PayLoadInfo)JSON.parseObject((String)tPBaseAdapter.getPayLoadStr(), BiddingResponse.PayLoadInfo.class)).getPrice()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return d;
    }

    private double getEcpmCnyByTPBaseAdapter(TPBaseAdapter tPBaseAdapter) {
        if (tPBaseAdapter == null) {
            return 0.0;
        }
        Object object = tPBaseAdapter.getWaterfallBean();
        if (object == null) {
            return 0.0;
        }
        double d = object.getEcpm_cny();
        if (!TextUtils.isEmpty((CharSequence)(object = object.getEcpmPrecision())) && ((String)object).equals("exact") && !TextUtils.isEmpty((CharSequence)tPBaseAdapter.getPayLoadStr())) {
            try {
                d = Double.valueOf(String.valueOf(((BiddingResponse.PayLoadInfo)JSON.parseObject((String)tPBaseAdapter.getPayLoadStr(), BiddingResponse.PayLoadInfo.class)).getPrice_cny()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return d;
    }

    public void sendDisPlayNotification(ConfigResponse.WaterfallBean waterfallBean, String string) {
        Context context = GlobalTradPlus.getInstance().getContext();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (waterfallBean != null) {
            string4 = waterfallBean.getId();
            string3 = waterfallBean.getAdsource_placement_id();
            if (waterfallBean.getConfigBean() != null) {
                string2 = NetworkSourceManager.getNetworkPlacementId((ConfigResponse.WaterfallBean)waterfallBean);
            }
        }
        context = new EventBiddingNotification(context, PushMessageUtils.PushStatus.BIDDING_IMP_AD.getValue());
        context.setLuid(this.mAdUnitId);
        context.setAdsource(string3);
        context.setApid(Integer.parseInt(string3));
        context.setPID(string2);
        context.setEc(string);
        context.setAs(string4);
        context.setAsu(string2);
        context.setRequestid(this.requestId);
        TPPushCenter.getInstance().saveEvent((BaseRequest)context);
        waterfallBean.setPayLoadInfo(null);
    }

    public void videoShowError(TPBaseAdapter tPBaseAdapter, String string, String string2) {
        tPBaseAdapter = tPBaseAdapter == null ? null : tPBaseAdapter.getWaterfallBean();
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        if (tPBaseAdapter != null) {
            string3 = tPBaseAdapter.getId();
            string4 = tPBaseAdapter.getName();
            string6 = tPBaseAdapter.getAdsource_placement_id();
            if (tPBaseAdapter.getConfigBean() != null) {
                string5 = NetworkSourceManager.getNetworkPlacementId((ConfigResponse.WaterfallBean)tPBaseAdapter);
            }
            string7 = String.valueOf(tPBaseAdapter.getEcpm());
        }
        tPBaseAdapter = GlobalTradPlus.getInstance().getContext();
        tPBaseAdapter = new VideoRequest((Context)tPBaseAdapter, PushMessageUtils.PushStatus.EV_AD_VIDEO_SHOW_ERROR.getValue());
        tPBaseAdapter.setLuid(this.mAdUnitId);
        tPBaseAdapter.setAs(string3);
        tPBaseAdapter.setEc("14");
        tPBaseAdapter.setEcpm(string7);
        tPBaseAdapter.setPID(string5);
        tPBaseAdapter.setAdsource(string6);
        tPBaseAdapter.setRequestId(this.requestId);
        tPBaseAdapter.setAsu(string5);
        tPBaseAdapter.setApid(Util.parseToInteger((String)string6));
        if (!TextUtils.isEmpty((CharSequence)string)) {
            tPBaseAdapter.setScid(string);
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            tPBaseAdapter.setEmsg(string2);
        }
        TPPushCenter.getInstance().saveEvent((BaseRequest)tPBaseAdapter);
        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.SHOW_ERROR, string4 + " " + this.mAdUnitId);
    }

    public void onAdVideoStart(TPBaseAdapter tPBaseAdapter, String string, boolean bl) {
        if (this.mLoadListener != null) {
            if (tPBaseAdapter != null) {
                tPBaseAdapter.setShowSceneId(string);
            }
            if (bl) {
                this.mLoadListener.onAdAgainVideoStart(tPBaseAdapter);
                return;
            }
            this.mLoadListener.onAdVideoStart(tPBaseAdapter);
        }
    }

    public void onAdVideoEnd(TPBaseAdapter tPBaseAdapter, String string, boolean bl) {
        if (this.mLoadListener != null) {
            if (tPBaseAdapter != null) {
                tPBaseAdapter.setShowSceneId(string);
            }
            if (bl) {
                this.mLoadListener.onAdAgainVideoEnd(tPBaseAdapter);
                return;
            }
            this.mLoadListener.onAdVideoEnd(tPBaseAdapter);
        }
    }

    public void videoEnd(TPBaseAdapter tPBaseAdapter, String string) {
        if (this.mLoadListener != null) {
            if (tPBaseAdapter != null) {
                tPBaseAdapter.setShowSceneId(string);
            }
            this.mLoadListener.onAdClosed(tPBaseAdapter);
        }
        Context context = null;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        long l = 0L;
        if (tPBaseAdapter != null) {
            tPBaseAdapter.setShowEndTime();
            l = tPBaseAdapter.getShowStartTime();
            context = tPBaseAdapter.getWaterfallBean();
        }
        if (context != null) {
            context.setPayLoadInfo(null);
            string2 = context.getId();
            string3 = context.getName();
            string5 = context.getAdsource_placement_id();
            if (context.getConfigBean() != null) {
                string4 = NetworkSourceManager.getNetworkPlacementId((ConfigResponse.WaterfallBean)context);
            }
            String.valueOf(context.getEcpm());
        }
        context = GlobalTradPlus.getInstance().getContext();
        context = new VideoCloseRequest(context, PushMessageUtils.PushStatus.EV_AD_VIDEO_CLOSE.getValue());
        context.setLuid(this.mAdUnitId);
        context.setScid(string);
        if (l == 0L) {
            this.videoShowError(tPBaseAdapter, string, "14");
        }
        context.setCreateTime(l);
        context.setIc("2");
        long l2 = RequestUtils.getInstance().countRuntime(context.getCreateTime());
        context.setTt(String.valueOf(l2));
        context.setPt(String.valueOf(l2));
        context.setPr("1.0");
        context.setRequestId(this.requestId);
        context.setAs(string2);
        context.setPID(string4);
        context.setAdsource(string5);
        context.setAsu(string4);
        context.setApid(Util.parseToInteger((String)string5));
        TPPushCenter.getInstance().saveEvent((BaseRequest)context);
        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.CLOSED_NETWORK, string3 + " " + this.mAdUnitId);
    }

    void reward(TPBaseAdapter tPBaseAdapter, String string, Map<String, Object> map) {
        this.reward(tPBaseAdapter, string, null, -1, map, false);
    }

    void reward(TPBaseAdapter tPBaseAdapter, String string, Map<String, Object> map, boolean bl) {
        this.reward(tPBaseAdapter, string, null, -1, map, bl);
    }

    void reward(TPBaseAdapter tPBaseAdapter, String string) {
        this.reward(tPBaseAdapter, string, null, -1, null, false);
    }

    void reward(TPBaseAdapter tPBaseAdapter, String string, boolean bl) {
        this.reward(tPBaseAdapter, string, null, -1, null, bl);
    }

    void reward(TPBaseAdapter tPBaseAdapter, String string, String string2, int n, Map<String, Object> context, boolean bl) {
        if (this.mLoadListener != null) {
            if (tPBaseAdapter != null) {
                tPBaseAdapter.setShowSceneId(string);
            }
            if (context == null) {
                if (string2 == null) {
                    if (bl) {
                        this.mLoadListener.onPlayAgainReward(tPBaseAdapter);
                    } else {
                        this.mLoadListener.onReward(tPBaseAdapter);
                    }
                } else if (bl) {
                    this.mLoadListener.onPlayAgainReward(tPBaseAdapter, string2, n);
                } else {
                    this.mLoadListener.onReward(tPBaseAdapter, string2, n);
                }
            } else if (bl) {
                this.mLoadListener.onPlayAgainReward(tPBaseAdapter, (Map<String, Object>)context);
            } else {
                this.mLoadListener.onReward(tPBaseAdapter, (Map<String, Object>)context);
            }
        }
        tPBaseAdapter = tPBaseAdapter == null ? null : tPBaseAdapter.getWaterfallBean();
        string = "";
        string2 = "";
        String string3 = "";
        if (tPBaseAdapter != null) {
            string = tPBaseAdapter.getId();
            string3 = tPBaseAdapter.getAdsource_placement_id();
            if (tPBaseAdapter.getConfigBean() != null) {
                string2 = NetworkSourceManager.getNetworkPlacementId((ConfigResponse.WaterfallBean)tPBaseAdapter);
            }
            String.valueOf(tPBaseAdapter.getEcpm());
        }
        context = GlobalTradPlus.getInstance().getContext();
        tPBaseAdapter = new RewardRequest(context, PushMessageUtils.PushStatus.EV_ADVIDEO_REWARD.getValue());
        tPBaseAdapter.setLuid(this.mAdUnitId);
        tPBaseAdapter.setEc("1");
        tPBaseAdapter.setRequestId(this.requestId);
        tPBaseAdapter.setAs(string);
        tPBaseAdapter.setPID(string2);
        tPBaseAdapter.setAdsource(string3);
        tPBaseAdapter.setAsu(string2);
        tPBaseAdapter.setApid(Util.parseToInteger((String)string3));
        TPPushCenter.getInstance().saveEvent((BaseRequest)tPBaseAdapter);
    }

    void videoError(TPBaseAdapter tPBaseAdapter, String string, String string2, String string3) {
        this.videoShowError(tPBaseAdapter, string, string3);
        if (this.mLoadListener != null) {
            this.mLoadListener.onAdVideoError(string2, tPBaseAdapter, string3);
        }
    }

    void zoomOutStart(TPBaseAdapter tPBaseAdapter) {
        if (this.mLoadListener != null) {
            this.mLoadListener.onZoomOutStart(tPBaseAdapter);
        }
    }

    void zoomOutEnd(TPBaseAdapter tPBaseAdapter) {
        if (this.mLoadListener != null) {
            this.mLoadListener.onZoomOutEnd(tPBaseAdapter);
        }
    }

    public void onShowSkip(TPBaseAdapter tPBaseAdapter) {
        if (this.mLoadListener != null) {
            this.mLoadListener.onShowSkip(tPBaseAdapter);
        }
    }

    public void onClickSkip(TPBaseAdapter tPBaseAdapter) {
        if (this.mLoadListener != null) {
            this.mLoadListener.onClickSkip(tPBaseAdapter);
        }
    }

    public void onCountDown(TPBaseAdapter tPBaseAdapter, int n) {
        if (this.mLoadListener != null) {
            this.mLoadListener.onCountDown(tPBaseAdapter, n);
        }
    }

    public void rewardSkip(TPBaseAdapter tPBaseAdapter) {
    }

    public void onDownloadStart(TPBaseAdapter tPBaseAdapter, long l, long l2, String string, String string2) {
        if (this.mLoadListener != null) {
            this.mLoadListener.onDownloadStart(tPBaseAdapter, l, l2, string, string2);
        }
    }

    public void onDownloadUpdate(TPBaseAdapter tPBaseAdapter, long l, long l2, String string, String string2, int n) {
        if (this.mLoadListener != null) {
            this.mLoadListener.onDownloadUpdate(tPBaseAdapter, l, l2, string, string2, n);
        }
    }

    public void onDownloadPause(TPBaseAdapter tPBaseAdapter, long l, long l2, String string, String string2) {
        if (this.mLoadListener != null) {
            this.mLoadListener.onDownloadPause(tPBaseAdapter, l, l2, string, string2);
        }
    }

    public void onDownloadFinish(TPBaseAdapter tPBaseAdapter, long l, long l2, String string, String string2) {
        if (this.mLoadListener != null) {
            this.mLoadListener.onDownloadFinish(tPBaseAdapter, l, l2, string, string2);
        }
    }

    public void onDownloadFail(TPBaseAdapter tPBaseAdapter, long l, long l2, String string, String string2) {
        if (this.mLoadListener != null) {
            this.mLoadListener.onDownloadFail(tPBaseAdapter, l, l2, string, string2);
        }
    }

    public void onInstalled(TPBaseAdapter tPBaseAdapter, long l, long l2, String string, String string2) {
        if (this.mLoadListener != null) {
            this.mLoadListener.onInstalled(tPBaseAdapter, l, l2, string, string2);
        }
    }

    void videoProgress() {
    }

    void dislikeClicked() {
    }

    void splashAdTick(long l) {
    }

    public boolean isLoadAllNetwork() {
        return this.isLoadAllNetwork;
    }

    public void onAdResume(TPBaseAdapter tPBaseAdapter) {
        if (this.mLoadListener != null) {
            this.mLoadListener.onAdResume(tPBaseAdapter);
        }
    }

    public void onAdPause(TPBaseAdapter tPBaseAdapter) {
        if (this.mLoadListener != null) {
            this.mLoadListener.onAdPause(tPBaseAdapter);
        }
    }

    public void onAdSkiped(TPBaseAdapter tPBaseAdapter) {
        if (this.mLoadListener != null) {
            this.mLoadListener.onAdSkiped(tPBaseAdapter);
        }
    }

    public void onAdTapped(TPBaseAdapter tPBaseAdapter) {
        if (this.mLoadListener != null) {
            this.mLoadListener.onAdTapped(tPBaseAdapter);
        }
    }

    public void onAdProgress(TPBaseAdapter tPBaseAdapter, float f, double d) {
        if (this.mLoadListener != null) {
            this.mLoadListener.onAdProgress(tPBaseAdapter, f, d);
        }
    }
}

