/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.core;

import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.adapter.TPLoadAdapterListener;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.LoadMode;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.config.ConfigLoadManager;
import com.tradplus.ads.base.config.response.BiddingResponse;
import com.tradplus.ads.base.filter.NetWorkFrequencyUtils;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.core.AdCacheManager;
import com.tradplus.ads.core.AdIntervalManager;
import com.tradplus.ads.core.AdMediationManager;
import com.tradplus.ads.core.HbTokenManager;
import com.tradplus.ads.core.cache.AdCache;
import com.tradplus.ads.core.factory.CustomEventFactory;
import com.tradplus.ads.core.track.LoadLifecycleCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AdLoadManager {
    private static final int LOAD_STATUS_SUCCESS = 1;
    private static final int LOAD_STATUS_HAS_CACHE = 2;
    private static final int LOAD_STATUS_FAILED = 0;
    private static final int LOAD_STATUS_TIMEOUT = 3;
    private static final int DEFAULT_INTERSTITIAL_TIMEOUT_DELAY = 60000;
    private ArrayList<ConfigResponse.WaterfallBean> mWaterfallBeans;
    private String mAdUnitId;
    private int mParallelNum;
    private int mMinCache;
    private volatile int currentIndex;
    private HashMap<ConfigResponse.WaterfallBean, Integer> mLoadFinishLayers;
    private ConcurrentHashMap<String, Runnable> mOverTimeMap;
    private Handler mThreadHandler;
    private int op;
    private LoadMode loadMode;
    private int[] cacheIndex;
    private boolean noBidMode;
    private boolean isloadAllNetwork;

    AdLoadManager(String string, ArrayList<ConfigResponse.WaterfallBean> arrayList, int n, int n2, int n3, LoadMode loadMode, boolean bl) {
        this.mWaterfallBeans = arrayList;
        this.mParallelNum = n;
        this.mMinCache = n2;
        this.mAdUnitId = string;
        this.mThreadHandler = TPTaskManager.getInstance().getThresholdThreadHandler();
        this.mOverTimeMap = new ConcurrentHashMap();
        this.mLoadFinishLayers = new HashMap();
        this.op = n3;
        this.loadMode = loadMode;
        this.noBidMode = bl;
    }

    void loadWaterfall(LoadLifecycleCallback loadLifecycleCallback) {
        int n;
        this.currentIndex = 0;
        this.mLoadFinishLayers.clear();
        int n2 = AdCacheManager.getInstance().getReadyAdNum(this.mAdUnitId);
        if (n2 > 0) {
            AdCacheManager.getInstance().sortWaterfallCacheByResult(this.mAdUnitId, this.mWaterfallBeans);
        }
        this.checkCacheIndex(loadLifecycleCallback);
        if (n2 > 0) {
            n = this.mMinCache - n2;
            this.mParallelNum = this.mParallelNum >= this.mMinCache ? n : Math.min(this.mParallelNum, n);
        }
        if (this.mParallelNum > this.mWaterfallBeans.size()) {
            this.mParallelNum = this.mWaterfallBeans.size();
        }
        LogUtil.ownShow((String)("AdLoadManager \u8be5\u8f6e\u5e76\u884c\u6570currentNume = " + this.mParallelNum + ", \u5df2\u7f13\u5b58readyAdNum:" + n2 + " ,\u6700\u5c0f\u7f13\u5b58\u6570MinCache :" + this.mMinCache));
        for (n = 0; n < this.mParallelNum; ++n) {
            AdLoadManager adLoadManager = this;
            adLoadManager.loadLayerAd(adLoadManager.currentIndex++, loadLifecycleCallback);
        }
    }

    private void checkParallelNum(int n, LoadLifecycleCallback loadLifecycleCallback) {
        int n2;
        if (n > 0 && this.mParallelNum > (n2 = this.mMinCache - n)) {
            this.mParallelNum = n2;
        }
        if (this.mParallelNum > this.mWaterfallBeans.size()) {
            this.mParallelNum = this.mWaterfallBeans.size();
        }
        LogUtil.ownShow((String)("AdLoadManager \u8be5\u8f6e\u5e76\u884c\u6570currentNume = " + this.mParallelNum + ", \u5df2\u7f13\u5b58readyAdNum:" + n + " ,\u6700\u5c0f\u7f13\u5b58\u6570MinCache :" + this.mMinCache));
        for (n2 = 0; n2 < this.mParallelNum; ++n2) {
            AdLoadManager adLoadManager = this;
            adLoadManager.loadLayerAd(adLoadManager.currentIndex++, loadLifecycleCallback);
        }
    }

    public void checkCacheIndex(LoadLifecycleCallback loadLifecycleCallback) {
        if (this.loadMode != LoadMode.SPEED) {
            return;
        }
        for (int i = 0; i < this.mWaterfallBeans.size(); ++i) {
            ConfigResponse.WaterfallBean waterfallBean = this.mWaterfallBeans.get(i);
            AdCache adCache = AdCacheManager.getInstance().isExistCache(this.mAdUnitId, waterfallBean);
            if (adCache == null) continue;
            if (this.cacheIndex == null) {
                this.cacheIndex = new int[this.mWaterfallBeans.size()];
            }
            this.currentCache(adCache, waterfallBean, loadLifecycleCallback);
            this.cacheIndex[i] = 1;
        }
    }

    private void loadLayerAd(int n, LoadLifecycleCallback loadLifecycleCallback) {
        ConfigResponse.WaterfallBean waterfallBean;
        while (true) {
            if (n >= this.mWaterfallBeans.size()) {
                return;
            }
            waterfallBean = this.mWaterfallBeans.get(n);
            if (this.cacheIndex == null || this.cacheIndex[n] != 1) break;
            ++this.currentIndex;
        }
        if (waterfallBean == null) {
            this.loadAdLoadFailed(null, null, loadLifecycleCallback, "9", null);
            return;
        }
        if (!NetWorkFrequencyUtils.getInstance().checkNetworkFrequency(waterfallBean)) {
            this.loadAdLoadFailed(waterfallBean, null, loadLifecycleCallback, "4", null);
            return;
        }
        if (!NetWorkFrequencyUtils.getInstance().checkAdSourceFilter(waterfallBean)) {
            this.loadAdLoadFailed(waterfallBean, null, loadLifecycleCallback, "4", null);
            return;
        }
        Object object = AdCacheManager.getInstance().isExistCache(this.mAdUnitId, waterfallBean);
        if (object != null) {
            this.currentLayerHasCache((AdCache)object, waterfallBean, loadLifecycleCallback);
            return;
        }
        object = waterfallBean.getCustomClassName();
        object = waterfallBean.getC2sAdapter() != null ? waterfallBean.getC2sAdapter() : CustomEventFactory.create((String)object);
        if (object == null) {
            this.loadAdLoadFailed(waterfallBean, null, loadLifecycleCallback, "13", null);
            return;
        }
        if (!HbTokenManager.checkPayLoadInfoExist(waterfallBean)) {
            this.loadAdLoadFailed(waterfallBean, null, loadLifecycleCallback, "17", null);
            return;
        }
        Object object2 = AdIntervalManager.getInstance(waterfallBean);
        if (object2 != null && !((AdIntervalManager)object2).canLoadToWaterfall()) {
            this.loadAdLoadFailed(waterfallBean, null, loadLifecycleCallback, "1107", null);
            return;
        }
        object2 = new a((TPBaseAdapter)object, loadLifecycleCallback);
        int n2 = this.mWaterfallBeans.indexOf(waterfallBean);
        object.setRequestId(loadLifecycleCallback.getRequestId());
        object.initAdapter(this.mAdUnitId, waterfallBean, n2, (TPLoadAdapterListener)object2);
        if (waterfallBean.getIs_main_thread() == 0) {
            this.loadAdapterOnThread((TPBaseAdapter)object, loadLifecycleCallback, waterfallBean);
            return;
        }
        this.loadAdapterOnMainThread((TPBaseAdapter)object, loadLifecycleCallback, waterfallBean);
    }

    private void loadAdapterOnMainThread(final TPBaseAdapter tPBaseAdapter, final LoadLifecycleCallback loadLifecycleCallback, final ConfigResponse.WaterfallBean waterfallBean) {
        TPTaskManager.getInstance().runOnMainThread(new Runnable(){

            @Override
            public final void run() {
                try {
                    AdLoadManager.this.startOverTimeRunnable(tPBaseAdapter, loadLifecycleCallback, waterfallBean);
                    loadLifecycleCallback.loadNetWorkStart(tPBaseAdapter);
                    tPBaseAdapter.loadAd();
                    return;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    AdLoadManager.this.loadAdLoadFailed(waterfallBean, tPBaseAdapter, loadLifecycleCallback, "18", null);
                    return;
                }
            }
        });
    }

    private void loadAdapterOnThread(final TPBaseAdapter tPBaseAdapter, final LoadLifecycleCallback loadLifecycleCallback, final ConfigResponse.WaterfallBean waterfallBean) {
        TPTaskManager.getInstance().runDyCorePool(new Runnable(){

            @Override
            public final void run() {
                try {
                    AdLoadManager.this.startOverTimeRunnable(tPBaseAdapter, loadLifecycleCallback, waterfallBean);
                    loadLifecycleCallback.loadNetWorkStart(tPBaseAdapter);
                    tPBaseAdapter.loadAd();
                    return;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    AdLoadManager.this.loadAdLoadFailed(waterfallBean, tPBaseAdapter, loadLifecycleCallback, "18", null);
                    return;
                }
            }
        });
    }

    private void startOverTimeRunnable(TPBaseAdapter object, LoadLifecycleCallback loadLifecycleCallback, final ConfigResponse.WaterfallBean waterfallBean) {
        object = new Runnable((TPBaseAdapter)object, loadLifecycleCallback){
            final /* synthetic */ TPBaseAdapter b;
            final /* synthetic */ LoadLifecycleCallback c;
            {
                this.b = tPBaseAdapter;
                this.c = loadLifecycleCallback;
            }

            @Override
            public final void run() {
                AdIntervalManager adIntervalManager;
                AdLoadManager.this.endOverTimeRunnable(waterfallBean.getAdsource_placement_id());
                if (!AdLoadManager.this.mLoadFinishLayers.containsKey(this.b.getWaterfallBean()) && (adIntervalManager = AdIntervalManager.getInstance(this.b.getWaterfallBean())) != null) {
                    adIntervalManager.loadWaterfallFailed();
                }
                AdLoadManager.this.loadAdLoadFailed(waterfallBean, this.b, this.c, "3", AdLoadManager.this.getErrorMessage());
            }
        };
        long l = 60000L;
        if (waterfallBean.getLoadTimeout() > 0L && waterfallBean.getLoadTimeout() <= 300L) {
            l = waterfallBean.getLoadTimeout() * 1000L;
        }
        LogUtil.ownShow((String)"AdLoadManager startOverTimeRunnable timeout:".concat(String.valueOf(l)));
        this.mThreadHandler.postDelayed((Runnable)object, l);
        this.mOverTimeMap.put(waterfallBean.getAdsource_placement_id(), (Runnable)object);
    }

    private String getErrorMessage() {
        if (!DeviceUtils.isNetworkAvailable((Context)GlobalTradPlus.getInstance().getContext())) {
            TPError tPError = new TPError();
            tPError.setErrorMessage("Network is unavailable.");
            tPError.setErrorCode("7");
            return tPError.getEmsg();
        }
        return null;
    }

    private void endOverTimeRunnable(String string) {
        Runnable runnable = this.mOverTimeMap.get(string);
        if (runnable != null) {
            this.mThreadHandler.removeCallbacks(runnable);
        }
        this.mOverTimeMap.remove(string);
    }

    private synchronized void loadAdLoaded(TPBaseAd tPBaseAd, TPBaseAdapter tPBaseAdapter, LoadLifecycleCallback loadLifecycleCallback) {
        boolean bl;
        int n;
        int n2;
        ConfigResponse.WaterfallBean waterfallBean = tPBaseAdapter.getWaterfallBean();
        if (this.mLoadFinishLayers.containsKey(waterfallBean)) {
            if (3 == this.mLoadFinishLayers.get(waterfallBean) && AdCacheManager.getInstance().isExistCache(this.mAdUnitId, waterfallBean) == null) {
                AdCache adCache = new AdCache();
                adCache.setAdapter(tPBaseAdapter);
                adCache.setAdObj(tPBaseAd);
                adCache.setCallback(loadLifecycleCallback);
                adCache.setConfigBean(waterfallBean);
                adCache.setStatus(0);
                AdCacheManager.getInstance().saveWaterfallCache(this.mAdUnitId, adCache, this.mWaterfallBeans.indexOf(waterfallBean));
                loadLifecycleCallback.loadNetWorkTimeoutSuccess(waterfallBean, tPBaseAdapter);
            }
            return;
        }
        this.mLoadFinishLayers.put(waterfallBean, 1);
        this.endOverTimeRunnable(tPBaseAdapter.getAdSourcePid());
        this.saveHighPrice(waterfallBean);
        AdIntervalManager adIntervalManager = AdIntervalManager.getInstance(waterfallBean);
        if (adIntervalManager != null) {
            adIntervalManager.loadWaterfallLoaded();
        }
        if (AdMediationManager.isReload(this.op) && (adIntervalManager = ConfigLoadManager.getInstance().getLocalConfigResponse(this.mAdUnitId)) != null && (n2 = AdCacheManager.getInstance().getReadyAdNum(this.mAdUnitId)) > (n = adIntervalManager.getMinCache())) {
            AdCacheManager.getInstance().removeEndCache(this.mAdUnitId, 1);
        }
        AdCache adCache = new AdCache();
        adCache.setAdapter(tPBaseAdapter);
        adCache.setAdObj(tPBaseAd);
        adCache.setCallback(loadLifecycleCallback);
        adCache.setConfigBean(waterfallBean);
        adCache.setStatus(0);
        AdCacheManager.getInstance().saveWaterfallCache(this.mAdUnitId, adCache, this.mWaterfallBeans.indexOf(waterfallBean));
        loadLifecycleCallback.loadNetWorkEnd(adCache, tPBaseAdapter.getWaterfallBean(), tPBaseAdapter, "1", null);
        if (!TextUtils.isEmpty((CharSequence)tPBaseAdapter.getPayLoadStr()) || waterfallBean.getC2sAdapter() != null) {
            HbTokenManager.sendWinOrDisplayNotification(true, tPBaseAdapter, loadLifecycleCallback);
        }
        n2 = AdCacheManager.getInstance().getReadyAdNum(this.mAdUnitId);
        int n3 = this.getLoadSuccessNum();
        if (this.loadMode == LoadMode.SPEED) {
            bl = n2 == this.mMinCache;
        } else {
            boolean bl2 = bl = n3 == this.mParallelNum;
        }
        if (bl || this.mLoadFinishLayers.size() == this.mWaterfallBeans.size()) {
            this.loadAllNetwork(loadLifecycleCallback, n3);
        }
        LogUtil.ownShow((String)("AdLoadManager loadAdLoaded tempHasCache:" + n2 + ", ParallelNum:" + this.mParallelNum + ", MinCache:" + this.mMinCache));
        if (this.mParallelNum < this.mMinCache && n2 + (this.mParallelNum - 1) < this.mMinCache) {
            AdLoadManager adLoadManager = this;
            adLoadManager.loadLayerAd(adLoadManager.currentIndex++, loadLifecycleCallback);
        }
    }

    private synchronized void loadAllNetwork(LoadLifecycleCallback loadLifecycleCallback, int n) {
        if (!this.isloadAllNetwork) {
            loadLifecycleCallback.loadAllNetwork("1", AdMediationManager.isReload(this.op), this.op, n);
            HbTokenManager.removeUnLoadBiddingPayload(this.mAdUnitId, this.currentIndex, this.mWaterfallBeans, loadLifecycleCallback);
            this.isloadAllNetwork = true;
        }
    }

    private int getLoadSuccessNum() {
        int n = 0;
        Iterator<Map.Entry<ConfigResponse.WaterfallBean, Integer>> iterator = this.mLoadFinishLayers.entrySet().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getValue() != 1) continue;
            ++n;
        }
        return n;
    }

    private synchronized void loadAdLoadFailed(ConfigResponse.WaterfallBean waterfallBean, TPBaseAdapter object, LoadLifecycleCallback loadLifecycleCallback, String string, String object22) {
        if (waterfallBean == null) {
            this.mLoadFinishLayers.put(new ConfigResponse.WaterfallBean(), 0);
        } else {
            if (this.mLoadFinishLayers.containsKey(waterfallBean)) {
                return;
            }
            if ("3".equals(string)) {
                this.mLoadFinishLayers.put(waterfallBean, 3);
            } else {
                this.mLoadFinishLayers.put(waterfallBean, 0);
            }
            this.endOverTimeRunnable(waterfallBean.getAdsource_placement_id());
            if (waterfallBean.getPayLoadInfo() != null && waterfallBean.getC2sAdapter() == null && TextUtils.equals((CharSequence)"2", (CharSequence)string)) {
                HbTokenManager.sendLosNotification("1", waterfallBean, loadLifecycleCallback);
                waterfallBean.setPayLoadInfo(null);
            }
        }
        loadLifecycleCallback.loadNetWorkEnd(null, waterfallBean, (TPBaseAdapter)object, string, (String)object22);
        if (this.mLoadFinishLayers.size() == this.mWaterfallBeans.size()) {
            BiddingResponse.PayLoadInfo payLoadInfo;
            for (Map.Entry entry : this.mLoadFinishLayers.entrySet()) {
                if ((Integer)entry.getValue() != 1 && (Integer)entry.getValue() != 2) continue;
                this.loadAllNetwork(loadLifecycleCallback, this.getLoadSuccessNum());
                return;
            }
            object = AdCacheManager.getInstance().getBottomCacheAd(this.mAdUnitId);
            string = "11";
            if (!"1".equals(string) && object != null) {
                if (((AdCache)object).isBottomWaterfall()) {
                    ((AdCache)object).setEffectTime(0L);
                    loadLifecycleCallback.loadAdLoaded((AdCache)object);
                }
                string = "1";
            }
            if (waterfallBean != null && (payLoadInfo = waterfallBean.getPayLoadInfo()) != null && payLoadInfo.getIs_exclusive() == 1) {
                string = "105";
            }
            LogUtil.ownShow((String)"AdLoadManager loadAdLoadFailed loadAllNetwork:");
            loadLifecycleCallback.loadAllNetwork(string, AdMediationManager.isReload(this.op), this.op, this.getLoadSuccessNum());
            HbTokenManager.removeUnLoadBiddingPayload(this.mAdUnitId, 0, this.mWaterfallBeans, loadLifecycleCallback);
            return;
        }
        if (this.currentIndex >= this.mWaterfallBeans.size()) {
            return;
        }
        AdLoadManager adLoadManager = this;
        adLoadManager.loadLayerAd(adLoadManager.currentIndex++, loadLifecycleCallback);
    }

    private boolean currentCache(AdCache adCache, ConfigResponse.WaterfallBean waterfallBean, LoadLifecycleCallback loadLifecycleCallback) {
        boolean bl;
        if (this.loadMode == LoadMode.SPEED && !this.noBidMode) {
            loadLifecycleCallback.currentLayerHasCache(adCache);
        }
        this.mLoadFinishLayers.put(waterfallBean, 2);
        int n = this.getLoadSuccessNum();
        int n2 = AdCacheManager.getInstance().getReadyAdNum(this.mAdUnitId);
        this.saveHighPrice(waterfallBean);
        LogUtil.ownShow((String)("AdLoadManager currentCache = " + n + ", mMinCache :" + this.mMinCache));
        if (this.loadMode == LoadMode.SPEED) {
            bl = n2 == this.mMinCache;
        } else {
            boolean bl2 = bl = n == this.mParallelNum;
        }
        if (bl || this.mLoadFinishLayers.size() == this.mWaterfallBeans.size() || AdMediationManager.isReload(this.op)) {
            this.loadAllNetwork(loadLifecycleCallback, n);
            return false;
        }
        return this.currentIndex < this.mWaterfallBeans.size();
    }

    private void currentLayerHasCache(AdCache adCache, ConfigResponse.WaterfallBean waterfallBean, LoadLifecycleCallback loadLifecycleCallback) {
        if (this.currentCache(adCache, waterfallBean, loadLifecycleCallback)) {
            AdLoadManager adLoadManager = this;
            adLoadManager.loadLayerAd(adLoadManager.currentIndex++, loadLifecycleCallback);
        }
    }

    private int isFindWaterfall(ArrayList<ConfigResponse.WaterfallBean> arrayList, ConfigResponse.WaterfallBean waterfallBean) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!TextUtils.equals((CharSequence)arrayList.get(i).getAdsource_placement_id(), (CharSequence)waterfallBean.getAdsource_placement_id())) continue;
            return i;
        }
        return -1;
    }

    private void saveHighPrice(ConfigResponse.WaterfallBean waterfallBean) {
        try {
            Object object;
            int n = this.mWaterfallBeans.indexOf(waterfallBean);
            BiddingResponse.PayLoadInfo payLoadInfo = waterfallBean.getPayLoadInfo();
            String string = null;
            float f = 0.0f;
            if (payLoadInfo == null) {
                string = String.valueOf(waterfallBean.getEcpm());
                f = (float)waterfallBean.getEcpm_cny();
            } else if (payLoadInfo.getExt() != null) {
                string = String.valueOf(payLoadInfo.getExt().getValue());
                f = payLoadInfo.getPrice_cny();
            }
            int n2 = n;
            while (n2 < this.mWaterfallBeans.size() - 1) {
                if ((object = this.mWaterfallBeans.get(++n2).getPayLoadInfo()) == null) continue;
                String string2 = object.getHighPrice();
                if (string2 == null || string2.length() <= 0 || string2.equals("0")) {
                    object.setHighPrice(string);
                    object.setHighaspid(waterfallBean.getAdsource_placement_id());
                }
                if (f == 0.0f) continue;
                object.setPrice_cny(f);
            }
            Log.i((String)"BiddingPayload", (String)"saveHighPrice beanPrice: ".concat(String.valueOf(string)));
            if (payLoadInfo == null) {
                return;
            }
            int n3 = n + 1;
            object = null;
            if (n3 < this.mWaterfallBeans.size()) {
                ConfigResponse.WaterfallBean waterfallBean2 = this.mWaterfallBeans.get(n3);
                if (waterfallBean2 == null) {
                    return;
                }
                waterfallBean = waterfallBean2.getPayLoadInfo();
                if (waterfallBean != null && waterfallBean.getExt() != null) {
                    object = String.valueOf(waterfallBean.getExt().getValue());
                } else if (waterfallBean == null) {
                    object = String.valueOf(waterfallBean2.getEcpm());
                }
                payLoadInfo.setSecondPrice((String)object);
                payLoadInfo.setSecondAspid(waterfallBean2.getAdsource_placement_id());
            }
            Log.i((String)"BiddingPayload", (String)"saveSecondBeanPrice: ".concat(String.valueOf(object)));
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    final class a
    implements TPLoadAdapterListener {
        TPBaseAdapter a;
        LoadLifecycleCallback b;

        a(TPBaseAdapter tPBaseAdapter, LoadLifecycleCallback loadLifecycleCallback) {
            this.a = tPBaseAdapter;
            this.b = loadLifecycleCallback;
        }

        public final void loadAdapterLoaded(final TPBaseAd tPBaseAd) {
            TPTaskManager.getInstance().getLoadThreadHandler().post(new Runnable(){

                @Override
                public final void run() {
                    AdLoadManager.this.loadAdLoaded(tPBaseAd, a.this.a, a.this.b);
                }
            });
        }

        public final void loadAdapterLoadFailed(final TPError tPError) {
            TPTaskManager.getInstance().getLoadThreadHandler().post(new Runnable(){

                @Override
                public final void run() {
                    AdIntervalManager adIntervalManager;
                    ConfigResponse.WaterfallBean waterfallBean = a.this.a.getWaterfallBean();
                    if (!AdLoadManager.this.mLoadFinishLayers.containsKey(waterfallBean) && (adIntervalManager = AdIntervalManager.getInstance(waterfallBean)) != null) {
                        adIntervalManager.loadWaterfallFailed();
                    }
                    AdLoadManager.this.loadAdLoadFailed(waterfallBean, a.this.a, a.this.b, tPError.getTpErrorCode(), tPError.getEmsg());
                }
            });
        }
    }
}

