/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.core;

import android.text.TextUtils;
import android.util.Log;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.common.LoadMode;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.common.Util;
import com.tradplus.ads.base.config.request.BiddingRequestInfo;
import com.tradplus.ads.base.config.response.BiddingResponse;
import com.tradplus.ads.base.filter.NetWorkFrequencyUtils;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.base.util.TradPlusInterstitialConstants;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.CustomLogUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.core.AdCacheManager;
import com.tradplus.ads.core.cache.AdCache;
import com.tradplus.ads.core.factory.CustomEventFactory;
import com.tradplus.ads.core.track.LoadLifecycleCallback;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class HBManager {
    public final String[] needTokenListenerArray = new String[]{"18", "19", "50", "55", "57", "2", "74", "23", "76"};
    private LoadLifecycleCallback loadCallback;
    private ConfigResponse response;
    private String adUnitId;
    private ConcurrentHashMap<ConfigResponse.WaterfallBean, TrackInfo> trackMap;
    private BiddingRequestInfo requestInfo;
    private OnBiddingSuccess onBiddingSuccess;
    private int biddingCount;
    private volatile int biddingEndCount;
    private volatile AtomicBoolean isTimeOut = new AtomicBoolean(false);
    private boolean isEnd;
    private long timeOutValue;
    public Runnable timeoutRunnable = new Runnable(){

        @Override
        public final void run() {
            HBManager.this.isTimeOut.set(true);
            HBManager.this.checkTimeOutWaterfall();
            HBManager.this.endCallBack();
        }
    };

    private void checkTimeOutWaterfall() {
        Iterator<Map.Entry<ConfigResponse.WaterfallBean, TrackInfo>> iterator = this.trackMap.entrySet().iterator();
        while (iterator.hasNext()) {
            TrackInfo trackInfo = iterator.next().getValue();
            if (trackInfo.getEndTime() != 0L) continue;
            trackInfo.setEndTime();
            trackInfo.setStatus("3");
        }
    }

    public HBManager(String string, ConfigResponse configResponse, LoadLifecycleCallback loadLifecycleCallback, OnBiddingSuccess onBiddingSuccess) {
        this.loadCallback = loadLifecycleCallback;
        this.response = configResponse;
        this.adUnitId = string;
        this.onBiddingSuccess = onBiddingSuccess;
    }

    public void startBidding(BiddingRequestInfo biddingRequestInfo, ConcurrentHashMap<ConfigResponse.WaterfallBean, TrackInfo> concurrentHashMap) {
        this.trackMap = concurrentHashMap;
        this.requestInfo = biddingRequestInfo;
        this.timeOutValue = this.getTimeOutValue();
        TPTaskManager.getInstance().getThresholdThreadHandler().postDelayed(this.timeoutRunnable, this.timeOutValue);
        int n = this.response.getBiddingwaterfall() == null ? 0 : this.response.getBiddingwaterfall().size();
        int n2 = this.response.getC2sbiddingwaterfall() == null ? 0 : this.response.getC2sbiddingwaterfall().size();
        this.biddingCount = n + n2;
        this.getS2SToken();
        this.getC2S();
    }

    private long getTimeOutValue() {
        ArrayList arrayList = this.response.getBiddingwaterfall();
        long l = 0L;
        if (arrayList != null && arrayList.size() > 0) {
            l = ((ConfigResponse.WaterfallBean)arrayList.get(0)).getBuyeruidTimeout() * 1000L;
        }
        if (l > 0L) {
            return l;
        }
        arrayList = this.response.getC2sbiddingwaterfall();
        if (arrayList != null && arrayList.size() > 0) {
            l = ((ConfigResponse.WaterfallBean)arrayList.get(0)).getBuyeruidTimeout() * 1000L;
        }
        if (l > 0L) {
            return l;
        }
        return 5000L;
    }

    public void getC2S() {
        ArrayList arrayList = this.response.getC2sbiddingwaterfall();
        if (arrayList == null) {
            return;
        }
        for (final ConfigResponse.WaterfallBean waterfallBean : new ArrayList(arrayList)) {
            AdCache adCache = AdCacheManager.getInstance().isExistCache(this.adUnitId, waterfallBean);
            if (adCache != null) {
                BiddingResponse.PayLoadInfo payLoadInfo;
                ConfigResponse.WaterfallBean waterfallBean2 = adCache.getConfigBean();
                if (waterfallBean.getAdsource_placement_id().equals(waterfallBean2.getAdsource_placement_id()) && (payLoadInfo = waterfallBean2.getPayLoadInfo()) != null) {
                    waterfallBean.setPayLoadInfo(payLoadInfo);
                    waterfallBean.setC2sAdapter(waterfallBean2.getC2sAdapter());
                }
                HBManager hBManager = this;
                if (LoadMode.ECPM != hBManager.getLoadedType(hBManager.response.getAd_fill_callback()) && this.response.getNobid() != 0) {
                    this.checkBiddingEnd();
                    continue;
                }
                payLoadInfo = adCache.getAdapter();
                if (payLoadInfo != null && (waterfallBean = payLoadInfo.getWaterfallBean()) != null && waterfallBean.getPayLoadInfo() != null) {
                    BiddingResponse.PayLoadInfo payLoadInfo2 = payLoadInfo;
                    this.setC2sAdsourcement((TPBaseAdapter)payLoadInfo2, payLoadInfo2.getC2sprice(), "");
                }
                this.checkBiddingEnd();
                continue;
            }
            if (!NetWorkFrequencyUtils.getInstance().checkNetworkFrequency(waterfallBean)) {
                this.checkBiddingEnd();
                continue;
            }
            if (!NetWorkFrequencyUtils.getInstance().checkAdSourceFilter(waterfallBean)) {
                this.checkBiddingEnd();
                continue;
            }
            TPTaskManager.getInstance().runDyCorePool(new Runnable(){

                @Override
                public final void run() {
                    HBManager.this.getC2SBidding(waterfallBean);
                }
            });
        }
    }

    private synchronized void setC2sAdsourcement(TPBaseAdapter object, double d, String string) {
        List list = this.requestInfo.getC2sadsourceplacements();
        int n = Util.parseToInteger((String)object.getWaterfallBean().getAdsource_placement_id());
        int n2 = Util.parseToInteger((String)object.getNetworkId());
        String string2 = object.getNetworkVersion();
        object = object.getNetworkName();
        BiddingRequestInfo.C2SBiddingWaterfall c2SBiddingWaterfall = new BiddingRequestInfo.C2SBiddingWaterfall();
        c2SBiddingWaterfall.setId(n);
        c2SBiddingWaterfall.setNetworkid(n2);
        c2SBiddingWaterfall.setNetworkname((String)object);
        c2SBiddingWaterfall.setNetworksdkver(string2);
        c2SBiddingWaterfall.setPrice(d);
        c2SBiddingWaterfall.setEncrypted_ecpm(string);
        list.add(c2SBiddingWaterfall);
    }

    public synchronized void endCallBack() {
        if (!this.isEnd) {
            this.isEnd = true;
            this.onBiddingSuccess.biddingEnd();
        }
    }

    private void setBiddingResult(String string, TrackInfo trackInfo, String string2) {
        if (!this.isTimeOut.get()) {
            trackInfo.setEndTime();
            trackInfo.setStatus(string);
            trackInfo.setMsg(string2);
            this.checkBiddingEnd();
        }
    }

    public void getC2SBidding(final ConfigResponse.WaterfallBean waterfallBean) {
        final TrackInfo trackInfo = new TrackInfo();
        try {
            String string = waterfallBean.getCustomClassName();
            this.trackMap.put(waterfallBean, trackInfo);
            this.loadCallback.startBiddingEvent(waterfallBean);
            final TPBaseAdapter tPBaseAdapter = CustomEventFactory.create(string);
            if (tPBaseAdapter == null) {
                this.setBiddingResult("13", trackInfo, "");
                this.logNotFoundAdater(string);
                return;
            }
            tPBaseAdapter.initAdapter(this.adUnitId, waterfallBean, -1, null);
            tPBaseAdapter.C2SBidding(this.adUnitId, waterfallBean, new TPBaseAdapter.OnC2STokenListener(){

                public final void onC2SBiddingResult(double d) {
                }

                public final void onC2SBiddingResult(Map<String, Object> map) {
                    Object object;
                    if (HBManager.this.isTimeOut.get()) {
                        return;
                    }
                    String string = "";
                    double d = 0.0;
                    if (map != null && map.containsKey("ecpm")) {
                        object = map.get("ecpm");
                        if (object instanceof Double) {
                            d = (Double)object;
                        }
                        tPBaseAdapter.setC2sprice(d);
                    }
                    if (map != null && map.containsKey("encrypted_ecpm") && (object = map.get("encrypted_ecpm")) instanceof String) {
                        string = (String)object;
                        tPBaseAdapter.setEncodec2sPrice(string);
                    }
                    HBManager.this.setC2sAdsourcement(tPBaseAdapter, d, string);
                    waterfallBean.setC2sAdapter(tPBaseAdapter);
                    HBManager.this.setBiddingResult("1", trackInfo, "");
                }

                public final void onC2SBiddingFailed(String string, String string2) {
                    LogUtil.ownShow((String)("C2S FAILED,code:" + string + ",msg:" + string2));
                    if (HBManager.this.isTimeOut.get()) {
                        return;
                    }
                    HBManager.this.setBiddingResult("2", trackInfo, TextUtils.isEmpty((CharSequence)string2) ? "C2S Bidding failed.No price." : string2);
                }
            });
            return;
        }
        catch (Throwable throwable) {
            this.setBiddingResult("2", trackInfo, "Bidding Crash.unknow error");
            throwable.printStackTrace();
            return;
        }
    }

    public void checkBiddingEnd() {
        ++this.biddingEndCount;
        if (this.biddingEndCount >= this.biddingCount && !this.isTimeOut.get()) {
            this.endCallBack();
        }
    }

    public void getS2SToken() {
        ArrayList arrayList = this.response.getBiddingwaterfall();
        if (arrayList == null) {
            return;
        }
        for (final ConfigResponse.WaterfallBean waterfallBean : new ArrayList(arrayList)) {
            AdCache adCache = AdCacheManager.getInstance().isExistCache(this.adUnitId, waterfallBean);
            if (adCache != null) {
                adCache = adCache.getConfigBean();
                if (waterfallBean.getAdsource_placement_id().equals(adCache.getAdsource_placement_id()) && (adCache = adCache.getPayLoadInfo()) != null) {
                    waterfallBean.setPayLoadInfo((BiddingResponse.PayLoadInfo)adCache);
                }
                HBManager hBManager = this;
                if (LoadMode.ECPM != hBManager.getLoadedType(hBManager.response.getAd_fill_callback()) && this.response.getNobid() != 0) {
                    this.checkBiddingEnd();
                    continue;
                }
            }
            if (!NetWorkFrequencyUtils.getInstance().checkNetworkFrequency(waterfallBean)) {
                this.checkBiddingEnd();
                continue;
            }
            if (!NetWorkFrequencyUtils.getInstance().checkAdSourceFilter(waterfallBean)) {
                this.checkBiddingEnd();
                continue;
            }
            if (waterfallBean.getIs_adx() == 1) {
                HBManager hBManager = this;
                hBManager.prepareRequestInfo(hBManager.requestInfo, waterfallBean);
            }
            LogUtil.ownShow((String)("requestInfo = " + JSON.toJSONString((Object)this.requestInfo)));
            TPTaskManager.getInstance().runDyCorePool(new Runnable(){

                @Override
                public final void run() {
                    if (HBManager.this.needTokenListener(waterfallBean)) {
                        HBManager.this.needTokenCallback(waterfallBean);
                        return;
                    }
                    HBManager.this.normalToken(waterfallBean);
                }
            });
        }
    }

    private synchronized void setS2sAdsourcement(ConfigResponse.WaterfallBean waterfallBean, String string, String string2, String string3, Map<String, Object> map) {
        Object object;
        Object object2;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (map != null) {
            if (map.containsKey("bid_banner_w") && map.containsKey("bid_banner_h")) {
                object2 = map.get("bid_banner_w");
                if (object2 instanceof Integer) {
                    n = (Integer)object2;
                }
                if ((object = map.get("bid_banner_h")) instanceof Integer) {
                    n2 = (Integer)object;
                }
            }
            if (map.containsKey("is_hybrid_setup") && map.get("is_hybrid_setup") instanceof Integer) {
                n3 = (Integer)map.get("is_hybrid_setup");
            }
            this.addExtraLocalParms(map);
        }
        object2 = this.requestInfo.getAdsourceplacements();
        object = new BiddingRequestInfo.AdSourcePlacements(waterfallBean, string, string2, string3, n, n2, n3);
        object2.add(object);
    }

    private void addExtraLocalParms(Map<String, Object> map) {
        BiddingRequestInfo.Device device;
        Object object;
        if (map.containsKey("country") && (object = map.get("country")) instanceof String) {
            object = (String)object;
            device = this.requestInfo.getDevice();
            if (device != null && (device = device.getExt()) != null) {
                device.setCountry((String)object);
            }
        }
        if (map.containsKey("miui_version_name") && (object = map.get("miui_version_name")) instanceof String) {
            object = (String)object;
            device = this.requestInfo.getDevice();
            if (device != null && (device = device.getExt()) != null) {
                device.setMiui_version_name((String)object);
            }
        }
        if (map.containsKey("mimarket_version") && (object = map.get("mimarket_version")) instanceof String) {
            object = (String)object;
            device = this.requestInfo.getApp();
            if (device != null && (device = device.getExt()) != null) {
                device.setMimarket_version((String)object);
            }
        }
        if (map.containsKey("googleplay_version") && (object = map.get("googleplay_version")) instanceof String) {
            object = (String)object;
            device = this.requestInfo.getApp();
            if (device != null && (device = device.getExt()) != null) {
                device.setGoogleplay_version((String)object);
            }
        }
    }

    private void needTokenCallback(final ConfigResponse.WaterfallBean waterfallBean) {
        final TrackInfo trackInfo = new TrackInfo();
        try {
            String string = waterfallBean.getCustomClassName();
            this.trackMap.put(waterfallBean, trackInfo);
            this.loadCallback.startBiddingEvent(waterfallBean);
            final TPBaseAdapter tPBaseAdapter = CustomEventFactory.create(string);
            if (tPBaseAdapter == null) {
                this.setBiddingResult("13", trackInfo, "");
                this.logNotFoundAdater(string);
                return;
            }
            tPBaseAdapter.initAdapter(this.adUnitId, waterfallBean, -1, null);
            tPBaseAdapter.getBiddingToken(new TPBaseAdapter.OnS2STokenListener(){

                public final void onTokenResult(final String string, final Map<String, Object> map) {
                    if (HBManager.this.isTimeOut.get()) {
                        return;
                    }
                    long l = 0L;
                    if (map != null && map.containsKey("time_stamp")) {
                        l = (Long)map.get("time_stamp");
                    }
                    final long l2 = l;
                    TPTaskManager.getInstance().runDyCorePool(new Runnable(){

                        @Override
                        public final void run() {
                            LogUtil.ownShow((String)("bidding token = " + string));
                            if (!TextUtils.isEmpty((CharSequence)string)) {
                                if (l2 > 0L) {
                                    HBManager.this.setS2sAdsourcement(waterfallBean, string, tPBaseAdapter.getNetworkVersion(), String.valueOf(l2), map);
                                } else {
                                    HBManager.this.setS2sAdsourcement(waterfallBean, string, tPBaseAdapter.getNetworkVersion(), tPBaseAdapter.getBiddingNetworkInfo(), map);
                                }
                            }
                            HBManager.this.setBiddingResult("1", trackInfo, "");
                        }
                    });
                }
            });
            return;
        }
        catch (Throwable throwable) {
            this.setBiddingResult("2", trackInfo, "Bidding Crash.unknow error");
            throwable.printStackTrace();
            return;
        }
    }

    private void normalToken(ConfigResponse.WaterfallBean waterfallBean) {
        TrackInfo trackInfo = new TrackInfo();
        try {
            String string = waterfallBean.getCustomClassName();
            this.trackMap.put(waterfallBean, trackInfo);
            this.loadCallback.startBiddingEvent(waterfallBean);
            TPBaseAdapter tPBaseAdapter = CustomEventFactory.create(string);
            if (tPBaseAdapter == null) {
                this.setBiddingResult("13", trackInfo, "");
                this.logNotFoundAdater(string);
                return;
            }
            tPBaseAdapter.initAdapter(this.adUnitId, waterfallBean, -1, null);
            string = tPBaseAdapter.getBiddingToken();
            LogUtil.ownShow((String)"bidding token = ".concat(String.valueOf(string)));
            this.setS2sAdsourcement(waterfallBean, string, tPBaseAdapter.getNetworkVersion(), tPBaseAdapter.getBiddingNetworkInfo(), null);
            this.setBiddingResult("1", trackInfo, "");
            return;
        }
        catch (Throwable throwable) {
            this.setBiddingResult("2", trackInfo, "Bidding Crash.unknow error");
            throwable.printStackTrace();
            return;
        }
    }

    private boolean needTokenListener(ConfigResponse.WaterfallBean waterfallBean) {
        for (int i = 0; i < this.needTokenListenerArray.length; ++i) {
            if (!TextUtils.equals((CharSequence)waterfallBean.getId(), (CharSequence)this.needTokenListenerArray[i])) continue;
            return true;
        }
        return false;
    }

    private void prepareRequestInfo(BiddingRequestInfo biddingRequestInfo, ConfigResponse.WaterfallBean waterfallBean) {
        if (TradPlusInterstitialConstants.isBannerType((String)this.response.getAdType())) {
            waterfallBean = new BiddingRequestInfo.Imp.Banner();
            ((BiddingRequestInfo.Imp)biddingRequestInfo.getImp().get(0)).setBanner((BiddingRequestInfo.Imp.Banner)waterfallBean);
            return;
        }
        if (TradPlusInterstitialConstants.isRewardType((String)this.response.getAdType()) || TradPlusInterstitialConstants.isInterstitialType((String)this.response.getAdType())) {
            if (TradPlusInterstitialConstants.isInterstitialType((String)this.response.getAdType())) {
                ((BiddingRequestInfo.Imp)biddingRequestInfo.getImp().get(0)).setInstl(1);
            } else {
                waterfallBean = new BiddingRequestInfo.Imp.Video(TradPlusInterstitialConstants.isRewardType((String)this.response.getAdType()) ? 1 : 0);
                ((BiddingRequestInfo.Imp)biddingRequestInfo.getImp().get(0)).setVideo((BiddingRequestInfo.Imp.Video)waterfallBean);
            }
            waterfallBean = new BiddingRequestInfo.Imp.Banner();
            ((BiddingRequestInfo.Imp)biddingRequestInfo.getImp().get(0)).setBanner((BiddingRequestInfo.Imp.Banner)waterfallBean);
            return;
        }
        if (TradPlusInterstitialConstants.isNativeType((String)this.response.getAdType())) {
            waterfallBean = new BiddingRequestInfo.Imp.NativeAd();
            ((BiddingRequestInfo.Imp)biddingRequestInfo.getImp().get(0)).setNativead((BiddingRequestInfo.Imp.NativeAd)waterfallBean);
        }
    }

    private void logNotFoundAdater(String string) {
        Log.w((String)"TradPlusLog", (String)"****************");
        CustomLogUtils.getInstance().logWarn(CustomLogUtils.TradPlusLog.NOTFOUNT_ADAPTER, string);
        Log.w((String)"TradPlusLog", (String)"****************");
    }

    public LoadMode getLoadedType(int n) {
        if (n == 1) {
            return LoadMode.ECPM;
        }
        return LoadMode.SPEED;
    }

    public static class TrackInfo {
        private long startTime = System.currentTimeMillis();
        private String status;
        private long endTime;
        private String msg;

        public long getEndTime() {
            return this.endTime;
        }

        public void setEndTime() {
            this.endTime = System.currentTimeMillis() - this.startTime;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String string) {
            this.status = string;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String string) {
            this.msg = string;
        }
    }

    public static interface OnBiddingSuccess {
        public void biddingEnd();
    }
}

