/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.core;

import android.os.Handler;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.adapter.TPLoadAdapterListener;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.common.util.NetWorkFrequencyUtils;
import com.tradplus.ads.core.AdCacheManager;
import com.tradplus.ads.core.HbTokenManager;
import com.tradplus.ads.core.cache.AdCache;
import com.tradplus.ads.core.factory.CustomEventFactory;
import com.tradplus.ads.core.track.LoadLifecycleCallback;
import com.tradplus.ads.mobileads.TradPlusErrorCode;
import com.tradplus.ads.network.response.ConfigResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AdLoadManager {
    private static final int LOAD_STATUS_SUCCESS = 1;
    private static final int LOAD_STATUS_HAS_CACHE = 2;
    private static final int LOAD_STATUS_FAILED = 0;
    private static final int DEFAULT_INTERSTITIAL_TIMEOUT_DELAY = 60000;
    private ArrayList<ConfigResponse.WaterfallBean> mWaterfallBeans;
    private String mAdUnitId;
    private int mCacheNum;
    private volatile int currentIndex;
    private HashMap<ConfigResponse.WaterfallBean, Integer> mLoadFinishLayers;
    private HashMap<String, Runnable> mOverTimeMap;
    private Handler mThreadHandler;

    AdLoadManager(String string, ArrayList<ConfigResponse.WaterfallBean> arrayList, int n) {
        this.mWaterfallBeans = arrayList;
        this.mCacheNum = n;
        this.mAdUnitId = string;
        this.mThreadHandler = TPTaskManager.getInstance().getThreadHandler();
        this.mOverTimeMap = new HashMap();
        this.mLoadFinishLayers = new HashMap();
    }

    void loadWaterfall(LoadLifecycleCallback loadLifecycleCallback) {
        this.currentIndex = 0;
        this.mLoadFinishLayers.clear();
        if (this.mCacheNum > this.mWaterfallBeans.size()) {
            this.mCacheNum = this.mWaterfallBeans.size();
        }
        loadLifecycleCallback.loadEnd("1");
        for (int i = 0; i < this.mCacheNum; ++i) {
            AdLoadManager adLoadManager = this;
            adLoadManager.loadLayerAd(adLoadManager.currentIndex++, loadLifecycleCallback);
        }
    }

    private void loadLayerAd(int n, LoadLifecycleCallback loadLifecycleCallback) {
        if (n >= this.mWaterfallBeans.size()) {
            return;
        }
        ConfigResponse.WaterfallBean waterfallBean = this.mWaterfallBeans.get(n);
        if (waterfallBean == null) {
            this.loadAdLoadFailed(null, null, loadLifecycleCallback, "9", null);
            return;
        }
        if (!NetWorkFrequencyUtils.getInstance().checkNetworkFrequency(waterfallBean)) {
            this.loadAdLoadFailed(waterfallBean, null, loadLifecycleCallback, "4", null);
            return;
        }
        AdCache adCache = AdCacheManager.getInstance().isExistCache(this.mAdUnitId, waterfallBean);
        if (adCache != null) {
            this.currentLayerHasCache(adCache, waterfallBean, loadLifecycleCallback);
            return;
        }
        adCache = CustomEventFactory.create(waterfallBean.getCustomClassName());
        if (adCache == null) {
            this.loadAdLoadFailed(waterfallBean, null, loadLifecycleCallback, "13", null);
            return;
        }
        a a2 = new a((TPBaseAdapter)adCache, loadLifecycleCallback);
        int n2 = this.mWaterfallBeans.indexOf(waterfallBean);
        adCache.initAdapter(this.mAdUnitId, waterfallBean, n2, a2);
        this.loadAdapterOnThread((TPBaseAdapter)adCache, loadLifecycleCallback, waterfallBean);
    }

    private void loadAdapterOnThread(final TPBaseAdapter tPBaseAdapter, final LoadLifecycleCallback loadLifecycleCallback, final ConfigResponse.WaterfallBean waterfallBean) {
        TPTaskManager.getInstance().runOnMainThread(new Runnable(){

            @Override
            public final void run() {
                try {
                    AdLoadManager.this.startOverTimeRunnable(tPBaseAdapter, loadLifecycleCallback, waterfallBean);
                    loadLifecycleCallback.loadNetWorkStart(waterfallBean, tPBaseAdapter);
                    tPBaseAdapter.loadAd();
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    AdLoadManager.this.loadAdLoadFailed(waterfallBean, tPBaseAdapter, loadLifecycleCallback, "18", null);
                    return;
                }
            }
        });
    }

    private synchronized void startOverTimeRunnable(TPBaseAdapter object, LoadLifecycleCallback loadLifecycleCallback, final ConfigResponse.WaterfallBean waterfallBean) {
        object = new Runnable((TPBaseAdapter)object, loadLifecycleCallback){
            final /* synthetic */ TPBaseAdapter b;
            final /* synthetic */ LoadLifecycleCallback c;
            {
                this.b = tPBaseAdapter;
                this.c = loadLifecycleCallback;
            }

            @Override
            public final void run() {
                AdLoadManager.this.endOverTimeRunnable(waterfallBean.getAdsource_placement_id());
                AdLoadManager.this.loadAdLoadFailed(waterfallBean, this.b, this.c, "3", null);
            }
        };
        long l = 60000L;
        if (waterfallBean.getLoadTimeout() > 0L && waterfallBean.getLoadTimeout() <= 300L) {
            l = waterfallBean.getLoadTimeout() * 1000L;
        }
        LogUtil.ownShow((String)"AdLoadManager startOverTimeRunnable timeout:".concat(String.valueOf(l)));
        this.mThreadHandler.postDelayed((Runnable)object, l);
        this.mOverTimeMap.put(waterfallBean.getAdsource_placement_id(), (Runnable)object);
    }

    private synchronized void endOverTimeRunnable(String string) {
        Runnable runnable = this.mOverTimeMap.get(string);
        if (runnable != null) {
            this.mThreadHandler.removeCallbacks(runnable);
        }
        this.mOverTimeMap.remove(string);
    }

    private synchronized void loadAdLoaded(TPBaseAd tPBaseAd, TPBaseAdapter object, LoadLifecycleCallback loadLifecycleCallback) {
        ConfigResponse.WaterfallBean waterfallBean = object.getWaterfallBean();
        if (this.mLoadFinishLayers.containsKey(waterfallBean)) {
            return;
        }
        this.mLoadFinishLayers.put(waterfallBean, 1);
        this.endOverTimeRunnable(object.getAdSourcePid());
        this.saveHighPrice(waterfallBean);
        AdCache adCache = new AdCache();
        adCache.setAdapter((TPBaseAdapter)object);
        adCache.setAdObj(tPBaseAd);
        adCache.setCallback(loadLifecycleCallback);
        adCache.setConfigBean(waterfallBean);
        adCache.setStatus(0);
        AdCacheManager.getInstance().saveWaterfallCache(this.mAdUnitId, adCache, this.mWaterfallBeans);
        loadLifecycleCallback.loadNetWorkEnd(adCache, object.getWaterfallBean(), (TPBaseAdapter)object, "1", null);
        if (waterfallBean.getPayLoadInfo() != null) {
            HbTokenManager.getInstance(this.mAdUnitId).sendWinOrDisplayNotification(true, waterfallBean, loadLifecycleCallback);
        }
        int n = 0;
        object = this.mLoadFinishLayers.entrySet().iterator();
        while (object.hasNext()) {
            if ((Integer)((Map.Entry)object.next()).getValue() != 1) continue;
            ++n;
        }
        if (n == this.mCacheNum || this.mLoadFinishLayers.size() == this.mWaterfallBeans.size()) {
            loadLifecycleCallback.loadAllNetwork("1");
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void loadAdLoadFailed(ConfigResponse.WaterfallBean object, TPBaseAdapter object22, LoadLifecycleCallback loadLifecycleCallback, String string, String string2) {
        void var5_7;
        void var4_6;
        void var3_5;
        if (object == null) {
            this.mLoadFinishLayers.put(new ConfigResponse.WaterfallBean(), 0);
        } else {
            if (this.mLoadFinishLayers.containsKey(object)) {
                return;
            }
            this.mLoadFinishLayers.put((ConfigResponse.WaterfallBean)object, 0);
            this.endOverTimeRunnable(object.getAdsource_placement_id());
            if (object.getPayLoadInfo() != null && object22 != null) {
                HbTokenManager.getInstance(this.mAdUnitId).sendLosNotification("1", object.getPayLoadInfo(), (LoadLifecycleCallback)var3_5);
            }
        }
        var3_5.loadNetWorkEnd(null, (ConfigResponse.WaterfallBean)object, (TPBaseAdapter)object22, (String)var4_6, (String)var5_7);
        if (this.mLoadFinishLayers.size() == this.mWaterfallBeans.size()) {
            for (Map.Entry entry : this.mLoadFinishLayers.entrySet()) {
                if ((Integer)entry.getValue() != 1 && (Integer)entry.getValue() != 2) continue;
                var3_5.loadAllNetwork("1");
                return;
            }
            var3_5.loadAllNetwork("11");
            return;
        }
        if (this.currentIndex >= this.mWaterfallBeans.size()) {
            return;
        }
        AdLoadManager adLoadManager = this;
        adLoadManager.loadLayerAd(adLoadManager.currentIndex++, (LoadLifecycleCallback)var3_5);
    }

    private void currentLayerHasCache(AdCache adCache, ConfigResponse.WaterfallBean waterfallBean, LoadLifecycleCallback loadLifecycleCallback) {
        AdCacheManager.getInstance().removeCache(this.mAdUnitId, waterfallBean.getAdsource_placement_id());
        AdCacheManager.getInstance().saveWaterfallCache(this.mAdUnitId, adCache, this.mWaterfallBeans);
        loadLifecycleCallback.currentLayerHasCache(adCache);
        this.mLoadFinishLayers.put(waterfallBean, 2);
        int n = 0;
        Iterator<Map.Entry<ConfigResponse.WaterfallBean, Integer>> iterator = this.mLoadFinishLayers.entrySet().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getValue() != 1) continue;
            ++n;
        }
        this.saveHighPrice(waterfallBean);
        if (n == this.mCacheNum || this.mLoadFinishLayers.size() == this.mWaterfallBeans.size()) {
            loadLifecycleCallback.loadAllNetwork("1");
            return;
        }
        if (this.currentIndex >= this.mWaterfallBeans.size()) {
            return;
        }
        AdLoadManager adLoadManager = this;
        adLoadManager.loadLayerAd(adLoadManager.currentIndex++, loadLifecycleCallback);
    }

    private void saveHighPrice(ConfigResponse.WaterfallBean object) {
        int n = this.mWaterfallBeans.indexOf(object);
        String string = object = object.getPayLoadInfo() == null ? String.valueOf(object.getEcpm()) : String.valueOf(object.getPayLoadInfo().getExt().getValue());
        while (n < this.mWaterfallBeans.size() - 1) {
            String string2;
            ConfigResponse.WaterfallBean waterfallBean;
            if ((waterfallBean = this.mWaterfallBeans.get(++n)).getPayLoadInfo() == null || (string2 = waterfallBean.getPayLoadInfo().getHighPrice()) != null && string2.length() > 0 && !string2.equals("0")) continue;
            waterfallBean.getPayLoadInfo().setHighPrice((String)object);
        }
    }

    final class a
    implements TPLoadAdapterListener {
        TPBaseAdapter a;
        LoadLifecycleCallback b;

        a(TPBaseAdapter tPBaseAdapter, LoadLifecycleCallback loadLifecycleCallback) {
            this.a = tPBaseAdapter;
            this.b = loadLifecycleCallback;
        }

        public final void loadAdapterLoaded(final TPBaseAd tPBaseAd) {
            TPTaskManager.getInstance().runOnThread(new Runnable(){

                @Override
                public final void run() {
                    AdLoadManager.this.loadAdLoaded(tPBaseAd, a.this.a, a.this.b);
                }
            });
        }

        public final void loadAdapterLoadFailed(final TradPlusErrorCode tradPlusErrorCode) {
            TPTaskManager.getInstance().runOnThread(new Runnable(){

                /*
                 * Unable to fully structure code
                 */
                @Override
                public final void run() {
                    if (tradPlusErrorCode == null) ** GOTO lbl-1000
                    if (tradPlusErrorCode == TradPlusErrorCode.NETWORK_TIMEOUT) {
                        var1_1 = "3";
                    } else if (tradPlusErrorCode == TradPlusErrorCode.NO_CONFIG) {
                        var1_1 = "12";
                    } else if (tradPlusErrorCode == TradPlusErrorCode.ADAPTER_CONFIGURATION_ERROR) {
                        var1_1 = "17";
                    } else lbl-1000:
                    // 2 sources

                    {
                        var1_1 = "2";
                    }
                    var2_2 = new StringBuilder();
                    var2_2.append("errCode:");
                    var2_2.append(tradPlusErrorCode == null ? "0" : tradPlusErrorCode.getCode());
                    var2_2.append(",errMsg:");
                    var2_2.append(tradPlusErrorCode == null ? "unknown error" : tradPlusErrorCode.getErrormessage());
                    AdLoadManager.access$100(AdLoadManager.this, a.this.a.getWaterfallBean(), a.this.a, a.this.b, var1_1, var2_2.toString());
                }
            });
        }
    }
}

