/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.core;

import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.common.Util;
import com.tradplus.ads.base.config.BiddingLoadManager;
import com.tradplus.ads.base.config.request.BiddingRequestInfo;
import com.tradplus.ads.base.config.response.BiddingResponse;
import com.tradplus.ads.base.filter.NetWorkFrequencyUtils;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.core.AdCacheManager;
import com.tradplus.ads.core.HbLoadManager;
import com.tradplus.ads.core.factory.CustomEventFactory;
import com.tradplus.ads.core.track.LoadLifecycleCallback;
import com.tradplus.ads.mobileads.TradPlus;
import com.tradplus.ads.mobileads.util.TradPlusInterstitialConstants;
import com.tradplus.ads.network.response.ConfigResponse;
import com.tradplus.ads.volley.NetworkError;
import com.tradplus.ads.volley.TimeoutError;
import com.tradplus.ads.volley.VolleyError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HbTokenManager {
    private static final int DEBUG_TIMEOUT_PAYLOAD = 300000;
    private String mAdUnitId;
    private ConfigResponse mResponse;
    private a mListener;

    public HbTokenManager(String string) {
        this.mAdUnitId = string;
    }

    void startBidding(ConfigResponse object, LoadLifecycleCallback loadLifecycleCallback, a a2) {
        this.mResponse = object;
        this.mListener = a2;
        ArrayList arrayList = this.mResponse.getBiddingwaterfall();
        if (arrayList == null || arrayList.size() <= 0) {
            a2.a(object.getWaterfall());
            LogUtil.ownShow((String)"HbTokenManager startBidding hbBeans is null");
            return;
        }
        object = new ArrayList(arrayList);
        this.changeThreadAndRequest((ArrayList<ConfigResponse.WaterfallBean>)object, loadLifecycleCallback);
    }

    private void changeThreadAndRequest(final ArrayList<ConfigResponse.WaterfallBean> arrayList, final LoadLifecycleCallback loadLifecycleCallback) {
        TPTaskManager.getInstance().runOnThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void run() {
                HbTokenManager hbTokenManager = HbTokenManager.this;
                synchronized (hbTokenManager) {
                    HbTokenManager.this.startRequestToken(arrayList, loadLifecycleCallback);
                    return;
                }
            }
        });
    }

    public static void removeUnLoadBiddingPayload(String string, int n, ArrayList<ConfigResponse.WaterfallBean> arrayList, LoadLifecycleCallback loadLifecycleCallback) {
        LogUtil.ownShow((String)("waterfallBeans = " + arrayList.size() + " index = " + n));
        if (n >= arrayList.size()) {
            return;
        }
        AdCacheManager.getInstance().checkAdCacheTimeout(string);
        while (n < arrayList.size()) {
            ConfigResponse.WaterfallBean waterfallBean = arrayList.get(n);
            if (waterfallBean.getNew_sort_type() == 9 && AdCacheManager.getInstance().isExistCache(string, waterfallBean) == null && waterfallBean.getPayLoadInfo() != null) {
                HbTokenManager.sendLosNotification("102", waterfallBean, loadLifecycleCallback);
                waterfallBean.setPayLoadInfo(null);
            }
            ++n;
        }
    }

    private void startRequestToken(ArrayList<ConfigResponse.WaterfallBean> arrayList, LoadLifecycleCallback loadLifecycleCallback) {
        Object object;
        Object object2;
        HbTokenManager.removeUnLoadBiddingPayload(this.mAdUnitId, 0, this.mResponse.getBiddingwaterfall(), loadLifecycleCallback);
        BiddingRequestInfo biddingRequestInfo = BiddingRequestInfo.getBiddingInfo((String)this.mAdUnitId, (int)this.mResponse.getBiddingTimeout(), (String)loadLifecycleCallback.getRequestId());
        List list = biddingRequestInfo.getAdsourceplacements();
        HashMap<ConfigResponse.WaterfallBean, Long> hashMap = new HashMap<ConfigResponse.WaterfallBean, Long>();
        for (ConfigResponse.WaterfallBean object3 : arrayList) {
            if (!NetWorkFrequencyUtils.getInstance().checkNetworkFrequency(object3)) continue;
            if ("40".equals(object3.getId())) {
                this.prepareRequestInfo(biddingRequestInfo, object3);
            }
            LogUtil.ownShow((String)("requestInfo = " + JSON.toJSONString((Object)biddingRequestInfo)));
            object2 = CustomEventFactory.create(object3.getCustomClassName());
            if (object2 == null) continue;
            try {
                object2.initAdapter(this.mAdUnitId, object3, -1, null);
                object = object2.getBiddingToken();
                LogUtil.ownShow((String)"bidding token = ".concat(String.valueOf(object)));
                Object object4 = object2.getNetworkVersion();
                object2 = object2.getBiddingNetworkInfo();
                object4 = new BiddingRequestInfo.AdSourcePlacements(object3, (String)object, (String)object4, (String)object2);
                list.add(object4);
            }
            catch (Throwable throwable) {
                continue;
            }
            loadLifecycleCallback.startBiddingEvent(object3);
            hashMap.put(object3, System.currentTimeMillis());
        }
        List list2 = biddingRequestInfo.getBiddingwaterfall();
        for (Object object4 : this.mResponse.getWaterfall()) {
            object2 = new BiddingRequestInfo.BiddingWaterfall();
            object2.setId(Util.parseToInteger((String)object4.getAdsource_placement_id()));
            object2.setValue(String.valueOf(object4.getEcpm()));
            list2.add(object2);
        }
        for (Object object4 : arrayList) {
            object2 = object4.getPayLoadInfo();
            if (this.checkPayLoadInfoValid((BiddingResponse.PayLoadInfo)object2)) {
                object = new BiddingRequestInfo.BiddingWaterfall();
                object.setId(object2.getId());
                object.setValue(object2.getExt().getValue());
                list2.add(object);
                object4.setPayLoadInfo((BiddingResponse.PayLoadInfo)object2);
                continue;
            }
            if (object2 == null) continue;
            HbTokenManager.sendLosNotification("102", object4, loadLifecycleCallback);
        }
        if (list.size() <= 0) {
            this.mListener.a(this.mResponse.getWaterfall());
            LogUtil.ownShow((String)"HbTokenManager startRequestToken request list is null");
            return;
        }
        this.startBidding(biddingRequestInfo, loadLifecycleCallback, hashMap);
    }

    private void startBidding(BiddingRequestInfo biddingRequestInfo, final LoadLifecycleCallback loadLifecycleCallback, final HashMap<ConfigResponse.WaterfallBean, Long> hashMap) {
        BiddingLoadManager.getInstance().loadBiddingRequest(biddingRequestInfo, new BiddingLoadManager.BiddingLoadListener(){

            public final void onSuccess(BiddingResponse biddingResponse) {
                HbTokenManager.this.mergeHbWaterfall(biddingResponse, loadLifecycleCallback);
                HbTokenManager.this.trackBiddingEndEvent(biddingResponse, hashMap, loadLifecycleCallback);
            }

            public final void onFailed(VolleyError volleyError) {
                if (volleyError != null) {
                    LogUtil.ownShow((String)("HbTokenManager startBidding onFailed error:" + volleyError.getMessage()));
                }
                HbTokenManager.this.trackBiddingEndEvent(null, hashMap, loadLifecycleCallback);
                HbTokenManager.this.mListener.a(HbTokenManager.this.mResponse.getWaterfall());
            }
        });
    }

    private void mergeHbWaterfall(BiddingResponse biddingResponse, LoadLifecycleCallback object) {
        Object object22;
        Object object32;
        if (biddingResponse == null) {
            this.mListener.a(this.mResponse.getWaterfall());
            LogUtil.ownShow((String)"HbTokenManager mergeHbWaterfall response is null");
            return;
        }
        ArrayList arrayList = biddingResponse.getAdsourceplacements();
        if (arrayList == null || arrayList.size() <= 0) {
            this.mListener.a(this.mResponse.getWaterfall());
            LogUtil.ownShow((String)"HbTokenManager mergeHbWaterfall response Adsourceplacements is null");
            return;
        }
        for (Object object32 : this.mResponse.getBiddingwaterfall()) {
            for (Object object22 : arrayList) {
                if (!object32.getAdsource_placement_id().equals(String.valueOf(object22.getId()))) continue;
                this.checkAndStartCountdown((ConfigResponse.WaterfallBean)object32, (BiddingResponse.PayLoadInfo)object22, (LoadLifecycleCallback)object);
            }
        }
        ArrayList arrayList2 = new ArrayList();
        object32 = new ArrayList();
        arrayList2.addAll(this.mResponse.getWaterfall());
        arrayList2.addAll(this.mResponse.getBiddingwaterfall());
        ArrayList arrayList3 = biddingResponse.getBiddingWaterfall();
        if (arrayList3 == null || arrayList3.size() <= 0) {
            this.mListener.a(this.mResponse.getWaterfall());
            LogUtil.ownShow((String)"HbTokenManager mergeHbWaterfall response biddingWaterfall is null");
            return;
        }
        object22 = arrayList3.iterator();
        block2: while (object22.hasNext()) {
            biddingResponse = (BiddingResponse.BiddingWaterfall)object22.next();
            object = arrayList2.iterator();
            while (object.hasNext()) {
                arrayList = (ConfigResponse.WaterfallBean)object.next();
                boolean bl = this.checkPayLoadInfoValid(arrayList.getPayLoadInfo());
                if (arrayList.getNew_sort_type() == 9 && !bl) {
                    LogUtil.ownShow((String)("HbTokenManager mergeHbWaterfall bidWaterfall payload is null break\uff1a" + arrayList.getAdsource_placement_id()));
                    continue;
                }
                if (!arrayList.getAdsource_placement_id().equals(String.valueOf(biddingResponse.getId()))) continue;
                ((ArrayList)object32).add(arrayList);
                continue block2;
            }
        }
        LogUtil.ownShow((String)"HbTokenManager mergeHbWaterfall result waterfall:");
        LogUtil.ownShow((String)JSON.toJSONString((Object)object32));
        this.mListener.a((ArrayList<ConfigResponse.WaterfallBean>)object32);
    }

    private void startLoadHbAd(ArrayList<ConfigResponse.WaterfallBean> arrayList, LoadLifecycleCallback loadLifecycleCallback) {
        new HbLoadManager(this.mAdUnitId, arrayList, this.mResponse.getCacheNum(), this.mResponse.getHbCacheNum()).loadHbAd(loadLifecycleCallback);
    }

    private boolean checkAndStartCountdown(ConfigResponse.WaterfallBean waterfallBean, BiddingResponse.PayLoadInfo payLoadInfo, LoadLifecycleCallback loadLifecycleCallback) {
        if (payLoadInfo != null && payLoadInfo.getIsbid() == 1 && payLoadInfo.getNbr() == 35) {
            loadLifecycleCallback.sendLossNotification(waterfallBean, "1", "102");
            return false;
        }
        if (payLoadInfo != null && payLoadInfo.getNbr() == 40) {
            BiddingResponse.PayLoadInfo payLoadInfo2 = waterfallBean.getPayLoadInfo();
            if (payLoadInfo2 != null) {
                HbTokenManager.sendLosNotification(AdCacheManager.getInstance().removeHbCache(this.mAdUnitId, payLoadInfo2) ? "4902" : "102", waterfallBean, loadLifecycleCallback);
            } else {
                loadLifecycleCallback.sendLossNotification(waterfallBean, "1", "102");
            }
            return false;
        }
        if (!this.checkPayLoadInfoValid(payLoadInfo)) {
            return false;
        }
        long l = waterfallBean.getPayloadTimeout() * 1000L;
        if (TradPlus.getLocalDebugMode()) {
            l = 300000L;
        }
        payLoadInfo.setValidTime(l);
        payLoadInfo.setStartTime(System.currentTimeMillis());
        BiddingResponse.PayLoadInfo payLoadInfo3 = waterfallBean.getPayLoadInfo();
        if (payLoadInfo3 != null) {
            payLoadInfo3.setHighPrice(payLoadInfo.getExt().getValue());
            payLoadInfo3.setHighaspid(waterfallBean.getAdsource_placement_id());
            HbTokenManager.sendLosNotification(AdCacheManager.getInstance().removeHbCache(this.mAdUnitId, payLoadInfo3) ? "4902" : "102", waterfallBean, loadLifecycleCallback);
        }
        waterfallBean.setPayLoadInfo(payLoadInfo);
        return true;
    }

    public static void sendLosNotification(final String string, final ConfigResponse.WaterfallBean waterfallBean, final LoadLifecycleCallback loadLifecycleCallback) {
        if (waterfallBean == null) {
            return;
        }
        BiddingResponse.PayLoadInfo payLoadInfo = waterfallBean.getPayLoadInfo();
        String string2 = "";
        if (payLoadInfo != null) {
            if (payLoadInfo.getExt() != null) {
                string2 = payLoadInfo.getExt().getValue();
            }
            if ("102".equals(string)) {
                string2 = payLoadInfo.getHighPrice();
            }
        } else {
            return;
        }
        BiddingLoadManager.getInstance().biddingNotification(string, string2, payLoadInfo.getHighaspid(), payLoadInfo.getLurl(), new BiddingLoadManager.BiddingNotificationListener(){

            public final void onSuccess(String string2) {
                loadLifecycleCallback.sendLossNotification(waterfallBean, "1", string);
            }

            public final void onFailed(VolleyError volleyError) {
                String string2 = "2";
                if (volleyError instanceof TimeoutError) {
                    string2 = "3";
                } else if (volleyError instanceof NetworkError) {
                    string2 = "7";
                }
                loadLifecycleCallback.sendLossNotification(waterfallBean, string2, string);
            }
        });
    }

    public static void sendWinOrDisplayNotification(final boolean bl, TPBaseAdapter tPBaseAdapter, final LoadLifecycleCallback loadLifecycleCallback) {
        BiddingResponse.PayLoadInfo payLoadInfo = (BiddingResponse.PayLoadInfo)JSON.parseObject((String)tPBaseAdapter.getPayLoadStr(), BiddingResponse.PayLoadInfo.class);
        String string = payLoadInfo.getExt().getValue();
        BiddingLoadManager biddingLoadManager = BiddingLoadManager.getInstance();
        if (bl) {
            payLoadInfo.setWined(true);
        }
        tPBaseAdapter = tPBaseAdapter.getWaterfallBean();
        biddingLoadManager.biddingNotification("0", string, payLoadInfo.getHighaspid(), bl ? payLoadInfo.getNurl() : payLoadInfo.getImpurl(), new BiddingLoadManager.BiddingNotificationListener((ConfigResponse.WaterfallBean)tPBaseAdapter){
            final /* synthetic */ ConfigResponse.WaterfallBean c;
            {
                this.c = waterfallBean;
            }

            public final void onSuccess(String string) {
                if (bl) {
                    loadLifecycleCallback.sendWinNotification(this.c, "1");
                    return;
                }
                loadLifecycleCallback.sendDisPlayNotification(this.c, "1");
            }

            public final void onFailed(VolleyError volleyError) {
                String string = "2";
                if (volleyError instanceof TimeoutError) {
                    string = "3";
                } else if (volleyError instanceof NetworkError) {
                    string = "7";
                }
                if (bl) {
                    loadLifecycleCallback.sendWinNotification(this.c, string);
                    return;
                }
                loadLifecycleCallback.sendDisPlayNotification(this.c, string);
            }
        });
    }

    public static boolean checkPayLoadInfoExist(ConfigResponse.WaterfallBean waterfallBean) {
        if (waterfallBean == null) {
            return false;
        }
        if (waterfallBean.getPayLoadInfo() != null) {
            if ((waterfallBean = waterfallBean.getPayLoadInfo()) == null) {
                return false;
            }
            return waterfallBean.getAdm() != null || waterfallBean.getPayload() != null;
        }
        return true;
    }

    private boolean checkPayLoadInfoValid(BiddingResponse.PayLoadInfo payLoadInfo) {
        if (payLoadInfo == null) {
            return false;
        }
        if (payLoadInfo.getAdm() == null && payLoadInfo.getPayload() == null) {
            return false;
        }
        if (payLoadInfo.getIsbid() != 1) {
            return false;
        }
        if (AdCacheManager.getInstance().isExistHbCache(this.mAdUnitId, payLoadInfo) != null) {
            return true;
        }
        long l = payLoadInfo.getStartTime();
        long l2 = payLoadInfo.getValidTime();
        if (l == 0L) {
            return true;
        }
        LogUtil.ownShow((String)("HbTokenManager checkPayLoadInfoValid startTime:" + l + " validTime:" + l2));
        return l + l2 >= System.currentTimeMillis();
    }

    private void trackBiddingEndEvent(BiddingResponse biddingResponse, HashMap<ConfigResponse.WaterfallBean, Long> object, LoadLifecycleCallback loadLifecycleCallback) {
        for (Map.Entry entry : ((HashMap)((Object)object)).entrySet()) {
            if (biddingResponse == null) {
                loadLifecycleCallback.endBiddingEvent((ConfigResponse.WaterfallBean)entry.getKey(), null, (Long)entry.getValue());
                continue;
            }
            Object object2 = biddingResponse.getAdsourceplacements();
            if (object2 == null || ((ArrayList)object2).size() <= 0) continue;
            object2 = ((ArrayList)object2).iterator();
            while (object2.hasNext()) {
                BiddingResponse.PayLoadInfo payLoadInfo = (BiddingResponse.PayLoadInfo)object2.next();
                if (!((ConfigResponse.WaterfallBean)entry.getKey()).getAdsource_placement_id().equals(String.valueOf(payLoadInfo.getId()))) continue;
                loadLifecycleCallback.endBiddingEvent((ConfigResponse.WaterfallBean)entry.getKey(), payLoadInfo, (Long)entry.getValue());
            }
        }
    }

    private void prepareRequestInfo(BiddingRequestInfo biddingRequestInfo, ConfigResponse.WaterfallBean waterfallBean) {
        if (TradPlusInterstitialConstants.isBannerType((String)this.mResponse.getAdType())) {
            waterfallBean = new BiddingRequestInfo.Imp.Banner();
            ((BiddingRequestInfo.Imp)biddingRequestInfo.getImp().get(0)).setBanner((BiddingRequestInfo.Imp.Banner)waterfallBean);
            return;
        }
        if (TradPlusInterstitialConstants.isRewardType((String)this.mResponse.getAdType()) || TradPlusInterstitialConstants.isInterstitialType((String)this.mResponse.getAdType())) {
            if (TradPlusInterstitialConstants.isInterstitialType((String)this.mResponse.getAdType())) {
                ((BiddingRequestInfo.Imp)biddingRequestInfo.getImp().get(0)).setInstl(1);
            } else {
                waterfallBean = new BiddingRequestInfo.Imp.Video(TradPlusInterstitialConstants.isRewardType((String)this.mResponse.getAdType()) ? 1 : 0);
                ((BiddingRequestInfo.Imp)biddingRequestInfo.getImp().get(0)).setVideo((BiddingRequestInfo.Imp.Video)waterfallBean);
            }
            waterfallBean = new BiddingRequestInfo.Imp.Banner();
            ((BiddingRequestInfo.Imp)biddingRequestInfo.getImp().get(0)).setBanner((BiddingRequestInfo.Imp.Banner)waterfallBean);
            return;
        }
        if (TradPlusInterstitialConstants.isNativeType((String)this.mResponse.getAdType())) {
            waterfallBean = new BiddingRequestInfo.Imp.NativeAd();
            ((BiddingRequestInfo.Imp)biddingRequestInfo.getImp().get(0)).setNativead((BiddingRequestInfo.Imp.NativeAd)waterfallBean);
        }
    }

    static interface a {
        public void a(ArrayList<ConfigResponse.WaterfallBean> var1);
    }
}

