/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.core;

import android.os.Handler;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.adapter.TPLoadAdapterListener;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.LoadMode;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.filter.NetWorkFrequencyUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.core.AdCacheManager;
import com.tradplus.ads.core.AdIntervalManager;
import com.tradplus.ads.core.cache.AdCache;
import com.tradplus.ads.core.factory.CustomEventFactory;
import com.tradplus.ads.core.track.LoadLifecycleCallback;
import com.tradplus.ads.network.response.ConfigResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public class BottomAdLoadManager {
    private static final int LOAD_STATUS_SUCCESS = 1;
    private static final int LOAD_STATUS_HAS_CACHE = 2;
    private static final int LOAD_STATUS_FAILED = 0;
    private static final int DEFAULT_INTERSTITIAL_TIMEOUT_DELAY = 60000;
    private ArrayList<ConfigResponse.WaterfallBean> mWaterfallBeans;
    private String mAdUnitId;
    private volatile int currentIndex;
    private ConcurrentHashMap<String, Runnable> mOverTimeMap;
    private Handler mThreadHandler;
    private int op;
    private LoadMode loadMode;
    private int bottomLoadedCallbackTime;
    private long startLoadAdTime;
    private HashMap<ConfigResponse.WaterfallBean, Integer> mLoadFinishLayers;

    BottomAdLoadManager(String string, ArrayList<ConfigResponse.WaterfallBean> arrayList, int n, LoadMode loadMode, int n2) {
        this.mWaterfallBeans = arrayList;
        this.mAdUnitId = string;
        this.mThreadHandler = TPTaskManager.getInstance().getThresholdThreadHandler();
        this.mOverTimeMap = new ConcurrentHashMap();
        this.op = n;
        this.loadMode = loadMode;
        this.bottomLoadedCallbackTime = n2 * 1000;
        this.startLoadAdTime = System.currentTimeMillis();
        this.mLoadFinishLayers = new HashMap();
    }

    void loadWaterfall(LoadLifecycleCallback loadLifecycleCallback) {
        this.currentIndex = 0;
        this.mLoadFinishLayers.clear();
        BottomAdLoadManager bottomAdLoadManager = this;
        bottomAdLoadManager.loadLayerAd(bottomAdLoadManager.currentIndex++, loadLifecycleCallback);
    }

    private void loadLayerAd(int n, LoadLifecycleCallback loadLifecycleCallback) {
        if (n >= this.mWaterfallBeans.size()) {
            return;
        }
        ConfigResponse.WaterfallBean waterfallBean = this.mWaterfallBeans.get(n);
        if (waterfallBean == null) {
            this.loadAdLoadFailed(null, null, loadLifecycleCallback, "9", null, 0L);
            return;
        }
        if (!NetWorkFrequencyUtils.getInstance().checkNetworkFrequency(waterfallBean)) {
            this.loadAdLoadFailed(waterfallBean, null, loadLifecycleCallback, "4", null, 0L);
            return;
        }
        AdCache adCache = AdCacheManager.getInstance().isExistCache(this.mAdUnitId, waterfallBean);
        if (adCache != null) {
            this.currentLayerHasCache(adCache, waterfallBean, loadLifecycleCallback);
            return;
        }
        adCache = CustomEventFactory.create(waterfallBean.getCustomClassName());
        if (adCache == null) {
            this.loadAdLoadFailed(waterfallBean, null, loadLifecycleCallback, "13", null, 0L);
            return;
        }
        Object object = AdIntervalManager.getInstance(waterfallBean);
        if (object != null && !((AdIntervalManager)object).canLoadToWaterfall()) {
            this.loadAdLoadFailed(waterfallBean, null, loadLifecycleCallback, "1107", null, 0L);
            return;
        }
        object = new a((TPBaseAdapter)adCache, loadLifecycleCallback);
        int n2 = this.mWaterfallBeans.indexOf(waterfallBean);
        adCache.setRequestId(loadLifecycleCallback.getRequestId());
        adCache.initAdapter(this.mAdUnitId, waterfallBean, n2, (TPLoadAdapterListener)object);
        waterfallBean.setBottomWaterfall(true);
        if (waterfallBean.getIs_main_thread() == 0) {
            this.loadAdapterOnThread((TPBaseAdapter)adCache, loadLifecycleCallback, waterfallBean);
            return;
        }
        this.loadAdapterOnMainThread((TPBaseAdapter)adCache, loadLifecycleCallback, waterfallBean);
    }

    private void loadAdapterOnMainThread(final TPBaseAdapter tPBaseAdapter, final LoadLifecycleCallback loadLifecycleCallback, final ConfigResponse.WaterfallBean waterfallBean) {
        TPTaskManager.getInstance().runOnMainThread(new Runnable(){

            @Override
            public final void run() {
                BottomAdLoadManager.this.loadAd(tPBaseAdapter, loadLifecycleCallback, waterfallBean);
            }
        });
    }

    private void loadAdapterOnThread(final TPBaseAdapter tPBaseAdapter, final LoadLifecycleCallback loadLifecycleCallback, final ConfigResponse.WaterfallBean waterfallBean) {
        TPTaskManager.getInstance().runDyCorePool(new Runnable(){

            @Override
            public final void run() {
                BottomAdLoadManager.this.loadAd(tPBaseAdapter, loadLifecycleCallback, waterfallBean);
            }
        });
    }

    private void loadAd(TPBaseAdapter tPBaseAdapter, LoadLifecycleCallback loadLifecycleCallback, ConfigResponse.WaterfallBean waterfallBean) {
        try {
            this.startOverTimeRunnable(tPBaseAdapter, loadLifecycleCallback, waterfallBean);
            loadLifecycleCallback.loadNetWorkStart(tPBaseAdapter);
            tPBaseAdapter.loadAd();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.loadAdLoadFailed(waterfallBean, tPBaseAdapter, loadLifecycleCallback, "18", null, 0L);
            return;
        }
    }

    private void startOverTimeRunnable(TPBaseAdapter object, LoadLifecycleCallback loadLifecycleCallback, final ConfigResponse.WaterfallBean waterfallBean) {
        long l = 60000L;
        if (waterfallBean.getLoadTimeout() > 0L && waterfallBean.getLoadTimeout() <= 300L) {
            l = waterfallBean.getLoadTimeout() * 1000L;
        }
        object = new Runnable((TPBaseAdapter)object, loadLifecycleCallback){
            final /* synthetic */ TPBaseAdapter b;
            final /* synthetic */ LoadLifecycleCallback c;
            {
                this.b = tPBaseAdapter;
                this.c = loadLifecycleCallback;
            }

            @Override
            public final void run() {
                AdIntervalManager adIntervalManager;
                BottomAdLoadManager.this.endOverTimeRunnable(waterfallBean.getAdsource_placement_id());
                if (!BottomAdLoadManager.this.mLoadFinishLayers.containsKey(this.b.getWaterfallBean()) && (adIntervalManager = AdIntervalManager.getInstance(this.b.getWaterfallBean())) != null) {
                    adIntervalManager.loadWaterfallFailed();
                }
                BottomAdLoadManager.this.loadAdLoadFailed(waterfallBean, this.b, this.c, "3", null, 0L);
            }
        };
        LogUtil.ownShow((String)"AdLoadManager startOverTimeRunnable timeout:".concat(String.valueOf(l)));
        this.mThreadHandler.postDelayed((Runnable)object, l);
        this.mOverTimeMap.put(waterfallBean.getAdsource_placement_id(), (Runnable)object);
    }

    private void endOverTimeRunnable(String string) {
        Runnable runnable = this.mOverTimeMap.get(string);
        if (runnable != null) {
            this.mThreadHandler.removeCallbacks(runnable);
        }
        this.mOverTimeMap.remove(string);
    }

    private synchronized void loadAdLoaded(TPBaseAd tPBaseAd, TPBaseAdapter tPBaseAdapter, LoadLifecycleCallback loadLifecycleCallback, AdCache adCache, long l) {
        tPBaseAd = tPBaseAdapter.getWaterfallBean();
        if (this.mLoadFinishLayers.containsKey(tPBaseAd)) {
            return;
        }
        this.mLoadFinishLayers.put((ConfigResponse.WaterfallBean)tPBaseAd, 1);
        this.endOverTimeRunnable(tPBaseAdapter.getAdSourcePid());
        loadLifecycleCallback.loadBottomNetWorkEnd(adCache, tPBaseAdapter.getWaterfallBean(), tPBaseAdapter, "1", null, l);
    }

    private AdCache saveBottomCache(TPBaseAd tPBaseAd, TPBaseAdapter tPBaseAdapter, LoadLifecycleCallback loadLifecycleCallback) {
        ConfigResponse.WaterfallBean waterfallBean = tPBaseAdapter.getWaterfallBean();
        AdCache adCache = new AdCache();
        adCache.setAdapter(tPBaseAdapter);
        adCache.setAdObj(tPBaseAd);
        adCache.setCallback(loadLifecycleCallback);
        adCache.setConfigBean(waterfallBean);
        adCache.setStatus(0);
        adCache.setBottomWaterfall(true);
        adCache.setLoadMode(this.loadMode);
        adCache.setEffectTime(System.currentTimeMillis() + this.getCallbackTime());
        if (loadLifecycleCallback.isLoadAllNetwork()) {
            adCache.setEffectTime(0L);
        }
        AdCacheManager.getInstance().saveBottomCache(this.mAdUnitId, adCache);
        return adCache;
    }

    private synchronized void loadAdLoadFailed(ConfigResponse.WaterfallBean waterfallBean, TPBaseAdapter tPBaseAdapter, LoadLifecycleCallback loadLifecycleCallback, String string, String string2, long l) {
        if (waterfallBean == null) {
            this.mLoadFinishLayers.put(new ConfigResponse.WaterfallBean(), 0);
        } else {
            if (this.mLoadFinishLayers.containsKey(waterfallBean)) {
                return;
            }
            this.mLoadFinishLayers.put(waterfallBean, 0);
            this.endOverTimeRunnable(waterfallBean.getAdsource_placement_id());
        }
        loadLifecycleCallback.loadBottomNetWorkEnd(null, waterfallBean, tPBaseAdapter, string, string2, l);
        BottomAdLoadManager bottomAdLoadManager = this;
        bottomAdLoadManager.loadLayerAd(bottomAdLoadManager.currentIndex++, loadLifecycleCallback);
    }

    private void currentLayerHasCache(AdCache adCache, ConfigResponse.WaterfallBean waterfallBean, LoadLifecycleCallback loadLifecycleCallback) {
        loadLifecycleCallback.currentBottomLayerHasCache(adCache);
        this.mLoadFinishLayers.put(waterfallBean, 2);
    }

    private long getCallbackTime() {
        long l = this.startLoadAdTime;
        long l2 = 0L;
        if (this.bottomLoadedCallbackTime != 0) {
            long l3 = (long)this.bottomLoadedCallbackTime - (System.currentTimeMillis() - l);
            LogUtil.ownShow((String)("tradpluslog endTimeCount = " + l3 + " loadTime = " + l));
            l2 = l3 > 0L ? l3 : 0L;
        }
        LogUtil.ownShow((String)"tradpluslog callbackTime = ".concat(String.valueOf(l2)));
        return l2;
    }

    final class a
    implements TPLoadAdapterListener {
        TPBaseAdapter a;
        LoadLifecycleCallback b;

        a(TPBaseAdapter tPBaseAdapter, LoadLifecycleCallback loadLifecycleCallback) {
            this.a = tPBaseAdapter;
            this.b = loadLifecycleCallback;
        }

        public final void loadAdapterLoaded(final TPBaseAd tPBaseAd) {
            final AdCache adCache = BottomAdLoadManager.this.saveBottomCache(tPBaseAd, this.a, this.b);
            final long l = System.currentTimeMillis() - BottomAdLoadManager.this.startLoadAdTime;
            TPTaskManager.getInstance().getLoadThreadHandler().postDelayed(new Runnable(){

                @Override
                public final void run() {
                    BottomAdLoadManager.this.loadAdLoaded(tPBaseAd, a.this.a, a.this.b, adCache, l);
                }
            }, this.b.isLoadAllNetwork() ? 0L : BottomAdLoadManager.this.getCallbackTime());
        }

        public final void loadAdapterLoadFailed(final TPError tPError) {
            final long l = System.currentTimeMillis() - BottomAdLoadManager.this.startLoadAdTime;
            TPTaskManager.getInstance().getLoadThreadHandler().post(new Runnable(){

                @Override
                public final void run() {
                    AdIntervalManager adIntervalManager;
                    if (!BottomAdLoadManager.this.mLoadFinishLayers.containsKey(a.this.a.getWaterfallBean()) && (adIntervalManager = AdIntervalManager.getInstance(a.this.a.getWaterfallBean())) != null) {
                        adIntervalManager.loadWaterfallFailed();
                    }
                    BottomAdLoadManager.this.loadAdLoadFailed(a.this.a.getWaterfallBean(), a.this.a, a.this.b, tPError.getTpErrorCode(), tPError.getEmsg(), l);
                }
            });
        }
    }
}

