/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.network;

import com.tradplus.ads.base.common.TPError;
import com.tradplus.crosspro.network.base.CPError;

public class CPErrorUtil {
    public static TPError getTradPlusErrorCode(CPError errorCode) {
        TPError tradPlusErrorCode = new TPError();
        switch (errorCode.getCode()) {
            case "301": {
                tradPlusErrorCode.setTpErrorCode("Third-party network failed to provide an ad.");
                break;
            }
            case "201": {
                tradPlusErrorCode.setTpErrorCode("Third-party network failed to respond in a timely manner.");
                break;
            }
            default: {
                tradPlusErrorCode.setTpErrorCode("Unspecified error.");
            }
        }
        tradPlusErrorCode.setErrorCode(errorCode.getCode() + "");
        tradPlusErrorCode.setErrorMessage(errorCode.getDesc());
        return tradPlusErrorCode;
    }

    public static TPError getErrorCode(int code, String msg) {
        TPError tradPlusErrorCode = new TPError("Can not init config data.");
        tradPlusErrorCode.setErrorCode(TPError.parseErrorCode((int)code));
        tradPlusErrorCode.setErrorMessage(msg);
        return tradPlusErrorCode;
    }
}

