/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.manager.resource;

import com.tradplus.crosspro.network.base.CPError;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class CPUrlLoadManager {
    public static final String TAG = CPUrlLoadManager.class.getSimpleName();
    private static CPUrlLoadManager sInstance;
    private List<CPResourceLoadResult> mResourceLoadResultList = new CopyOnWriteArrayList<CPResourceLoadResult>();

    private CPUrlLoadManager() {
    }

    public static synchronized CPUrlLoadManager getInstance() {
        if (sInstance == null) {
            sInstance = new CPUrlLoadManager();
        }
        return sInstance;
    }

    public synchronized void register(CPResourceLoadResult result) {
        this.mResourceLoadResultList.add(result);
    }

    public synchronized void unRegister(CPResourceLoadResult result) {
        int size = this.mResourceLoadResultList.size();
        int removeIndex = -1;
        for (int i = 0; i < size; ++i) {
            if (result != this.mResourceLoadResultList.get(i)) continue;
            removeIndex = i;
            break;
        }
        if (removeIndex != -1) {
            this.mResourceLoadResultList.remove(removeIndex);
        }
    }

    public void notifyDownloadSuccess(String url) {
        if (this.mResourceLoadResultList != null) {
            for (CPResourceLoadResult resourceLoadResult : this.mResourceLoadResultList) {
                resourceLoadResult.onResourceLoadSuccess(url);
            }
        }
    }

    public void notifyDownloadFailed(String url, CPError error) {
        if (this.mResourceLoadResultList != null) {
            for (CPResourceLoadResult resourceLoadResult : this.mResourceLoadResultList) {
                resourceLoadResult.onResourceLoadFailed(url, error);
            }
        }
    }

    public static interface CPResourceLoadResult {
        public void onResourceLoadSuccess(String var1);

        public void onResourceLoadFailed(String var1, CPError var2);
    }
}

