/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.ui;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.View;
import android.view.WindowManager;
import android.widget.RelativeLayout;
import com.tradplus.ads.base.CommonUtil;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.network.response.CPAdResponse;
import com.tradplus.ads.common.util.ResourceUtils;
import com.tradplus.ads.pushcenter.event.EventSendMessageUtil;
import com.tradplus.crosspro.ui.InterstitialView;

public class HalfScreenDialog
extends Dialog {
    private Context context;
    private InterstitialView interstitialView;
    private View.OnClickListener confirmClickListener;
    private RelativeLayout mRoot;

    public HalfScreenDialog(Context context) {
        super(context);
        this.context = context;
    }

    public HalfScreenDialog(Context context, int themeResId) {
        super(context, themeResId);
        this.context = context;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(ResourceUtils.getLayoutIdByName((Context)this.context, (String)"cp_activity_ad"));
        this.mRoot = (RelativeLayout)this.findViewById(CommonUtil.getResId((Context)this.context, (String)"cp_rl_root", (String)"id"));
        this.mRoot.addView((View)this.interstitialView);
        this.setWindowSize();
    }

    public void start(final CPAdResponse cpAdResponse, int orientation, long timeStamp, final String adSourceId, boolean isInterstitial, int screenWidth, int screenHeight, int direction) {
        this.interstitialView = new InterstitialView(this.context);
        this.interstitialView.setCpAdResponse(cpAdResponse);
        this.interstitialView.setmOrientation(orientation);
        this.interstitialView.setAdSourceId(adSourceId);
        this.interstitialView.setInterstitial(isInterstitial);
        this.interstitialView.setTimeStamp(timeStamp);
        this.interstitialView.setDirection(direction);
        this.interstitialView.setmScreenWidth(screenWidth);
        this.interstitialView.setmScreenHeight(screenHeight);
        this.interstitialView.setOnViewFinish(new InterstitialView.OnViewFinish(){

            @Override
            public void onFinish() {
                EventSendMessageUtil.getInstance().sendAdVideoClose(HalfScreenDialog.this.context, cpAdResponse.getCampaign_id(), cpAdResponse.getAd_id(), "1", adSourceId);
                HalfScreenDialog.this.dismiss();
            }
        });
        this.interstitialView.initView();
    }

    private void setWindowSize() {
        int width;
        int height;
        DisplayMetrics dm = new DisplayMetrics();
        Activity activity = GlobalTradPlus.getInstance().getActivity();
        if (activity == null) {
            height = 1920;
            width = 1080;
        } else {
            WindowManager m = activity.getWindowManager();
            m.getDefaultDisplay().getMetrics(dm);
            height = dm.heightPixels;
            width = dm.widthPixels;
        }
        WindowManager.LayoutParams p = this.getWindow().getAttributes();
        p.height = (int)((double)height * 0.7);
        p.width = (int)((double)width * 0.7);
        p.dimAmount = 0.5f;
        this.getWindow().setAttributes(p);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (4 == keyCode) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }
}

