/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.ui.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import java.io.FileDescriptor;

public class CPImageUtil {
    public static Bitmap getBitmap(String path, int maxWidth, int maxHeight) {
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
            options.inSampleSize = CPImageUtil.calculateSampleSize(options.outWidth, options.outHeight, maxWidth, maxHeight);
            options.inJustDecodeBounds = false;
            return BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError options) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Bitmap getBitmap(FileDescriptor fd, int maxWidth, int maxHeight) {
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
            options.inSampleSize = CPImageUtil.calculateSampleSize(options.outWidth, options.outHeight, maxWidth, maxHeight);
            options.inJustDecodeBounds = false;
            return BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError oom) {
            oom.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static int calculateSampleSize(int originWidth, int originHeight, int desWidth, int desHeight) {
        int sampleSize = 1;
        int width = originWidth;
        int height = originHeight;
        while (width / sampleSize > desWidth && height / sampleSize > desHeight) {
            sampleSize *= 2;
        }
        return sampleSize;
    }

    public static Bitmap blurBitmap(Context context, Bitmap bitmap) {
        try {
            Bitmap outBitmap = Bitmap.createBitmap((int)(bitmap.getWidth() / 3), (int)(bitmap.getHeight() / 3), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            RenderScript rs = RenderScript.create((Context)context);
            ScriptIntrinsicBlur blurScript = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)Element.U8_4((RenderScript)rs));
            Allocation allIn = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)bitmap);
            Allocation allOut = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)outBitmap);
            blurScript.setRadius(25.0f);
            blurScript.setInput(allIn);
            blurScript.forEach(allOut);
            allOut.copyTo(outBitmap);
            Canvas c = new Canvas(outBitmap);
            c.drawColor(0x33000000);
            rs.destroy();
            return outBitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

