/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.network;

import android.content.Context;
import android.util.Log;
import com.tradplus.ads.base.adapter.reward.TPRewardAdapter;
import com.tradplus.ads.mobileads.TradPlusErrorCode;
import com.tradplus.ads.network.CPErrorUtil;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import com.tradplus.crosspro.network.base.CPError;
import com.tradplus.crosspro.network.rewardvideo.CPRewardVideoAd;
import com.tradplus.crosspro.network.rewardvideo.CPRewardVideoAdListener;
import java.util.Map;

public class CPADRewardVideoAdapter
extends TPRewardAdapter {
    private Context context;
    private String campaignId;
    private String adSourceId;
    private CPRewardVideoAd cpRewardVideoAd;
    private long timeoutValue = 10800000L;
    private long mFirstLoadTime;
    public static final long TIME_DELTA = 30000L;
    private static String TAG = "CrossPro";
    private int direction;

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        Object d;
        this.context = context;
        if (this.extrasAreValid(tpParams)) {
            this.campaignId = tpParams.get("placementId");
        } else if (this.mLoadAdapterListener != null) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(TradPlusErrorCode.ADAPTER_CONFIGURATION_ERROR);
            return;
        }
        if (tpParams.containsKey("adsource_placement_id")) {
            this.adSourceId = tpParams.get("adsource_placement_id");
        }
        if ((d = userParams.get("direction")) != null) {
            this.direction = Integer.parseInt(String.valueOf(d));
        }
        this.cpRewardVideoAd = new CPRewardVideoAd(context, this.campaignId, this.adSourceId);
        this.cpRewardVideoAd.setCpRewardVideoAdListener(new CPRewardVideoAdListener(){

            @Override
            public void onVideoAdPlayStart() {
                Log.i((String)TAG, (String)"onVideoAdPlayStart: ");
            }

            @Override
            public void onVideoAdPlayEnd() {
                Log.i((String)TAG, (String)"onVideoAdPlayEnd: ");
            }

            @Override
            public void onVideoShowFailed(CPError error) {
                Log.i((String)TAG, (String)"onVideoShowFailed: ");
                if (CPADRewardVideoAdapter.this.mShowListener != null) {
                    CPADRewardVideoAdapter.this.mShowListener.onAdVideoError(CPErrorUtil.getTradPlusErrorCode(error));
                }
            }

            @Override
            public void onRewarded() {
                Log.i((String)TAG, (String)"onRewarded: ");
                if (CPADRewardVideoAdapter.this.mShowListener != null) {
                    CPADRewardVideoAdapter.this.mShowListener.onReward();
                }
            }

            public void onInterstitialLoad() {
            }

            public void onInterstitialLoaded() {
                Log.i((String)TAG, (String)"onInterstitialLoaded: ");
                CPADRewardVideoAdapter.this.setTimeoutValue(CPADRewardVideoAdapter.this.cpRewardVideoAd.getExpreTime());
                CPADRewardVideoAdapter.this.mFirstLoadTime = System.currentTimeMillis();
                if (CPADRewardVideoAdapter.this.mLoadAdapterListener != null) {
                    CPADRewardVideoAdapter.this.mLoadAdapterListener.loadAdapterLoaded(null);
                }
            }

            public void onInterstitialFailed(TradPlusErrorCode errorCode) {
                Log.i((String)TAG, (String)"onInterstitialFailed: ");
                if (CPADRewardVideoAdapter.this.mLoadAdapterListener != null) {
                    CPADRewardVideoAdapter.this.mLoadAdapterListener.loadAdapterLoadFailed(TradPlusErrorCode.NO_FILL);
                }
            }

            public void onInterstitialShown() {
                Log.i((String)TAG, (String)"onInterstitialShown: ");
                if (CPADRewardVideoAdapter.this.mShowListener != null) {
                    CPADRewardVideoAdapter.this.mShowListener.onAdVideoStart();
                }
            }

            public void onInterstitialClicked() {
                Log.i((String)TAG, (String)"onInterstitialClicked: ");
                if (CPADRewardVideoAdapter.this.mShowListener != null) {
                    CPADRewardVideoAdapter.this.mShowListener.onAdVideoClicked();
                }
            }

            public void onLeaveApplication() {
                Log.i((String)TAG, (String)"onLeaveApplication: ");
            }

            public void onInterstitialDismissed() {
                Log.i((String)TAG, (String)"onInterstitialDismissed: ");
                if (CPADRewardVideoAdapter.this.mShowListener != null) {
                    CPADRewardVideoAdapter.this.mShowListener.onAdVideoEnd();
                }
            }

            public void onInterstitialRewarded(String currencyName, int amount) {
                Log.i((String)TAG, (String)"onInterstitialRewarded: ");
            }
        });
        this.cpRewardVideoAd.setDirection(this.direction);
        this.cpRewardVideoAd.load();
    }

    public void showAd() {
        if (this.cpRewardVideoAd != null) {
            this.cpRewardVideoAd.show();
        }
    }

    public boolean isReady() {
        if (this.cpRewardVideoAd != null) {
            return this.cpRewardVideoAd.isReady() && !this.isAdsTimeOut();
        }
        return false;
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("27");
    }

    public String getNetworkVersion() {
        return null;
    }

    private boolean extrasAreValid(Map<String, String> tpParams) {
        String placementId = tpParams.get("placementId");
        return placementId != null && placementId.length() > 0;
    }

    public void setTimeoutValue(long timeoutValue) {
        this.timeoutValue = timeoutValue;
    }

    public boolean isAdsTimeOut() {
        return System.currentTimeMillis() - this.mFirstLoadTime + 30000L > this.timeoutValue;
    }
}

