/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.network;

import android.content.Context;
import android.util.Log;
import android.view.View;
import com.tradplus.ads.base.adapter.splash.TPSplashAdapter;
import com.tradplus.ads.mobileads.TradPlusErrorCode;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import com.tradplus.crosspro.network.splash.CPSplashAd;
import com.tradplus.crosspro.network.splash.CPSplashAdListener;
import java.util.Map;

public class CPADSplashAdapter
extends TPSplashAdapter {
    private Context context;
    private String campaignId;
    private String adSourceId;
    private CPSplashAd cpSplashAd;
    private long timeoutValue = 10800000L;
    private long mFirstLoadTime;
    public static final long TIME_DELTA = 30000L;
    private static String TAG = "CrossPro";
    private int countdown_time;
    private int is_skipable;
    private int direction;

    public void showAd() {
        View view;
        Log.i((String)TAG, (String)"showAd: ");
        if (this.cpSplashAd != null && (view = this.cpSplashAd.getSplashView(new CPSplashAd.OnSplashShownListener(){

            @Override
            public void onShown() {
                if (CPADSplashAdapter.this.mShowListener != null) {
                    CPADSplashAdapter.this.mShowListener.onAdShown();
                }
            }
        })) != null && this.mAdContainerView != null) {
            this.mAdContainerView.removeAllViews();
            this.mAdContainerView.addView(view);
        }
    }

    public void clean() {
    }

    public boolean isReady() {
        return !this.isAdsTimeOut();
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("27");
    }

    public String getNetworkVersion() {
        return "";
    }

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        this.context = context;
        if (this.extrasAreValid(tpParams)) {
            this.campaignId = tpParams.get("placementId");
            this.countdown_time = Integer.parseInt(tpParams.get("countdown"));
            this.is_skipable = Integer.parseInt(tpParams.get("skip"));
            this.direction = Integer.parseInt(tpParams.get("direction"));
        } else if (this.mLoadAdapterListener != null) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(TradPlusErrorCode.ADAPTER_CONFIGURATION_ERROR);
            return;
        }
        if (tpParams.containsKey("adsource_placement_id")) {
            this.adSourceId = tpParams.get("adsource_placement_id");
        }
        this.cpSplashAd = new CPSplashAd(context, this.campaignId, this.adSourceId, this.countdown_time, this.is_skipable, this.direction);
        this.cpSplashAd.setCpSplashAdListener(new CPSplashAdListener(){

            public void onInterstitialLoad() {
            }

            public void onInterstitialLoaded() {
                CPADSplashAdapter.this.setTimeoutValue(CPADSplashAdapter.this.cpSplashAd.getExpreTime());
                CPADSplashAdapter.this.mFirstLoadTime = System.currentTimeMillis();
                CPADSplashAdapter.this.mLoadAdapterListener.loadAdapterLoaded(null);
            }

            public void onInterstitialFailed(TradPlusErrorCode errorCode) {
                if (CPADSplashAdapter.this.mLoadAdapterListener != null) {
                    CPADSplashAdapter.this.mLoadAdapterListener.loadAdapterLoadFailed(errorCode);
                }
            }

            public void onInterstitialShown() {
            }

            public void onInterstitialClicked() {
                if (CPADSplashAdapter.this.mShowListener != null) {
                    CPADSplashAdapter.this.mShowListener.onAdClicked();
                }
            }

            public void onLeaveApplication() {
            }

            public void onInterstitialDismissed() {
                if (CPADSplashAdapter.this.mAdContainerView != null) {
                    CPADSplashAdapter.this.mAdContainerView.removeAllViews();
                }
                CPADSplashAdapter.this.mShowListener.onAdClosed();
            }

            public void onInterstitialRewarded(String currencyName, int amount) {
            }
        });
        this.cpSplashAd.load();
    }

    public void setTimeoutValue(long timeoutValue) {
        this.timeoutValue = timeoutValue;
    }

    public boolean isAdsTimeOut() {
        return System.currentTimeMillis() - this.mFirstLoadTime + 30000L > this.timeoutValue;
    }

    public boolean extrasAreValid(Map<String, String> tpParams) {
        String placementId = tpParams.get("placementId");
        return placementId != null && placementId.length() > 0;
    }
}

