/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.network;

import com.tradplus.ads.mobileads.TradPlusErrorCode;
import com.tradplus.ads.volley.NetworkError;
import com.tradplus.ads.volley.TimeoutError;
import com.tradplus.ads.volley.VolleyError;
import com.tradplus.crosspro.network.base.CPError;

public class CPErrorUtil {
    public static TradPlusErrorCode getTradPlusErrorCode(CPError errorCode) {
        TradPlusErrorCode tradPlusErrorCode;
        switch (errorCode.getCode()) {
            case "301": {
                tradPlusErrorCode = TradPlusErrorCode.NETWORK_NO_FILL;
                break;
            }
            case "201": {
                tradPlusErrorCode = TradPlusErrorCode.NETWORK_TIMEOUT;
                break;
            }
            default: {
                tradPlusErrorCode = TradPlusErrorCode.UNSPECIFIED;
            }
        }
        tradPlusErrorCode.setCode(errorCode.getCode() + "");
        tradPlusErrorCode.setErrormessage(errorCode.getDesc());
        return tradPlusErrorCode;
    }

    public static TradPlusErrorCode getErrorCode(VolleyError error) {
        TradPlusErrorCode tradPlusErrorCode = TradPlusErrorCode.NO_CONFIG;
        if (error == null) {
            tradPlusErrorCode.setCode("12");
            tradPlusErrorCode.setErrormessage("Can not init config data.");
        } else if (error instanceof TimeoutError) {
            tradPlusErrorCode.setCode("3");
            tradPlusErrorCode.setErrormessage("Third-party network failed to respond in a timely manner.");
        } else if (error instanceof NetworkError) {
            tradPlusErrorCode.setCode("7");
            tradPlusErrorCode.setErrormessage("No internet connection detected.");
        } else {
            tradPlusErrorCode.setCode("2");
            tradPlusErrorCode.setErrormessage("Unspecified error.");
        }
        return tradPlusErrorCode;
    }
}

