/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.ui;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.tradplus.ads.common.ClientMetadata;
import com.tradplus.ads.common.TaskUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.common.util.ResourceUtils;
import com.tradplus.ads.mobileads.TradPlus;
import com.tradplus.ads.mobileads.gdpr.CommonUtil;
import com.tradplus.ads.network.response.CPAdResponse;
import com.tradplus.ads.pushcenter.event.EventSendMessageUtil;
import com.tradplus.ads.pushcenter.event.request.EventShowEndRequest;
import com.tradplus.ads.pushcenter.event.utils.EventPushMessageUtils;
import com.tradplus.crosspro.manager.CPAdManager;
import com.tradplus.crosspro.manager.CPAdMessager;
import com.tradplus.crosspro.manager.CPClickController;
import com.tradplus.crosspro.network.base.CPError;
import com.tradplus.crosspro.ui.BannerView;
import com.tradplus.crosspro.ui.CPAdActivity;
import com.tradplus.crosspro.ui.EndCardView;
import com.tradplus.crosspro.ui.LoadingView;
import com.tradplus.crosspro.ui.PlayerView;
import java.util.ArrayList;
import java.util.List;

public class InterstitialView
extends LinearLayout {
    private static final String TAG = CPAdActivity.class.getSimpleName();
    private RelativeLayout mRoot;
    private Context context;
    private CPAdMessager.OnEventListener mListener;
    private OnViewFinish onViewFinish;
    private int mScreenWidth;
    private int mScreenHeight;
    private CPAdResponse cpAdResponse;
    private int mOrientation;
    private int mfullScreen;
    private String adSourceId;
    private long timeStamp;
    private boolean isInterstitial;
    private EndCardView endCardView;
    private RelativeLayout unFullRoot;
    private boolean isClicking;
    private PlayerView mPlayerView;
    private CPClickController cpClickController;
    private LoadingView mLoadingView;
    private boolean isShowEndCard;
    private int direction;
    int videoPlayFinish = 0;
    int videoPlayCompletion = 0;

    public int getmScreenWidth() {
        return this.mScreenWidth;
    }

    public void setmScreenWidth(int mScreenWidth) {
        this.mScreenWidth = mScreenWidth;
    }

    public int getmScreenHeight() {
        return this.mScreenHeight;
    }

    public void setmScreenHeight(int mScreenHeight) {
        this.mScreenHeight = mScreenHeight;
    }

    public CPAdResponse getCpAdResponse() {
        return this.cpAdResponse;
    }

    public void setCpAdResponse(CPAdResponse cpAdResponse) {
        this.cpAdResponse = cpAdResponse;
    }

    public int getmOrientation() {
        return this.mOrientation;
    }

    public void setmOrientation(int mOrientation) {
        this.mOrientation = mOrientation;
    }

    public String getAdSourceId() {
        return this.adSourceId;
    }

    public void setAdSourceId(String adSourceId) {
        this.adSourceId = adSourceId;
    }

    public boolean isInterstitial() {
        return this.isInterstitial;
    }

    public void setInterstitial(boolean interstitial) {
        this.isInterstitial = interstitial;
    }

    public PlayerView getmPlayerView() {
        return this.mPlayerView;
    }

    public void setmPlayerView(PlayerView mPlayerView) {
        this.mPlayerView = mPlayerView;
    }

    public CPClickController getCpClickController() {
        return this.cpClickController;
    }

    public void setCpClickController(CPClickController cpClickController) {
        this.cpClickController = cpClickController;
    }

    public boolean isShowEndCard() {
        return this.isShowEndCard;
    }

    public void setShowEndCard(boolean showEndCard) {
        this.isShowEndCard = showEndCard;
    }

    public int getVideoPlayFinish() {
        return this.videoPlayFinish;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setVideoPlayFinish(int videoPlayFinish) {
        this.videoPlayFinish = videoPlayFinish;
    }

    public int getVideoPlayCompletion() {
        return this.videoPlayCompletion;
    }

    public void setVideoPlayCompletion(int videoPlayCompletion) {
        this.videoPlayCompletion = videoPlayCompletion;
    }

    public InterstitialView(Context context) {
        super(context);
        this.context = context;
    }

    public InterstitialView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
    }

    public InterstitialView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
    }

    public void initView() {
        InterstitialView.inflate((Context)this.context, (int)ResourceUtils.getLayoutIdByName((Context)this.context, (String)"cp_activity_ad"), (ViewGroup)this);
        this.init();
    }

    private void init() {
        this.mRoot = (RelativeLayout)this.findViewById(CommonUtil.getResId((Context)this.context, (String)"cp_rl_root", (String)"id"));
        this.mListener = CPAdMessager.getInstance().getListener(this.cpAdResponse.getKey() + this.timeStamp);
        if (TextUtils.isEmpty((CharSequence)this.cpAdResponse.getVideo_url())) {
            this.showEndCard();
            EventSendMessageUtil.getInstance().sendShowEndAd(this.context, this.cpAdResponse.getCampaign_id(), this.cpAdResponse.getAd_id(), "1", this.adSourceId);
            this.notifyShow();
        } else if (this.isShowEndCard) {
            this.showEndCard();
        } else {
            this.initPlayer();
        }
        this.initBannerView();
    }

    private void initBannerView() {
        if (this.mfullScreen == 1 && this.isInterstitial()) {
            BannerView bannerView = new BannerView(this.context, new BannerView.OnBannerClickListener(){

                @Override
                public void onClick() {
                    InterstitialView.this.onClick();
                }
            });
            bannerView.initView((ViewGroup)this.mRoot, this.cpAdResponse);
        }
    }

    private void hideLoading() {
        if (this.mLoadingView != null) {
            this.mLoadingView.hide();
        }
    }

    private List<String> replanceTrackIds(List<String> list) {
        ArrayList<String> _list = new ArrayList<String>();
        ClientMetadata clientMetadata = ClientMetadata.getInstance((Context)this.context);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String url = list.get(i).replace("__TP_REQ_ID__", clientMetadata.getIds(this.adSourceId).getRequest_id()).replace("__TP_IMP_ID__", clientMetadata.getIds(this.adSourceId).getImpression_id()).replace("__TP_CLK_ID__", clientMetadata.getIds(this.adSourceId).getClick_id());
                LogUtil.ownShow((String)("cross pro url = " + url));
                _list.add(url);
            }
        }
        return _list;
    }

    private void initPlayer() {
        if (this.mfullScreen == 1) {
            this.mRoot.setBackgroundColor(this.getResources().getColor(17170444));
        }
        this.mPlayerView = new PlayerView((ViewGroup)this.mRoot, new PlayerView.OnPlayerListener(){

            @Override
            public void onVideoPlayStart() {
                LogUtil.ownShow((String)"onVideoPlayStart...");
                EventSendMessageUtil.getInstance().sendAdVideoStart(InterstitialView.this.context, InterstitialView.this.cpAdResponse.getCampaign_id(), InterstitialView.this.cpAdResponse.getAd_id(), InterstitialView.this.adSourceId);
                EventSendMessageUtil.getInstance().sendShowEndAd(InterstitialView.this.context, InterstitialView.this.cpAdResponse.getCampaign_id(), InterstitialView.this.cpAdResponse.getAd_id(), "1", InterstitialView.this.adSourceId);
                InterstitialView.this.notifyShow();
                InterstitialView.this.notifyVideoPlayStart();
            }

            @Override
            public void onVideoUpdateProgress(int progress) {
            }

            @Override
            public void onVideoPlayEnd() {
                InterstitialView.this.videoPlayCompletion = 1;
                LogUtil.ownShow((String)"onVideoPlayEnd...");
                if (InterstitialView.this.videoPlayFinish == 0) {
                    EventSendMessageUtil.getInstance().sendAdVideoClose(InterstitialView.this.context, InterstitialView.this.cpAdResponse.getCampaign_id(), InterstitialView.this.cpAdResponse.getAd_id(), "1", InterstitialView.this.adSourceId);
                }
            }

            @Override
            public void onVideoPlayCompletion() {
                InterstitialView.this.videoPlayFinish = 1;
                InterstitialView.this.videoPlayCompletion = 1;
                LogUtil.ownShow((String)"onVideoPlayCompletion...");
                if (InterstitialView.this.mListener != null) {
                    InterstitialView.this.mListener.onVideoPlayEnd();
                }
                if (InterstitialView.this.mListener != null) {
                    EventSendMessageUtil.getInstance().sendAdVideoClose(InterstitialView.this.context, InterstitialView.this.cpAdResponse.getCampaign_id(), InterstitialView.this.cpAdResponse.getAd_id(), "2", InterstitialView.this.adSourceId);
                    if (!InterstitialView.this.isInterstitial) {
                        EventSendMessageUtil.getInstance().sendAdVideoReward(InterstitialView.this.context, InterstitialView.this.cpAdResponse.getCampaign_id(), InterstitialView.this.cpAdResponse.getAd_id(), InterstitialView.this.adSourceId);
                    }
                    InterstitialView.this.mListener.onReward();
                }
                InterstitialView.this.showEndCard();
            }

            @Override
            public void onVideoShowFailed(CPError error) {
                InterstitialView.this.notifyShowFailedAndFinish(error);
                Log.i((String)TAG, (String)("onVideoShowFailed: errorCode :" + error.getCode() + ", errorMsg :" + error.getDesc()));
                InterstitialView.this.showFailed(error);
            }

            @Override
            public void onVideoPlayProgress(int progressArea) {
                switch (progressArea) {
                    case 25: {
                        LogUtil.ownShow((String)"onVideoProgress25.......");
                        EventSendMessageUtil.getInstance().sendAdVideoProgress25(InterstitialView.this.context, InterstitialView.this.cpAdResponse.getCampaign_id(), InterstitialView.this.cpAdResponse.getAd_id(), InterstitialView.this.adSourceId);
                        break;
                    }
                    case 50: {
                        LogUtil.ownShow((String)"onVideoProgress50.......");
                        EventSendMessageUtil.getInstance().sendAdVideoProgress50(InterstitialView.this.context, InterstitialView.this.cpAdResponse.getCampaign_id(), InterstitialView.this.cpAdResponse.getAd_id(), InterstitialView.this.adSourceId);
                        break;
                    }
                    case 75: {
                        LogUtil.ownShow((String)"onVideoProgress75.......");
                        EventSendMessageUtil.getInstance().sendAdVideoProgress75(InterstitialView.this.context, InterstitialView.this.cpAdResponse.getCampaign_id(), InterstitialView.this.cpAdResponse.getAd_id(), InterstitialView.this.adSourceId);
                    }
                }
            }

            @Override
            public void onVideoCloseClick() {
                if (InterstitialView.this.mPlayerView != null) {
                    InterstitialView.this.mPlayerView.stop();
                }
                InterstitialView.this.showEndCard();
            }

            @Override
            public void onVideoClick() {
                if (InterstitialView.this.cpAdResponse != null && InterstitialView.this.cpAdResponse.getVideo_click() == 1) {
                    InterstitialView.this.onClick();
                }
            }
        }, TradPlus.invoker().getChinaHandler() != null);
        this.mPlayerView.setSetting(this.cpAdResponse);
        this.mPlayerView.load(this.cpAdResponse.getVideo_url());
    }

    private void showFailed(CPError error) {
        if (error.getCode().equals("401")) {
            EventSendMessageUtil.getInstance().sendShowEndAd(this.context, this.cpAdResponse.getCampaign_id(), this.cpAdResponse.getAd_id(), "20", this.adSourceId);
        } else if (error.getCode().equals("402")) {
            EventSendMessageUtil.getInstance().sendShowEndAd(this.context, this.cpAdResponse.getCampaign_id(), this.cpAdResponse.getAd_id(), "24", this.adSourceId);
        } else if (error.getCode().equals("201")) {
            EventSendMessageUtil.getInstance().sendShowEndAd(this.context, this.cpAdResponse.getCampaign_id(), this.cpAdResponse.getAd_id(), "3", this.adSourceId);
        } else if (error.getCode().equals("301")) {
            EventSendMessageUtil.getInstance().sendShowEndAd(this.context, this.cpAdResponse.getCampaign_id(), this.cpAdResponse.getAd_id(), "5", this.adSourceId);
        }
    }

    private void notifyShow() {
        if (this.cpAdResponse != null && this.context != null) {
            this.sendTrackStart(this.context, false);
            EventShowEndRequest _eventShowEndRequest = new EventShowEndRequest(this.context, EventPushMessageUtils.EventPushStats.EV_SHOW_PUSH_FAILED.getValue());
            _eventShowEndRequest.setCampaign_id(this.cpAdResponse.getCampaign_id());
            _eventShowEndRequest.setAd_id(this.cpAdResponse.getAd_id());
            _eventShowEndRequest.setAsu_id(this.adSourceId);
            EventSendMessageUtil.getInstance().pushTrackToServer(this.context, this.replanceTrackIds(this.cpAdResponse.getImp_track_url_list()), _eventShowEndRequest);
        }
        if (this.mListener != null) {
            this.mListener.onShow();
        }
    }

    private void notifyVideoPlayStart() {
        if (this.mListener != null) {
            this.mListener.onVideoPlayStart();
        }
    }

    private void notifyShowFailedAndFinish(CPError error) {
        if (this.mListener != null) {
            this.mListener.onVideoShowFailed(error);
        }
        if (this.onViewFinish != null) {
            this.onViewFinish.onFinish();
        }
    }

    private void showEndCard() {
        LogUtil.ownShow((String)"showEndCard.......");
        this.isShowEndCard = true;
        this.endCardView = new EndCardView((ViewGroup)this.mRoot, this.mScreenWidth, this.mScreenHeight, this.cpAdResponse, this.mOrientation, new EndCardView.OnEndCardListener(){

            @Override
            public void onClickEndCard() {
                LogUtil.ownShow((String)"onClickEndCard: ");
                if (InterstitialView.this.cpAdResponse != null && TextUtils.equals((CharSequence)InterstitialView.this.cpAdResponse.getEnd_card_click_area(), (CharSequence)"0")) {
                    InterstitialView.this.onClick();
                }
            }

            @Override
            public void onCloseEndCard() {
                LogUtil.ownShow((String)"onCloseEndCard.......");
                if (InterstitialView.this.mListener != null) {
                    InterstitialView.this.mListener.onClose();
                }
                if (InterstitialView.this.onViewFinish != null) {
                    InterstitialView.this.onViewFinish.onFinish();
                }
            }
        }, this.direction);
        if (this.mPlayerView != null) {
            this.mRoot.removeView((View)this.mPlayerView);
            this.mPlayerView = null;
        }
    }

    public OnViewFinish getOnViewFinish() {
        return this.onViewFinish;
    }

    public void setOnViewFinish(OnViewFinish onViewFinish) {
        this.onViewFinish = onViewFinish;
    }

    public void setMfullScreen(int mfullScreen) {
        this.mfullScreen = mfullScreen;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    private void sendTrackStart(Context context, boolean isClick) {
        List<String> _list = this.replanceTrackIds(isClick ? this.cpAdResponse.getClick_track_url_list() : this.cpAdResponse.getImp_track_url_list());
        if (_list != null) {
            for (int i = 0; i < _list.size(); ++i) {
                EventSendMessageUtil.getInstance().sendThirdCheckStart(context, this.cpAdResponse.getCampaign_id(), this.cpAdResponse.getAd_id(), this.adSourceId, isClick, _list.get(i));
            }
        }
    }

    private void onClick() {
        LogUtil.ownShow((String)"click \u3002\u3002\u3002\u3002\u3002");
        EventSendMessageUtil.getInstance().sendClickAd(this.context, this.cpAdResponse.getCampaign_id(), this.cpAdResponse.getAd_id(), this.adSourceId);
        if (this.isClicking) {
            LogUtil.ownShow((String)"during click \u3002\u3002\u3002\u3002\u3002");
            return;
        }
        if (this.cpAdResponse == null) {
            return;
        }
        if (this.mListener != null) {
            this.mListener.onClick();
        }
        if (this.cpAdResponse != null && this.context != null) {
            this.sendTrackStart(this.context, true);
            EventShowEndRequest _eventShowEndRequest = new EventShowEndRequest(this.context, EventPushMessageUtils.EventPushStats.EV_CLICK_PUSH_FAILED.getValue());
            _eventShowEndRequest.setCampaign_id(this.cpAdResponse.getCampaign_id());
            _eventShowEndRequest.setAd_id(this.cpAdResponse.getAd_id());
            _eventShowEndRequest.setAsu_id(this.adSourceId);
            EventSendMessageUtil.getInstance().pushTrackToServer(this.context, this.replanceTrackIds(this.cpAdResponse.getClick_track_url_list()), _eventShowEndRequest);
        }
        this.cpClickController = new CPClickController(this.context, this.cpAdResponse, this.adSourceId);
        this.cpClickController.startClick("", new CPClickController.ClickStatusCallback(){

            @Override
            public void clickStart() {
                InterstitialView.this.isClicking = true;
                InterstitialView.this.showLoading();
            }

            @Override
            public void clickEnd() {
                InterstitialView.this.isClicking = false;
                TaskUtils.runOnUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        InterstitialView.this.hideLoading();
                    }
                });
            }

            @Override
            public void downloadApp(final String url) {
                TaskUtils.runOnUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        InterstitialView.this.hideLoading();
                        CPAdManager.getInstance(InterstitialView.this.context).startDownloadApp(InterstitialView.this.cpAdResponse.getCampaign_id(), InterstitialView.this.cpAdResponse, url, InterstitialView.this.adSourceId);
                    }
                });
            }
        });
    }

    private void showLoading() {
        if (this.mLoadingView == null) {
            this.mLoadingView = new LoadingView((ViewGroup)this.mRoot);
        }
        this.mLoadingView.startLoading();
    }

    public static interface OnViewFinish {
        public void onFinish();
    }
}

