/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.network;

import android.content.Context;
import android.util.Log;
import com.tradplus.ads.base.adapter.interstitial.TPInterstitialAdapter;
import com.tradplus.ads.mobileads.TradPlusErrorCode;
import com.tradplus.ads.network.CPErrorUtil;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import com.tradplus.crosspro.network.base.CPError;
import com.tradplus.crosspro.network.interstitial.CPInterstitialAd;
import com.tradplus.crosspro.network.rewardvideo.CPRewardVideoAdListener;
import java.util.Map;

public class CPADInterstitialAdapter
extends TPInterstitialAdapter {
    private Context context;
    private String campaignId;
    private String adSourceId;
    private CPInterstitialAd cpInterstitialAd;
    private long timeoutValue = 10800000L;
    private long mFirstLoadTime;
    public static final long TIME_DELTA = 30000L;
    private static String TAG = "CrossPro";
    private int full_screen;

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        this.context = context;
        if (this.extrasAreValid(tpParams)) {
            this.campaignId = tpParams.get("placementId");
        } else if (this.mLoadAdapterListener != null) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(TradPlusErrorCode.ADAPTER_CONFIGURATION_ERROR);
            return;
        }
        if (tpParams.containsKey("adsource_placement_id")) {
            this.adSourceId = tpParams.get("adsource_placement_id");
            this.full_screen = Integer.parseInt(tpParams.get("full_screen_type"));
        }
        this.cpInterstitialAd = new CPInterstitialAd(context, this.campaignId, this.adSourceId, this.full_screen);
        this.cpInterstitialAd.setCpRewardVideoAdListener(new CPRewardVideoAdListener(){

            @Override
            public void onVideoAdPlayStart() {
                Log.i((String)TAG, (String)"onVideoAdPlayStart: ");
            }

            @Override
            public void onVideoAdPlayEnd() {
                Log.i((String)TAG, (String)"onVideoAdPlayEnd: ");
            }

            @Override
            public void onVideoShowFailed(CPError error) {
                Log.i((String)TAG, (String)"onVideoShowFailed: ");
                if (CPADInterstitialAdapter.this.mShowListener != null) {
                    CPADInterstitialAdapter.this.mShowListener.onAdVideoError(CPErrorUtil.getTradPlusErrorCode(error));
                }
            }

            @Override
            public void onRewarded() {
                Log.i((String)TAG, (String)"onRewarded: ");
                if (CPADInterstitialAdapter.this.mShowListener != null) {
                    CPADInterstitialAdapter.this.mShowListener.onReward();
                }
            }

            public void onInterstitialLoad() {
            }

            public void onInterstitialLoaded() {
                Log.i((String)TAG, (String)"onInterstitialLoaded: ");
                CPADInterstitialAdapter.this.setTimeoutValue(CPADInterstitialAdapter.this.cpInterstitialAd.getExpreTime());
                CPADInterstitialAdapter.this.mFirstLoadTime = System.currentTimeMillis();
                if (CPADInterstitialAdapter.this.mLoadAdapterListener != null) {
                    CPADInterstitialAdapter.this.mLoadAdapterListener.loadAdapterLoaded(null);
                }
            }

            public void onInterstitialFailed(TradPlusErrorCode errorCode) {
                Log.i((String)TAG, (String)"onInterstitialFailed: ");
                if (CPADInterstitialAdapter.this.mLoadAdapterListener != null) {
                    CPADInterstitialAdapter.this.mLoadAdapterListener.loadAdapterLoadFailed(TradPlusErrorCode.NO_FILL);
                }
            }

            public void onInterstitialShown() {
                Log.i((String)TAG, (String)"onInterstitialShown: ");
                if (CPADInterstitialAdapter.this.mShowListener != null) {
                    CPADInterstitialAdapter.this.mShowListener.onAdVideoStart();
                }
            }

            public void onInterstitialClicked() {
                Log.i((String)TAG, (String)"onInterstitialClicked: ");
                if (CPADInterstitialAdapter.this.mShowListener != null) {
                    CPADInterstitialAdapter.this.mShowListener.onAdVideoClicked();
                }
            }

            public void onLeaveApplication() {
                Log.i((String)TAG, (String)"onLeaveApplication: ");
            }

            public void onInterstitialDismissed() {
                Log.i((String)TAG, (String)"onInterstitialDismissed: ");
                if (CPADInterstitialAdapter.this.mShowListener != null) {
                    CPADInterstitialAdapter.this.mShowListener.onAdVideoEnd();
                }
            }

            public void onInterstitialRewarded(String currencyName, int amount) {
                Log.i((String)TAG, (String)"onInterstitialRewarded: ");
            }
        });
        this.cpInterstitialAd.load();
    }

    public void showAd() {
        if (this.cpInterstitialAd != null) {
            this.cpInterstitialAd.show();
        }
    }

    public boolean isReady() {
        if (this.cpInterstitialAd != null) {
            return this.cpInterstitialAd.isReady() && !this.isAdsTimeOut();
        }
        return false;
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("27");
    }

    public String getNetworkVersion() {
        return null;
    }

    private boolean extrasAreValid(Map<String, String> tpParams) {
        String placementId = tpParams.get("placementId");
        return placementId != null && placementId.length() > 0;
    }

    public void setTimeoutValue(long timeoutValue) {
        this.timeoutValue = timeoutValue;
    }

    public boolean isAdsTimeOut() {
        return System.currentTimeMillis() - this.mFirstLoadTime + 30000L > this.timeoutValue;
    }
}

