/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.manager;

import android.content.Context;
import android.util.Log;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.network.CPConfigRequest;
import com.tradplus.ads.network.Networking;
import com.tradplus.ads.network.TPRequestQueue;
import com.tradplus.ads.network.response.CPAdResponse;
import com.tradplus.ads.pushcenter.event.EventSendMessageUtil;
import com.tradplus.ads.volley.Request;
import com.tradplus.ads.volley.VolleyError;
import com.tradplus.crosspro.common.CPConfigUrlGenerator;
import com.tradplus.crosspro.common.CPConst;
import java.util.HashMap;
import java.util.Map;

public class CPAdConfigController {
    private CPAdResponse cpAdResponse;
    private static Map<String, CPAdResponse> cpAdResponseMap = new HashMap<String, CPAdResponse>();
    private OnConfigListener onConfigListener;

    public void loadConfig(final Context context, final String pid, final String adSourceId, String type, int orientation) {
        String url = this.generateAdUrl(context, pid, type, orientation);
        LogUtil.ownShow((String)("cp ad config url = " + url));
        CPConfigRequest cpConfigRequest = new CPConfigRequest(url, new CPConfigRequest.Listener(){

            public void onSuccess(CPAdResponse response) {
                if (response != null) {
                    cpAdResponseMap.put(pid, response);
                    if (response.getError_code() == 0) {
                        if (CPAdConfigController.this.onConfigListener != null) {
                            String ip = response.getIp();
                            String iso = response.getIso();
                            EventSendMessageUtil.getInstance().sendOpenAPIStart(context, ip, adSourceId, iso);
                            Log.i((String)"CrossPro", (String)("onSuccess: adSourceId :" + adSourceId));
                            CPAdConfigController.this.onConfigListener.onSuccess(pid);
                        }
                    } else if (CPAdConfigController.this.onConfigListener != null) {
                        CPAdConfigController.this.onConfigListener.onError(null);
                    }
                } else if (CPAdConfigController.this.onConfigListener != null) {
                    CPAdConfigController.this.onConfigListener.onError(null);
                }
            }

            public void onErrorResponse(VolleyError error) {
                error.printStackTrace();
                if (CPAdConfigController.this.onConfigListener != null) {
                    CPAdConfigController.this.onConfigListener.onError(error);
                }
            }
        });
        TPRequestQueue requestQueue = Networking.getRequestQueue((Context)context);
        if (requestQueue != null) {
            requestQueue.add((Request)cpConfigRequest);
        }
    }

    public void setOnConfigListener(OnConfigListener onConfigListener) {
        this.onConfigListener = onConfigListener;
    }

    String generateAdUrl(Context context, String pid, String type, int orientation) {
        CPConfigUrlGenerator cpConfigUrlGenerator = new CPConfigUrlGenerator(context);
        Networking.useHttps((boolean)true);
        return cpConfigUrlGenerator == null ? null : cpConfigUrlGenerator.withAdCampaignIdId(pid).withAdOrientation(orientation).withAdType(type).generateUrlString(CPConst.HOST);
    }

    public static CPAdResponse getCpAdResponse(String pid) {
        return cpAdResponseMap.get(pid);
    }

    public static interface OnConfigListener {
        public void onSuccess(String var1);

        public void onError(VolleyError var1);
    }
}

