/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.network.rewardvideo;

import android.content.Context;
import com.tradplus.ads.common.ClientMetadata;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.mobileads.util.TradPlusDataConstants;
import com.tradplus.ads.network.CPErrorUtil;
import com.tradplus.ads.network.response.CPAdResponse;
import com.tradplus.ads.pushcenter.PushCenter;
import com.tradplus.ads.pushcenter.event.EventSendMessageUtil;
import com.tradplus.ads.pushcenter.event.request.EventLoadEndRequest;
import com.tradplus.ads.pushcenter.event.request.EventReadyRequest;
import com.tradplus.ads.pushcenter.event.utils.EventPushMessageUtils;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import com.tradplus.ads.volley.NetworkError;
import com.tradplus.ads.volley.TimeoutError;
import com.tradplus.ads.volley.VolleyError;
import com.tradplus.crosspro.manager.CPAdConfigController;
import com.tradplus.crosspro.manager.CPAdManager;
import com.tradplus.crosspro.manager.CPAdMessager;
import com.tradplus.crosspro.manager.resource.CPLoader;
import com.tradplus.crosspro.manager.resource.CPResourceStatus;
import com.tradplus.crosspro.network.base.CPBaseAd;
import com.tradplus.crosspro.network.base.CPError;
import com.tradplus.crosspro.network.base.CPErrorCode;
import com.tradplus.crosspro.network.rewardvideo.CPRewardVideoAdListener;
import com.tradplus.crosspro.ui.CPAdActivity;

public class CPRewardVideoAd
extends CPBaseAd {
    private CPRewardVideoAdListener cpRewardVideoAdListener;
    private String mAdId;

    public CPRewardVideoAd(Context context, String campaignId, String adSourceId) {
        super(context, campaignId, adSourceId);
    }

    @Override
    public void load() {
        LogUtil.ownShow((String)"OpenAPIStart...");
        CPAdConfigController cpAdConfigController = new CPAdConfigController();
        cpAdConfigController.setOnConfigListener(new CPAdConfigController.OnConfigListener(){

            @Override
            public void onSuccess(String pid) {
                CPRewardVideoAd.this.mAdId = CPAdManager.getInstance(CPRewardVideoAd.this.getContext()).getCpAdConfig(CPRewardVideoAd.this.campaignId).getAd_id();
                ClientMetadata.getInstance((Context)CPRewardVideoAd.this.getContext()).putIds(CPRewardVideoAd.this.adSourceId);
                EventSendMessageUtil.getInstance().sendLoadAdNetworkStart(CPRewardVideoAd.this.getContext(), CPRewardVideoAd.this.campaignId, CPRewardVideoAd.this.adSourceId);
                CPAdManager.getInstance(CPRewardVideoAd.this.getContext()).load(CPRewardVideoAd.this.campaignId, new CPLoader.CPLoaderListener(){

                    @Override
                    public void onSuccess() {
                        if (CPRewardVideoAd.this.cpRewardVideoAdListener != null) {
                            CPRewardVideoAd.this.cpRewardVideoAdListener.onInterstitialLoaded();
                        }
                    }

                    @Override
                    public void onFailed(CPError msg) {
                        if (CPRewardVideoAd.this.cpRewardVideoAdListener != null) {
                            CPRewardVideoAd.this.cpRewardVideoAdListener.onInterstitialFailed(CPErrorUtil.getTradPlusErrorCode(msg));
                        }
                    }
                }, CPRewardVideoAd.this.adSourceId);
            }

            @Override
            public void onError(VolleyError error) {
                if (CPRewardVideoAd.this.cpRewardVideoAdListener != null) {
                    EventSendMessageUtil.getInstance().sendOpenAPIStart(CPRewardVideoAd.this.getContext(), "", CPRewardVideoAd.this.adSourceId, "");
                    EventSendMessageUtil.getInstance().sendLoadAdNetworkStart(CPRewardVideoAd.this.getContext(), CPRewardVideoAd.this.campaignId, CPRewardVideoAd.this.adSourceId);
                    EventLoadEndRequest eventLoadEndRequest = new EventLoadEndRequest(CPRewardVideoAd.this.getContext(), EventPushMessageUtils.EventPushStats.EV_LOAD_AD_END.getValue());
                    eventLoadEndRequest.setCampaign_id(CPRewardVideoAd.this.campaignId);
                    eventLoadEndRequest.setAsu_id(CPRewardVideoAd.this.adSourceId);
                    if (error == null) {
                        eventLoadEndRequest.setError_code("12");
                    } else if (error instanceof TimeoutError) {
                        eventLoadEndRequest.setError_code("3");
                    } else if (error instanceof NetworkError) {
                        eventLoadEndRequest.setError_code("7");
                    } else {
                        eventLoadEndRequest.setError_code("2");
                    }
                    long loadTime = RequestUtils.getInstance().countRuntime(eventLoadEndRequest.getCreateTime());
                    eventLoadEndRequest.setLoad_time(loadTime + "");
                    PushCenter.getInstance().sendMessageToCenter(CPRewardVideoAd.this.getContext(), (Object)eventLoadEndRequest, TradPlusDataConstants.CACHETYPE);
                    CPRewardVideoAd.this.cpRewardVideoAdListener.onInterstitialFailed(CPErrorUtil.getErrorCode(error));
                }
            }
        });
        cpAdConfigController.loadConfig(this.getContext(), this.campaignId, this.adSourceId, "5", 0);
    }

    public long getExpreTime() {
        CPAdResponse _cpAdResponse = CPAdManager.getInstance(this.getContext()).getCpAdConfig(this.campaignId);
        if (_cpAdResponse != null && _cpAdResponse.getAd_expire_time() > 0) {
            return _cpAdResponse.getAd_expire_time() * 1000;
        }
        return 10800000L;
    }

    @Override
    public void show() {
        block4: {
            EventSendMessageUtil.getInstance().sendShowAdStart(this.getContext(), this.campaignId, this.mAdId, this.adSourceId);
            try {
                CPAdResponse _cpAdResponse = CPAdManager.getInstance(this.getContext()).getCpAdConfig(this.campaignId);
                if (this.mContext == null || _cpAdResponse == null) {
                    if (this.cpRewardVideoAdListener != null) {
                        this.cpRewardVideoAdListener.onVideoShowFailed(CPErrorCode.get("301", "context = null!"));
                        EventSendMessageUtil.getInstance().sendShowEndAd(this.getContext(), this.campaignId, this.mAdId, "14", this.adSourceId);
                    }
                    return;
                }
                long timeStamp = System.currentTimeMillis();
                CPAdMessager.getInstance().setListener(_cpAdResponse.getKey() + timeStamp, new CPAdMessager.OnEventListener(){

                    @Override
                    public void onShow() {
                        if (CPRewardVideoAd.this.cpRewardVideoAdListener != null) {
                            CPRewardVideoAd.this.cpRewardVideoAdListener.onInterstitialShown();
                        }
                    }

                    @Override
                    public void onVideoShowFailed(CPError error) {
                        if (CPRewardVideoAd.this.cpRewardVideoAdListener != null) {
                            CPRewardVideoAd.this.cpRewardVideoAdListener.onVideoShowFailed(error);
                        }
                    }

                    @Override
                    public void onVideoPlayStart() {
                    }

                    @Override
                    public void onVideoPlayEnd() {
                    }

                    @Override
                    public void onReward() {
                        if (CPRewardVideoAd.this.cpRewardVideoAdListener != null) {
                            CPRewardVideoAd.this.cpRewardVideoAdListener.onRewarded();
                        }
                    }

                    @Override
                    public void onClose() {
                        if (CPRewardVideoAd.this.cpRewardVideoAdListener != null) {
                            CPRewardVideoAd.this.cpRewardVideoAdListener.onInterstitialDismissed();
                        }
                    }

                    @Override
                    public void onClick() {
                        if (CPRewardVideoAd.this.cpRewardVideoAdListener != null) {
                            CPRewardVideoAd.this.cpRewardVideoAdListener.onInterstitialClicked();
                        }
                    }
                });
                boolean orientation = DeviceUtils.isScreenLandscapeOrientation((Context)this.getContext());
                CPAdActivity.start(this.getContext(), _cpAdResponse, orientation ? 2 : 1, timeStamp, this.adSourceId);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.cpRewardVideoAdListener == null) break block4;
                this.cpRewardVideoAdListener.onVideoShowFailed(CPErrorCode.get("-9999", e.getMessage()));
                EventSendMessageUtil.getInstance().sendShowEndAd(this.getContext(), this.campaignId, this.mAdId, "2", this.adSourceId);
            }
        }
    }

    @Override
    public boolean isReady() {
        EventReadyRequest eventReadyRequest = new EventReadyRequest(this.getContext(), EventPushMessageUtils.EventPushStats.EV_ISREADY.getValue());
        if (this.mContext == null) {
            eventReadyRequest.setIs_ad_ready("1");
            eventReadyRequest.setAsu_id(this.adSourceId);
            PushCenter.getInstance().sendMessageToCenter(this.getContext(), (Object)eventReadyRequest, TradPlusDataConstants.CACHETYPE);
            return false;
        }
        try {
            if (this.checkIsReadyParams()) {
                CPAdResponse _cpAdResponse = CPAdManager.getInstance(this.mContext).getCpAdConfig(this.campaignId);
                boolean endCardReady = CPResourceStatus.isEndCardExist(_cpAdResponse);
                boolean videoReady = CPResourceStatus.isVideoExist(_cpAdResponse);
                String errorCode = !endCardReady ? "21" : (!videoReady ? "20" : "1");
                eventReadyRequest.setIs_ad_ready(errorCode);
                eventReadyRequest.setAsu_id(this.adSourceId);
                PushCenter.getInstance().sendMessageToCenter(this.getContext(), (Object)eventReadyRequest, TradPlusDataConstants.CACHETYPE);
                return endCardReady && videoReady;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            eventReadyRequest.setIs_ad_ready("1");
            eventReadyRequest.setAsu_id(this.adSourceId);
            PushCenter.getInstance().sendMessageToCenter(this.getContext(), (Object)eventReadyRequest, TradPlusDataConstants.CACHETYPE);
        }
        return false;
    }

    public CPRewardVideoAdListener getCpRewardVideoAdListener() {
        return this.cpRewardVideoAdListener;
    }

    public void setCpRewardVideoAdListener(CPRewardVideoAdListener cpRewardVideoAdListener) {
        this.cpRewardVideoAdListener = cpRewardVideoAdListener;
    }
}

