/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.network.splash;

import android.content.Context;
import android.view.View;
import com.tradplus.ads.common.ClientMetadata;
import com.tradplus.ads.mobileads.util.TradPlusDataConstants;
import com.tradplus.ads.network.CPErrorUtil;
import com.tradplus.ads.network.response.CPAdResponse;
import com.tradplus.ads.pushcenter.PushCenter;
import com.tradplus.ads.pushcenter.event.EventSendMessageUtil;
import com.tradplus.ads.pushcenter.event.request.EventLoadEndRequest;
import com.tradplus.ads.pushcenter.event.utils.EventPushMessageUtils;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import com.tradplus.ads.volley.NetworkError;
import com.tradplus.ads.volley.TimeoutError;
import com.tradplus.ads.volley.VolleyError;
import com.tradplus.crosspro.manager.CPAdConfigController;
import com.tradplus.crosspro.manager.CPAdManager;
import com.tradplus.crosspro.manager.resource.CPLoader;
import com.tradplus.crosspro.network.base.CPBaseAd;
import com.tradplus.crosspro.network.base.CPError;
import com.tradplus.crosspro.network.splash.CPSplashAdListener;
import com.tradplus.crosspro.ui.EndCardView;
import com.tradplus.crosspro.ui.SplashView;

public class CPSplashAd
extends CPBaseAd {
    private CPSplashAdListener cpSplashAdListener;
    private String mAdId;
    private int countdown_time;
    private int is_skipable;
    private int direction;

    public CPSplashAd(Context context, String campaignId, String adSourceId, int countdown_time, int is_skipable, int direction) {
        super(context, campaignId, adSourceId);
        this.countdown_time = countdown_time;
        this.is_skipable = is_skipable;
        this.direction = direction;
    }

    @Override
    public void load() {
        CPAdConfigController cpAdConfigController = new CPAdConfigController();
        cpAdConfigController.setOnConfigListener(new CPAdConfigController.OnConfigListener(){

            @Override
            public void onSuccess(String pid) {
                CPSplashAd.this.mAdId = CPAdManager.getInstance(CPSplashAd.this.getContext()).getCpAdConfig(CPSplashAd.this.campaignId).getAd_id();
                ClientMetadata.getInstance((Context)CPSplashAd.this.getContext()).putIds(CPSplashAd.this.adSourceId);
                EventSendMessageUtil.getInstance().sendLoadAdNetworkStart(CPSplashAd.this.getContext(), CPSplashAd.this.campaignId, CPSplashAd.this.adSourceId);
                CPAdManager.getInstance(CPSplashAd.this.getContext()).load(CPSplashAd.this.campaignId, new CPLoader.CPLoaderListener(){

                    @Override
                    public void onSuccess() {
                        if (CPSplashAd.this.cpSplashAdListener != null) {
                            CPSplashAd.this.cpSplashAdListener.onInterstitialLoaded();
                        }
                    }

                    @Override
                    public void onFailed(CPError msg) {
                        if (CPSplashAd.this.cpSplashAdListener != null) {
                            CPSplashAd.this.cpSplashAdListener.onInterstitialFailed(CPErrorUtil.getTradPlusErrorCode(msg));
                        }
                    }
                }, CPSplashAd.this.adSourceId);
            }

            @Override
            public void onError(VolleyError error) {
                if (CPSplashAd.this.cpSplashAdListener != null) {
                    EventSendMessageUtil.getInstance().sendOpenAPIStart(CPSplashAd.this.getContext(), "", CPSplashAd.this.adSourceId, "");
                    EventSendMessageUtil.getInstance().sendLoadAdNetworkStart(CPSplashAd.this.getContext(), CPSplashAd.this.campaignId, CPSplashAd.this.adSourceId);
                    EventLoadEndRequest eventLoadEndRequest = new EventLoadEndRequest(CPSplashAd.this.getContext(), EventPushMessageUtils.EventPushStats.EV_LOAD_AD_END.getValue());
                    eventLoadEndRequest.setCampaign_id(CPSplashAd.this.campaignId);
                    eventLoadEndRequest.setAsu_id(CPSplashAd.this.adSourceId);
                    if (error == null) {
                        CPAdResponse _cpAdResponse = CPAdManager.getInstance(CPSplashAd.this.getContext()).getCpAdConfig(CPSplashAd.this.campaignId);
                        if (_cpAdResponse != null) {
                            eventLoadEndRequest.setError_code(_cpAdResponse.getError_code() + "");
                            eventLoadEndRequest.setError_message(_cpAdResponse.getError_message());
                        } else {
                            eventLoadEndRequest.setError_code("2");
                        }
                    } else if (error instanceof TimeoutError) {
                        eventLoadEndRequest.setError_code("3");
                    } else if (error instanceof NetworkError) {
                        eventLoadEndRequest.setError_code("7");
                    } else {
                        eventLoadEndRequest.setError_code("2");
                    }
                    long loadTime = RequestUtils.getInstance().countRuntime(eventLoadEndRequest.getCreateTime());
                    eventLoadEndRequest.setLoad_time(loadTime + "");
                    PushCenter.getInstance().sendMessageToCenter(CPSplashAd.this.getContext(), (Object)eventLoadEndRequest, TradPlusDataConstants.CACHETYPE);
                    CPSplashAd.this.cpSplashAdListener.onInterstitialFailed(CPErrorUtil.getErrorCode(error));
                }
            }
        });
        cpAdConfigController.loadConfig(this.getContext(), this.campaignId, this.adSourceId, "3", this.direction);
    }

    @Override
    public void show() {
    }

    public View getSplashView(OnSplashShownListener onSplashShownListener) {
        SplashView splashView = new SplashView(this.mContext);
        splashView.initView(this.mContext, this.campaignId, this.countdown_time, this.is_skipable, this.direction, this.adSourceId, new EndCardView.OnEndCardListener(){

            @Override
            public void onClickEndCard() {
                CPSplashAd.this.cpSplashAdListener.onInterstitialClicked();
            }

            @Override
            public void onCloseEndCard() {
                CPSplashAd.this.cpSplashAdListener.onInterstitialDismissed();
            }
        }, onSplashShownListener);
        return splashView;
    }

    public long getExpreTime() {
        CPAdResponse _cpAdResponse = CPAdManager.getInstance(this.getContext()).getCpAdConfig(this.campaignId);
        if (_cpAdResponse != null && _cpAdResponse.getAd_expire_time() > 0) {
            return _cpAdResponse.getAd_expire_time() * 1000;
        }
        return 10800000L;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    public void setCpSplashAdListener(CPSplashAdListener cpSplashAdListener) {
        this.cpSplashAdListener = cpSplashAdListener;
    }

    public static interface OnSplashShownListener {
        public void onShown();
    }
}

