/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.tradplus.ads.common.ClientMetadata;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.mobileads.TradPlus;
import com.tradplus.ads.mobileads.gdpr.CommonUtil;
import com.tradplus.ads.network.response.CPAdResponse;
import com.tradplus.ads.pushcenter.event.EventSendMessageUtil;
import com.tradplus.ads.pushcenter.event.request.EventShowEndRequest;
import com.tradplus.ads.pushcenter.event.utils.EventPushMessageUtils;
import com.tradplus.crosspro.manager.CPAdManager;
import com.tradplus.crosspro.manager.CPAdMessager;
import com.tradplus.crosspro.manager.CPClickController;
import com.tradplus.crosspro.network.base.CPError;
import com.tradplus.crosspro.ui.BannerView;
import com.tradplus.crosspro.ui.CPLandscapeActivity;
import com.tradplus.crosspro.ui.CPPortraitActivity;
import com.tradplus.crosspro.ui.EndCardView;
import com.tradplus.crosspro.ui.LoadingView;
import com.tradplus.crosspro.ui.PlayerView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CPAdActivity
extends Activity {
    private static final String TAG = CPAdActivity.class.getSimpleName();
    private boolean isShowEndCard;
    private int mScreenWidth;
    private int mScreenHeight;
    private CPAdResponse cpAdResponse;
    private EndCardView endCardView;
    private RelativeLayout mRoot;
    private RelativeLayout unFullRoot;
    private long timeStamp;
    private CPAdMessager.OnEventListener mListener;
    private boolean isClicking;
    private PlayerView mPlayerView;
    private CPClickController cpClickController;
    private LoadingView mLoadingView;
    private Context context;
    private static final String EXTRA_IS_SHOW_END_CARD = "extra_is_show_end_card";
    private static final String EXTRA_CPADRESPONSE_AD = "extra_adResponse_ad";
    private static final String EXTRA_REQUEST_ID = "extra_request_id";
    private static final String EXTRA_ORIENTATION_AD = "extra_orientation";
    private static final String EXTRA_FULLSCREEN_AD = "extra_full_screen";
    private static final String EXTRA_INTERSTITIAL_AD = "extra_isinterstitial";
    private static final String EXTRA_ADSOURCEID_AD = "extra_adsourceid";
    private static String campaignId;
    private static String adId;
    private CPAdResponse mCPAdResponse;
    private int mOrientation;
    private int mfullScreen;
    private String adSourceId;
    private boolean isInterstitial;
    int videoPlayFinish = 0;
    int videoPlayCompletion = 0;

    public static void start(Context context, CPAdResponse cpAdResponse, int orientation, long timeStamp, String adSourceId, int full_screen, boolean isInterstitial) {
        Intent intent = new Intent();
        campaignId = cpAdResponse.getCampaign_id();
        adId = cpAdResponse.getAd_id();
        if (orientation == 2) {
            intent.setClass(context, CPLandscapeActivity.class);
        } else {
            intent.setClass(context, CPPortraitActivity.class);
        }
        intent.putExtra(EXTRA_CPADRESPONSE_AD, (Serializable)cpAdResponse);
        intent.putExtra("timeStamp", timeStamp);
        intent.putExtra(EXTRA_ORIENTATION_AD, orientation);
        intent.putExtra(EXTRA_ADSOURCEID_AD, adSourceId);
        intent.putExtra(EXTRA_FULLSCREEN_AD, full_screen);
        intent.putExtra(EXTRA_INTERSTITIAL_AD, isInterstitial);
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    public static void start(Context context, CPAdResponse cpAdResponse, int orientation, long timeStamp, String adSourceId) {
        CPAdActivity.start(context, cpAdResponse, orientation, timeStamp, adSourceId, 1, false);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.context = this;
        this.parseIntent();
        this.readSaveInstance(savedInstanceState);
        this.setContentView(this.getLayoutIdByAdFormat());
        this.init();
    }

    private void parseIntent() {
        Intent intent = this.getIntent();
        this.mCPAdResponse = (CPAdResponse)intent.getSerializableExtra(EXTRA_CPADRESPONSE_AD);
    }

    private void readSaveInstance(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.isShowEndCard = savedInstanceState.getBoolean(EXTRA_IS_SHOW_END_CARD);
        }
    }

    private int getLayoutIdByAdFormat() {
        return CommonUtil.getResId((Context)this, (String)"cp_activity_ad", (String)"layout");
    }

    private void init() {
        this.getScreenParams();
        this.cpAdResponse = (CPAdResponse)this.getIntent().getSerializableExtra(EXTRA_CPADRESPONSE_AD);
        this.mOrientation = this.getIntent().getIntExtra(EXTRA_ORIENTATION_AD, 0);
        this.mfullScreen = this.getIntent().getIntExtra(EXTRA_FULLSCREEN_AD, 0);
        this.adSourceId = this.getIntent().getStringExtra(EXTRA_ADSOURCEID_AD);
        this.isInterstitial = this.getIntent().getBooleanExtra(EXTRA_INTERSTITIAL_AD, false);
        this.timeStamp = this.getIntent().getLongExtra("timeStamp", 0L);
        this.mRoot = this.mfullScreen == 1 ? (RelativeLayout)this.findViewById(CommonUtil.getResId((Context)this, (String)"cp_rl_root", (String)"id")) : (RelativeLayout)this.findViewById(CommonUtil.getResId((Context)this, (String)"cp_unfull_rl_root", (String)"id"));
        this.mListener = CPAdMessager.getInstance().getListener(this.cpAdResponse.getKey() + this.timeStamp);
        if (TextUtils.isEmpty((CharSequence)this.cpAdResponse.getVideo_url())) {
            this.showEndCard();
            EventSendMessageUtil.getInstance().sendShowEndAd(this.context, campaignId, adId, "1", this.adSourceId);
            this.notifyShow();
        } else if (this.isShowEndCard) {
            this.showEndCard();
        } else {
            this.initPlayer();
        }
        this.initBannerView();
    }

    private void initBannerView() {
        if (this.mfullScreen == 1) {
            BannerView bannerView = new BannerView((Context)this, new BannerView.OnBannerClickListener(){

                @Override
                public void onClick() {
                    CPAdActivity.this.onClick();
                }
            });
            bannerView.initView((ViewGroup)this.mRoot, this.cpAdResponse);
        }
    }

    private void getScreenParams() {
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        this.mScreenWidth = dm.widthPixels;
        this.mScreenHeight = dm.heightPixels;
        if (this.mScreenWidth > this.mScreenHeight) {
            this.setRequestedOrientation(6);
        } else {
            this.setRequestedOrientation(1);
        }
    }

    private List<String> replanceTrackIds(List<String> list) {
        ArrayList<String> _list = new ArrayList<String>();
        ClientMetadata clientMetadata = ClientMetadata.getInstance((Context)this.context);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String url = list.get(i).replace("__TP_REQ_ID__", clientMetadata.getIds(this.adSourceId).getRequest_id()).replace("__TP_IMP_ID__", clientMetadata.getIds(this.adSourceId).getImpression_id()).replace("__TP_CLK_ID__", clientMetadata.getIds(this.adSourceId).getClick_id());
                LogUtil.ownShow((String)("cross pro url = " + url));
                _list.add(url);
            }
        }
        return _list;
    }

    private void initPlayer() {
        if (this.mfullScreen == 1) {
            this.mRoot.setBackgroundColor(this.getResources().getColor(17170444));
        }
        this.mPlayerView = new PlayerView((ViewGroup)this.mRoot, new PlayerView.OnPlayerListener(){

            @Override
            public void onVideoPlayStart() {
                LogUtil.ownShow((String)"onVideoPlayStart...");
                EventSendMessageUtil.getInstance().sendAdVideoStart(CPAdActivity.this.context, campaignId, adId, CPAdActivity.this.adSourceId);
                EventSendMessageUtil.getInstance().sendShowEndAd(CPAdActivity.this.context, campaignId, adId, "1", CPAdActivity.this.adSourceId);
                CPAdActivity.this.notifyShow();
                CPAdActivity.this.notifyVideoPlayStart();
            }

            @Override
            public void onVideoUpdateProgress(int progress) {
            }

            @Override
            public void onVideoPlayEnd() {
                CPAdActivity.this.videoPlayCompletion = 1;
                LogUtil.ownShow((String)"onVideoPlayEnd...");
                if (CPAdActivity.this.videoPlayFinish == 0) {
                    EventSendMessageUtil.getInstance().sendAdVideoClose(CPAdActivity.this.context, campaignId, adId, "1", CPAdActivity.this.adSourceId);
                }
            }

            @Override
            public void onVideoPlayCompletion() {
                CPAdActivity.this.videoPlayFinish = 1;
                CPAdActivity.this.videoPlayCompletion = 1;
                LogUtil.ownShow((String)"onVideoPlayCompletion...");
                if (CPAdActivity.this.mListener != null) {
                    CPAdActivity.this.mListener.onVideoPlayEnd();
                }
                if (CPAdActivity.this.mListener != null) {
                    EventSendMessageUtil.getInstance().sendAdVideoClose(CPAdActivity.this.context, campaignId, adId, "2", CPAdActivity.this.adSourceId);
                    if (!CPAdActivity.this.isInterstitial) {
                        EventSendMessageUtil.getInstance().sendAdVideoReward(CPAdActivity.this.context, campaignId, adId, CPAdActivity.this.adSourceId);
                    }
                    CPAdActivity.this.mListener.onReward();
                }
                CPAdActivity.this.showEndCard();
            }

            @Override
            public void onVideoShowFailed(CPError error) {
                CPAdActivity.this.notifyShowFailedAndFinish(error);
                Log.i((String)TAG, (String)("onVideoShowFailed: errorCode :" + error.getCode() + ", errorMsg :" + error.getDesc()));
                CPAdActivity.this.showFailed(error);
            }

            @Override
            public void onVideoPlayProgress(int progressArea) {
                switch (progressArea) {
                    case 25: {
                        LogUtil.ownShow((String)"onVideoProgress25.......");
                        EventSendMessageUtil.getInstance().sendAdVideoProgress25(CPAdActivity.this.context, campaignId, adId, CPAdActivity.this.adSourceId);
                        break;
                    }
                    case 50: {
                        LogUtil.ownShow((String)"onVideoProgress50.......");
                        EventSendMessageUtil.getInstance().sendAdVideoProgress50(CPAdActivity.this.context, campaignId, adId, CPAdActivity.this.adSourceId);
                        break;
                    }
                    case 75: {
                        LogUtil.ownShow((String)"onVideoProgress75.......");
                        EventSendMessageUtil.getInstance().sendAdVideoProgress75(CPAdActivity.this.context, campaignId, adId, CPAdActivity.this.adSourceId);
                    }
                }
            }

            @Override
            public void onVideoCloseClick() {
                if (CPAdActivity.this.mPlayerView != null) {
                    CPAdActivity.this.mPlayerView.stop();
                }
                CPAdActivity.this.showEndCard();
            }

            @Override
            public void onVideoClick() {
                if (CPAdActivity.this.cpAdResponse != null && CPAdActivity.this.cpAdResponse.getVideo_click() == 1) {
                    CPAdActivity.this.onClick();
                }
            }
        }, TradPlus.invoker().getChinaHandler() != null);
        this.mPlayerView.setSetting(this.cpAdResponse);
        this.mPlayerView.load(this.cpAdResponse.getVideo_url());
    }

    private void showFailed(CPError error) {
        if (error.getCode().equals("401")) {
            EventSendMessageUtil.getInstance().sendShowEndAd(this.context, campaignId, adId, "20", this.adSourceId);
        } else if (error.getCode().equals("402")) {
            EventSendMessageUtil.getInstance().sendShowEndAd(this.context, campaignId, adId, "24", this.adSourceId);
        } else if (error.getCode().equals("201")) {
            EventSendMessageUtil.getInstance().sendShowEndAd(this.context, campaignId, adId, "3", this.adSourceId);
        } else if (error.getCode().equals("301")) {
            EventSendMessageUtil.getInstance().sendShowEndAd(this.context, campaignId, adId, "5", this.adSourceId);
        }
    }

    private void notifyShow() {
        if (this.cpAdResponse != null && this.context != null) {
            this.sendTrackStart(this.context, false);
            EventShowEndRequest _eventShowEndRequest = new EventShowEndRequest(this.context, EventPushMessageUtils.EventPushStats.EV_SHOW_PUSH_FAILED.getValue());
            _eventShowEndRequest.setCampaign_id(campaignId);
            _eventShowEndRequest.setAd_id(adId);
            _eventShowEndRequest.setAsu_id(this.adSourceId);
            EventSendMessageUtil.getInstance().pushTrackToServer(this.context, this.replanceTrackIds(this.cpAdResponse.getImp_track_url_list()), _eventShowEndRequest);
        }
        if (this.mListener != null) {
            this.mListener.onShow();
        }
    }

    private void notifyVideoPlayStart() {
        if (this.mListener != null) {
            this.mListener.onVideoPlayStart();
        }
    }

    private void notifyShowFailedAndFinish(CPError error) {
        if (this.mListener != null) {
            this.mListener.onVideoShowFailed(error);
        }
        this.finish();
    }

    private void showEndCard() {
        LogUtil.ownShow((String)"showEndCard.......");
        this.isShowEndCard = true;
        this.endCardView = new EndCardView((ViewGroup)this.mRoot, this.mScreenWidth, this.mScreenHeight, this.cpAdResponse, this.mOrientation, new EndCardView.OnEndCardListener(){

            @Override
            public void onClickEndCard() {
                LogUtil.ownShow((String)"onClickEndCard: ");
                if (CPAdActivity.this.cpAdResponse != null && TextUtils.equals((CharSequence)CPAdActivity.this.cpAdResponse.getEnd_card_click_area(), (CharSequence)"0")) {
                    CPAdActivity.this.onClick();
                }
            }

            @Override
            public void onCloseEndCard() {
                LogUtil.ownShow((String)"onCloseEndCard.......");
                CPAdActivity.this.finish();
                if (CPAdActivity.this.mListener != null) {
                    CPAdActivity.this.mListener.onClose();
                }
            }
        });
        if (this.mPlayerView != null) {
            this.mRoot.removeView((View)this.mPlayerView);
            this.mPlayerView = null;
        }
    }

    private void sendTrackStart(Context context, boolean isClick) {
        List<String> _list = this.replanceTrackIds(isClick ? this.cpAdResponse.getClick_track_url_list() : this.cpAdResponse.getImp_track_url_list());
        if (_list != null) {
            for (int i = 0; i < _list.size(); ++i) {
                EventSendMessageUtil.getInstance().sendThirdCheckStart(context, campaignId, adId, this.adSourceId, isClick, _list.get(i));
            }
        }
    }

    private void onClick() {
        LogUtil.ownShow((String)"click \u3002\u3002\u3002\u3002\u3002");
        EventSendMessageUtil.getInstance().sendClickAd(this.context, campaignId, adId, this.adSourceId);
        if (this.isClicking) {
            LogUtil.ownShow((String)"during click \u3002\u3002\u3002\u3002\u3002");
            return;
        }
        if (this.cpAdResponse == null) {
            return;
        }
        if (this.mListener != null) {
            this.mListener.onClick();
        }
        if (this.cpAdResponse != null && this.context != null) {
            this.sendTrackStart(this.context, true);
            EventShowEndRequest _eventShowEndRequest = new EventShowEndRequest(this.context, EventPushMessageUtils.EventPushStats.EV_CLICK_PUSH_FAILED.getValue());
            _eventShowEndRequest.setCampaign_id(campaignId);
            _eventShowEndRequest.setAd_id(adId);
            _eventShowEndRequest.setAsu_id(this.adSourceId);
            EventSendMessageUtil.getInstance().pushTrackToServer(this.context, this.replanceTrackIds(this.cpAdResponse.getClick_track_url_list()), _eventShowEndRequest);
        }
        this.cpClickController = new CPClickController((Context)this, this.cpAdResponse, this.adSourceId);
        this.cpClickController.startClick("", new CPClickController.ClickStatusCallback(){

            @Override
            public void clickStart() {
                CPAdActivity.this.isClicking = true;
                CPAdActivity.this.showLoading();
            }

            @Override
            public void clickEnd() {
                CPAdActivity.this.isClicking = false;
                CPAdActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        CPAdActivity.this.hideLoading();
                    }
                });
            }

            @Override
            public void downloadApp(final String url) {
                CPAdActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        CPAdActivity.this.hideLoading();
                        CPAdManager.getInstance(CPAdActivity.this.getApplicationContext()).startDownloadApp(CPAdActivity.this.mCPAdResponse.getCampaign_id(), CPAdActivity.this.mCPAdResponse, url, CPAdActivity.this.adSourceId);
                    }
                });
            }
        });
    }

    private void showLoading() {
        if (this.mLoadingView == null) {
            this.mLoadingView = new LoadingView((ViewGroup)this.mRoot);
        }
        this.mLoadingView.startLoading();
    }

    private void hideLoading() {
        if (this.mLoadingView != null) {
            this.mLoadingView.hide();
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        LogUtil.ownShow((String)"onSaveInstanceState...");
        if (this.isShowEndCard) {
            LogUtil.ownShow((String)"onSaveInstanceState... mIsShowEndCard - true");
            outState.putBoolean(EXTRA_IS_SHOW_END_CARD, true);
        }
    }

    protected void onResume() {
        super.onResume();
        Log.i((String)"CrossPro", (String)"onResume: ");
        try {
            if (this.mPlayerView != null && !this.mPlayerView.isPlaying()) {
                this.mPlayerView.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onPause() {
        super.onPause();
        Log.i((String)"CrossPro", (String)"onResume: ");
        if (this.mPlayerView != null) {
            this.mPlayerView.pause();
        }
    }

    protected void onDestroy() {
        Log.i((String)"CrossPro", (String)"onDestroy: ");
        if (this.cpClickController != null) {
            this.cpClickController.cancelClick();
        }
        if (this.videoPlayFinish == 0 && this.videoPlayCompletion == 0 && !TextUtils.isEmpty((CharSequence)this.cpAdResponse.getVideo_url())) {
            EventSendMessageUtil.getInstance().sendAdVideoClose(this.context, campaignId, adId, "1", this.adSourceId);
        }
        super.onDestroy();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (4 == keyCode) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }
}

