/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.manager;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.tradplus.ads.base.common.TPURLManager;
import com.tradplus.ads.common.ClientMetadata;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.network.CPConfigRequest;
import com.tradplus.ads.network.Networking;
import com.tradplus.ads.network.TPRequestQueue;
import com.tradplus.ads.network.response.CPAdResponse;
import com.tradplus.ads.pushcenter.event.EventSendMessageUtil;
import com.tradplus.ads.volley.Request;
import com.tradplus.ads.volley.VolleyError;
import com.tradplus.crosspro.common.CPConfigUrlGenerator;
import java.util.HashMap;
import java.util.Map;

public class CPAdConfigController {
    private CPAdResponse cpAdResponse;
    private static Map<String, CPAdResponse> cpAdResponseMap = new HashMap<String, CPAdResponse>();
    private OnConfigListener onConfigListener;

    public void loadConfig(Context context, String pid, String adSourceId, String type, int orientation) {
        this.loadConfig(context, pid, adSourceId, type, orientation, 0);
    }

    public void loadConfig(final Context context, final String pid, final String adSourceId, String type, int orientation, final int direction) {
        String url = this.generateAdUrl(context, pid, type, orientation);
        LogUtil.ownShow((String)("cp ad config url = " + url));
        CPConfigRequest cpConfigRequest = new CPConfigRequest(url, new CPConfigRequest.Listener(){

            public void onSuccess(CPAdResponse response) {
                if (response != null) {
                    cpAdResponseMap.put(pid, response);
                    if (response.getError_code() == 0) {
                        if (CPAdConfigController.this.onConfigListener != null) {
                            String endcardUrl = CPAdConfigController.this.getEndCardWithDeviceType(response, direction);
                            if (!TextUtils.isEmpty((CharSequence)endcardUrl) || direction == -1) {
                                String ip = response.getIp();
                                String iso = response.getIso();
                                EventSendMessageUtil.getInstance().sendOpenAPIStart(context, ip, adSourceId, iso);
                                Log.i((String)"CrossPro", (String)("onSuccess: adSourceId :" + adSourceId));
                                CPAdConfigController.this.onConfigListener.onSuccess(pid);
                            } else if (CPAdConfigController.this.onConfigListener != null) {
                                CPAdConfigController.this.onConfigListener.onError(null);
                            }
                        }
                    } else if (CPAdConfigController.this.onConfigListener != null) {
                        CPAdConfigController.this.onConfigListener.onError(null);
                    }
                } else if (CPAdConfigController.this.onConfigListener != null) {
                    CPAdConfigController.this.onConfigListener.onError(null);
                }
            }

            public void onErrorResponse(VolleyError error) {
                error.printStackTrace();
                if (CPAdConfigController.this.onConfigListener != null) {
                    CPAdConfigController.this.onConfigListener.onError(error);
                }
            }
        });
        TPRequestQueue requestQueue = Networking.getRequestQueue((Context)context);
        if (requestQueue != null) {
            requestQueue.add((Request)cpConfigRequest);
        }
    }

    private String getEndCardWithDeviceType(CPAdResponse cpAdResponse, int direction) {
        LogUtil.ownShow((String)("getEnd_cardcpAdResponse = " + JSON.toJSONString((Object)cpAdResponse)));
        ClientMetadata clientMetadata = ClientMetadata.getInstance();
        String device_type = clientMetadata.getDeviceType();
        if (direction == 0) {
            String landUrl;
            if (TextUtils.equals((CharSequence)device_type, (CharSequence)"1")) {
                String landUrl2;
                if (direction == 2) {
                    landUrl2 = this.getEndCardByIndex(cpAdResponse, 1);
                    if (TextUtils.isEmpty((CharSequence)landUrl2)) {
                        landUrl2 = this.getEndCardByIndex(cpAdResponse, 0);
                    }
                } else {
                    landUrl2 = this.getEndCardByIndex(cpAdResponse, 0);
                    if (TextUtils.isEmpty((CharSequence)landUrl2)) {
                        landUrl2 = this.getEndCardByIndex(cpAdResponse, 1);
                    }
                }
                return landUrl2;
            }
            if (direction == 2) {
                landUrl = this.getEndCardByIndex(cpAdResponse, 3);
                if (TextUtils.isEmpty((CharSequence)landUrl)) {
                    landUrl = this.getEndCardByIndex(cpAdResponse, 2);
                }
            } else {
                landUrl = this.getEndCardByIndex(cpAdResponse, 2);
                if (TextUtils.isEmpty((CharSequence)landUrl)) {
                    landUrl = this.getEndCardByIndex(cpAdResponse, 3);
                }
            }
            return landUrl;
        }
        if (TextUtils.equals((CharSequence)device_type, (CharSequence)"1")) {
            if (direction == 2) {
                return this.getEndCardByIndex(cpAdResponse, 1);
            }
            return this.getEndCardByIndex(cpAdResponse, 0);
        }
        if (direction == 2) {
            return this.getEndCardByIndex(cpAdResponse, 3);
        }
        return this.getEndCardByIndex(cpAdResponse, 2);
    }

    private String getEndCardByIndex(CPAdResponse cpAdResponse, int index) {
        for (int i = 0; i < cpAdResponse.getEnd_card().size(); ++i) {
            if (!((CPAdResponse.EndCardBean)cpAdResponse.getEnd_card().get(i)).getType().equals(index + 1 + "")) continue;
            return ((CPAdResponse.EndCardBean)cpAdResponse.getEnd_card().get(i)).getUrl();
        }
        return "";
    }

    public void setOnConfigListener(OnConfigListener onConfigListener) {
        this.onConfigListener = onConfigListener;
    }

    String generateAdUrl(Context context, String pid, String type, int orientation) {
        CPConfigUrlGenerator cpConfigUrlGenerator = new CPConfigUrlGenerator(context);
        Networking.useHttps((boolean)true);
        return cpConfigUrlGenerator == null ? null : cpConfigUrlGenerator.withAdCampaignIdId(pid).withAdOrientation(orientation).withAdType(type).generateUrlString(TPURLManager.getInstance().getCrossProHost());
    }

    public static CPAdResponse getCpAdResponse(String pid) {
        return cpAdResponseMap.get(pid);
    }

    public static interface OnConfigListener {
        public void onSuccess(String var1);

        public void onError(VolleyError var1);
    }
}

