/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.manager.resource;

import android.media.MediaMetadataRetriever;
import android.text.TextUtils;
import java.io.FileDescriptor;

public class CPVideoUtil {
    public static Size getVideoSize(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        Size size = null;
        try {
            size = new Size();
            MediaMetadataRetriever mMetadataRetriever = new MediaMetadataRetriever();
            mMetadataRetriever.setDataSource(path);
            String width = mMetadataRetriever.extractMetadata(18);
            String height = mMetadataRetriever.extractMetadata(19);
            mMetadataRetriever.release();
            size.width = Integer.parseInt(width);
            size.height = Integer.parseInt(height);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    public static Size getVideoSize(FileDescriptor fd) {
        if (fd == null) {
            return null;
        }
        Size size = null;
        try {
            size = new Size();
            MediaMetadataRetriever mMetadataRetriever = new MediaMetadataRetriever();
            mMetadataRetriever.setDataSource(fd);
            String width = mMetadataRetriever.extractMetadata(18);
            String height = mMetadataRetriever.extractMetadata(19);
            mMetadataRetriever.release();
            size.width = Integer.parseInt(width);
            size.height = Integer.parseInt(height);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    public static Size getAdaptiveVideoSize(String path, int destWidth, int destHeight) {
        Size videoSize = CPVideoUtil.getVideoSize(path);
        if (videoSize == null) {
            return null;
        }
        int videoWidth = videoSize.width;
        int videoHeight = videoSize.height;
        float ratio_video = (float)videoWidth * 1.0f / (float)videoHeight;
        float ratio_dest = (float)destWidth * 1.0f / (float)destHeight;
        if (ratio_video < ratio_dest) {
            videoSize.height = destHeight;
            videoSize.width = (int)((float)videoSize.height * ratio_video);
        } else {
            videoSize.width = destWidth;
            videoSize.height = (int)((float)videoSize.width / ratio_video);
        }
        return videoSize;
    }

    public static Size getAdaptiveVideoSize(FileDescriptor fd, int destWidth, int destHeight) {
        Size videoSize = CPVideoUtil.getVideoSize(fd);
        if (videoSize == null) {
            return null;
        }
        int videoWidth = videoSize.width;
        int videoHeight = videoSize.height;
        float ratio_video = (float)videoWidth * 1.0f / (float)videoHeight;
        float ratio_dest = (float)destWidth * 1.0f / (float)destHeight;
        if (ratio_video < ratio_dest) {
            videoSize.height = destHeight;
            videoSize.width = (int)((float)videoSize.height * ratio_video);
        } else {
            videoSize.width = destWidth;
            videoSize.height = (int)((float)videoSize.width / ratio_video);
        }
        return videoSize;
    }

    public static class Size {
        public int width;
        public int height;
    }
}

